package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::EIPAssociation`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.17.0 (build 7d5d104)", date = "2019-09-20T09:56:18.916Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnEIPAssociationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::EC2::EIPAssociation.AllocationId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html#cfn-ec2-eipassociation-allocationid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getAllocationId();

    /**
     * `AWS::EC2::EIPAssociation.EIP`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html#cfn-ec2-eipassociation-eip
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getEip();

    /**
     * `AWS::EC2::EIPAssociation.InstanceId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html#cfn-ec2-eipassociation-instanceid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getInstanceId();

    /**
     * `AWS::EC2::EIPAssociation.NetworkInterfaceId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html#cfn-ec2-eipassociation-networkinterfaceid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getNetworkInterfaceId();

    /**
     * `AWS::EC2::EIPAssociation.PrivateIpAddress`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html#cfn-ec2-eipassociation-PrivateIpAddress
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getPrivateIpAddress();

    /**
     * @return a {@link Builder} of {@link CfnEIPAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnEIPAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        private java.lang.String allocationId;
        private java.lang.String eip;
        private java.lang.String instanceId;
        private java.lang.String networkInterfaceId;
        private java.lang.String privateIpAddress;

        /**
         * Sets the value of AllocationId
         * @param allocationId `AWS::EC2::EIPAssociation.AllocationId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder allocationId(java.lang.String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        /**
         * Sets the value of Eip
         * @param eip `AWS::EC2::EIPAssociation.EIP`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder eip(java.lang.String eip) {
            this.eip = eip;
            return this;
        }

        /**
         * Sets the value of InstanceId
         * @param instanceId `AWS::EC2::EIPAssociation.InstanceId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder instanceId(java.lang.String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        /**
         * Sets the value of NetworkInterfaceId
         * @param networkInterfaceId `AWS::EC2::EIPAssociation.NetworkInterfaceId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder networkInterfaceId(java.lang.String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        /**
         * Sets the value of PrivateIpAddress
         * @param privateIpAddress `AWS::EC2::EIPAssociation.PrivateIpAddress`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder privateIpAddress(java.lang.String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnEIPAssociationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnEIPAssociationProps build() {
            return new Jsii$Proxy(allocationId, eip, instanceId, networkInterfaceId, privateIpAddress);
        }
    }

    /**
     * An implementation for {@link CfnEIPAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnEIPAssociationProps {
        private final java.lang.String allocationId;
        private final java.lang.String eip;
        private final java.lang.String instanceId;
        private final java.lang.String networkInterfaceId;
        private final java.lang.String privateIpAddress;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.allocationId = this.jsiiGet("allocationId", java.lang.String.class);
            this.eip = this.jsiiGet("eip", java.lang.String.class);
            this.instanceId = this.jsiiGet("instanceId", java.lang.String.class);
            this.networkInterfaceId = this.jsiiGet("networkInterfaceId", java.lang.String.class);
            this.privateIpAddress = this.jsiiGet("privateIpAddress", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String allocationId, java.lang.String eip, java.lang.String instanceId, java.lang.String networkInterfaceId, java.lang.String privateIpAddress) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.allocationId = allocationId;
            this.eip = eip;
            this.instanceId = instanceId;
            this.networkInterfaceId = networkInterfaceId;
            this.privateIpAddress = privateIpAddress;
        }

        @Override
        public java.lang.String getAllocationId() {
            return this.allocationId;
        }

        @Override
        public java.lang.String getEip() {
            return this.eip;
        }

        @Override
        public java.lang.String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public java.lang.String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public java.lang.String getPrivateIpAddress() {
            return this.privateIpAddress;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            if (this.getAllocationId() != null) {
                obj.set("allocationId", om.valueToTree(this.getAllocationId()));
            }
            if (this.getEip() != null) {
                obj.set("eip", om.valueToTree(this.getEip()));
            }
            if (this.getInstanceId() != null) {
                obj.set("instanceId", om.valueToTree(this.getInstanceId()));
            }
            if (this.getNetworkInterfaceId() != null) {
                obj.set("networkInterfaceId", om.valueToTree(this.getNetworkInterfaceId()));
            }
            if (this.getPrivateIpAddress() != null) {
                obj.set("privateIpAddress", om.valueToTree(this.getPrivateIpAddress()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnEIPAssociationProps.Jsii$Proxy that = (CfnEIPAssociationProps.Jsii$Proxy) o;

            if (this.allocationId != null ? !this.allocationId.equals(that.allocationId) : that.allocationId != null) return false;
            if (this.eip != null ? !this.eip.equals(that.eip) : that.eip != null) return false;
            if (this.instanceId != null ? !this.instanceId.equals(that.instanceId) : that.instanceId != null) return false;
            if (this.networkInterfaceId != null ? !this.networkInterfaceId.equals(that.networkInterfaceId) : that.networkInterfaceId != null) return false;
            return this.privateIpAddress != null ? this.privateIpAddress.equals(that.privateIpAddress) : that.privateIpAddress == null;
        }

        @Override
        public int hashCode() {
            int result = this.allocationId != null ? this.allocationId.hashCode() : 0;
            result = 31 * result + (this.eip != null ? this.eip.hashCode() : 0);
            result = 31 * result + (this.instanceId != null ? this.instanceId.hashCode() : 0);
            result = 31 * result + (this.networkInterfaceId != null ? this.networkInterfaceId.hashCode() : 0);
            result = 31 * result + (this.privateIpAddress != null ? this.privateIpAddress.hashCode() : 0);
            return result;
        }
    }
}
