package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::NetworkInterfaceAttachment`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.17.0 (build 7d5d104)", date = "2019-09-20T09:56:18.963Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnNetworkInterfaceAttachmentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::EC2::NetworkInterfaceAttachment.DeviceIndex`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html#cfn-ec2-network-interface-attachment-deviceindex
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getDeviceIndex();

    /**
     * `AWS::EC2::NetworkInterfaceAttachment.InstanceId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html#cfn-ec2-network-interface-attachment-instanceid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getInstanceId();

    /**
     * `AWS::EC2::NetworkInterfaceAttachment.NetworkInterfaceId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html#cfn-ec2-network-interface-attachment-networkinterfaceid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getNetworkInterfaceId();

    /**
     * `AWS::EC2::NetworkInterfaceAttachment.DeleteOnTermination`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html#cfn-ec2-network-interface-attachment-deleteonterm
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getDeleteOnTermination();

    /**
     * @return a {@link Builder} of {@link CfnNetworkInterfaceAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnNetworkInterfaceAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        private java.lang.String deviceIndex;
        private java.lang.String instanceId;
        private java.lang.String networkInterfaceId;
        private java.lang.Object deleteOnTermination;

        /**
         * Sets the value of DeviceIndex
         * @param deviceIndex `AWS::EC2::NetworkInterfaceAttachment.DeviceIndex`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder deviceIndex(java.lang.String deviceIndex) {
            this.deviceIndex = deviceIndex;
            return this;
        }

        /**
         * Sets the value of InstanceId
         * @param instanceId `AWS::EC2::NetworkInterfaceAttachment.InstanceId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder instanceId(java.lang.String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        /**
         * Sets the value of NetworkInterfaceId
         * @param networkInterfaceId `AWS::EC2::NetworkInterfaceAttachment.NetworkInterfaceId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder networkInterfaceId(java.lang.String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        /**
         * Sets the value of DeleteOnTermination
         * @param deleteOnTermination `AWS::EC2::NetworkInterfaceAttachment.DeleteOnTermination`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder deleteOnTermination(java.lang.Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        /**
         * Sets the value of DeleteOnTermination
         * @param deleteOnTermination `AWS::EC2::NetworkInterfaceAttachment.DeleteOnTermination`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder deleteOnTermination(software.amazon.awscdk.core.IResolvable deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnNetworkInterfaceAttachmentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnNetworkInterfaceAttachmentProps build() {
            return new Jsii$Proxy(deviceIndex, instanceId, networkInterfaceId, deleteOnTermination);
        }
    }

    /**
     * An implementation for {@link CfnNetworkInterfaceAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnNetworkInterfaceAttachmentProps {
        private final java.lang.String deviceIndex;
        private final java.lang.String instanceId;
        private final java.lang.String networkInterfaceId;
        private final java.lang.Object deleteOnTermination;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.deviceIndex = this.jsiiGet("deviceIndex", java.lang.String.class);
            this.instanceId = this.jsiiGet("instanceId", java.lang.String.class);
            this.networkInterfaceId = this.jsiiGet("networkInterfaceId", java.lang.String.class);
            this.deleteOnTermination = this.jsiiGet("deleteOnTermination", java.lang.Object.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String deviceIndex, java.lang.String instanceId, java.lang.String networkInterfaceId, java.lang.Object deleteOnTermination) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.deviceIndex = java.util.Objects.requireNonNull(deviceIndex, "deviceIndex is required");
            this.instanceId = java.util.Objects.requireNonNull(instanceId, "instanceId is required");
            this.networkInterfaceId = java.util.Objects.requireNonNull(networkInterfaceId, "networkInterfaceId is required");
            this.deleteOnTermination = deleteOnTermination;
        }

        @Override
        public java.lang.String getDeviceIndex() {
            return this.deviceIndex;
        }

        @Override
        public java.lang.String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public java.lang.String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public java.lang.Object getDeleteOnTermination() {
            return this.deleteOnTermination;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("deviceIndex", om.valueToTree(this.getDeviceIndex()));
            obj.set("instanceId", om.valueToTree(this.getInstanceId()));
            obj.set("networkInterfaceId", om.valueToTree(this.getNetworkInterfaceId()));
            if (this.getDeleteOnTermination() != null) {
                obj.set("deleteOnTermination", om.valueToTree(this.getDeleteOnTermination()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnNetworkInterfaceAttachmentProps.Jsii$Proxy that = (CfnNetworkInterfaceAttachmentProps.Jsii$Proxy) o;

            if (!deviceIndex.equals(that.deviceIndex)) return false;
            if (!instanceId.equals(that.instanceId)) return false;
            if (!networkInterfaceId.equals(that.networkInterfaceId)) return false;
            return this.deleteOnTermination != null ? this.deleteOnTermination.equals(that.deleteOnTermination) : that.deleteOnTermination == null;
        }

        @Override
        public int hashCode() {
            int result = this.deviceIndex.hashCode();
            result = 31 * result + (this.instanceId.hashCode());
            result = 31 * result + (this.networkInterfaceId.hashCode());
            result = 31 * result + (this.deleteOnTermination != null ? this.deleteOnTermination.hashCode() : 0);
            return result;
        }
    }
}
