/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import java.util.List;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.services.ec2.CfnVPCEndpointProps;
import software.amazon.jsii.JsiiSerializable;

public interface CfnVPCEndpointProps
extends JsiiSerializable {
    public String getServiceName();

    public String getVpcId();

    public Object getPolicyDocument();

    public Object getPrivateDnsEnabled();

    public List<String> getRouteTableIds();

    public List<String> getSecurityGroupIds();

    public List<String> getSubnetIds();

    public String getVpcEndpointType();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String serviceName;
        private String vpcId;
        private Object policyDocument;
        private Object privateDnsEnabled;
        private List<String> routeTableIds;
        private List<String> securityGroupIds;
        private List<String> subnetIds;
        private String vpcEndpointType;

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public Builder policyDocument(Object policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public Builder privateDnsEnabled(Boolean privateDnsEnabled) {
            this.privateDnsEnabled = privateDnsEnabled;
            return this;
        }

        public Builder privateDnsEnabled(IResolvable privateDnsEnabled) {
            this.privateDnsEnabled = privateDnsEnabled;
            return this;
        }

        public Builder routeTableIds(List<String> routeTableIds) {
            this.routeTableIds = routeTableIds;
            return this;
        }

        public Builder securityGroupIds(List<String> securityGroupIds) {
            this.securityGroupIds = securityGroupIds;
            return this;
        }

        public Builder subnetIds(List<String> subnetIds) {
            this.subnetIds = subnetIds;
            return this;
        }

        public Builder vpcEndpointType(String vpcEndpointType) {
            this.vpcEndpointType = vpcEndpointType;
            return this;
        }

        public CfnVPCEndpointProps build() {
            return new Jsii.Proxy(this.serviceName, this.vpcId, this.policyDocument, this.privateDnsEnabled, this.routeTableIds, this.securityGroupIds, this.subnetIds, this.vpcEndpointType, null);
        }
    }
}

