package software.amazon.awscdk.services.ec2;

/**
 * Describes a block device mapping for an EC2 instance or Auto Scaling group.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.21.0 (build 4262b22)", date = "2021-02-19T10:08:57.850Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.BlockDeviceVolume")
public class BlockDeviceVolume extends software.amazon.jsii.JsiiObject {

    protected BlockDeviceVolume(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected BlockDeviceVolume(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param ebsDevice EBS device info.
     * @param virtualName Virtual device name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected BlockDeviceVolume(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.EbsDeviceProps ebsDevice, final @org.jetbrains.annotations.Nullable java.lang.String virtualName) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { ebsDevice, virtualName });
    }

    /**
     * @param ebsDevice EBS device info.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected BlockDeviceVolume(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.EbsDeviceProps ebsDevice) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { ebsDevice });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected BlockDeviceVolume() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Creates a new Elastic Block Storage device.
     * <p>
     * @param volumeSize The volume size, in Gibibytes (GiB). This parameter is required.
     * @param options additional device options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.BlockDeviceVolume ebs(final @org.jetbrains.annotations.NotNull java.lang.Number volumeSize, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.EbsDeviceOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.BlockDeviceVolume.class, "ebs", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.BlockDeviceVolume.class), new Object[] { java.util.Objects.requireNonNull(volumeSize, "volumeSize is required"), options });
    }

    /**
     * Creates a new Elastic Block Storage device.
     * <p>
     * @param volumeSize The volume size, in Gibibytes (GiB). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.BlockDeviceVolume ebs(final @org.jetbrains.annotations.NotNull java.lang.Number volumeSize) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.BlockDeviceVolume.class, "ebs", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.BlockDeviceVolume.class), new Object[] { java.util.Objects.requireNonNull(volumeSize, "volumeSize is required") });
    }

    /**
     * Creates a new Elastic Block Storage device from an existing snapshot.
     * <p>
     * @param snapshotId The snapshot ID of the volume to use. This parameter is required.
     * @param options additional device options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.BlockDeviceVolume ebsFromSnapshot(final @org.jetbrains.annotations.NotNull java.lang.String snapshotId, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.EbsDeviceSnapshotOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.BlockDeviceVolume.class, "ebsFromSnapshot", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.BlockDeviceVolume.class), new Object[] { java.util.Objects.requireNonNull(snapshotId, "snapshotId is required"), options });
    }

    /**
     * Creates a new Elastic Block Storage device from an existing snapshot.
     * <p>
     * @param snapshotId The snapshot ID of the volume to use. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.BlockDeviceVolume ebsFromSnapshot(final @org.jetbrains.annotations.NotNull java.lang.String snapshotId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.BlockDeviceVolume.class, "ebsFromSnapshot", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.BlockDeviceVolume.class), new Object[] { java.util.Objects.requireNonNull(snapshotId, "snapshotId is required") });
    }

    /**
     * Creates a virtual, ephemeral device.
     * <p>
     * The name will be in the form ephemeral{volumeIndex}.
     * <p>
     * @param volumeIndex the volume index. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.BlockDeviceVolume ephemeral(final @org.jetbrains.annotations.NotNull java.lang.Number volumeIndex) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.BlockDeviceVolume.class, "ephemeral", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.BlockDeviceVolume.class), new Object[] { java.util.Objects.requireNonNull(volumeIndex, "volumeIndex is required") });
    }

    /**
     * EBS device info.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.EbsDeviceProps getEbsDevice() {
        return software.amazon.jsii.Kernel.get(this, "ebsDevice", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.EbsDeviceProps.class));
    }

    /**
     * Virtual device name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getVirtualName() {
        return software.amazon.jsii.Kernel.get(this, "virtualName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
