package software.amazon.awscdk.services.ec2;

/**
 * Select the latest version of the indicated Windows version.
 * <p>
 * This Machine Image automatically updates to the latest version on every
 * deployment. Be aware this will cause your instances to be replaced when a
 * new version of the image becomes available. Do not store stateful information
 * on the instance if you are using this image.
 * <p>
 * The AMI ID is selected using the values published to the SSM parameter store.
 * <p>
 * https://aws.amazon.com/blogs/mt/query-for-the-latest-windows-ami-using-systems-manager-parameter-store/
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.21.0 (build 4262b22)", date = "2021-02-23T11:52:19.571Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.WindowsImage")
public class WindowsImage extends software.amazon.awscdk.services.ec2.GenericSSMParameterImage {

    protected WindowsImage(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected WindowsImage(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param version This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public WindowsImage(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.WindowsVersion version, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.WindowsImageProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(version, "version is required"), props });
    }

    /**
     * @param version This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public WindowsImage(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.WindowsVersion version) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(version, "version is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.WindowsImage}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.WindowsImage> {
        /**
         * @return a new instance of {@link Builder}.
         * @param version This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.services.ec2.WindowsVersion version) {
            return new Builder(version);
        }

        private final software.amazon.awscdk.services.ec2.WindowsVersion version;
        private software.amazon.awscdk.services.ec2.WindowsImageProps.Builder props;

        private Builder(final software.amazon.awscdk.services.ec2.WindowsVersion version) {
            this.version = version;
        }

        /**
         * Initial user data.
         * <p>
         * Default: - Empty UserData for Windows machines
         * <p>
         * @return {@code this}
         * @param userData Initial user data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userData(final software.amazon.awscdk.services.ec2.UserData userData) {
            this.props().userData(userData);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.WindowsImage}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.WindowsImage build() {
            return new software.amazon.awscdk.services.ec2.WindowsImage(
                this.version,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ec2.WindowsImageProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ec2.WindowsImageProps.Builder();
            }
            return this.props;
        }
    }
}
