package software.amazon.awscdk.services.ec2;

/**
 * Properties for a ClientVpnAuthorizationRule.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.26.0 (build 7d76e02)", date = "2021-04-01T03:13:02.817Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.ClientVpnAuthorizationRuleProps")
@software.amazon.jsii.Jsii.Proxy(ClientVpnAuthorizationRuleProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ClientVpnAuthorizationRuleProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ec2.ClientVpnAuthorizationRuleOptions {

    /**
     * The client VPN endpoint to which to add the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IClientVpnEndpoint getClientVpnEndoint();

    /**
     * @return a {@link Builder} of {@link ClientVpnAuthorizationRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ClientVpnAuthorizationRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ClientVpnAuthorizationRuleProps> {
        private software.amazon.awscdk.services.ec2.IClientVpnEndpoint clientVpnEndoint;
        private java.lang.String cidr;
        private java.lang.String description;
        private java.lang.String groupId;

        /**
         * Sets the value of {@link ClientVpnAuthorizationRuleProps#getClientVpnEndoint}
         * @param clientVpnEndoint The client VPN endpoint to which to add the rule. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientVpnEndoint(software.amazon.awscdk.services.ec2.IClientVpnEndpoint clientVpnEndoint) {
            this.clientVpnEndoint = clientVpnEndoint;
            return this;
        }

        /**
         * Sets the value of {@link ClientVpnAuthorizationRuleProps#getCidr}
         * @param cidr The IPv4 address range, in CIDR notation, of the network for which access is being authorized. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cidr(java.lang.String cidr) {
            this.cidr = cidr;
            return this;
        }

        /**
         * Sets the value of {@link ClientVpnAuthorizationRuleProps#getDescription}
         * @param description A brief description of the authorization rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link ClientVpnAuthorizationRuleProps#getGroupId}
         * @param groupId The ID of the group to grant access to, for example, the Active Directory group or identity provider (IdP) group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupId(java.lang.String groupId) {
            this.groupId = groupId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ClientVpnAuthorizationRuleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ClientVpnAuthorizationRuleProps build() {
            return new Jsii$Proxy(clientVpnEndoint, cidr, description, groupId);
        }
    }

    /**
     * An implementation for {@link ClientVpnAuthorizationRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClientVpnAuthorizationRuleProps {
        private final software.amazon.awscdk.services.ec2.IClientVpnEndpoint clientVpnEndoint;
        private final java.lang.String cidr;
        private final java.lang.String description;
        private final java.lang.String groupId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.clientVpnEndoint = software.amazon.jsii.Kernel.get(this, "clientVpnEndoint", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IClientVpnEndpoint.class));
            this.cidr = software.amazon.jsii.Kernel.get(this, "cidr", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.groupId = software.amazon.jsii.Kernel.get(this, "groupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final software.amazon.awscdk.services.ec2.IClientVpnEndpoint clientVpnEndoint, final java.lang.String cidr, final java.lang.String description, final java.lang.String groupId) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.clientVpnEndoint = java.util.Objects.requireNonNull(clientVpnEndoint, "clientVpnEndoint is required");
            this.cidr = java.util.Objects.requireNonNull(cidr, "cidr is required");
            this.description = description;
            this.groupId = groupId;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IClientVpnEndpoint getClientVpnEndoint() {
            return this.clientVpnEndoint;
        }

        @Override
        public final java.lang.String getCidr() {
            return this.cidr;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getGroupId() {
            return this.groupId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("clientVpnEndoint", om.valueToTree(this.getClientVpnEndoint()));
            data.set("cidr", om.valueToTree(this.getCidr()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getGroupId() != null) {
                data.set("groupId", om.valueToTree(this.getGroupId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.ClientVpnAuthorizationRuleProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ClientVpnAuthorizationRuleProps.Jsii$Proxy that = (ClientVpnAuthorizationRuleProps.Jsii$Proxy) o;

            if (!clientVpnEndoint.equals(that.clientVpnEndoint)) return false;
            if (!cidr.equals(that.cidr)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            return this.groupId != null ? this.groupId.equals(that.groupId) : that.groupId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.clientVpnEndoint.hashCode();
            result = 31 * result + (this.cidr.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.groupId != null ? this.groupId.hashCode() : 0);
            return result;
        }
    }
}
