package software.amazon.awscdk.services.ec2;

/**
 * Result of selecting a subset of subnets from a VPC.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.26.0 (build 7d76e02)", date = "2021-04-01T03:13:02.890Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.SelectedSubnets")
@software.amazon.jsii.Jsii.Proxy(SelectedSubnets.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SelectedSubnets extends software.amazon.jsii.JsiiSerializable {

    /**
     * The respective AZs of each subnet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAvailabilityZones();

    /**
     * Whether any of the given subnets are from the VPC's public subnets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Boolean getHasPublic();

    /**
     * Dependency representing internet connectivity for these subnets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IDependable getInternetConnectivityEstablished();

    /**
     * The subnet IDs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSubnetIds();

    /**
     * Selected subnet objects.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ec2.ISubnet> getSubnets();

    /**
     * @return a {@link Builder} of {@link SelectedSubnets}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SelectedSubnets}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SelectedSubnets> {
        private java.util.List<java.lang.String> availabilityZones;
        private java.lang.Boolean hasPublic;
        private software.amazon.awscdk.core.IDependable internetConnectivityEstablished;
        private java.util.List<java.lang.String> subnetIds;
        private java.util.List<software.amazon.awscdk.services.ec2.ISubnet> subnets;

        /**
         * Sets the value of {@link SelectedSubnets#getAvailabilityZones}
         * @param availabilityZones The respective AZs of each subnet. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZones(java.util.List<java.lang.String> availabilityZones) {
            this.availabilityZones = availabilityZones;
            return this;
        }

        /**
         * Sets the value of {@link SelectedSubnets#getHasPublic}
         * @param hasPublic Whether any of the given subnets are from the VPC's public subnets. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hasPublic(java.lang.Boolean hasPublic) {
            this.hasPublic = hasPublic;
            return this;
        }

        /**
         * Sets the value of {@link SelectedSubnets#getInternetConnectivityEstablished}
         * @param internetConnectivityEstablished Dependency representing internet connectivity for these subnets. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder internetConnectivityEstablished(software.amazon.awscdk.core.IDependable internetConnectivityEstablished) {
            this.internetConnectivityEstablished = internetConnectivityEstablished;
            return this;
        }

        /**
         * Sets the value of {@link SelectedSubnets#getSubnetIds}
         * @param subnetIds The subnet IDs. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetIds(java.util.List<java.lang.String> subnetIds) {
            this.subnetIds = subnetIds;
            return this;
        }

        /**
         * Sets the value of {@link SelectedSubnets#getSubnets}
         * @param subnets Selected subnet objects. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder subnets(java.util.List<? extends software.amazon.awscdk.services.ec2.ISubnet> subnets) {
            this.subnets = (java.util.List<software.amazon.awscdk.services.ec2.ISubnet>)subnets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SelectedSubnets}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SelectedSubnets build() {
            return new Jsii$Proxy(availabilityZones, hasPublic, internetConnectivityEstablished, subnetIds, subnets);
        }
    }

    /**
     * An implementation for {@link SelectedSubnets}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SelectedSubnets {
        private final java.util.List<java.lang.String> availabilityZones;
        private final java.lang.Boolean hasPublic;
        private final software.amazon.awscdk.core.IDependable internetConnectivityEstablished;
        private final java.util.List<java.lang.String> subnetIds;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISubnet> subnets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.availabilityZones = software.amazon.jsii.Kernel.get(this, "availabilityZones", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.hasPublic = software.amazon.jsii.Kernel.get(this, "hasPublic", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.internetConnectivityEstablished = software.amazon.jsii.Kernel.get(this, "internetConnectivityEstablished", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.IDependable.class));
            this.subnetIds = software.amazon.jsii.Kernel.get(this, "subnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.subnets = software.amazon.jsii.Kernel.get(this, "subnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISubnet.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final java.util.List<java.lang.String> availabilityZones, final java.lang.Boolean hasPublic, final software.amazon.awscdk.core.IDependable internetConnectivityEstablished, final java.util.List<java.lang.String> subnetIds, final java.util.List<? extends software.amazon.awscdk.services.ec2.ISubnet> subnets) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.availabilityZones = java.util.Objects.requireNonNull(availabilityZones, "availabilityZones is required");
            this.hasPublic = java.util.Objects.requireNonNull(hasPublic, "hasPublic is required");
            this.internetConnectivityEstablished = java.util.Objects.requireNonNull(internetConnectivityEstablished, "internetConnectivityEstablished is required");
            this.subnetIds = java.util.Objects.requireNonNull(subnetIds, "subnetIds is required");
            this.subnets = (java.util.List<software.amazon.awscdk.services.ec2.ISubnet>)java.util.Objects.requireNonNull(subnets, "subnets is required");
        }

        @Override
        public final java.util.List<java.lang.String> getAvailabilityZones() {
            return this.availabilityZones;
        }

        @Override
        public final java.lang.Boolean getHasPublic() {
            return this.hasPublic;
        }

        @Override
        public final software.amazon.awscdk.core.IDependable getInternetConnectivityEstablished() {
            return this.internetConnectivityEstablished;
        }

        @Override
        public final java.util.List<java.lang.String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.ISubnet> getSubnets() {
            return this.subnets;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("availabilityZones", om.valueToTree(this.getAvailabilityZones()));
            data.set("hasPublic", om.valueToTree(this.getHasPublic()));
            data.set("internetConnectivityEstablished", om.valueToTree(this.getInternetConnectivityEstablished()));
            data.set("subnetIds", om.valueToTree(this.getSubnetIds()));
            data.set("subnets", om.valueToTree(this.getSubnets()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.SelectedSubnets"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SelectedSubnets.Jsii$Proxy that = (SelectedSubnets.Jsii$Proxy) o;

            if (!availabilityZones.equals(that.availabilityZones)) return false;
            if (!hasPublic.equals(that.hasPublic)) return false;
            if (!internetConnectivityEstablished.equals(that.internetConnectivityEstablished)) return false;
            if (!subnetIds.equals(that.subnetIds)) return false;
            return this.subnets.equals(that.subnets);
        }

        @Override
        public final int hashCode() {
            int result = this.availabilityZones.hashCode();
            result = 31 * result + (this.hasPublic.hashCode());
            result = 31 * result + (this.internetConnectivityEstablished.hashCode());
            result = 31 * result + (this.subnetIds.hashCode());
            result = 31 * result + (this.subnets.hashCode());
            return result;
        }
    }
}
