package software.amazon.awscdk.services.ec2;

/**
 * Instance type for EC2 instances.
 * <p>
 * This class takes a literal string, good if you already
 * know the identifier of the type you want.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.28.0 (build 1801f4f)", date = "2021-04-13T16:59:37.947Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.InstanceType")
public class InstanceType extends software.amazon.jsii.JsiiObject {

    protected InstanceType(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected InstanceType(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param instanceTypeIdentifier This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public InstanceType(final @org.jetbrains.annotations.NotNull java.lang.String instanceTypeIdentifier) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(instanceTypeIdentifier, "instanceTypeIdentifier is required") });
    }

    /**
     * Instance type for EC2 instances.
     * <p>
     * This class takes a combination of a class and size.
     * <p>
     * Be aware that not all combinations of class and size are available, and not all
     * classes are available in all regions.
     * <p>
     * @param instanceClass This parameter is required.
     * @param instanceSize This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InstanceType of(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InstanceClass instanceClass, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InstanceSize instanceSize) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.InstanceType.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InstanceType.class), new Object[] { java.util.Objects.requireNonNull(instanceClass, "instanceClass is required"), java.util.Objects.requireNonNull(instanceSize, "instanceSize is required") });
    }

    /**
     * Return the instance type as a dotted string.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The instance's CPU architecture.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InstanceArchitecture getArchitecture() {
        return software.amazon.jsii.Kernel.get(this, "architecture", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InstanceArchitecture.class));
    }
}
