package software.amazon.awscdk.services.ec2;

/**
 * Properties of an EBS Volume.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.28.0 (build 1801f4f)", date = "2021-04-13T16:59:37.977Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.VolumeProps")
@software.amazon.jsii.Jsii.Proxy(VolumeProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VolumeProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Availability Zone in which to create the volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAvailabilityZone();

    /**
     * Indicates whether the volume is auto-enabled for I/O operations.
     * <p>
     * By default, Amazon EBS disables I/O to the volume from attached EC2
     * instances when it determines that a volume's data is potentially inconsistent. If the consistency of the volume is not a concern, and
     * you prefer that the volume be made available immediately if it's impaired, you can configure the volume to automatically enable I/O.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAutoEnableIo() {
        return null;
    }

    /**
     * Indicates whether Amazon EBS Multi-Attach is enabled.
     * <p>
     * See {&#64;link https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-volumes-multi.html#considerations|Considerations and limitations}
     * for the constraints of multi-attach.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableMultiAttach() {
        return null;
    }

    /**
     * Specifies whether the volume should be encrypted.
     * <p>
     * The effect of setting the encryption state to true depends on the volume origin
     * (new or from a snapshot), starting encryption state, ownership, and whether encryption by default is enabled. For more information,
     * see {&#64;link https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#encryption-by-default|Encryption by Default}
     * in the Amazon Elastic Compute Cloud User Guide.
     * <p>
     * Encrypted Amazon EBS volumes must be attached to instances that support Amazon EBS encryption. For more information, see
     * {&#64;link https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances|Supported Instance Types.}
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEncrypted() {
        return null;
    }

    /**
     * The customer-managed encryption key that is used to encrypt the Volume.
     * <p>
     * The encrypted property must
     * be true if this is provided.
     * <p>
     * Note: If using an {&#64;link aws-kms.IKey} created from a {&#64;link aws-kms.Key.fromKeyArn()} here,
     * then the KMS key <strong>must</strong> have the following in its Key policy; otherwise, the Volume
     * will fail to create.
     * <p>
     * <blockquote><pre>
     *  {
     *    "Effect": "Allow",
     *    "Principal": { "AWS": "&lt;arn for your account-user&gt; ex: arn:aws:iam::00000000000:root" },
     *    "Resource": "*",
     *    "Action": [
     *      "kms:DescribeKey",
     *      "kms:GenerateDataKeyWithoutPlainText",
     *    ],
     *    "Condition": {
     *      "StringEquals": {
     *        "kms:ViaService": "ec2.&lt;Region&gt;.amazonaws.com", (eg: ec2.us-east-1.amazonaws.com)
     *        "kms:CallerAccount": "0000000000" (your account ID)
     *      }
     *    }
     *  }
     * </pre></blockquote>
     * <p>
     * Default: The default KMS key for the account, region, and EC2 service is used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return null;
    }

    /**
     * The number of I/O operations per second (IOPS) to provision for the volume.
     * <p>
     * The maximum ratio is 50 IOPS/GiB for PROVISIONED_IOPS_SSD,
     * and 500 IOPS/GiB for both PROVISIONED_IOPS_SSD_IO2 and GENERAL_PURPOSE_SSD_GP3.
     * See {&#64;link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html}
     * for more information.
     * <p>
     * This parameter is valid only for PROVISIONED_IOPS_SSD, PROVISIONED_IOPS_SSD_IO2 and GENERAL_PURPOSE_SSD_GP3 volumes.
     * <p>
     * Default: None -- Required for io1 and io2 volumes. The default for gp3 volumes is 3,000 IOPS if omitted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getIops() {
        return null;
    }

    /**
     * Policy to apply when the volume is removed from the stack.
     * <p>
     * Default: RemovalPolicy.RETAIN
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
        return null;
    }

    /**
     * The size of the volume, in GiBs.
     * <p>
     * You must specify either a snapshot ID or a volume size.
     * See {&#64;link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html}
     * for details on the allowable size for each type of volume.
     * <p>
     * Default: If you're creating the volume from a snapshot and don't specify a volume size, the default is the snapshot size.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Size getSize() {
        return null;
    }

    /**
     * The snapshot from which to create the volume.
     * <p>
     * You must specify either a snapshot ID or a volume size.
     * <p>
     * Default: The EBS volume is not created from a snapshot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSnapshotId() {
        return null;
    }

    /**
     * The value of the physicalName property of this resource.
     * <p>
     * Default: The physical name will be allocated by CloudFormation at deployment time
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVolumeName() {
        return null;
    }

    /**
     * The type of the volume;
     * <p>
     * what type of storage to use to form the EBS Volume.
     * <p>
     * Default: {@link EbsDeviceVolumeType.GENERAL_PURPOSE_SSD}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.EbsDeviceVolumeType getVolumeType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link VolumeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VolumeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<VolumeProps> {
        private java.lang.String availabilityZone;
        private java.lang.Boolean autoEnableIo;
        private java.lang.Boolean enableMultiAttach;
        private java.lang.Boolean encrypted;
        private software.amazon.awscdk.services.kms.IKey encryptionKey;
        private java.lang.Number iops;
        private software.amazon.awscdk.core.RemovalPolicy removalPolicy;
        private software.amazon.awscdk.core.Size size;
        private java.lang.String snapshotId;
        private java.lang.String volumeName;
        private software.amazon.awscdk.services.ec2.EbsDeviceVolumeType volumeType;

        /**
         * Sets the value of {@link VolumeProps#getAvailabilityZone}
         * @param availabilityZone The Availability Zone in which to create the volume. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(java.lang.String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        /**
         * Sets the value of {@link VolumeProps#getAutoEnableIo}
         * @param autoEnableIo Indicates whether the volume is auto-enabled for I/O operations.
         *                     By default, Amazon EBS disables I/O to the volume from attached EC2
         *                     instances when it determines that a volume's data is potentially inconsistent. If the consistency of the volume is not a concern, and
         *                     you prefer that the volume be made available immediately if it's impaired, you can configure the volume to automatically enable I/O.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoEnableIo(java.lang.Boolean autoEnableIo) {
            this.autoEnableIo = autoEnableIo;
            return this;
        }

        /**
         * Sets the value of {@link VolumeProps#getEnableMultiAttach}
         * @param enableMultiAttach Indicates whether Amazon EBS Multi-Attach is enabled.
         *                          See {&#64;link https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-volumes-multi.html#considerations|Considerations and limitations}
         *                          for the constraints of multi-attach.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableMultiAttach(java.lang.Boolean enableMultiAttach) {
            this.enableMultiAttach = enableMultiAttach;
            return this;
        }

        /**
         * Sets the value of {@link VolumeProps#getEncrypted}
         * @param encrypted Specifies whether the volume should be encrypted.
         *                  The effect of setting the encryption state to true depends on the volume origin
         *                  (new or from a snapshot), starting encryption state, ownership, and whether encryption by default is enabled. For more information,
         *                  see {&#64;link https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#encryption-by-default|Encryption by Default}
         *                  in the Amazon Elastic Compute Cloud User Guide.
         *                  <p>
         *                  Encrypted Amazon EBS volumes must be attached to instances that support Amazon EBS encryption. For more information, see
         *                  {&#64;link https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances|Supported Instance Types.}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encrypted(java.lang.Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        /**
         * Sets the value of {@link VolumeProps#getEncryptionKey}
         * @param encryptionKey The customer-managed encryption key that is used to encrypt the Volume.
         *                      The encrypted property must
         *                      be true if this is provided.
         *                      <p>
         *                      Note: If using an {&#64;link aws-kms.IKey} created from a {&#64;link aws-kms.Key.fromKeyArn()} here,
         *                      then the KMS key <strong>must</strong> have the following in its Key policy; otherwise, the Volume
         *                      will fail to create.
         *                      <p>
         *                      <blockquote><pre>
         *                       {
         *                         "Effect": "Allow",
         *                         "Principal": { "AWS": "&lt;arn for your account-user&gt; ex: arn:aws:iam::00000000000:root" },
         *                         "Resource": "*",
         *                         "Action": [
         *                           "kms:DescribeKey",
         *                           "kms:GenerateDataKeyWithoutPlainText",
         *                         ],
         *                         "Condition": {
         *                           "StringEquals": {
         *                             "kms:ViaService": "ec2.&lt;Region&gt;.amazonaws.com", (eg: ec2.us-east-1.amazonaws.com)
         *                             "kms:CallerAccount": "0000000000" (your account ID)
         *                           }
         *                         }
         *                       }
         *                      </pre></blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKey(software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link VolumeProps#getIops}
         * @param iops The number of I/O operations per second (IOPS) to provision for the volume.
         *             The maximum ratio is 50 IOPS/GiB for PROVISIONED_IOPS_SSD,
         *             and 500 IOPS/GiB for both PROVISIONED_IOPS_SSD_IO2 and GENERAL_PURPOSE_SSD_GP3.
         *             See {&#64;link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html}
         *             for more information.
         *             <p>
         *             This parameter is valid only for PROVISIONED_IOPS_SSD, PROVISIONED_IOPS_SSD_IO2 and GENERAL_PURPOSE_SSD_GP3 volumes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iops(java.lang.Number iops) {
            this.iops = iops;
            return this;
        }

        /**
         * Sets the value of {@link VolumeProps#getRemovalPolicy}
         * @param removalPolicy Policy to apply when the volume is removed from the stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(software.amazon.awscdk.core.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Sets the value of {@link VolumeProps#getSize}
         * @param size The size of the volume, in GiBs.
         *             You must specify either a snapshot ID or a volume size.
         *             See {&#64;link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html}
         *             for details on the allowable size for each type of volume.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder size(software.amazon.awscdk.core.Size size) {
            this.size = size;
            return this;
        }

        /**
         * Sets the value of {@link VolumeProps#getSnapshotId}
         * @param snapshotId The snapshot from which to create the volume.
         *                   You must specify either a snapshot ID or a volume size.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotId(java.lang.String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        /**
         * Sets the value of {@link VolumeProps#getVolumeName}
         * @param volumeName The value of the physicalName property of this resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumeName(java.lang.String volumeName) {
            this.volumeName = volumeName;
            return this;
        }

        /**
         * Sets the value of {@link VolumeProps#getVolumeType}
         * @param volumeType The type of the volume;.
         *                   what type of storage to use to form the EBS Volume.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumeType(software.amazon.awscdk.services.ec2.EbsDeviceVolumeType volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VolumeProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public VolumeProps build() {
            return new Jsii$Proxy(availabilityZone, autoEnableIo, enableMultiAttach, encrypted, encryptionKey, iops, removalPolicy, size, snapshotId, volumeName, volumeType);
        }
    }

    /**
     * An implementation for {@link VolumeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VolumeProps {
        private final java.lang.String availabilityZone;
        private final java.lang.Boolean autoEnableIo;
        private final java.lang.Boolean enableMultiAttach;
        private final java.lang.Boolean encrypted;
        private final software.amazon.awscdk.services.kms.IKey encryptionKey;
        private final java.lang.Number iops;
        private final software.amazon.awscdk.core.RemovalPolicy removalPolicy;
        private final software.amazon.awscdk.core.Size size;
        private final java.lang.String snapshotId;
        private final java.lang.String volumeName;
        private final software.amazon.awscdk.services.ec2.EbsDeviceVolumeType volumeType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.autoEnableIo = software.amazon.jsii.Kernel.get(this, "autoEnableIo", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.enableMultiAttach = software.amazon.jsii.Kernel.get(this, "enableMultiAttach", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.encrypted = software.amazon.jsii.Kernel.get(this, "encrypted", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.encryptionKey = software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.iops = software.amazon.jsii.Kernel.get(this, "iops", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.removalPolicy = software.amazon.jsii.Kernel.get(this, "removalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.RemovalPolicy.class));
            this.size = software.amazon.jsii.Kernel.get(this, "size", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Size.class));
            this.snapshotId = software.amazon.jsii.Kernel.get(this, "snapshotId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.volumeName = software.amazon.jsii.Kernel.get(this, "volumeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.volumeType = software.amazon.jsii.Kernel.get(this, "volumeType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.EbsDeviceVolumeType.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.String availabilityZone, final java.lang.Boolean autoEnableIo, final java.lang.Boolean enableMultiAttach, final java.lang.Boolean encrypted, final software.amazon.awscdk.services.kms.IKey encryptionKey, final java.lang.Number iops, final software.amazon.awscdk.core.RemovalPolicy removalPolicy, final software.amazon.awscdk.core.Size size, final java.lang.String snapshotId, final java.lang.String volumeName, final software.amazon.awscdk.services.ec2.EbsDeviceVolumeType volumeType) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.availabilityZone = java.util.Objects.requireNonNull(availabilityZone, "availabilityZone is required");
            this.autoEnableIo = autoEnableIo;
            this.enableMultiAttach = enableMultiAttach;
            this.encrypted = encrypted;
            this.encryptionKey = encryptionKey;
            this.iops = iops;
            this.removalPolicy = removalPolicy;
            this.size = size;
            this.snapshotId = snapshotId;
            this.volumeName = volumeName;
            this.volumeType = volumeType;
        }

        @Override
        public final java.lang.String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final java.lang.Boolean getAutoEnableIo() {
            return this.autoEnableIo;
        }

        @Override
        public final java.lang.Boolean getEnableMultiAttach() {
            return this.enableMultiAttach;
        }

        @Override
        public final java.lang.Boolean getEncrypted() {
            return this.encrypted;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        public final java.lang.Number getIops() {
            return this.iops;
        }

        @Override
        public final software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        public final software.amazon.awscdk.core.Size getSize() {
            return this.size;
        }

        @Override
        public final java.lang.String getSnapshotId() {
            return this.snapshotId;
        }

        @Override
        public final java.lang.String getVolumeName() {
            return this.volumeName;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.EbsDeviceVolumeType getVolumeType() {
            return this.volumeType;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
            if (this.getAutoEnableIo() != null) {
                data.set("autoEnableIo", om.valueToTree(this.getAutoEnableIo()));
            }
            if (this.getEnableMultiAttach() != null) {
                data.set("enableMultiAttach", om.valueToTree(this.getEnableMultiAttach()));
            }
            if (this.getEncrypted() != null) {
                data.set("encrypted", om.valueToTree(this.getEncrypted()));
            }
            if (this.getEncryptionKey() != null) {
                data.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));
            }
            if (this.getIops() != null) {
                data.set("iops", om.valueToTree(this.getIops()));
            }
            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }
            if (this.getSize() != null) {
                data.set("size", om.valueToTree(this.getSize()));
            }
            if (this.getSnapshotId() != null) {
                data.set("snapshotId", om.valueToTree(this.getSnapshotId()));
            }
            if (this.getVolumeName() != null) {
                data.set("volumeName", om.valueToTree(this.getVolumeName()));
            }
            if (this.getVolumeType() != null) {
                data.set("volumeType", om.valueToTree(this.getVolumeType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.VolumeProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VolumeProps.Jsii$Proxy that = (VolumeProps.Jsii$Proxy) o;

            if (!availabilityZone.equals(that.availabilityZone)) return false;
            if (this.autoEnableIo != null ? !this.autoEnableIo.equals(that.autoEnableIo) : that.autoEnableIo != null) return false;
            if (this.enableMultiAttach != null ? !this.enableMultiAttach.equals(that.enableMultiAttach) : that.enableMultiAttach != null) return false;
            if (this.encrypted != null ? !this.encrypted.equals(that.encrypted) : that.encrypted != null) return false;
            if (this.encryptionKey != null ? !this.encryptionKey.equals(that.encryptionKey) : that.encryptionKey != null) return false;
            if (this.iops != null ? !this.iops.equals(that.iops) : that.iops != null) return false;
            if (this.removalPolicy != null ? !this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy != null) return false;
            if (this.size != null ? !this.size.equals(that.size) : that.size != null) return false;
            if (this.snapshotId != null ? !this.snapshotId.equals(that.snapshotId) : that.snapshotId != null) return false;
            if (this.volumeName != null ? !this.volumeName.equals(that.volumeName) : that.volumeName != null) return false;
            return this.volumeType != null ? this.volumeType.equals(that.volumeType) : that.volumeType == null;
        }

        @Override
        public final int hashCode() {
            int result = this.availabilityZone.hashCode();
            result = 31 * result + (this.autoEnableIo != null ? this.autoEnableIo.hashCode() : 0);
            result = 31 * result + (this.enableMultiAttach != null ? this.enableMultiAttach.hashCode() : 0);
            result = 31 * result + (this.encrypted != null ? this.encrypted.hashCode() : 0);
            result = 31 * result + (this.encryptionKey != null ? this.encryptionKey.hashCode() : 0);
            result = 31 * result + (this.iops != null ? this.iops.hashCode() : 0);
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            result = 31 * result + (this.size != null ? this.size.hashCode() : 0);
            result = 31 * result + (this.snapshotId != null ? this.snapshotId.hashCode() : 0);
            result = 31 * result + (this.volumeName != null ? this.volumeName.hashCode() : 0);
            result = 31 * result + (this.volumeType != null ? this.volumeType.hashCode() : 0);
            return result;
        }
    }
}
