/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ecr;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.ecr.;
import software.amazon.awscdk.services.ecr.CfnRepository;
import software.amazon.awscdk.services.ecr.CfnRepositoryProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-ecr.CfnRepository")
public class CfnRepository
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnRepository.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnRepository(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnRepository(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnRepository(@NotNull Construct scope, @NotNull String id, @Nullable CfnRepositoryProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public CfnRepository(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)((Object)this), (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)((Object)this), (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)((Object)this), (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)Kernel.get((Object)((Object)this), (String)"tags", (NativeType)NativeType.forClass(TagManager.class));
    }

    @NotNull
    public Object getImageScanningConfiguration() {
        return Kernel.get((Object)((Object)this), (String)"imageScanningConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setImageScanningConfiguration(@NotNull Object value) {
        Kernel.set((Object)((Object)this), (String)"imageScanningConfiguration", (Object)Objects.requireNonNull(value, "imageScanningConfiguration is required"));
    }

    @NotNull
    public Object getRepositoryPolicyText() {
        return Kernel.get((Object)((Object)this), (String)"repositoryPolicyText", (NativeType)NativeType.forClass(Object.class));
    }

    public void setRepositoryPolicyText(@NotNull Object value) {
        Kernel.set((Object)((Object)this), (String)"repositoryPolicyText", (Object)Objects.requireNonNull(value, "repositoryPolicyText is required"));
    }

    @Nullable
    public String getImageTagMutability() {
        return (String)Kernel.get((Object)((Object)this), (String)"imageTagMutability", (NativeType)NativeType.forClass(String.class));
    }

    public void setImageTagMutability(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"imageTagMutability", (Object)value);
    }

    @Nullable
    public Object getLifecyclePolicy() {
        return Kernel.get((Object)((Object)this), (String)"lifecyclePolicy", (NativeType)NativeType.forClass(Object.class));
    }

    public void setLifecyclePolicy(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"lifecyclePolicy", (Object)value);
    }

    public void setLifecyclePolicy(@Nullable LifecyclePolicyProperty value) {
        Kernel.set((Object)((Object)this), (String)"lifecyclePolicy", (Object)value);
    }

    @Nullable
    public String getRepositoryName() {
        return (String)Kernel.get((Object)((Object)this), (String)"repositoryName", (NativeType)NativeType.forClass(String.class));
    }

    public void setRepositoryName(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"repositoryName", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnRepository> {
        private final Construct scope;
        private final String id;
        private CfnRepositoryProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder imageScanningConfiguration(Object imageScanningConfiguration) {
            this.props().imageScanningConfiguration(imageScanningConfiguration);
            return this;
        }

        public Builder imageTagMutability(String imageTagMutability) {
            this.props().imageTagMutability(imageTagMutability);
            return this;
        }

        public Builder lifecyclePolicy(IResolvable lifecyclePolicy) {
            this.props().lifecyclePolicy(lifecyclePolicy);
            return this;
        }

        public Builder lifecyclePolicy(LifecyclePolicyProperty lifecyclePolicy) {
            this.props().lifecyclePolicy(lifecyclePolicy);
            return this;
        }

        public Builder repositoryName(String repositoryName) {
            this.props().repositoryName(repositoryName);
            return this;
        }

        public Builder repositoryPolicyText(Object repositoryPolicyText) {
            this.props().repositoryPolicyText(repositoryPolicyText);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        public CfnRepository build() {
            return new CfnRepository(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private CfnRepositoryProps.Builder props() {
            if (this.props == null) {
                this.props = new CfnRepositoryProps.Builder();
            }
            return this.props;
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ecr.CfnRepository.LifecyclePolicyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LifecyclePolicyProperty
    extends JsiiSerializable {
        @Nullable
        default public String getLifecyclePolicyText() {
            return null;
        }

        @Nullable
        default public String getRegistryId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LifecyclePolicyProperty> {
            private String lifecyclePolicyText;
            private String registryId;

            public Builder lifecyclePolicyText(String lifecyclePolicyText) {
                this.lifecyclePolicyText = lifecyclePolicyText;
                return this;
            }

            public Builder registryId(String registryId) {
                this.registryId = registryId;
                return this;
            }

            public LifecyclePolicyProperty build() {
                return new Jsii.Proxy(this.lifecyclePolicyText, this.registryId);
            }
        }
    }
}

