/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ecr;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.RemovalPolicy;
import software.amazon.awscdk.services.ecr.$Module;
import software.amazon.awscdk.services.ecr.IRepository;
import software.amazon.awscdk.services.ecr.LifecycleRule;
import software.amazon.awscdk.services.ecr.RepositoryAttributes;
import software.amazon.awscdk.services.ecr.RepositoryBase;
import software.amazon.awscdk.services.ecr.RepositoryProps;
import software.amazon.awscdk.services.iam.AddToResourcePolicyResult;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;
import software.constructs.IConstruct;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-ecr.Repository")
public class Repository
extends RepositoryBase {
    protected Repository(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Repository(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Repository(@NotNull Construct scope, @NotNull String id, @Nullable RepositoryProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public Repository(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public static String arnForLocalRepository(@NotNull String repositoryName, @NotNull IConstruct scope, @Nullable String account) {
        return (String)JsiiObject.jsiiStaticCall(Repository.class, (String)"arnForLocalRepository", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{Objects.requireNonNull(repositoryName, "repositoryName is required"), Objects.requireNonNull(scope, "scope is required"), account});
    }

    @NotNull
    public static String arnForLocalRepository(@NotNull String repositoryName, @NotNull IConstruct scope) {
        return (String)JsiiObject.jsiiStaticCall(Repository.class, (String)"arnForLocalRepository", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{Objects.requireNonNull(repositoryName, "repositoryName is required"), Objects.requireNonNull(scope, "scope is required")});
    }

    @NotNull
    public static IRepository fromRepositoryArn(@NotNull Construct scope, @NotNull String id, @NotNull String repositoryArn) {
        return (IRepository)JsiiObject.jsiiStaticCall(Repository.class, (String)"fromRepositoryArn", (NativeType)NativeType.forClass(IRepository.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(repositoryArn, "repositoryArn is required")});
    }

    @NotNull
    public static IRepository fromRepositoryAttributes(@NotNull Construct scope, @NotNull String id, @NotNull RepositoryAttributes attrs) {
        return (IRepository)JsiiObject.jsiiStaticCall(Repository.class, (String)"fromRepositoryAttributes", (NativeType)NativeType.forClass(IRepository.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @NotNull
    public static IRepository fromRepositoryName(@NotNull Construct scope, @NotNull String id, @NotNull String repositoryName) {
        return (IRepository)JsiiObject.jsiiStaticCall(Repository.class, (String)"fromRepositoryName", (NativeType)NativeType.forClass(IRepository.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(repositoryName, "repositoryName is required")});
    }

    public void addLifecycleRule(@NotNull LifecycleRule rule) {
        Kernel.call((Object)this, (String)"addLifecycleRule", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(rule, "rule is required")});
    }

    @Override
    @NotNull
    public AddToResourcePolicyResult addToResourcePolicy(@NotNull PolicyStatement statement) {
        return (AddToResourcePolicyResult)Kernel.call((Object)this, (String)"addToResourcePolicy", (NativeType)NativeType.forClass(AddToResourcePolicyResult.class), (Object[])new Object[]{Objects.requireNonNull(statement, "statement is required")});
    }

    @NotNull
    protected List<String> validate() {
        return Collections.unmodifiableList((List)Kernel.call((Object)this, (String)"validate", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)), (Object[])new Object[0]));
    }

    @Override
    @NotNull
    public String getRepositoryArn() {
        return (String)Kernel.get((Object)this, (String)"repositoryArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getRepositoryName() {
        return (String)Kernel.get((Object)this, (String)"repositoryName", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Repository> {
        private final Construct scope;
        private final String id;
        private RepositoryProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder imageScanOnPush(Boolean imageScanOnPush) {
            this.props().imageScanOnPush(imageScanOnPush);
            return this;
        }

        public Builder lifecycleRegistryId(String lifecycleRegistryId) {
            this.props().lifecycleRegistryId(lifecycleRegistryId);
            return this;
        }

        public Builder lifecycleRules(List<? extends LifecycleRule> lifecycleRules) {
            this.props().lifecycleRules(lifecycleRules);
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.props().removalPolicy(removalPolicy);
            return this;
        }

        public Builder repositoryName(String repositoryName) {
            this.props().repositoryName(repositoryName);
            return this;
        }

        public Repository build() {
            return new Repository(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private RepositoryProps.Builder props() {
            if (this.props == null) {
                this.props = new RepositoryProps.Builder();
            }
            return this.props;
        }
    }
}

