/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ecs.patterns;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ecs.AwsLogDriver;
import software.amazon.awscdk.services.ecs.BaseService;
import software.amazon.awscdk.services.ecs.Cluster;
import software.amazon.awscdk.services.ecs.ContainerDefinition;
import software.amazon.awscdk.services.ecs.ICluster;
import software.amazon.awscdk.services.ecs.LogDriver;
import software.amazon.awscdk.services.ecs.patterns.;
import software.amazon.awscdk.services.ecs.patterns.NetworkMultipleTargetGroupsServiceBaseProps;
import software.amazon.awscdk.services.ecs.patterns.NetworkTargetProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListener;
import software.amazon.awscdk.services.elasticloadbalancingv2.NetworkLoadBalancer;
import software.amazon.awscdk.services.elasticloadbalancingv2.NetworkTargetGroup;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-ecs-patterns.NetworkMultipleTargetGroupsServiceBase")
public abstract class NetworkMultipleTargetGroupsServiceBase
extends Construct {
    protected NetworkMultipleTargetGroupsServiceBase(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected NetworkMultipleTargetGroupsServiceBase(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    protected NetworkMultipleTargetGroupsServiceBase(@NotNull software.constructs.Construct scope, @NotNull String id, @Nullable NetworkMultipleTargetGroupsServiceBaseProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    protected NetworkMultipleTargetGroupsServiceBase(@NotNull software.constructs.Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    protected void addPortMappingForTargets(@NotNull ContainerDefinition container, @NotNull List<NetworkTargetProps> targets) {
        Kernel.call((Object)((Object)this), (String)"addPortMappingForTargets", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(container, "container is required"), Objects.requireNonNull(targets, "targets is required")});
    }

    @NotNull
    protected AwsLogDriver createAWSLogDriver(@NotNull String prefix) {
        return (AwsLogDriver)Kernel.call((Object)((Object)this), (String)"createAWSLogDriver", (NativeType)NativeType.forClass(AwsLogDriver.class), (Object[])new Object[]{Objects.requireNonNull(prefix, "prefix is required")});
    }

    @NotNull
    protected NetworkListener findListener(@Nullable String name) {
        return (NetworkListener)Kernel.call((Object)((Object)this), (String)"findListener", (NativeType)NativeType.forClass(NetworkListener.class), (Object[])new Object[]{name});
    }

    @NotNull
    protected NetworkListener findListener() {
        return (NetworkListener)Kernel.call((Object)((Object)this), (String)"findListener", (NativeType)NativeType.forClass(NetworkListener.class), (Object[])new Object[0]);
    }

    @NotNull
    protected Cluster getDefaultCluster(@NotNull software.constructs.Construct scope, @Nullable IVpc vpc) {
        return (Cluster)Kernel.call((Object)((Object)this), (String)"getDefaultCluster", (NativeType)NativeType.forClass(Cluster.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), vpc});
    }

    @NotNull
    protected Cluster getDefaultCluster(@NotNull software.constructs.Construct scope) {
        return (Cluster)Kernel.call((Object)((Object)this), (String)"getDefaultCluster", (NativeType)NativeType.forClass(Cluster.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required")});
    }

    @NotNull
    protected NetworkTargetGroup registerECSTargets(@NotNull BaseService service, @NotNull ContainerDefinition container, @NotNull List<NetworkTargetProps> targets) {
        return (NetworkTargetGroup)Kernel.call((Object)((Object)this), (String)"registerECSTargets", (NativeType)NativeType.forClass(NetworkTargetGroup.class), (Object[])new Object[]{Objects.requireNonNull(service, "service is required"), Objects.requireNonNull(container, "container is required"), Objects.requireNonNull(targets, "targets is required")});
    }

    @NotNull
    public ICluster getCluster() {
        return (ICluster)Kernel.get((Object)((Object)this), (String)"cluster", (NativeType)NativeType.forClass(ICluster.class));
    }

    @NotNull
    public Number getDesiredCount() {
        return (Number)Kernel.get((Object)((Object)this), (String)"desiredCount", (NativeType)NativeType.forClass(Number.class));
    }

    @NotNull
    public NetworkListener getListener() {
        return (NetworkListener)Kernel.get((Object)((Object)this), (String)"listener", (NativeType)NativeType.forClass(NetworkListener.class));
    }

    @NotNull
    public NetworkLoadBalancer getLoadBalancer() {
        return (NetworkLoadBalancer)Kernel.get((Object)((Object)this), (String)"loadBalancer", (NativeType)NativeType.forClass(NetworkLoadBalancer.class));
    }

    @NotNull
    protected List<NetworkListener> getListeners() {
        return Collections.unmodifiableList((List)Kernel.get((Object)((Object)this), (String)"listeners", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(NetworkListener.class))));
    }

    protected void setListeners(@NotNull List<NetworkListener> value) {
        Kernel.set((Object)((Object)this), (String)"listeners", Objects.requireNonNull(value, "listeners is required"));
    }

    @NotNull
    protected List<NetworkTargetGroup> getTargetGroups() {
        return Collections.unmodifiableList((List)Kernel.get((Object)((Object)this), (String)"targetGroups", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(NetworkTargetGroup.class))));
    }

    protected void setTargetGroups(@NotNull List<NetworkTargetGroup> value) {
        Kernel.set((Object)((Object)this), (String)"targetGroups", Objects.requireNonNull(value, "targetGroups is required"));
    }

    @Nullable
    protected LogDriver getLogDriver() {
        return (LogDriver)Kernel.get((Object)((Object)this), (String)"logDriver", (NativeType)NativeType.forClass(LogDriver.class));
    }

    protected void setLogDriver(@Nullable LogDriver value) {
        Kernel.set((Object)((Object)this), (String)"logDriver", (Object)value);
    }
}

