/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ecs;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.ecs.$Module;
import software.amazon.awscdk.services.ecs.CfnCluster;
import software.amazon.awscdk.services.ecs.CfnClusterProps;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-ecs.CfnCluster")
public class CfnCluster
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnCluster.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnCluster(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCluster(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnCluster(@NotNull Construct scope, @NotNull String id, @Nullable CfnClusterProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public CfnCluster(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)((Object)this), (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)((Object)this), (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)((Object)this), (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)Kernel.get((Object)((Object)this), (String)"tags", (NativeType)NativeType.forClass(TagManager.class));
    }

    @Nullable
    public List<String> getCapacityProviders() {
        return Optional.ofNullable((List)Kernel.get((Object)((Object)this), (String)"capacityProviders", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setCapacityProviders(@Nullable List<String> value) {
        Kernel.set((Object)((Object)this), (String)"capacityProviders", value);
    }

    @Nullable
    public String getClusterName() {
        return (String)Kernel.get((Object)((Object)this), (String)"clusterName", (NativeType)NativeType.forClass(String.class));
    }

    public void setClusterName(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"clusterName", (Object)value);
    }

    @Nullable
    public Object getClusterSettings() {
        return Kernel.get((Object)((Object)this), (String)"clusterSettings", (NativeType)NativeType.forClass(Object.class));
    }

    public void setClusterSettings(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"clusterSettings", (Object)value);
    }

    public void setClusterSettings(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof ClusterSettingsProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.core.IResolvable, software.amazon.awscdk.services.ecs.CfnCluster.ClusterSettingsProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)((Object)this), (String)"clusterSettings", value);
    }

    @Nullable
    public Object getConfiguration() {
        return Kernel.get((Object)((Object)this), (String)"configuration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"configuration", (Object)value);
    }

    public void setConfiguration(@Nullable ClusterConfigurationProperty value) {
        Kernel.set((Object)((Object)this), (String)"configuration", (Object)value);
    }

    @Nullable
    public Object getDefaultCapacityProviderStrategy() {
        return Kernel.get((Object)((Object)this), (String)"defaultCapacityProviderStrategy", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDefaultCapacityProviderStrategy(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"defaultCapacityProviderStrategy", (Object)value);
    }

    public void setDefaultCapacityProviderStrategy(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof CapacityProviderStrategyItemProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.core.IResolvable, software.amazon.awscdk.services.ecs.CfnCluster.CapacityProviderStrategyItemProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)((Object)this), (String)"defaultCapacityProviderStrategy", value);
    }

    @Nullable
    public Object getServiceConnectDefaults() {
        return Kernel.get((Object)((Object)this), (String)"serviceConnectDefaults", (NativeType)NativeType.forClass(Object.class));
    }

    public void setServiceConnectDefaults(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"serviceConnectDefaults", (Object)value);
    }

    public void setServiceConnectDefaults(@Nullable ServiceConnectDefaultsProperty value) {
        Kernel.set((Object)((Object)this), (String)"serviceConnectDefaults", (Object)value);
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ecs.CfnCluster.ClusterSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ClusterSettingsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public String getValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ClusterSettingsProperty> {
            String name;
            String value;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public ClusterSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ecs.CfnCluster.CapacityProviderStrategyItemProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CapacityProviderStrategyItemProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getBase() {
            return null;
        }

        @Nullable
        default public String getCapacityProvider() {
            return null;
        }

        @Nullable
        default public Number getWeight() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CapacityProviderStrategyItemProperty> {
            Number base;
            String capacityProvider;
            Number weight;

            public Builder base(Number base) {
                this.base = base;
                return this;
            }

            public Builder capacityProvider(String capacityProvider) {
                this.capacityProvider = capacityProvider;
                return this;
            }

            public Builder weight(Number weight) {
                this.weight = weight;
                return this;
            }

            public CapacityProviderStrategyItemProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnCluster> {
        private final Construct scope;
        private final String id;
        private CfnClusterProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder capacityProviders(List<String> capacityProviders) {
            this.props().capacityProviders(capacityProviders);
            return this;
        }

        public Builder clusterName(String clusterName) {
            this.props().clusterName(clusterName);
            return this;
        }

        public Builder clusterSettings(IResolvable clusterSettings) {
            this.props().clusterSettings(clusterSettings);
            return this;
        }

        public Builder clusterSettings(List<? extends Object> clusterSettings) {
            this.props().clusterSettings(clusterSettings);
            return this;
        }

        public Builder configuration(IResolvable configuration) {
            this.props().configuration(configuration);
            return this;
        }

        public Builder configuration(ClusterConfigurationProperty configuration) {
            this.props().configuration(configuration);
            return this;
        }

        public Builder defaultCapacityProviderStrategy(IResolvable defaultCapacityProviderStrategy) {
            this.props().defaultCapacityProviderStrategy(defaultCapacityProviderStrategy);
            return this;
        }

        public Builder defaultCapacityProviderStrategy(List<? extends Object> defaultCapacityProviderStrategy) {
            this.props().defaultCapacityProviderStrategy(defaultCapacityProviderStrategy);
            return this;
        }

        public Builder serviceConnectDefaults(IResolvable serviceConnectDefaults) {
            this.props().serviceConnectDefaults(serviceConnectDefaults);
            return this;
        }

        public Builder serviceConnectDefaults(ServiceConnectDefaultsProperty serviceConnectDefaults) {
            this.props().serviceConnectDefaults(serviceConnectDefaults);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        public CfnCluster build() {
            return new CfnCluster(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private CfnClusterProps.Builder props() {
            if (this.props == null) {
                this.props = new CfnClusterProps.Builder();
            }
            return this.props;
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ecs.CfnCluster.ServiceConnectDefaultsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ServiceConnectDefaultsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getNamespace() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ServiceConnectDefaultsProperty> {
            String namespace;

            public Builder namespace(String namespace) {
                this.namespace = namespace;
                return this;
            }

            public ServiceConnectDefaultsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ecs.CfnCluster.ExecuteCommandLogConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ExecuteCommandLogConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCloudWatchEncryptionEnabled() {
            return null;
        }

        @Nullable
        default public String getCloudWatchLogGroupName() {
            return null;
        }

        @Nullable
        default public String getS3BucketName() {
            return null;
        }

        @Nullable
        default public Object getS3EncryptionEnabled() {
            return null;
        }

        @Nullable
        default public String getS3KeyPrefix() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ExecuteCommandLogConfigurationProperty> {
            Object cloudWatchEncryptionEnabled;
            String cloudWatchLogGroupName;
            String s3BucketName;
            Object s3EncryptionEnabled;
            String s3KeyPrefix;

            public Builder cloudWatchEncryptionEnabled(Boolean cloudWatchEncryptionEnabled) {
                this.cloudWatchEncryptionEnabled = cloudWatchEncryptionEnabled;
                return this;
            }

            public Builder cloudWatchEncryptionEnabled(IResolvable cloudWatchEncryptionEnabled) {
                this.cloudWatchEncryptionEnabled = cloudWatchEncryptionEnabled;
                return this;
            }

            public Builder cloudWatchLogGroupName(String cloudWatchLogGroupName) {
                this.cloudWatchLogGroupName = cloudWatchLogGroupName;
                return this;
            }

            public Builder s3BucketName(String s3BucketName) {
                this.s3BucketName = s3BucketName;
                return this;
            }

            public Builder s3EncryptionEnabled(Boolean s3EncryptionEnabled) {
                this.s3EncryptionEnabled = s3EncryptionEnabled;
                return this;
            }

            public Builder s3EncryptionEnabled(IResolvable s3EncryptionEnabled) {
                this.s3EncryptionEnabled = s3EncryptionEnabled;
                return this;
            }

            public Builder s3KeyPrefix(String s3KeyPrefix) {
                this.s3KeyPrefix = s3KeyPrefix;
                return this;
            }

            public ExecuteCommandLogConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ecs.CfnCluster.ExecuteCommandConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ExecuteCommandConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getKmsKeyId() {
            return null;
        }

        @Nullable
        default public Object getLogConfiguration() {
            return null;
        }

        @Nullable
        default public String getLogging() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ExecuteCommandConfigurationProperty> {
            String kmsKeyId;
            Object logConfiguration;
            String logging;

            public Builder kmsKeyId(String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            public Builder logConfiguration(IResolvable logConfiguration) {
                this.logConfiguration = logConfiguration;
                return this;
            }

            public Builder logConfiguration(ExecuteCommandLogConfigurationProperty logConfiguration) {
                this.logConfiguration = logConfiguration;
                return this;
            }

            public Builder logging(String logging) {
                this.logging = logging;
                return this;
            }

            public ExecuteCommandConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ecs.CfnCluster.ClusterConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ClusterConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getExecuteCommandConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ClusterConfigurationProperty> {
            Object executeCommandConfiguration;

            public Builder executeCommandConfiguration(IResolvable executeCommandConfiguration) {
                this.executeCommandConfiguration = executeCommandConfiguration;
                return this;
            }

            public Builder executeCommandConfiguration(ExecuteCommandConfigurationProperty executeCommandConfiguration) {
                this.executeCommandConfiguration = executeCommandConfiguration;
                return this;
            }

            public ClusterConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

