/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ecs;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.ecs.;
import software.amazon.awscdk.services.ecs.CfnCapacityProvider;
import software.amazon.awscdk.services.ecs.CfnCapacityProviderProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-ecs.CfnCapacityProvider")
public class CfnCapacityProvider
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnCapacityProvider.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnCapacityProvider(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCapacityProvider(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnCapacityProvider(@NotNull Construct scope, @NotNull String id, @NotNull CfnCapacityProviderProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)((Object)this), (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)((Object)this), (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)((Object)this), (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)Kernel.get((Object)((Object)this), (String)"tags", (NativeType)NativeType.forClass(TagManager.class));
    }

    @NotNull
    public Object getAutoScalingGroupProvider() {
        return Kernel.get((Object)((Object)this), (String)"autoScalingGroupProvider", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAutoScalingGroupProvider(@NotNull AutoScalingGroupProviderProperty value) {
        Kernel.set((Object)((Object)this), (String)"autoScalingGroupProvider", (Object)Objects.requireNonNull(value, "autoScalingGroupProvider is required"));
    }

    public void setAutoScalingGroupProvider(@NotNull IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"autoScalingGroupProvider", (Object)Objects.requireNonNull(value, "autoScalingGroupProvider is required"));
    }

    @Nullable
    public String getName() {
        return (String)Kernel.get((Object)((Object)this), (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"name", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnCapacityProvider> {
        private final Construct scope;
        private final String id;
        private final CfnCapacityProviderProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnCapacityProviderProps.Builder();
        }

        public Builder autoScalingGroupProvider(AutoScalingGroupProviderProperty autoScalingGroupProvider) {
            this.props.autoScalingGroupProvider(autoScalingGroupProvider);
            return this;
        }

        public Builder autoScalingGroupProvider(IResolvable autoScalingGroupProvider) {
            this.props.autoScalingGroupProvider(autoScalingGroupProvider);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnCapacityProvider build() {
            return new CfnCapacityProvider(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ecs.CfnCapacityProvider.ManagedScalingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ManagedScalingProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getMaximumScalingStepSize() {
            return null;
        }

        @Nullable
        default public Number getMinimumScalingStepSize() {
            return null;
        }

        @Nullable
        default public String getStatus() {
            return null;
        }

        @Nullable
        default public Number getTargetCapacity() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ManagedScalingProperty> {
            private Number maximumScalingStepSize;
            private Number minimumScalingStepSize;
            private String status;
            private Number targetCapacity;

            public Builder maximumScalingStepSize(Number maximumScalingStepSize) {
                this.maximumScalingStepSize = maximumScalingStepSize;
                return this;
            }

            public Builder minimumScalingStepSize(Number minimumScalingStepSize) {
                this.minimumScalingStepSize = minimumScalingStepSize;
                return this;
            }

            public Builder status(String status) {
                this.status = status;
                return this;
            }

            public Builder targetCapacity(Number targetCapacity) {
                this.targetCapacity = targetCapacity;
                return this;
            }

            public ManagedScalingProperty build() {
                return new Jsii.Proxy(this.maximumScalingStepSize, this.minimumScalingStepSize, this.status, this.targetCapacity);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ecs.CfnCapacityProvider.AutoScalingGroupProviderProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AutoScalingGroupProviderProperty
    extends JsiiSerializable {
        @NotNull
        public String getAutoScalingGroupArn();

        @Nullable
        default public Object getManagedScaling() {
            return null;
        }

        @Nullable
        default public String getManagedTerminationProtection() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AutoScalingGroupProviderProperty> {
            private String autoScalingGroupArn;
            private Object managedScaling;
            private String managedTerminationProtection;

            public Builder autoScalingGroupArn(String autoScalingGroupArn) {
                this.autoScalingGroupArn = autoScalingGroupArn;
                return this;
            }

            public Builder managedScaling(IResolvable managedScaling) {
                this.managedScaling = managedScaling;
                return this;
            }

            public Builder managedScaling(ManagedScalingProperty managedScaling) {
                this.managedScaling = managedScaling;
                return this;
            }

            public Builder managedTerminationProtection(String managedTerminationProtection) {
                this.managedTerminationProtection = managedTerminationProtection;
                return this;
            }

            public AutoScalingGroupProviderProperty build() {
                return new Jsii.Proxy(this.autoScalingGroupArn, this.managedScaling, this.managedTerminationProtection);
            }
        }
    }
}

