/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ecs;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.ecs.;
import software.amazon.awscdk.services.ecs.CfnTaskDefinition;
import software.amazon.awscdk.services.ecs.CfnTaskDefinitionProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-ecs.CfnTaskDefinition")
public class CfnTaskDefinition
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnTaskDefinition.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnTaskDefinition(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnTaskDefinition(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnTaskDefinition(@NotNull Construct scope, @NotNull String id, @Nullable CfnTaskDefinitionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public CfnTaskDefinition(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)((Object)this), (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)((Object)this), (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrTaskDefinitionArn() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrTaskDefinitionArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)((Object)this), (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)Kernel.get((Object)((Object)this), (String)"tags", (NativeType)NativeType.forClass(TagManager.class));
    }

    @Nullable
    public Object getContainerDefinitions() {
        return Kernel.get((Object)((Object)this), (String)"containerDefinitions", (NativeType)NativeType.forClass(Object.class));
    }

    public void setContainerDefinitions(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"containerDefinitions", (Object)value);
    }

    public void setContainerDefinitions(@Nullable List<Object> value) {
        Kernel.set((Object)((Object)this), (String)"containerDefinitions", value);
    }

    @Nullable
    public String getCpu() {
        return (String)Kernel.get((Object)((Object)this), (String)"cpu", (NativeType)NativeType.forClass(String.class));
    }

    public void setCpu(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"cpu", (Object)value);
    }

    @Nullable
    public String getExecutionRoleArn() {
        return (String)Kernel.get((Object)((Object)this), (String)"executionRoleArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setExecutionRoleArn(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"executionRoleArn", (Object)value);
    }

    @Nullable
    public String getFamily() {
        return (String)Kernel.get((Object)((Object)this), (String)"family", (NativeType)NativeType.forClass(String.class));
    }

    public void setFamily(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"family", (Object)value);
    }

    @Nullable
    public Object getInferenceAccelerators() {
        return Kernel.get((Object)((Object)this), (String)"inferenceAccelerators", (NativeType)NativeType.forClass(Object.class));
    }

    public void setInferenceAccelerators(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"inferenceAccelerators", (Object)value);
    }

    public void setInferenceAccelerators(@Nullable List<Object> value) {
        Kernel.set((Object)((Object)this), (String)"inferenceAccelerators", value);
    }

    @Nullable
    public String getIpcMode() {
        return (String)Kernel.get((Object)((Object)this), (String)"ipcMode", (NativeType)NativeType.forClass(String.class));
    }

    public void setIpcMode(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"ipcMode", (Object)value);
    }

    @Nullable
    public String getMemory() {
        return (String)Kernel.get((Object)((Object)this), (String)"memory", (NativeType)NativeType.forClass(String.class));
    }

    public void setMemory(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"memory", (Object)value);
    }

    @Nullable
    public String getNetworkMode() {
        return (String)Kernel.get((Object)((Object)this), (String)"networkMode", (NativeType)NativeType.forClass(String.class));
    }

    public void setNetworkMode(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"networkMode", (Object)value);
    }

    @Nullable
    public String getPidMode() {
        return (String)Kernel.get((Object)((Object)this), (String)"pidMode", (NativeType)NativeType.forClass(String.class));
    }

    public void setPidMode(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"pidMode", (Object)value);
    }

    @Nullable
    public Object getPlacementConstraints() {
        return Kernel.get((Object)((Object)this), (String)"placementConstraints", (NativeType)NativeType.forClass(Object.class));
    }

    public void setPlacementConstraints(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"placementConstraints", (Object)value);
    }

    public void setPlacementConstraints(@Nullable List<Object> value) {
        Kernel.set((Object)((Object)this), (String)"placementConstraints", value);
    }

    @Nullable
    public Object getProxyConfiguration() {
        return Kernel.get((Object)((Object)this), (String)"proxyConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setProxyConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"proxyConfiguration", (Object)value);
    }

    public void setProxyConfiguration(@Nullable ProxyConfigurationProperty value) {
        Kernel.set((Object)((Object)this), (String)"proxyConfiguration", (Object)value);
    }

    @Nullable
    public List<String> getRequiresCompatibilities() {
        return Optional.ofNullable((List)Kernel.get((Object)((Object)this), (String)"requiresCompatibilities", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setRequiresCompatibilities(@Nullable List<String> value) {
        Kernel.set((Object)((Object)this), (String)"requiresCompatibilities", value);
    }

    @Nullable
    public String getTaskRoleArn() {
        return (String)Kernel.get((Object)((Object)this), (String)"taskRoleArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setTaskRoleArn(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"taskRoleArn", (Object)value);
    }

    @Nullable
    public Object getVolumes() {
        return Kernel.get((Object)((Object)this), (String)"volumes", (NativeType)NativeType.forClass(Object.class));
    }

    public void setVolumes(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"volumes", (Object)value);
    }

    public void setVolumes(@Nullable List<Object> value) {
        Kernel.set((Object)((Object)this), (String)"volumes", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnTaskDefinition> {
        private final Construct scope;
        private final String id;
        private CfnTaskDefinitionProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder containerDefinitions(IResolvable containerDefinitions) {
            this.props().containerDefinitions(containerDefinitions);
            return this;
        }

        public Builder containerDefinitions(List<? extends Object> containerDefinitions) {
            this.props().containerDefinitions(containerDefinitions);
            return this;
        }

        public Builder cpu(String cpu) {
            this.props().cpu(cpu);
            return this;
        }

        public Builder executionRoleArn(String executionRoleArn) {
            this.props().executionRoleArn(executionRoleArn);
            return this;
        }

        public Builder family(String family) {
            this.props().family(family);
            return this;
        }

        public Builder inferenceAccelerators(IResolvable inferenceAccelerators) {
            this.props().inferenceAccelerators(inferenceAccelerators);
            return this;
        }

        public Builder inferenceAccelerators(List<? extends Object> inferenceAccelerators) {
            this.props().inferenceAccelerators(inferenceAccelerators);
            return this;
        }

        public Builder ipcMode(String ipcMode) {
            this.props().ipcMode(ipcMode);
            return this;
        }

        public Builder memory(String memory) {
            this.props().memory(memory);
            return this;
        }

        public Builder networkMode(String networkMode) {
            this.props().networkMode(networkMode);
            return this;
        }

        public Builder pidMode(String pidMode) {
            this.props().pidMode(pidMode);
            return this;
        }

        public Builder placementConstraints(IResolvable placementConstraints) {
            this.props().placementConstraints(placementConstraints);
            return this;
        }

        public Builder placementConstraints(List<? extends Object> placementConstraints) {
            this.props().placementConstraints(placementConstraints);
            return this;
        }

        public Builder proxyConfiguration(IResolvable proxyConfiguration) {
            this.props().proxyConfiguration(proxyConfiguration);
            return this;
        }

        public Builder proxyConfiguration(ProxyConfigurationProperty proxyConfiguration) {
            this.props().proxyConfiguration(proxyConfiguration);
            return this;
        }

        public Builder requiresCompatibilities(List<String> requiresCompatibilities) {
            this.props().requiresCompatibilities(requiresCompatibilities);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        public Builder taskRoleArn(String taskRoleArn) {
            this.props().taskRoleArn(taskRoleArn);
            return this;
        }

        public Builder volumes(IResolvable volumes) {
            this.props().volumes(volumes);
            return this;
        }

        public Builder volumes(List<? extends Object> volumes) {
            this.props().volumes(volumes);
            return this;
        }

        public CfnTaskDefinition build() {
            return new CfnTaskDefinition(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private CfnTaskDefinitionProps.Builder props() {
            if (this.props == null) {
                this.props = new CfnTaskDefinitionProps.Builder();
            }
            return this.props;
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ecs.CfnTaskDefinition.VolumeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VolumeProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDockerVolumeConfiguration() {
            return null;
        }

        @Nullable
        default public Object getEfsVolumeConfiguration() {
            return null;
        }

        @Nullable
        default public Object getHost() {
            return null;
        }

        @Nullable
        default public String getName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VolumeProperty> {
            private Object dockerVolumeConfiguration;
            private Object efsVolumeConfiguration;
            private Object host;
            private String name;

            public Builder dockerVolumeConfiguration(IResolvable dockerVolumeConfiguration) {
                this.dockerVolumeConfiguration = dockerVolumeConfiguration;
                return this;
            }

            public Builder dockerVolumeConfiguration(DockerVolumeConfigurationProperty dockerVolumeConfiguration) {
                this.dockerVolumeConfiguration = dockerVolumeConfiguration;
                return this;
            }

            public Builder efsVolumeConfiguration(IResolvable efsVolumeConfiguration) {
                this.efsVolumeConfiguration = efsVolumeConfiguration;
                return this;
            }

            public Builder efsVolumeConfiguration(EfsVolumeConfigurationProperty efsVolumeConfiguration) {
                this.efsVolumeConfiguration = efsVolumeConfiguration;
                return this;
            }

            public Builder host(IResolvable host) {
                this.host = host;
                return this;
            }

            public Builder host(HostVolumePropertiesProperty host) {
                this.host = host;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public VolumeProperty build() {
                return new Jsii.Proxy(this.dockerVolumeConfiguration, this.efsVolumeConfiguration, this.host, this.name);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ecs.CfnTaskDefinition.VolumeFromProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VolumeFromProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getReadOnly() {
            return null;
        }

        @Nullable
        default public String getSourceContainer() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VolumeFromProperty> {
            private Object readOnly;
            private String sourceContainer;

            public Builder readOnly(Boolean readOnly) {
                this.readOnly = readOnly;
                return this;
            }

            public Builder readOnly(IResolvable readOnly) {
                this.readOnly = readOnly;
                return this;
            }

            public Builder sourceContainer(String sourceContainer) {
                this.sourceContainer = sourceContainer;
                return this;
            }

            public VolumeFromProperty build() {
                return new Jsii.Proxy(this.readOnly, this.sourceContainer);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ecs.CfnTaskDefinition.UlimitProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface UlimitProperty
    extends JsiiSerializable {
        @NotNull
        public Number getHardLimit();

        @NotNull
        public String getName();

        @NotNull
        public Number getSoftLimit();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<UlimitProperty> {
            private Number hardLimit;
            private String name;
            private Number softLimit;

            public Builder hardLimit(Number hardLimit) {
                this.hardLimit = hardLimit;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder softLimit(Number softLimit) {
                this.softLimit = softLimit;
                return this;
            }

            public UlimitProperty build() {
                return new Jsii.Proxy(this.hardLimit, this.name, this.softLimit);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ecs.CfnTaskDefinition.TmpfsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TmpfsProperty
    extends JsiiSerializable {
        @NotNull
        public Number getSize();

        @Nullable
        default public String getContainerPath() {
            return null;
        }

        @Nullable
        default public List<String> getMountOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TmpfsProperty> {
            private Number size;
            private String containerPath;
            private List<String> mountOptions;

            public Builder size(Number size) {
                this.size = size;
                return this;
            }

            public Builder containerPath(String containerPath) {
                this.containerPath = containerPath;
                return this;
            }

            public Builder mountOptions(List<String> mountOptions) {
                this.mountOptions = mountOptions;
                return this;
            }

            public TmpfsProperty build() {
                return new Jsii.Proxy(this.size, this.containerPath, this.mountOptions);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ecs.CfnTaskDefinition.TaskDefinitionPlacementConstraintProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TaskDefinitionPlacementConstraintProperty
    extends JsiiSerializable {
        @NotNull
        public String getType();

        @Nullable
        default public String getExpression() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TaskDefinitionPlacementConstraintProperty> {
            private String type;
            private String expression;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder expression(String expression) {
                this.expression = expression;
                return this;
            }

            public TaskDefinitionPlacementConstraintProperty build() {
                return new Jsii.Proxy(this.type, this.expression);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ecs.CfnTaskDefinition.SystemControlProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SystemControlProperty
    extends JsiiSerializable {
        @Nullable
        default public String getNamespace() {
            return null;
        }

        @Nullable
        default public String getValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SystemControlProperty> {
            private String namespace;
            private String value;

            public Builder namespace(String namespace) {
                this.namespace = namespace;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public SystemControlProperty build() {
                return new Jsii.Proxy(this.namespace, this.value);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ecs.CfnTaskDefinition.SecretProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SecretProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public String getValueFrom();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SecretProperty> {
            private String name;
            private String valueFrom;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder valueFrom(String valueFrom) {
                this.valueFrom = valueFrom;
                return this;
            }

            public SecretProperty build() {
                return new Jsii.Proxy(this.name, this.valueFrom);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ecs.CfnTaskDefinition.ResourceRequirementProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ResourceRequirementProperty
    extends JsiiSerializable {
        @NotNull
        public String getType();

        @NotNull
        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ResourceRequirementProperty> {
            private String type;
            private String value;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public ResourceRequirementProperty build() {
                return new Jsii.Proxy(this.type, this.value);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ecs.CfnTaskDefinition.RepositoryCredentialsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RepositoryCredentialsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getCredentialsParameter() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RepositoryCredentialsProperty> {
            private String credentialsParameter;

            public Builder credentialsParameter(String credentialsParameter) {
                this.credentialsParameter = credentialsParameter;
                return this;
            }

            public RepositoryCredentialsProperty build() {
                return new Jsii.Proxy(this.credentialsParameter);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ecs.CfnTaskDefinition.ProxyConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ProxyConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getContainerName();

        @Nullable
        default public Object getProxyConfigurationProperties() {
            return null;
        }

        @Nullable
        default public String getType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ProxyConfigurationProperty> {
            private String containerName;
            private Object proxyConfigurationProperties;
            private String type;

            public Builder containerName(String containerName) {
                this.containerName = containerName;
                return this;
            }

            public Builder proxyConfigurationProperties(IResolvable proxyConfigurationProperties) {
                this.proxyConfigurationProperties = proxyConfigurationProperties;
                return this;
            }

            public Builder proxyConfigurationProperties(List<? extends Object> proxyConfigurationProperties) {
                this.proxyConfigurationProperties = proxyConfigurationProperties;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public ProxyConfigurationProperty build() {
                return new Jsii.Proxy(this.containerName, this.proxyConfigurationProperties, this.type);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ecs.CfnTaskDefinition.PortMappingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PortMappingProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getContainerPort() {
            return null;
        }

        @Nullable
        default public Number getHostPort() {
            return null;
        }

        @Nullable
        default public String getProtocol() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PortMappingProperty> {
            private Number containerPort;
            private Number hostPort;
            private String protocol;

            public Builder containerPort(Number containerPort) {
                this.containerPort = containerPort;
                return this;
            }

            public Builder hostPort(Number hostPort) {
                this.hostPort = hostPort;
                return this;
            }

            public Builder protocol(String protocol) {
                this.protocol = protocol;
                return this;
            }

            public PortMappingProperty build() {
                return new Jsii.Proxy(this.containerPort, this.hostPort, this.protocol);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ecs.CfnTaskDefinition.MountPointProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MountPointProperty
    extends JsiiSerializable {
        @Nullable
        default public String getContainerPath() {
            return null;
        }

        @Nullable
        default public Object getReadOnly() {
            return null;
        }

        @Nullable
        default public String getSourceVolume() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MountPointProperty> {
            private String containerPath;
            private Object readOnly;
            private String sourceVolume;

            public Builder containerPath(String containerPath) {
                this.containerPath = containerPath;
                return this;
            }

            public Builder readOnly(Boolean readOnly) {
                this.readOnly = readOnly;
                return this;
            }

            public Builder readOnly(IResolvable readOnly) {
                this.readOnly = readOnly;
                return this;
            }

            public Builder sourceVolume(String sourceVolume) {
                this.sourceVolume = sourceVolume;
                return this;
            }

            public MountPointProperty build() {
                return new Jsii.Proxy(this.containerPath, this.readOnly, this.sourceVolume);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ecs.CfnTaskDefinition.LogConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LogConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getLogDriver();

        @Nullable
        default public Object getOptions() {
            return null;
        }

        @Nullable
        default public Object getSecretOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LogConfigurationProperty> {
            private String logDriver;
            private Object options;
            private Object secretOptions;

            public Builder logDriver(String logDriver) {
                this.logDriver = logDriver;
                return this;
            }

            public Builder options(IResolvable options) {
                this.options = options;
                return this;
            }

            public Builder options(Map<String, String> options) {
                this.options = options;
                return this;
            }

            public Builder secretOptions(IResolvable secretOptions) {
                this.secretOptions = secretOptions;
                return this;
            }

            public Builder secretOptions(List<? extends Object> secretOptions) {
                this.secretOptions = secretOptions;
                return this;
            }

            public LogConfigurationProperty build() {
                return new Jsii.Proxy(this.logDriver, this.options, this.secretOptions);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ecs.CfnTaskDefinition.LinuxParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LinuxParametersProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCapabilities() {
            return null;
        }

        @Nullable
        default public Object getDevices() {
            return null;
        }

        @Nullable
        default public Object getInitProcessEnabled() {
            return null;
        }

        @Nullable
        default public Number getMaxSwap() {
            return null;
        }

        @Nullable
        default public Number getSharedMemorySize() {
            return null;
        }

        @Nullable
        default public Number getSwappiness() {
            return null;
        }

        @Nullable
        default public Object getTmpfs() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LinuxParametersProperty> {
            private Object capabilities;
            private Object devices;
            private Object initProcessEnabled;
            private Number maxSwap;
            private Number sharedMemorySize;
            private Number swappiness;
            private Object tmpfs;

            public Builder capabilities(IResolvable capabilities) {
                this.capabilities = capabilities;
                return this;
            }

            public Builder capabilities(KernelCapabilitiesProperty capabilities) {
                this.capabilities = capabilities;
                return this;
            }

            public Builder devices(IResolvable devices) {
                this.devices = devices;
                return this;
            }

            public Builder devices(List<? extends Object> devices) {
                this.devices = devices;
                return this;
            }

            public Builder initProcessEnabled(Boolean initProcessEnabled) {
                this.initProcessEnabled = initProcessEnabled;
                return this;
            }

            public Builder initProcessEnabled(IResolvable initProcessEnabled) {
                this.initProcessEnabled = initProcessEnabled;
                return this;
            }

            public Builder maxSwap(Number maxSwap) {
                this.maxSwap = maxSwap;
                return this;
            }

            public Builder sharedMemorySize(Number sharedMemorySize) {
                this.sharedMemorySize = sharedMemorySize;
                return this;
            }

            public Builder swappiness(Number swappiness) {
                this.swappiness = swappiness;
                return this;
            }

            public Builder tmpfs(IResolvable tmpfs) {
                this.tmpfs = tmpfs;
                return this;
            }

            public Builder tmpfs(List<? extends Object> tmpfs) {
                this.tmpfs = tmpfs;
                return this;
            }

            public LinuxParametersProperty build() {
                return new Jsii.Proxy(this.capabilities, this.devices, this.initProcessEnabled, this.maxSwap, this.sharedMemorySize, this.swappiness, this.tmpfs);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ecs.CfnTaskDefinition.KeyValuePairProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KeyValuePairProperty
    extends JsiiSerializable {
        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public String getValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KeyValuePairProperty> {
            private String name;
            private String value;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public KeyValuePairProperty build() {
                return new Jsii.Proxy(this.name, this.value);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ecs.CfnTaskDefinition.KernelCapabilitiesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KernelCapabilitiesProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getAdd() {
            return null;
        }

        @Nullable
        default public List<String> getDrop() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KernelCapabilitiesProperty> {
            private List<String> add;
            private List<String> drop;

            public Builder add(List<String> add) {
                this.add = add;
                return this;
            }

            public Builder drop(List<String> drop) {
                this.drop = drop;
                return this;
            }

            public KernelCapabilitiesProperty build() {
                return new Jsii.Proxy(this.add, this.drop);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ecs.CfnTaskDefinition.InferenceAcceleratorProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InferenceAcceleratorProperty
    extends JsiiSerializable {
        @Nullable
        default public String getDeviceName() {
            return null;
        }

        @Nullable
        default public String getDeviceType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InferenceAcceleratorProperty> {
            private String deviceName;
            private String deviceType;

            public Builder deviceName(String deviceName) {
                this.deviceName = deviceName;
                return this;
            }

            public Builder deviceType(String deviceType) {
                this.deviceType = deviceType;
                return this;
            }

            public InferenceAcceleratorProperty build() {
                return new Jsii.Proxy(this.deviceName, this.deviceType);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ecs.CfnTaskDefinition.HostVolumePropertiesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HostVolumePropertiesProperty
    extends JsiiSerializable {
        @Nullable
        default public String getSourcePath() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HostVolumePropertiesProperty> {
            private String sourcePath;

            public Builder sourcePath(String sourcePath) {
                this.sourcePath = sourcePath;
                return this;
            }

            public HostVolumePropertiesProperty build() {
                return new Jsii.Proxy(this.sourcePath);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ecs.CfnTaskDefinition.HostEntryProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HostEntryProperty
    extends JsiiSerializable {
        @Nullable
        default public String getHostname() {
            return null;
        }

        @Nullable
        default public String getIpAddress() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HostEntryProperty> {
            private String hostname;
            private String ipAddress;

            public Builder hostname(String hostname) {
                this.hostname = hostname;
                return this;
            }

            public Builder ipAddress(String ipAddress) {
                this.ipAddress = ipAddress;
                return this;
            }

            public HostEntryProperty build() {
                return new Jsii.Proxy(this.hostname, this.ipAddress);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ecs.CfnTaskDefinition.HealthCheckProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HealthCheckProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getCommand() {
            return null;
        }

        @Nullable
        default public Number getInterval() {
            return null;
        }

        @Nullable
        default public Number getRetries() {
            return null;
        }

        @Nullable
        default public Number getStartPeriod() {
            return null;
        }

        @Nullable
        default public Number getTimeout() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HealthCheckProperty> {
            private List<String> command;
            private Number interval;
            private Number retries;
            private Number startPeriod;
            private Number timeout;

            public Builder command(List<String> command) {
                this.command = command;
                return this;
            }

            public Builder interval(Number interval) {
                this.interval = interval;
                return this;
            }

            public Builder retries(Number retries) {
                this.retries = retries;
                return this;
            }

            public Builder startPeriod(Number startPeriod) {
                this.startPeriod = startPeriod;
                return this;
            }

            public Builder timeout(Number timeout) {
                this.timeout = timeout;
                return this;
            }

            public HealthCheckProperty build() {
                return new Jsii.Proxy(this.command, this.interval, this.retries, this.startPeriod, this.timeout);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ecs.CfnTaskDefinition.FirelensConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FirelensConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getOptions() {
            return null;
        }

        @Nullable
        default public String getType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FirelensConfigurationProperty> {
            private Object options;
            private String type;

            public Builder options(IResolvable options) {
                this.options = options;
                return this;
            }

            public Builder options(Map<String, String> options) {
                this.options = options;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public FirelensConfigurationProperty build() {
                return new Jsii.Proxy(this.options, this.type);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ecs.CfnTaskDefinition.EnvironmentFileProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EnvironmentFileProperty
    extends JsiiSerializable {
        @Nullable
        default public String getType() {
            return null;
        }

        @Nullable
        default public String getValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EnvironmentFileProperty> {
            private String type;
            private String value;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public EnvironmentFileProperty build() {
                return new Jsii.Proxy(this.type, this.value);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ecs.CfnTaskDefinition.EfsVolumeConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EfsVolumeConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getFileSystemId();

        @Nullable
        default public Object getAuthorizationConfig() {
            return null;
        }

        @Nullable
        default public String getRootDirectory() {
            return null;
        }

        @Nullable
        default public String getTransitEncryption() {
            return null;
        }

        @Nullable
        default public Number getTransitEncryptionPort() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EfsVolumeConfigurationProperty> {
            private String fileSystemId;
            private Object authorizationConfig;
            private String rootDirectory;
            private String transitEncryption;
            private Number transitEncryptionPort;

            public Builder fileSystemId(String fileSystemId) {
                this.fileSystemId = fileSystemId;
                return this;
            }

            public Builder authorizationConfig(IResolvable authorizationConfig) {
                this.authorizationConfig = authorizationConfig;
                return this;
            }

            public Builder authorizationConfig(AuthorizationConfigProperty authorizationConfig) {
                this.authorizationConfig = authorizationConfig;
                return this;
            }

            public Builder rootDirectory(String rootDirectory) {
                this.rootDirectory = rootDirectory;
                return this;
            }

            public Builder transitEncryption(String transitEncryption) {
                this.transitEncryption = transitEncryption;
                return this;
            }

            public Builder transitEncryptionPort(Number transitEncryptionPort) {
                this.transitEncryptionPort = transitEncryptionPort;
                return this;
            }

            public EfsVolumeConfigurationProperty build() {
                return new Jsii.Proxy(this.fileSystemId, this.authorizationConfig, this.rootDirectory, this.transitEncryption, this.transitEncryptionPort);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ecs.CfnTaskDefinition.DockerVolumeConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DockerVolumeConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAutoprovision() {
            return null;
        }

        @Nullable
        default public String getDriver() {
            return null;
        }

        @Nullable
        default public Object getDriverOpts() {
            return null;
        }

        @Nullable
        default public Object getLabels() {
            return null;
        }

        @Nullable
        default public String getScope() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DockerVolumeConfigurationProperty> {
            private Object autoprovision;
            private String driver;
            private Object driverOpts;
            private Object labels;
            private String scope;

            public Builder autoprovision(Boolean autoprovision) {
                this.autoprovision = autoprovision;
                return this;
            }

            public Builder autoprovision(IResolvable autoprovision) {
                this.autoprovision = autoprovision;
                return this;
            }

            public Builder driver(String driver) {
                this.driver = driver;
                return this;
            }

            public Builder driverOpts(IResolvable driverOpts) {
                this.driverOpts = driverOpts;
                return this;
            }

            public Builder driverOpts(Map<String, String> driverOpts) {
                this.driverOpts = driverOpts;
                return this;
            }

            public Builder labels(IResolvable labels) {
                this.labels = labels;
                return this;
            }

            public Builder labels(Map<String, String> labels) {
                this.labels = labels;
                return this;
            }

            public Builder scope(String scope) {
                this.scope = scope;
                return this;
            }

            public DockerVolumeConfigurationProperty build() {
                return new Jsii.Proxy(this.autoprovision, this.driver, this.driverOpts, this.labels, this.scope);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ecs.CfnTaskDefinition.DeviceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DeviceProperty
    extends JsiiSerializable {
        @Nullable
        default public String getContainerPath() {
            return null;
        }

        @Nullable
        default public String getHostPath() {
            return null;
        }

        @Nullable
        default public List<String> getPermissions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DeviceProperty> {
            private String containerPath;
            private String hostPath;
            private List<String> permissions;

            public Builder containerPath(String containerPath) {
                this.containerPath = containerPath;
                return this;
            }

            public Builder hostPath(String hostPath) {
                this.hostPath = hostPath;
                return this;
            }

            public Builder permissions(List<String> permissions) {
                this.permissions = permissions;
                return this;
            }

            public DeviceProperty build() {
                return new Jsii.Proxy(this.containerPath, this.hostPath, this.permissions);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ecs.CfnTaskDefinition.ContainerDependencyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ContainerDependencyProperty
    extends JsiiSerializable {
        @Nullable
        default public String getCondition() {
            return null;
        }

        @Nullable
        default public String getContainerName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ContainerDependencyProperty> {
            private String condition;
            private String containerName;

            public Builder condition(String condition) {
                this.condition = condition;
                return this;
            }

            public Builder containerName(String containerName) {
                this.containerName = containerName;
                return this;
            }

            public ContainerDependencyProperty build() {
                return new Jsii.Proxy(this.condition, this.containerName);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ecs.CfnTaskDefinition.ContainerDefinitionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ContainerDefinitionProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getCommand() {
            return null;
        }

        @Nullable
        default public Number getCpu() {
            return null;
        }

        @Nullable
        default public Object getDependsOn() {
            return null;
        }

        @Nullable
        default public Object getDisableNetworking() {
            return null;
        }

        @Nullable
        default public List<String> getDnsSearchDomains() {
            return null;
        }

        @Nullable
        default public List<String> getDnsServers() {
            return null;
        }

        @Nullable
        default public Object getDockerLabels() {
            return null;
        }

        @Nullable
        default public List<String> getDockerSecurityOptions() {
            return null;
        }

        @Nullable
        default public List<String> getEntryPoint() {
            return null;
        }

        @Nullable
        default public Object getEnvironment() {
            return null;
        }

        @Nullable
        default public Object getEnvironmentFiles() {
            return null;
        }

        @Nullable
        default public Object getEssential() {
            return null;
        }

        @Nullable
        default public Object getExtraHosts() {
            return null;
        }

        @Nullable
        default public Object getFirelensConfiguration() {
            return null;
        }

        @Nullable
        default public Object getHealthCheck() {
            return null;
        }

        @Nullable
        default public String getHostname() {
            return null;
        }

        @Nullable
        default public String getImage() {
            return null;
        }

        @Nullable
        default public Object getInteractive() {
            return null;
        }

        @Nullable
        default public List<String> getLinks() {
            return null;
        }

        @Nullable
        default public Object getLinuxParameters() {
            return null;
        }

        @Nullable
        default public Object getLogConfiguration() {
            return null;
        }

        @Nullable
        default public Number getMemory() {
            return null;
        }

        @Nullable
        default public Number getMemoryReservation() {
            return null;
        }

        @Nullable
        default public Object getMountPoints() {
            return null;
        }

        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public Object getPortMappings() {
            return null;
        }

        @Nullable
        default public Object getPrivileged() {
            return null;
        }

        @Nullable
        default public Object getPseudoTerminal() {
            return null;
        }

        @Nullable
        default public Object getReadonlyRootFilesystem() {
            return null;
        }

        @Nullable
        default public Object getRepositoryCredentials() {
            return null;
        }

        @Nullable
        default public Object getResourceRequirements() {
            return null;
        }

        @Nullable
        default public Object getSecrets() {
            return null;
        }

        @Nullable
        default public Number getStartTimeout() {
            return null;
        }

        @Nullable
        default public Number getStopTimeout() {
            return null;
        }

        @Nullable
        default public Object getSystemControls() {
            return null;
        }

        @Nullable
        default public Object getUlimits() {
            return null;
        }

        @Nullable
        default public String getUser() {
            return null;
        }

        @Nullable
        default public Object getVolumesFrom() {
            return null;
        }

        @Nullable
        default public String getWorkingDirectory() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ContainerDefinitionProperty> {
            private List<String> command;
            private Number cpu;
            private Object dependsOn;
            private Object disableNetworking;
            private List<String> dnsSearchDomains;
            private List<String> dnsServers;
            private Object dockerLabels;
            private List<String> dockerSecurityOptions;
            private List<String> entryPoint;
            private Object environment;
            private Object environmentFiles;
            private Object essential;
            private Object extraHosts;
            private Object firelensConfiguration;
            private Object healthCheck;
            private String hostname;
            private String image;
            private Object interactive;
            private List<String> links;
            private Object linuxParameters;
            private Object logConfiguration;
            private Number memory;
            private Number memoryReservation;
            private Object mountPoints;
            private String name;
            private Object portMappings;
            private Object privileged;
            private Object pseudoTerminal;
            private Object readonlyRootFilesystem;
            private Object repositoryCredentials;
            private Object resourceRequirements;
            private Object secrets;
            private Number startTimeout;
            private Number stopTimeout;
            private Object systemControls;
            private Object ulimits;
            private String user;
            private Object volumesFrom;
            private String workingDirectory;

            public Builder command(List<String> command) {
                this.command = command;
                return this;
            }

            public Builder cpu(Number cpu) {
                this.cpu = cpu;
                return this;
            }

            public Builder dependsOn(IResolvable dependsOn) {
                this.dependsOn = dependsOn;
                return this;
            }

            public Builder dependsOn(List<? extends Object> dependsOn) {
                this.dependsOn = dependsOn;
                return this;
            }

            public Builder disableNetworking(Boolean disableNetworking) {
                this.disableNetworking = disableNetworking;
                return this;
            }

            public Builder disableNetworking(IResolvable disableNetworking) {
                this.disableNetworking = disableNetworking;
                return this;
            }

            public Builder dnsSearchDomains(List<String> dnsSearchDomains) {
                this.dnsSearchDomains = dnsSearchDomains;
                return this;
            }

            public Builder dnsServers(List<String> dnsServers) {
                this.dnsServers = dnsServers;
                return this;
            }

            public Builder dockerLabels(IResolvable dockerLabels) {
                this.dockerLabels = dockerLabels;
                return this;
            }

            public Builder dockerLabels(Map<String, String> dockerLabels) {
                this.dockerLabels = dockerLabels;
                return this;
            }

            public Builder dockerSecurityOptions(List<String> dockerSecurityOptions) {
                this.dockerSecurityOptions = dockerSecurityOptions;
                return this;
            }

            public Builder entryPoint(List<String> entryPoint) {
                this.entryPoint = entryPoint;
                return this;
            }

            public Builder environment(IResolvable environment) {
                this.environment = environment;
                return this;
            }

            public Builder environment(List<? extends Object> environment) {
                this.environment = environment;
                return this;
            }

            public Builder environmentFiles(IResolvable environmentFiles) {
                this.environmentFiles = environmentFiles;
                return this;
            }

            public Builder environmentFiles(List<? extends Object> environmentFiles) {
                this.environmentFiles = environmentFiles;
                return this;
            }

            public Builder essential(Boolean essential) {
                this.essential = essential;
                return this;
            }

            public Builder essential(IResolvable essential) {
                this.essential = essential;
                return this;
            }

            public Builder extraHosts(IResolvable extraHosts) {
                this.extraHosts = extraHosts;
                return this;
            }

            public Builder extraHosts(List<? extends Object> extraHosts) {
                this.extraHosts = extraHosts;
                return this;
            }

            public Builder firelensConfiguration(IResolvable firelensConfiguration) {
                this.firelensConfiguration = firelensConfiguration;
                return this;
            }

            public Builder firelensConfiguration(FirelensConfigurationProperty firelensConfiguration) {
                this.firelensConfiguration = firelensConfiguration;
                return this;
            }

            public Builder healthCheck(IResolvable healthCheck) {
                this.healthCheck = healthCheck;
                return this;
            }

            public Builder healthCheck(HealthCheckProperty healthCheck) {
                this.healthCheck = healthCheck;
                return this;
            }

            public Builder hostname(String hostname) {
                this.hostname = hostname;
                return this;
            }

            public Builder image(String image) {
                this.image = image;
                return this;
            }

            public Builder interactive(Boolean interactive) {
                this.interactive = interactive;
                return this;
            }

            public Builder interactive(IResolvable interactive) {
                this.interactive = interactive;
                return this;
            }

            public Builder links(List<String> links) {
                this.links = links;
                return this;
            }

            public Builder linuxParameters(IResolvable linuxParameters) {
                this.linuxParameters = linuxParameters;
                return this;
            }

            public Builder linuxParameters(LinuxParametersProperty linuxParameters) {
                this.linuxParameters = linuxParameters;
                return this;
            }

            public Builder logConfiguration(IResolvable logConfiguration) {
                this.logConfiguration = logConfiguration;
                return this;
            }

            public Builder logConfiguration(LogConfigurationProperty logConfiguration) {
                this.logConfiguration = logConfiguration;
                return this;
            }

            public Builder memory(Number memory) {
                this.memory = memory;
                return this;
            }

            public Builder memoryReservation(Number memoryReservation) {
                this.memoryReservation = memoryReservation;
                return this;
            }

            public Builder mountPoints(IResolvable mountPoints) {
                this.mountPoints = mountPoints;
                return this;
            }

            public Builder mountPoints(List<? extends Object> mountPoints) {
                this.mountPoints = mountPoints;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder portMappings(IResolvable portMappings) {
                this.portMappings = portMappings;
                return this;
            }

            public Builder portMappings(List<? extends Object> portMappings) {
                this.portMappings = portMappings;
                return this;
            }

            public Builder privileged(Boolean privileged) {
                this.privileged = privileged;
                return this;
            }

            public Builder privileged(IResolvable privileged) {
                this.privileged = privileged;
                return this;
            }

            public Builder pseudoTerminal(Boolean pseudoTerminal) {
                this.pseudoTerminal = pseudoTerminal;
                return this;
            }

            public Builder pseudoTerminal(IResolvable pseudoTerminal) {
                this.pseudoTerminal = pseudoTerminal;
                return this;
            }

            public Builder readonlyRootFilesystem(Boolean readonlyRootFilesystem) {
                this.readonlyRootFilesystem = readonlyRootFilesystem;
                return this;
            }

            public Builder readonlyRootFilesystem(IResolvable readonlyRootFilesystem) {
                this.readonlyRootFilesystem = readonlyRootFilesystem;
                return this;
            }

            public Builder repositoryCredentials(IResolvable repositoryCredentials) {
                this.repositoryCredentials = repositoryCredentials;
                return this;
            }

            public Builder repositoryCredentials(RepositoryCredentialsProperty repositoryCredentials) {
                this.repositoryCredentials = repositoryCredentials;
                return this;
            }

            public Builder resourceRequirements(IResolvable resourceRequirements) {
                this.resourceRequirements = resourceRequirements;
                return this;
            }

            public Builder resourceRequirements(List<? extends Object> resourceRequirements) {
                this.resourceRequirements = resourceRequirements;
                return this;
            }

            public Builder secrets(IResolvable secrets) {
                this.secrets = secrets;
                return this;
            }

            public Builder secrets(List<? extends Object> secrets) {
                this.secrets = secrets;
                return this;
            }

            public Builder startTimeout(Number startTimeout) {
                this.startTimeout = startTimeout;
                return this;
            }

            public Builder stopTimeout(Number stopTimeout) {
                this.stopTimeout = stopTimeout;
                return this;
            }

            public Builder systemControls(IResolvable systemControls) {
                this.systemControls = systemControls;
                return this;
            }

            public Builder systemControls(List<? extends Object> systemControls) {
                this.systemControls = systemControls;
                return this;
            }

            public Builder ulimits(IResolvable ulimits) {
                this.ulimits = ulimits;
                return this;
            }

            public Builder ulimits(List<? extends Object> ulimits) {
                this.ulimits = ulimits;
                return this;
            }

            public Builder user(String user) {
                this.user = user;
                return this;
            }

            public Builder volumesFrom(IResolvable volumesFrom) {
                this.volumesFrom = volumesFrom;
                return this;
            }

            public Builder volumesFrom(List<? extends Object> volumesFrom) {
                this.volumesFrom = volumesFrom;
                return this;
            }

            public Builder workingDirectory(String workingDirectory) {
                this.workingDirectory = workingDirectory;
                return this;
            }

            public ContainerDefinitionProperty build() {
                return new Jsii.Proxy(this.command, this.cpu, this.dependsOn, this.disableNetworking, this.dnsSearchDomains, this.dnsServers, this.dockerLabels, this.dockerSecurityOptions, this.entryPoint, this.environment, this.environmentFiles, this.essential, this.extraHosts, this.firelensConfiguration, this.healthCheck, this.hostname, this.image, this.interactive, this.links, this.linuxParameters, this.logConfiguration, this.memory, this.memoryReservation, this.mountPoints, this.name, this.portMappings, this.privileged, this.pseudoTerminal, this.readonlyRootFilesystem, this.repositoryCredentials, this.resourceRequirements, this.secrets, this.startTimeout, this.stopTimeout, this.systemControls, this.ulimits, this.user, this.volumesFrom, this.workingDirectory);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-ecs.CfnTaskDefinition.AuthorizationConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AuthorizationConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAccessPointId() {
            return null;
        }

        @Nullable
        default public String getIam() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AuthorizationConfigProperty> {
            private String accessPointId;
            private String iam;

            public Builder accessPointId(String accessPointId) {
                this.accessPointId = accessPointId;
                return this;
            }

            public Builder iam(String iam) {
                this.iam = iam;
                return this;
            }

            public AuthorizationConfigProperty build() {
                return new Jsii.Proxy(this.accessPointId, this.iam);
            }
        }
    }
}

