package software.amazon.awscdk.services.eks;

/**
 * Controller version.
 * <p>
 * Corresponds to the image tag of 'amazon/aws-load-balancer-controller' image.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster.Builder.create(this, "HelloEKS")
 *         .version(KubernetesVersion.V1_21)
 *         .albController(AlbControllerOptions.builder()
 *                 .version(AlbControllerVersion.V2_4_1)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-07T17:24:46.601Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.eks.$Module.class, fqn = "@aws-cdk/aws-eks.AlbControllerVersion")
public class AlbControllerVersion extends software.amazon.jsii.JsiiObject {

    protected AlbControllerVersion(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AlbControllerVersion(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        V2_0_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "V2_0_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class));
        V2_0_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "V2_0_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class));
        V2_1_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "V2_1_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class));
        V2_1_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "V2_1_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class));
        V2_1_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "V2_1_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class));
        V2_1_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "V2_1_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class));
        V2_2_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "V2_2_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class));
        V2_2_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "V2_2_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class));
        V2_2_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "V2_2_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class));
        V2_2_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "V2_2_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class));
        V2_2_4 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "V2_2_4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class));
        V2_3_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "V2_3_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class));
        V2_3_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "V2_3_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class));
        V2_4_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "V2_4_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class));
    }

    /**
     * Specify a custom version.
     * <p>
     * Use this if the version you need is not available in one of the predefined versions.
     * Note that in this case, you will also need to provide an IAM policy in the controller options.
     * <p>
     * @param version The version number. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.AlbControllerVersion of(final @org.jetbrains.annotations.NotNull java.lang.String version) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.eks.AlbControllerVersion.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerVersion.class), new Object[] { java.util.Objects.requireNonNull(version, "version is required") });
    }

    /**
     * v2.0.0.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AlbControllerVersion V2_0_0;

    /**
     * v2.0.1.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AlbControllerVersion V2_0_1;

    /**
     * v2.1.0.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AlbControllerVersion V2_1_0;

    /**
     * v2.1.1.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AlbControllerVersion V2_1_1;

    /**
     * v2.1.2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AlbControllerVersion V2_1_2;

    /**
     * v2.1.3.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AlbControllerVersion V2_1_3;

    /**
     * v2.0.0.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AlbControllerVersion V2_2_0;

    /**
     * v2.2.1.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AlbControllerVersion V2_2_1;

    /**
     * v2.2.2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AlbControllerVersion V2_2_2;

    /**
     * v2.2.3.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AlbControllerVersion V2_2_3;

    /**
     * v2.2.4.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AlbControllerVersion V2_2_4;

    /**
     * v2.3.0.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AlbControllerVersion V2_3_0;

    /**
     * v2.3.1.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AlbControllerVersion V2_3_1;

    /**
     * v2.4.1.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AlbControllerVersion V2_4_1;

    /**
     * Whether or not its a custom version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getCustom() {
        return software.amazon.jsii.Kernel.get(this, "custom", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * The version string.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getVersion() {
        return software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
