package software.amazon.awscdk.services.eks;

/**
 * Capacity type of the managed node group.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * cluster.addNodegroupCapacity("extra-ng-spot", NodegroupOptions.builder()
 *         .instanceTypes(List.of(
 *             new InstanceType("c5.large"),
 *             new InstanceType("c5a.large"),
 *             new InstanceType("c5d.large")))
 *         .minSize(3)
 *         .capacityType(CapacityType.SPOT)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-07T17:24:46.624Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.eks.$Module.class, fqn = "@aws-cdk/aws-eks.CapacityType")
public enum CapacityType {
    /**
     * spot instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SPOT,
    /**
     * on-demand instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ON_DEMAND,
}
