package software.amazon.awscdk.services.eks;

/**
 * Options for `KubernetesManifest`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.eks.*;
 * KubernetesManifestOptions kubernetesManifestOptions = KubernetesManifestOptions.builder()
 *         .ingressAlb(false)
 *         .ingressAlbScheme(AlbScheme.INTERNAL)
 *         .prune(false)
 *         .skipValidation(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-07T17:24:46.723Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.eks.$Module.class, fqn = "@aws-cdk/aws-eks.KubernetesManifestOptions")
@software.amazon.jsii.Jsii.Proxy(KubernetesManifestOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface KubernetesManifestOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Automatically detect `Ingress` resources in the manifest and annotate them so they are picked up by an ALB Ingress Controller.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIngressAlb() {
        return null;
    }

    /**
     * Specify the ALB scheme that should be applied to `Ingress` resources.
     * <p>
     * Only applicable if <code>ingressAlb</code> is set to <code>true</code>.
     * <p>
     * Default: AlbScheme.INTERNAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.eks.AlbScheme getIngressAlbScheme() {
        return null;
    }

    /**
     * When a resource is removed from a Kubernetes manifest, it no longer appears in the manifest, and there is no way to know that this resource needs to be deleted.
     * <p>
     * To address this, <code>kubectl apply</code> has a <code>--prune</code> option which will
     * query the cluster for all resources with a specific label and will remove
     * all the labeld resources that are not part of the applied manifest. If this
     * option is disabled and a resource is removed, it will become "orphaned" and
     * will not be deleted from the cluster.
     * <p>
     * When this option is enabled (default), the construct will inject a label to
     * all Kubernetes resources included in this manifest which will be used to
     * prune resources when the manifest changes via <code>kubectl apply --prune</code>.
     * <p>
     * The label name will be <code>aws.cdk.eks/prune-&lt;ADDR&gt;</code> where <code>&lt;ADDR&gt;</code> is the
     * 42-char unique address of this construct in the construct tree. Value is
     * empty.
     * <p>
     * Default: - based on the prune option of the cluster, which is `true` unless
     * otherwise specified.
     * <p>
     * @see <a href="https://kubernetes.io/docs/tasks/manage-kubernetes-objects/declarative-config/#alternative-kubectl-apply-f-directory-prune-l-your-label">https://kubernetes.io/docs/tasks/manage-kubernetes-objects/declarative-config/#alternative-kubectl-apply-f-directory-prune-l-your-label</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPrune() {
        return null;
    }

    /**
     * A flag to signify if the manifest validation should be skipped.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSkipValidation() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link KubernetesManifestOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link KubernetesManifestOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<KubernetesManifestOptions> {
        java.lang.Boolean ingressAlb;
        software.amazon.awscdk.services.eks.AlbScheme ingressAlbScheme;
        java.lang.Boolean prune;
        java.lang.Boolean skipValidation;

        /**
         * Sets the value of {@link KubernetesManifestOptions#getIngressAlb}
         * @param ingressAlb Automatically detect `Ingress` resources in the manifest and annotate them so they are picked up by an ALB Ingress Controller.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ingressAlb(java.lang.Boolean ingressAlb) {
            this.ingressAlb = ingressAlb;
            return this;
        }

        /**
         * Sets the value of {@link KubernetesManifestOptions#getIngressAlbScheme}
         * @param ingressAlbScheme Specify the ALB scheme that should be applied to `Ingress` resources.
         *                         Only applicable if <code>ingressAlb</code> is set to <code>true</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ingressAlbScheme(software.amazon.awscdk.services.eks.AlbScheme ingressAlbScheme) {
            this.ingressAlbScheme = ingressAlbScheme;
            return this;
        }

        /**
         * Sets the value of {@link KubernetesManifestOptions#getPrune}
         * @param prune When a resource is removed from a Kubernetes manifest, it no longer appears in the manifest, and there is no way to know that this resource needs to be deleted.
         *              To address this, <code>kubectl apply</code> has a <code>--prune</code> option which will
         *              query the cluster for all resources with a specific label and will remove
         *              all the labeld resources that are not part of the applied manifest. If this
         *              option is disabled and a resource is removed, it will become "orphaned" and
         *              will not be deleted from the cluster.
         *              <p>
         *              When this option is enabled (default), the construct will inject a label to
         *              all Kubernetes resources included in this manifest which will be used to
         *              prune resources when the manifest changes via <code>kubectl apply --prune</code>.
         *              <p>
         *              The label name will be <code>aws.cdk.eks/prune-&lt;ADDR&gt;</code> where <code>&lt;ADDR&gt;</code> is the
         *              42-char unique address of this construct in the construct tree. Value is
         *              empty.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder prune(java.lang.Boolean prune) {
            this.prune = prune;
            return this;
        }

        /**
         * Sets the value of {@link KubernetesManifestOptions#getSkipValidation}
         * @param skipValidation A flag to signify if the manifest validation should be skipped.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder skipValidation(java.lang.Boolean skipValidation) {
            this.skipValidation = skipValidation;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link KubernetesManifestOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public KubernetesManifestOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link KubernetesManifestOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KubernetesManifestOptions {
        private final java.lang.Boolean ingressAlb;
        private final software.amazon.awscdk.services.eks.AlbScheme ingressAlbScheme;
        private final java.lang.Boolean prune;
        private final java.lang.Boolean skipValidation;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.ingressAlb = software.amazon.jsii.Kernel.get(this, "ingressAlb", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.ingressAlbScheme = software.amazon.jsii.Kernel.get(this, "ingressAlbScheme", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbScheme.class));
            this.prune = software.amazon.jsii.Kernel.get(this, "prune", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.skipValidation = software.amazon.jsii.Kernel.get(this, "skipValidation", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.ingressAlb = builder.ingressAlb;
            this.ingressAlbScheme = builder.ingressAlbScheme;
            this.prune = builder.prune;
            this.skipValidation = builder.skipValidation;
        }

        @Override
        public final java.lang.Boolean getIngressAlb() {
            return this.ingressAlb;
        }

        @Override
        public final software.amazon.awscdk.services.eks.AlbScheme getIngressAlbScheme() {
            return this.ingressAlbScheme;
        }

        @Override
        public final java.lang.Boolean getPrune() {
            return this.prune;
        }

        @Override
        public final java.lang.Boolean getSkipValidation() {
            return this.skipValidation;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getIngressAlb() != null) {
                data.set("ingressAlb", om.valueToTree(this.getIngressAlb()));
            }
            if (this.getIngressAlbScheme() != null) {
                data.set("ingressAlbScheme", om.valueToTree(this.getIngressAlbScheme()));
            }
            if (this.getPrune() != null) {
                data.set("prune", om.valueToTree(this.getPrune()));
            }
            if (this.getSkipValidation() != null) {
                data.set("skipValidation", om.valueToTree(this.getSkipValidation()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-eks.KubernetesManifestOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            KubernetesManifestOptions.Jsii$Proxy that = (KubernetesManifestOptions.Jsii$Proxy) o;

            if (this.ingressAlb != null ? !this.ingressAlb.equals(that.ingressAlb) : that.ingressAlb != null) return false;
            if (this.ingressAlbScheme != null ? !this.ingressAlbScheme.equals(that.ingressAlbScheme) : that.ingressAlbScheme != null) return false;
            if (this.prune != null ? !this.prune.equals(that.prune) : that.prune != null) return false;
            return this.skipValidation != null ? this.skipValidation.equals(that.skipValidation) : that.skipValidation == null;
        }

        @Override
        public final int hashCode() {
            int result = this.ingressAlb != null ? this.ingressAlb.hashCode() : 0;
            result = 31 * result + (this.ingressAlbScheme != null ? this.ingressAlbScheme.hashCode() : 0);
            result = 31 * result + (this.prune != null ? this.prune.hashCode() : 0);
            result = 31 * result + (this.skipValidation != null ? this.skipValidation.hashCode() : 0);
            return result;
        }
    }
}
