package software.amazon.awscdk.services.eks;

/**
 * The machine image type.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * cluster.addAutoScalingGroupCapacity("BottlerocketNodes", AutoScalingGroupCapacityOptions.builder()
 *         .instanceType(new InstanceType("t3.small"))
 *         .minCapacity(2)
 *         .machineImageType(MachineImageType.BOTTLEROCKET)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-07T17:24:46.748Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.eks.$Module.class, fqn = "@aws-cdk/aws-eks.MachineImageType")
public enum MachineImageType {
    /**
     * Amazon EKS-optimized Linux AMI.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AMAZON_LINUX_2,
    /**
     * Bottlerocket AMI.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BOTTLEROCKET,
}
