package software.amazon.awscdk.services.eks;

/**
 * EKS cluster logging types.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster = Cluster.Builder.create(this, "Cluster")
 *         // ...
 *         .version(KubernetesVersion.V1_21)
 *         .clusterLogging(List.of(ClusterLoggingTypes.API, ClusterLoggingTypes.AUTHENTICATOR, ClusterLoggingTypes.SCHEDULER))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.84.0 (build 5404dcf)", date = "2023-06-19T16:30:46.575Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.eks.$Module.class, fqn = "@aws-cdk/aws-eks.ClusterLoggingTypes")
public enum ClusterLoggingTypes {
    /**
     * Logs pertaining to API requests to the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    API,
    /**
     * Logs pertaining to cluster access via the Kubernetes API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AUDIT,
    /**
     * Logs pertaining to authentication requests into the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AUTHENTICATOR,
    /**
     * Logs pertaining to state of cluster controllers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CONTROLLER_MANAGER,
    /**
     * Logs pertaining to scheduling decisions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SCHEDULER,
}
