package software.amazon.awscdk.services.eks;

/**
 * IAM OIDC identity providers are entities in IAM that describe an external identity provider (IdP) service that supports the OpenID Connect (OIDC) standard, such as Google or Salesforce.
 * <p>
 * You use an IAM OIDC identity provider
 * when you want to establish trust between an OIDC-compatible IdP and your AWS
 * account.
 * <p>
 * This implementation has default values for thumbprints and clientIds props
 * that will be compatible with the eks cluster
 * <p>
 * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_oidc.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.24.0 (build b722f66)", date = "2021-03-11T13:47:08.098Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.eks.$Module.class, fqn = "@aws-cdk/aws-eks.OpenIdConnectProvider")
public class OpenIdConnectProvider extends software.amazon.awscdk.services.iam.OpenIdConnectProvider {

    protected OpenIdConnectProvider(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected OpenIdConnectProvider(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Defines an OpenID Connect provider.
     * <p>
     * @param scope The definition scope. This parameter is required.
     * @param id Construct ID. This parameter is required.
     * @param props Initialization properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public OpenIdConnectProvider(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.OpenIdConnectProviderProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.eks.OpenIdConnectProvider}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.eks.OpenIdConnectProvider> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope The definition scope. This parameter is required.
         * @param id Construct ID. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.eks.OpenIdConnectProviderProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.eks.OpenIdConnectProviderProps.Builder();
        }

        /**
         * The URL of the identity provider.
         * <p>
         * The URL must begin with https:// and
         * should correspond to the iss claim in the provider's OpenID Connect ID
         * tokens. Per the OIDC standard, path components are allowed but query
         * parameters are not. Typically the URL consists of only a hostname, like
         * https://server.example.org or https://example.com.
         * <p>
         * You can find your OIDC Issuer URL by:
         * aws eks describe-cluster --name %cluster_name% --query "cluster.identity.oidc.issuer" --output text
         * <p>
         * @return {@code this}
         * @param url The URL of the identity provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder url(final java.lang.String url) {
            this.props.url(url);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.eks.OpenIdConnectProvider}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.eks.OpenIdConnectProvider build() {
            return new software.amazon.awscdk.services.eks.OpenIdConnectProvider(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
