package software.amazon.awscdk.services.elasticbeanstalk.cloudformation;

/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.10 (build 35934ad)", date = "2018-11-12T19:52:59.324Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticbeanstalk.$Module.class, fqn = "@aws-cdk/aws-elasticbeanstalk.cloudformation.ApplicationVersionResource")
public class ApplicationVersionResource extends software.amazon.awscdk.Resource {
    protected ApplicationVersionResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ApplicationVersionResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::ElasticBeanstalk::ApplicationVersion``.
     * @param parent the ``cdk.Construct`` this ``ApplicationVersionResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``ApplicationVersionResource``
     */
    public ApplicationVersionResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, final software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ApplicationVersionResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required"))).toArray());
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required")).toArray());
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    public java.lang.String getApplicationVersionName() {
        return this.jsiiGet("applicationVersionName", java.lang.String.class);
    }

    public software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ApplicationVersionResourceProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ApplicationVersionResourceProps.class);
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-sourcebundle.html
     */
    public static interface SourceBundleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``ApplicationVersionResource.SourceBundleProperty.S3Bucket``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-sourcebundle.html#cfn-beanstalk-sourcebundle-s3bucket
         */
        java.lang.Object getS3Bucket();
        /**
         * ``ApplicationVersionResource.SourceBundleProperty.S3Bucket``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-sourcebundle.html#cfn-beanstalk-sourcebundle-s3bucket
         */
        void setS3Bucket(final java.lang.String value);
        /**
         * ``ApplicationVersionResource.SourceBundleProperty.S3Bucket``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-sourcebundle.html#cfn-beanstalk-sourcebundle-s3bucket
         */
        void setS3Bucket(final software.amazon.awscdk.Token value);
        /**
         * ``ApplicationVersionResource.SourceBundleProperty.S3Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-sourcebundle.html#cfn-beanstalk-sourcebundle-s3key
         */
        java.lang.Object getS3Key();
        /**
         * ``ApplicationVersionResource.SourceBundleProperty.S3Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-sourcebundle.html#cfn-beanstalk-sourcebundle-s3key
         */
        void setS3Key(final java.lang.String value);
        /**
         * ``ApplicationVersionResource.SourceBundleProperty.S3Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-sourcebundle.html#cfn-beanstalk-sourcebundle-s3key
         */
        void setS3Key(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link SourceBundleProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SourceBundleProperty}
         */
        final class Builder {
            private java.lang.Object _s3Bucket;
            private java.lang.Object _s3Key;

            /**
             * Sets the value of S3Bucket
             * @param value ``ApplicationVersionResource.SourceBundleProperty.S3Bucket``
             * @return {@code this}
             */
            public Builder withS3Bucket(final java.lang.String value) {
                this._s3Bucket = java.util.Objects.requireNonNull(value, "s3Bucket is required");
                return this;
            }
            /**
             * Sets the value of S3Bucket
             * @param value ``ApplicationVersionResource.SourceBundleProperty.S3Bucket``
             * @return {@code this}
             */
            public Builder withS3Bucket(final software.amazon.awscdk.Token value) {
                this._s3Bucket = java.util.Objects.requireNonNull(value, "s3Bucket is required");
                return this;
            }
            /**
             * Sets the value of S3Key
             * @param value ``ApplicationVersionResource.SourceBundleProperty.S3Key``
             * @return {@code this}
             */
            public Builder withS3Key(final java.lang.String value) {
                this._s3Key = java.util.Objects.requireNonNull(value, "s3Key is required");
                return this;
            }
            /**
             * Sets the value of S3Key
             * @param value ``ApplicationVersionResource.SourceBundleProperty.S3Key``
             * @return {@code this}
             */
            public Builder withS3Key(final software.amazon.awscdk.Token value) {
                this._s3Key = java.util.Objects.requireNonNull(value, "s3Key is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceBundleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public SourceBundleProperty build() {
                return new SourceBundleProperty() {
                    private java.lang.Object $s3Bucket = java.util.Objects.requireNonNull(_s3Bucket, "s3Bucket is required");
                    private java.lang.Object $s3Key = java.util.Objects.requireNonNull(_s3Key, "s3Key is required");

                    @Override
                    public java.lang.Object getS3Bucket() {
                        return this.$s3Bucket;
                    }

                    @Override
                    public void setS3Bucket(final java.lang.String value) {
                        this.$s3Bucket = java.util.Objects.requireNonNull(value, "s3Bucket is required");
                    }

                    @Override
                    public void setS3Bucket(final software.amazon.awscdk.Token value) {
                        this.$s3Bucket = java.util.Objects.requireNonNull(value, "s3Bucket is required");
                    }

                    @Override
                    public java.lang.Object getS3Key() {
                        return this.$s3Key;
                    }

                    @Override
                    public void setS3Key(final java.lang.String value) {
                        this.$s3Key = java.util.Objects.requireNonNull(value, "s3Key is required");
                    }

                    @Override
                    public void setS3Key(final software.amazon.awscdk.Token value) {
                        this.$s3Key = java.util.Objects.requireNonNull(value, "s3Key is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ApplicationVersionResource.SourceBundleProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``ApplicationVersionResource.SourceBundleProperty.S3Bucket``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-sourcebundle.html#cfn-beanstalk-sourcebundle-s3bucket
             */
            @Override
            public java.lang.Object getS3Bucket() {
                return this.jsiiGet("s3Bucket", java.lang.Object.class);
            }

            /**
             * ``ApplicationVersionResource.SourceBundleProperty.S3Bucket``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-sourcebundle.html#cfn-beanstalk-sourcebundle-s3bucket
             */
            @Override
            public void setS3Bucket(final java.lang.String value) {
                this.jsiiSet("s3Bucket", java.util.Objects.requireNonNull(value, "s3Bucket is required"));
            }

            /**
             * ``ApplicationVersionResource.SourceBundleProperty.S3Bucket``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-sourcebundle.html#cfn-beanstalk-sourcebundle-s3bucket
             */
            @Override
            public void setS3Bucket(final software.amazon.awscdk.Token value) {
                this.jsiiSet("s3Bucket", java.util.Objects.requireNonNull(value, "s3Bucket is required"));
            }

            /**
             * ``ApplicationVersionResource.SourceBundleProperty.S3Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-sourcebundle.html#cfn-beanstalk-sourcebundle-s3key
             */
            @Override
            public java.lang.Object getS3Key() {
                return this.jsiiGet("s3Key", java.lang.Object.class);
            }

            /**
             * ``ApplicationVersionResource.SourceBundleProperty.S3Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-sourcebundle.html#cfn-beanstalk-sourcebundle-s3key
             */
            @Override
            public void setS3Key(final java.lang.String value) {
                this.jsiiSet("s3Key", java.util.Objects.requireNonNull(value, "s3Key is required"));
            }

            /**
             * ``ApplicationVersionResource.SourceBundleProperty.S3Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-sourcebundle.html#cfn-beanstalk-sourcebundle-s3key
             */
            @Override
            public void setS3Key(final software.amazon.awscdk.Token value) {
                this.jsiiSet("s3Key", java.util.Objects.requireNonNull(value, "s3Key is required"));
            }
        }
    }
}
