package software.amazon.awscdk.services.elasticbeanstalk;

/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.15 (build e429c41)", date = "2019-03-05T00:06:19.192Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticbeanstalk.$Module.class, fqn = "@aws-cdk/aws-elasticbeanstalk.CfnApplication")
public class CfnApplication extends software.amazon.awscdk.Resource {
    protected CfnApplication(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticbeanstalk.CfnApplication.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::ElasticBeanstalk::Application``.
     * @param scope scope in which this resource is defined
     * @param id scoped id of the resource
     * @param props resource properties
     */
    public CfnApplication(final software.amazon.awscdk.Construct scope, final java.lang.String id, @javax.annotation.Nullable final software.amazon.awscdk.services.elasticbeanstalk.CfnApplicationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(scope, "scope is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))), java.util.stream.Stream.of(props)).toArray());
    }
    /**
     * Creates a new ``AWS::ElasticBeanstalk::Application``.
     * @param scope scope in which this resource is defined
     * @param id scoped id of the resource
     */
    public CfnApplication(final software.amazon.awscdk.Construct scope, final java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(scope, "scope is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))).toArray());
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required")).toArray());
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    public java.lang.String getApplicationName() {
        return this.jsiiGet("applicationName", java.lang.String.class);
    }

    public software.amazon.awscdk.services.elasticbeanstalk.CfnApplicationProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.elasticbeanstalk.CfnApplicationProps.class);
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationresourcelifecycleconfig.html
     */
    public static interface ApplicationResourceLifecycleConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnApplication.ApplicationResourceLifecycleConfigProperty.ServiceRole``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationresourcelifecycleconfig.html#cfn-elasticbeanstalk-application-applicationresourcelifecycleconfig-servicerole
         */
        java.lang.String getServiceRole();
        /**
         * ``CfnApplication.ApplicationResourceLifecycleConfigProperty.ServiceRole``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationresourcelifecycleconfig.html#cfn-elasticbeanstalk-application-applicationresourcelifecycleconfig-servicerole
         */
        void setServiceRole(final java.lang.String value);
        /**
         * ``CfnApplication.ApplicationResourceLifecycleConfigProperty.VersionLifecycleConfig``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationresourcelifecycleconfig.html#cfn-elasticbeanstalk-application-applicationresourcelifecycleconfig-versionlifecycleconfig
         */
        java.lang.Object getVersionLifecycleConfig();
        /**
         * ``CfnApplication.ApplicationResourceLifecycleConfigProperty.VersionLifecycleConfig``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationresourcelifecycleconfig.html#cfn-elasticbeanstalk-application-applicationresourcelifecycleconfig-versionlifecycleconfig
         */
        void setVersionLifecycleConfig(final software.amazon.awscdk.Token value);
        /**
         * ``CfnApplication.ApplicationResourceLifecycleConfigProperty.VersionLifecycleConfig``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationresourcelifecycleconfig.html#cfn-elasticbeanstalk-application-applicationresourcelifecycleconfig-versionlifecycleconfig
         */
        void setVersionLifecycleConfig(final software.amazon.awscdk.services.elasticbeanstalk.CfnApplication.ApplicationVersionLifecycleConfigProperty value);

        /**
         * @return a {@link Builder} of {@link ApplicationResourceLifecycleConfigProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ApplicationResourceLifecycleConfigProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _serviceRole;
            @javax.annotation.Nullable
            private java.lang.Object _versionLifecycleConfig;

            /**
             * Sets the value of ServiceRole
             * @param value ``CfnApplication.ApplicationResourceLifecycleConfigProperty.ServiceRole``
             * @return {@code this}
             */
            public Builder withServiceRole(@javax.annotation.Nullable final java.lang.String value) {
                this._serviceRole = value;
                return this;
            }
            /**
             * Sets the value of VersionLifecycleConfig
             * @param value ``CfnApplication.ApplicationResourceLifecycleConfigProperty.VersionLifecycleConfig``
             * @return {@code this}
             */
            public Builder withVersionLifecycleConfig(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._versionLifecycleConfig = value;
                return this;
            }
            /**
             * Sets the value of VersionLifecycleConfig
             * @param value ``CfnApplication.ApplicationResourceLifecycleConfigProperty.VersionLifecycleConfig``
             * @return {@code this}
             */
            public Builder withVersionLifecycleConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticbeanstalk.CfnApplication.ApplicationVersionLifecycleConfigProperty value) {
                this._versionLifecycleConfig = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ApplicationResourceLifecycleConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ApplicationResourceLifecycleConfigProperty build() {
                return new ApplicationResourceLifecycleConfigProperty() {
                    @javax.annotation.Nullable
                    private java.lang.String $serviceRole = _serviceRole;
                    @javax.annotation.Nullable
                    private java.lang.Object $versionLifecycleConfig = _versionLifecycleConfig;

                    @Override
                    public java.lang.String getServiceRole() {
                        return this.$serviceRole;
                    }

                    @Override
                    public void setServiceRole(@javax.annotation.Nullable final java.lang.String value) {
                        this.$serviceRole = value;
                    }

                    @Override
                    public java.lang.Object getVersionLifecycleConfig() {
                        return this.$versionLifecycleConfig;
                    }

                    @Override
                    public void setVersionLifecycleConfig(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$versionLifecycleConfig = value;
                    }

                    @Override
                    public void setVersionLifecycleConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticbeanstalk.CfnApplication.ApplicationVersionLifecycleConfigProperty value) {
                        this.$versionLifecycleConfig = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticbeanstalk.CfnApplication.ApplicationResourceLifecycleConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnApplication.ApplicationResourceLifecycleConfigProperty.ServiceRole``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationresourcelifecycleconfig.html#cfn-elasticbeanstalk-application-applicationresourcelifecycleconfig-servicerole
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getServiceRole() {
                return this.jsiiGet("serviceRole", java.lang.String.class);
            }

            /**
             * ``CfnApplication.ApplicationResourceLifecycleConfigProperty.ServiceRole``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationresourcelifecycleconfig.html#cfn-elasticbeanstalk-application-applicationresourcelifecycleconfig-servicerole
             */
            @Override
            public void setServiceRole(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("serviceRole", value);
            }

            /**
             * ``CfnApplication.ApplicationResourceLifecycleConfigProperty.VersionLifecycleConfig``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationresourcelifecycleconfig.html#cfn-elasticbeanstalk-application-applicationresourcelifecycleconfig-versionlifecycleconfig
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getVersionLifecycleConfig() {
                return this.jsiiGet("versionLifecycleConfig", java.lang.Object.class);
            }

            /**
             * ``CfnApplication.ApplicationResourceLifecycleConfigProperty.VersionLifecycleConfig``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationresourcelifecycleconfig.html#cfn-elasticbeanstalk-application-applicationresourcelifecycleconfig-versionlifecycleconfig
             */
            @Override
            public void setVersionLifecycleConfig(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("versionLifecycleConfig", value);
            }

            /**
             * ``CfnApplication.ApplicationResourceLifecycleConfigProperty.VersionLifecycleConfig``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationresourcelifecycleconfig.html#cfn-elasticbeanstalk-application-applicationresourcelifecycleconfig-versionlifecycleconfig
             */
            @Override
            public void setVersionLifecycleConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticbeanstalk.CfnApplication.ApplicationVersionLifecycleConfigProperty value) {
                this.jsiiSet("versionLifecycleConfig", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html
     */
    public static interface ApplicationVersionLifecycleConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnApplication.ApplicationVersionLifecycleConfigProperty.MaxAgeRule``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html#cfn-elasticbeanstalk-application-applicationversionlifecycleconfig-maxagerule
         */
        java.lang.Object getMaxAgeRule();
        /**
         * ``CfnApplication.ApplicationVersionLifecycleConfigProperty.MaxAgeRule``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html#cfn-elasticbeanstalk-application-applicationversionlifecycleconfig-maxagerule
         */
        void setMaxAgeRule(final software.amazon.awscdk.Token value);
        /**
         * ``CfnApplication.ApplicationVersionLifecycleConfigProperty.MaxAgeRule``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html#cfn-elasticbeanstalk-application-applicationversionlifecycleconfig-maxagerule
         */
        void setMaxAgeRule(final software.amazon.awscdk.services.elasticbeanstalk.CfnApplication.MaxAgeRuleProperty value);
        /**
         * ``CfnApplication.ApplicationVersionLifecycleConfigProperty.MaxCountRule``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html#cfn-elasticbeanstalk-application-applicationversionlifecycleconfig-maxcountrule
         */
        java.lang.Object getMaxCountRule();
        /**
         * ``CfnApplication.ApplicationVersionLifecycleConfigProperty.MaxCountRule``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html#cfn-elasticbeanstalk-application-applicationversionlifecycleconfig-maxcountrule
         */
        void setMaxCountRule(final software.amazon.awscdk.Token value);
        /**
         * ``CfnApplication.ApplicationVersionLifecycleConfigProperty.MaxCountRule``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html#cfn-elasticbeanstalk-application-applicationversionlifecycleconfig-maxcountrule
         */
        void setMaxCountRule(final software.amazon.awscdk.services.elasticbeanstalk.CfnApplication.MaxCountRuleProperty value);

        /**
         * @return a {@link Builder} of {@link ApplicationVersionLifecycleConfigProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ApplicationVersionLifecycleConfigProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _maxAgeRule;
            @javax.annotation.Nullable
            private java.lang.Object _maxCountRule;

            /**
             * Sets the value of MaxAgeRule
             * @param value ``CfnApplication.ApplicationVersionLifecycleConfigProperty.MaxAgeRule``
             * @return {@code this}
             */
            public Builder withMaxAgeRule(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._maxAgeRule = value;
                return this;
            }
            /**
             * Sets the value of MaxAgeRule
             * @param value ``CfnApplication.ApplicationVersionLifecycleConfigProperty.MaxAgeRule``
             * @return {@code this}
             */
            public Builder withMaxAgeRule(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticbeanstalk.CfnApplication.MaxAgeRuleProperty value) {
                this._maxAgeRule = value;
                return this;
            }
            /**
             * Sets the value of MaxCountRule
             * @param value ``CfnApplication.ApplicationVersionLifecycleConfigProperty.MaxCountRule``
             * @return {@code this}
             */
            public Builder withMaxCountRule(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._maxCountRule = value;
                return this;
            }
            /**
             * Sets the value of MaxCountRule
             * @param value ``CfnApplication.ApplicationVersionLifecycleConfigProperty.MaxCountRule``
             * @return {@code this}
             */
            public Builder withMaxCountRule(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticbeanstalk.CfnApplication.MaxCountRuleProperty value) {
                this._maxCountRule = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ApplicationVersionLifecycleConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ApplicationVersionLifecycleConfigProperty build() {
                return new ApplicationVersionLifecycleConfigProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $maxAgeRule = _maxAgeRule;
                    @javax.annotation.Nullable
                    private java.lang.Object $maxCountRule = _maxCountRule;

                    @Override
                    public java.lang.Object getMaxAgeRule() {
                        return this.$maxAgeRule;
                    }

                    @Override
                    public void setMaxAgeRule(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$maxAgeRule = value;
                    }

                    @Override
                    public void setMaxAgeRule(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticbeanstalk.CfnApplication.MaxAgeRuleProperty value) {
                        this.$maxAgeRule = value;
                    }

                    @Override
                    public java.lang.Object getMaxCountRule() {
                        return this.$maxCountRule;
                    }

                    @Override
                    public void setMaxCountRule(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$maxCountRule = value;
                    }

                    @Override
                    public void setMaxCountRule(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticbeanstalk.CfnApplication.MaxCountRuleProperty value) {
                        this.$maxCountRule = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticbeanstalk.CfnApplication.ApplicationVersionLifecycleConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnApplication.ApplicationVersionLifecycleConfigProperty.MaxAgeRule``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html#cfn-elasticbeanstalk-application-applicationversionlifecycleconfig-maxagerule
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getMaxAgeRule() {
                return this.jsiiGet("maxAgeRule", java.lang.Object.class);
            }

            /**
             * ``CfnApplication.ApplicationVersionLifecycleConfigProperty.MaxAgeRule``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html#cfn-elasticbeanstalk-application-applicationversionlifecycleconfig-maxagerule
             */
            @Override
            public void setMaxAgeRule(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("maxAgeRule", value);
            }

            /**
             * ``CfnApplication.ApplicationVersionLifecycleConfigProperty.MaxAgeRule``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html#cfn-elasticbeanstalk-application-applicationversionlifecycleconfig-maxagerule
             */
            @Override
            public void setMaxAgeRule(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticbeanstalk.CfnApplication.MaxAgeRuleProperty value) {
                this.jsiiSet("maxAgeRule", value);
            }

            /**
             * ``CfnApplication.ApplicationVersionLifecycleConfigProperty.MaxCountRule``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html#cfn-elasticbeanstalk-application-applicationversionlifecycleconfig-maxcountrule
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getMaxCountRule() {
                return this.jsiiGet("maxCountRule", java.lang.Object.class);
            }

            /**
             * ``CfnApplication.ApplicationVersionLifecycleConfigProperty.MaxCountRule``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html#cfn-elasticbeanstalk-application-applicationversionlifecycleconfig-maxcountrule
             */
            @Override
            public void setMaxCountRule(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("maxCountRule", value);
            }

            /**
             * ``CfnApplication.ApplicationVersionLifecycleConfigProperty.MaxCountRule``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html#cfn-elasticbeanstalk-application-applicationversionlifecycleconfig-maxcountrule
             */
            @Override
            public void setMaxCountRule(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticbeanstalk.CfnApplication.MaxCountRuleProperty value) {
                this.jsiiSet("maxCountRule", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html
     */
    public static interface MaxAgeRuleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnApplication.MaxAgeRuleProperty.DeleteSourceFromS3``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-deletesourcefroms3
         */
        java.lang.Object getDeleteSourceFromS3();
        /**
         * ``CfnApplication.MaxAgeRuleProperty.DeleteSourceFromS3``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-deletesourcefroms3
         */
        void setDeleteSourceFromS3(final java.lang.Boolean value);
        /**
         * ``CfnApplication.MaxAgeRuleProperty.DeleteSourceFromS3``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-deletesourcefroms3
         */
        void setDeleteSourceFromS3(final software.amazon.awscdk.Token value);
        /**
         * ``CfnApplication.MaxAgeRuleProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-enabled
         */
        java.lang.Object getEnabled();
        /**
         * ``CfnApplication.MaxAgeRuleProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-enabled
         */
        void setEnabled(final java.lang.Boolean value);
        /**
         * ``CfnApplication.MaxAgeRuleProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-enabled
         */
        void setEnabled(final software.amazon.awscdk.Token value);
        /**
         * ``CfnApplication.MaxAgeRuleProperty.MaxAgeInDays``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-maxageindays
         */
        java.lang.Object getMaxAgeInDays();
        /**
         * ``CfnApplication.MaxAgeRuleProperty.MaxAgeInDays``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-maxageindays
         */
        void setMaxAgeInDays(final java.lang.Number value);
        /**
         * ``CfnApplication.MaxAgeRuleProperty.MaxAgeInDays``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-maxageindays
         */
        void setMaxAgeInDays(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link MaxAgeRuleProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link MaxAgeRuleProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _deleteSourceFromS3;
            @javax.annotation.Nullable
            private java.lang.Object _enabled;
            @javax.annotation.Nullable
            private java.lang.Object _maxAgeInDays;

            /**
             * Sets the value of DeleteSourceFromS3
             * @param value ``CfnApplication.MaxAgeRuleProperty.DeleteSourceFromS3``
             * @return {@code this}
             */
            public Builder withDeleteSourceFromS3(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._deleteSourceFromS3 = value;
                return this;
            }
            /**
             * Sets the value of DeleteSourceFromS3
             * @param value ``CfnApplication.MaxAgeRuleProperty.DeleteSourceFromS3``
             * @return {@code this}
             */
            public Builder withDeleteSourceFromS3(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._deleteSourceFromS3 = value;
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value ``CfnApplication.MaxAgeRuleProperty.Enabled``
             * @return {@code this}
             */
            public Builder withEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._enabled = value;
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value ``CfnApplication.MaxAgeRuleProperty.Enabled``
             * @return {@code this}
             */
            public Builder withEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._enabled = value;
                return this;
            }
            /**
             * Sets the value of MaxAgeInDays
             * @param value ``CfnApplication.MaxAgeRuleProperty.MaxAgeInDays``
             * @return {@code this}
             */
            public Builder withMaxAgeInDays(@javax.annotation.Nullable final java.lang.Number value) {
                this._maxAgeInDays = value;
                return this;
            }
            /**
             * Sets the value of MaxAgeInDays
             * @param value ``CfnApplication.MaxAgeRuleProperty.MaxAgeInDays``
             * @return {@code this}
             */
            public Builder withMaxAgeInDays(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._maxAgeInDays = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MaxAgeRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public MaxAgeRuleProperty build() {
                return new MaxAgeRuleProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $deleteSourceFromS3 = _deleteSourceFromS3;
                    @javax.annotation.Nullable
                    private java.lang.Object $enabled = _enabled;
                    @javax.annotation.Nullable
                    private java.lang.Object $maxAgeInDays = _maxAgeInDays;

                    @Override
                    public java.lang.Object getDeleteSourceFromS3() {
                        return this.$deleteSourceFromS3;
                    }

                    @Override
                    public void setDeleteSourceFromS3(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$deleteSourceFromS3 = value;
                    }

                    @Override
                    public void setDeleteSourceFromS3(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$deleteSourceFromS3 = value;
                    }

                    @Override
                    public java.lang.Object getEnabled() {
                        return this.$enabled;
                    }

                    @Override
                    public void setEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$enabled = value;
                    }

                    @Override
                    public void setEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$enabled = value;
                    }

                    @Override
                    public java.lang.Object getMaxAgeInDays() {
                        return this.$maxAgeInDays;
                    }

                    @Override
                    public void setMaxAgeInDays(@javax.annotation.Nullable final java.lang.Number value) {
                        this.$maxAgeInDays = value;
                    }

                    @Override
                    public void setMaxAgeInDays(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$maxAgeInDays = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticbeanstalk.CfnApplication.MaxAgeRuleProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnApplication.MaxAgeRuleProperty.DeleteSourceFromS3``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-deletesourcefroms3
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getDeleteSourceFromS3() {
                return this.jsiiGet("deleteSourceFromS3", java.lang.Object.class);
            }

            /**
             * ``CfnApplication.MaxAgeRuleProperty.DeleteSourceFromS3``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-deletesourcefroms3
             */
            @Override
            public void setDeleteSourceFromS3(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("deleteSourceFromS3", value);
            }

            /**
             * ``CfnApplication.MaxAgeRuleProperty.DeleteSourceFromS3``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-deletesourcefroms3
             */
            @Override
            public void setDeleteSourceFromS3(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("deleteSourceFromS3", value);
            }

            /**
             * ``CfnApplication.MaxAgeRuleProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-enabled
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getEnabled() {
                return this.jsiiGet("enabled", java.lang.Object.class);
            }

            /**
             * ``CfnApplication.MaxAgeRuleProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-enabled
             */
            @Override
            public void setEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("enabled", value);
            }

            /**
             * ``CfnApplication.MaxAgeRuleProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-enabled
             */
            @Override
            public void setEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("enabled", value);
            }

            /**
             * ``CfnApplication.MaxAgeRuleProperty.MaxAgeInDays``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-maxageindays
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getMaxAgeInDays() {
                return this.jsiiGet("maxAgeInDays", java.lang.Object.class);
            }

            /**
             * ``CfnApplication.MaxAgeRuleProperty.MaxAgeInDays``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-maxageindays
             */
            @Override
            public void setMaxAgeInDays(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("maxAgeInDays", value);
            }

            /**
             * ``CfnApplication.MaxAgeRuleProperty.MaxAgeInDays``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-maxageindays
             */
            @Override
            public void setMaxAgeInDays(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("maxAgeInDays", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html
     */
    public static interface MaxCountRuleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnApplication.MaxCountRuleProperty.DeleteSourceFromS3``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-deletesourcefroms3
         */
        java.lang.Object getDeleteSourceFromS3();
        /**
         * ``CfnApplication.MaxCountRuleProperty.DeleteSourceFromS3``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-deletesourcefroms3
         */
        void setDeleteSourceFromS3(final java.lang.Boolean value);
        /**
         * ``CfnApplication.MaxCountRuleProperty.DeleteSourceFromS3``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-deletesourcefroms3
         */
        void setDeleteSourceFromS3(final software.amazon.awscdk.Token value);
        /**
         * ``CfnApplication.MaxCountRuleProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-enabled
         */
        java.lang.Object getEnabled();
        /**
         * ``CfnApplication.MaxCountRuleProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-enabled
         */
        void setEnabled(final java.lang.Boolean value);
        /**
         * ``CfnApplication.MaxCountRuleProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-enabled
         */
        void setEnabled(final software.amazon.awscdk.Token value);
        /**
         * ``CfnApplication.MaxCountRuleProperty.MaxCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-maxcount
         */
        java.lang.Object getMaxCount();
        /**
         * ``CfnApplication.MaxCountRuleProperty.MaxCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-maxcount
         */
        void setMaxCount(final java.lang.Number value);
        /**
         * ``CfnApplication.MaxCountRuleProperty.MaxCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-maxcount
         */
        void setMaxCount(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link MaxCountRuleProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link MaxCountRuleProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _deleteSourceFromS3;
            @javax.annotation.Nullable
            private java.lang.Object _enabled;
            @javax.annotation.Nullable
            private java.lang.Object _maxCount;

            /**
             * Sets the value of DeleteSourceFromS3
             * @param value ``CfnApplication.MaxCountRuleProperty.DeleteSourceFromS3``
             * @return {@code this}
             */
            public Builder withDeleteSourceFromS3(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._deleteSourceFromS3 = value;
                return this;
            }
            /**
             * Sets the value of DeleteSourceFromS3
             * @param value ``CfnApplication.MaxCountRuleProperty.DeleteSourceFromS3``
             * @return {@code this}
             */
            public Builder withDeleteSourceFromS3(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._deleteSourceFromS3 = value;
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value ``CfnApplication.MaxCountRuleProperty.Enabled``
             * @return {@code this}
             */
            public Builder withEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._enabled = value;
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value ``CfnApplication.MaxCountRuleProperty.Enabled``
             * @return {@code this}
             */
            public Builder withEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._enabled = value;
                return this;
            }
            /**
             * Sets the value of MaxCount
             * @param value ``CfnApplication.MaxCountRuleProperty.MaxCount``
             * @return {@code this}
             */
            public Builder withMaxCount(@javax.annotation.Nullable final java.lang.Number value) {
                this._maxCount = value;
                return this;
            }
            /**
             * Sets the value of MaxCount
             * @param value ``CfnApplication.MaxCountRuleProperty.MaxCount``
             * @return {@code this}
             */
            public Builder withMaxCount(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._maxCount = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MaxCountRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public MaxCountRuleProperty build() {
                return new MaxCountRuleProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $deleteSourceFromS3 = _deleteSourceFromS3;
                    @javax.annotation.Nullable
                    private java.lang.Object $enabled = _enabled;
                    @javax.annotation.Nullable
                    private java.lang.Object $maxCount = _maxCount;

                    @Override
                    public java.lang.Object getDeleteSourceFromS3() {
                        return this.$deleteSourceFromS3;
                    }

                    @Override
                    public void setDeleteSourceFromS3(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$deleteSourceFromS3 = value;
                    }

                    @Override
                    public void setDeleteSourceFromS3(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$deleteSourceFromS3 = value;
                    }

                    @Override
                    public java.lang.Object getEnabled() {
                        return this.$enabled;
                    }

                    @Override
                    public void setEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$enabled = value;
                    }

                    @Override
                    public void setEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$enabled = value;
                    }

                    @Override
                    public java.lang.Object getMaxCount() {
                        return this.$maxCount;
                    }

                    @Override
                    public void setMaxCount(@javax.annotation.Nullable final java.lang.Number value) {
                        this.$maxCount = value;
                    }

                    @Override
                    public void setMaxCount(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$maxCount = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticbeanstalk.CfnApplication.MaxCountRuleProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnApplication.MaxCountRuleProperty.DeleteSourceFromS3``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-deletesourcefroms3
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getDeleteSourceFromS3() {
                return this.jsiiGet("deleteSourceFromS3", java.lang.Object.class);
            }

            /**
             * ``CfnApplication.MaxCountRuleProperty.DeleteSourceFromS3``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-deletesourcefroms3
             */
            @Override
            public void setDeleteSourceFromS3(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("deleteSourceFromS3", value);
            }

            /**
             * ``CfnApplication.MaxCountRuleProperty.DeleteSourceFromS3``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-deletesourcefroms3
             */
            @Override
            public void setDeleteSourceFromS3(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("deleteSourceFromS3", value);
            }

            /**
             * ``CfnApplication.MaxCountRuleProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-enabled
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getEnabled() {
                return this.jsiiGet("enabled", java.lang.Object.class);
            }

            /**
             * ``CfnApplication.MaxCountRuleProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-enabled
             */
            @Override
            public void setEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("enabled", value);
            }

            /**
             * ``CfnApplication.MaxCountRuleProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-enabled
             */
            @Override
            public void setEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("enabled", value);
            }

            /**
             * ``CfnApplication.MaxCountRuleProperty.MaxCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-maxcount
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getMaxCount() {
                return this.jsiiGet("maxCount", java.lang.Object.class);
            }

            /**
             * ``CfnApplication.MaxCountRuleProperty.MaxCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-maxcount
             */
            @Override
            public void setMaxCount(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("maxCount", value);
            }

            /**
             * ``CfnApplication.MaxCountRuleProperty.MaxCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-maxcount
             */
            @Override
            public void setMaxCount(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("maxCount", value);
            }
        }
    }
}
