package software.amazon.awscdk.services.elasticbeanstalk;

/**
 * @cloudformationResource AWS::ElasticBeanstalk::ConfigurationTemplate
 * A CloudFormation `AWS::ElasticBeanstalk::ConfigurationTemplate`
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.8.2 (build e9eb3c9)", date = "2019-03-28T21:32:21.317Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticbeanstalk.$Module.class, fqn = "@aws-cdk/aws-elasticbeanstalk.CfnConfigurationTemplate")
public class CfnConfigurationTemplate extends software.amazon.awscdk.CfnResource {
    protected CfnConfigurationTemplate(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticbeanstalk.CfnConfigurationTemplate.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Create a new `AWS::ElasticBeanstalk::ConfigurationTemplate`.
     * @param scope - scope in which this resource is defined
     * @param id - scoped id of the resource
     * @param props - resource properties
     */
    public CfnConfigurationTemplate(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.elasticbeanstalk.CfnConfigurationTemplateProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(scope, "scope is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required"))).toArray());
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required")).toArray());
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    public java.lang.String getConfigurationTemplateName() {
        return this.jsiiGet("configurationTemplateName", java.lang.String.class);
    }

    public software.amazon.awscdk.services.elasticbeanstalk.CfnConfigurationTemplateProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.elasticbeanstalk.CfnConfigurationTemplateProps.class);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html
     */
    public static interface ConfigurationOptionSettingProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnConfigurationTemplate.ConfigurationOptionSettingProperty.Namespace`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-namespace
         */
        java.lang.String getNamespace();
        /**
         * `CfnConfigurationTemplate.ConfigurationOptionSettingProperty.OptionName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-optionname
         */
        java.lang.String getOptionName();
        /**
         * `CfnConfigurationTemplate.ConfigurationOptionSettingProperty.ResourceName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-resourcename
         */
        java.lang.String getResourceName();
        /**
         * `CfnConfigurationTemplate.ConfigurationOptionSettingProperty.Value`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-value
         */
        java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link ConfigurationOptionSettingProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ConfigurationOptionSettingProperty}
         */
        final class Builder {
            private java.lang.String _namespace;
            private java.lang.String _optionName;
            @javax.annotation.Nullable
            private java.lang.String _resourceName;
            @javax.annotation.Nullable
            private java.lang.String _value;

            /**
             * Sets the value of Namespace
             * @param value `CfnConfigurationTemplate.ConfigurationOptionSettingProperty.Namespace`
             * @return {@code this}
             */
            public Builder withNamespace(final java.lang.String value) {
                this._namespace = java.util.Objects.requireNonNull(value, "namespace is required");
                return this;
            }
            /**
             * Sets the value of OptionName
             * @param value `CfnConfigurationTemplate.ConfigurationOptionSettingProperty.OptionName`
             * @return {@code this}
             */
            public Builder withOptionName(final java.lang.String value) {
                this._optionName = java.util.Objects.requireNonNull(value, "optionName is required");
                return this;
            }
            /**
             * Sets the value of ResourceName
             * @param value `CfnConfigurationTemplate.ConfigurationOptionSettingProperty.ResourceName`
             * @return {@code this}
             */
            public Builder withResourceName(@javax.annotation.Nullable final java.lang.String value) {
                this._resourceName = value;
                return this;
            }
            /**
             * Sets the value of Value
             * @param value `CfnConfigurationTemplate.ConfigurationOptionSettingProperty.Value`
             * @return {@code this}
             */
            public Builder withValue(@javax.annotation.Nullable final java.lang.String value) {
                this._value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConfigurationOptionSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ConfigurationOptionSettingProperty build() {
                return new ConfigurationOptionSettingProperty() {
                    private final java.lang.String $namespace = java.util.Objects.requireNonNull(_namespace, "namespace is required");
                    private final java.lang.String $optionName = java.util.Objects.requireNonNull(_optionName, "optionName is required");
                    @javax.annotation.Nullable
                    private final java.lang.String $resourceName = _resourceName;
                    @javax.annotation.Nullable
                    private final java.lang.String $value = _value;

                    @Override
                    public java.lang.String getNamespace() {
                        return this.$namespace;
                    }

                    @Override
                    public java.lang.String getOptionName() {
                        return this.$optionName;
                    }

                    @Override
                    public java.lang.String getResourceName() {
                        return this.$resourceName;
                    }

                    @Override
                    public java.lang.String getValue() {
                        return this.$value;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("namespace", om.valueToTree(this.getNamespace()));
                        obj.set("optionName", om.valueToTree(this.getOptionName()));
                        obj.set("resourceName", om.valueToTree(this.getResourceName()));
                        obj.set("value", om.valueToTree(this.getValue()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticbeanstalk.CfnConfigurationTemplate.ConfigurationOptionSettingProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnConfigurationTemplate.ConfigurationOptionSettingProperty.Namespace`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-namespace
             */
            @Override
            public java.lang.String getNamespace() {
                return this.jsiiGet("namespace", java.lang.String.class);
            }

            /**
             * `CfnConfigurationTemplate.ConfigurationOptionSettingProperty.OptionName`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-optionname
             */
            @Override
            public java.lang.String getOptionName() {
                return this.jsiiGet("optionName", java.lang.String.class);
            }

            /**
             * `CfnConfigurationTemplate.ConfigurationOptionSettingProperty.ResourceName`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-resourcename
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getResourceName() {
                return this.jsiiGet("resourceName", java.lang.String.class);
            }

            /**
             * `CfnConfigurationTemplate.ConfigurationOptionSettingProperty.Value`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-value
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getValue() {
                return this.jsiiGet("value", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-sourceconfiguration.html
     */
    public static interface SourceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnConfigurationTemplate.SourceConfigurationProperty.ApplicationName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-sourceconfiguration.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration-applicationname
         */
        java.lang.String getApplicationName();
        /**
         * `CfnConfigurationTemplate.SourceConfigurationProperty.TemplateName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-sourceconfiguration.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration-templatename
         */
        java.lang.String getTemplateName();

        /**
         * @return a {@link Builder} of {@link SourceConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SourceConfigurationProperty}
         */
        final class Builder {
            private java.lang.String _applicationName;
            private java.lang.String _templateName;

            /**
             * Sets the value of ApplicationName
             * @param value `CfnConfigurationTemplate.SourceConfigurationProperty.ApplicationName`
             * @return {@code this}
             */
            public Builder withApplicationName(final java.lang.String value) {
                this._applicationName = java.util.Objects.requireNonNull(value, "applicationName is required");
                return this;
            }
            /**
             * Sets the value of TemplateName
             * @param value `CfnConfigurationTemplate.SourceConfigurationProperty.TemplateName`
             * @return {@code this}
             */
            public Builder withTemplateName(final java.lang.String value) {
                this._templateName = java.util.Objects.requireNonNull(value, "templateName is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public SourceConfigurationProperty build() {
                return new SourceConfigurationProperty() {
                    private final java.lang.String $applicationName = java.util.Objects.requireNonNull(_applicationName, "applicationName is required");
                    private final java.lang.String $templateName = java.util.Objects.requireNonNull(_templateName, "templateName is required");

                    @Override
                    public java.lang.String getApplicationName() {
                        return this.$applicationName;
                    }

                    @Override
                    public java.lang.String getTemplateName() {
                        return this.$templateName;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("applicationName", om.valueToTree(this.getApplicationName()));
                        obj.set("templateName", om.valueToTree(this.getTemplateName()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticbeanstalk.CfnConfigurationTemplate.SourceConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnConfigurationTemplate.SourceConfigurationProperty.ApplicationName`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-sourceconfiguration.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration-applicationname
             */
            @Override
            public java.lang.String getApplicationName() {
                return this.jsiiGet("applicationName", java.lang.String.class);
            }

            /**
             * `CfnConfigurationTemplate.SourceConfigurationProperty.TemplateName`
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-sourceconfiguration.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration-templatename
             */
            @Override
            public java.lang.String getTemplateName() {
                return this.jsiiGet("templateName", java.lang.String.class);
            }
        }
    }
}
