package software.amazon.awscdk.services.elasticbeanstalk;

/**
 * A CloudFormation `AWS::ElasticBeanstalk::ApplicationVersion`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.5 (build 46bc9b0)", date = "2019-05-24T10:13:09.784Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticbeanstalk.$Module.class, fqn = "@aws-cdk/aws-elasticbeanstalk.CfnApplicationVersion")
public class CfnApplicationVersion extends software.amazon.awscdk.CfnResource {
    protected CfnApplicationVersion(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticbeanstalk.CfnApplicationVersion.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Create a new `AWS::ElasticBeanstalk::ApplicationVersion`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     */
    public CfnApplicationVersion(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.elasticbeanstalk.CfnApplicationVersionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(@javax.annotation.Nullable final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { properties });
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    public java.lang.String getApplicationVersionName() {
        return this.jsiiGet("applicationVersionName", java.lang.String.class);
    }

    public software.amazon.awscdk.services.elasticbeanstalk.CfnApplicationVersionProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.elasticbeanstalk.CfnApplicationVersionProps.class);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-sourcebundle.html
     */
    public static interface SourceBundleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnApplicationVersion.SourceBundleProperty.S3Bucket`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-sourcebundle.html#cfn-beanstalk-sourcebundle-s3bucket
         */
        java.lang.String getS3Bucket();
        /**
         * `CfnApplicationVersion.SourceBundleProperty.S3Key`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-sourcebundle.html#cfn-beanstalk-sourcebundle-s3key
         */
        java.lang.String getS3Key();

        /**
         * @return a {@link Builder} of {@link SourceBundleProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SourceBundleProperty}
         */
        final class Builder {
            private java.lang.String _s3Bucket;
            private java.lang.String _s3Key;

            /**
             * Sets the value of S3Bucket
             * @param value `CfnApplicationVersion.SourceBundleProperty.S3Bucket`.
             * @return {@code this}
             */
            public Builder withS3Bucket(final java.lang.String value) {
                this._s3Bucket = java.util.Objects.requireNonNull(value, "s3Bucket is required");
                return this;
            }
            /**
             * Sets the value of S3Key
             * @param value `CfnApplicationVersion.SourceBundleProperty.S3Key`.
             * @return {@code this}
             */
            public Builder withS3Key(final java.lang.String value) {
                this._s3Key = java.util.Objects.requireNonNull(value, "s3Key is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceBundleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public SourceBundleProperty build() {
                return new SourceBundleProperty() {
                    private final java.lang.String $s3Bucket = java.util.Objects.requireNonNull(_s3Bucket, "s3Bucket is required");
                    private final java.lang.String $s3Key = java.util.Objects.requireNonNull(_s3Key, "s3Key is required");

                    @Override
                    public java.lang.String getS3Bucket() {
                        return this.$s3Bucket;
                    }

                    @Override
                    public java.lang.String getS3Key() {
                        return this.$s3Key;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("s3Bucket", om.valueToTree(this.getS3Bucket()));
                        obj.set("s3Key", om.valueToTree(this.getS3Key()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticbeanstalk.CfnApplicationVersion.SourceBundleProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnApplicationVersion.SourceBundleProperty.S3Bucket`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-sourcebundle.html#cfn-beanstalk-sourcebundle-s3bucket
             */
            @Override
            public java.lang.String getS3Bucket() {
                return this.jsiiGet("s3Bucket", java.lang.String.class);
            }

            /**
             * `CfnApplicationVersion.SourceBundleProperty.S3Key`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-sourcebundle.html#cfn-beanstalk-sourcebundle-s3key
             */
            @Override
            public java.lang.String getS3Key() {
                return this.jsiiGet("s3Key", java.lang.String.class);
            }
        }
    }
}
