/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.elasticbeanstalk;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.services.elasticbeanstalk.CfnEnvironment;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CfnEnvironmentProps
extends JsiiSerializable {
    public String getApplicationName();

    public String getCnamePrefix();

    public String getDescription();

    public String getEnvironmentName();

    public Object getOptionSettings();

    public String getPlatformArn();

    public String getSolutionStackName();

    public List<CfnTag> getTags();

    public String getTemplateName();

    public Object getTier();

    public String getVersionLabel();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _applicationName;
        @Nullable
        private String _cnamePrefix;
        @Nullable
        private String _description;
        @Nullable
        private String _environmentName;
        @Nullable
        private Object _optionSettings;
        @Nullable
        private String _platformArn;
        @Nullable
        private String _solutionStackName;
        @Nullable
        private List<CfnTag> _tags;
        @Nullable
        private String _templateName;
        @Nullable
        private Object _tier;
        @Nullable
        private String _versionLabel;

        public Builder withApplicationName(String value) {
            this._applicationName = Objects.requireNonNull(value, "applicationName is required");
            return this;
        }

        public Builder withCnamePrefix(@Nullable String value) {
            this._cnamePrefix = value;
            return this;
        }

        public Builder withDescription(@Nullable String value) {
            this._description = value;
            return this;
        }

        public Builder withEnvironmentName(@Nullable String value) {
            this._environmentName = value;
            return this;
        }

        public Builder withOptionSettings(@Nullable IResolvable value) {
            this._optionSettings = value;
            return this;
        }

        public Builder withOptionSettings(@Nullable List<Object> value) {
            this._optionSettings = value;
            return this;
        }

        public Builder withPlatformArn(@Nullable String value) {
            this._platformArn = value;
            return this;
        }

        public Builder withSolutionStackName(@Nullable String value) {
            this._solutionStackName = value;
            return this;
        }

        public Builder withTags(@Nullable List<CfnTag> value) {
            this._tags = value;
            return this;
        }

        public Builder withTemplateName(@Nullable String value) {
            this._templateName = value;
            return this;
        }

        public Builder withTier(@Nullable IResolvable value) {
            this._tier = value;
            return this;
        }

        public Builder withTier(@Nullable CfnEnvironment.TierProperty value) {
            this._tier = value;
            return this;
        }

        public Builder withVersionLabel(@Nullable String value) {
            this._versionLabel = value;
            return this;
        }

        public CfnEnvironmentProps build() {
            return new CfnEnvironmentProps(){
                private final String $applicationName;
                @Nullable
                private final String $cnamePrefix;
                @Nullable
                private final String $description;
                @Nullable
                private final String $environmentName;
                @Nullable
                private final Object $optionSettings;
                @Nullable
                private final String $platformArn;
                @Nullable
                private final String $solutionStackName;
                @Nullable
                private final List<CfnTag> $tags;
                @Nullable
                private final String $templateName;
                @Nullable
                private final Object $tier;
                @Nullable
                private final String $versionLabel;
                {
                    this.$applicationName = Objects.requireNonNull(_applicationName, "applicationName is required");
                    this.$cnamePrefix = _cnamePrefix;
                    this.$description = _description;
                    this.$environmentName = _environmentName;
                    this.$optionSettings = _optionSettings;
                    this.$platformArn = _platformArn;
                    this.$solutionStackName = _solutionStackName;
                    this.$tags = _tags;
                    this.$templateName = _templateName;
                    this.$tier = _tier;
                    this.$versionLabel = _versionLabel;
                }

                @Override
                public String getApplicationName() {
                    return this.$applicationName;
                }

                @Override
                public String getCnamePrefix() {
                    return this.$cnamePrefix;
                }

                @Override
                public String getDescription() {
                    return this.$description;
                }

                @Override
                public String getEnvironmentName() {
                    return this.$environmentName;
                }

                @Override
                public Object getOptionSettings() {
                    return this.$optionSettings;
                }

                @Override
                public String getPlatformArn() {
                    return this.$platformArn;
                }

                @Override
                public String getSolutionStackName() {
                    return this.$solutionStackName;
                }

                @Override
                public List<CfnTag> getTags() {
                    return this.$tags;
                }

                @Override
                public String getTemplateName() {
                    return this.$templateName;
                }

                @Override
                public Object getTier() {
                    return this.$tier;
                }

                @Override
                public String getVersionLabel() {
                    return this.$versionLabel;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("applicationName", om.valueToTree((Object)this.getApplicationName()));
                    if (this.getCnamePrefix() != null) {
                        obj.set("cnamePrefix", om.valueToTree((Object)this.getCnamePrefix()));
                    }
                    if (this.getDescription() != null) {
                        obj.set("description", om.valueToTree((Object)this.getDescription()));
                    }
                    if (this.getEnvironmentName() != null) {
                        obj.set("environmentName", om.valueToTree((Object)this.getEnvironmentName()));
                    }
                    if (this.getOptionSettings() != null) {
                        obj.set("optionSettings", om.valueToTree(this.getOptionSettings()));
                    }
                    if (this.getPlatformArn() != null) {
                        obj.set("platformArn", om.valueToTree((Object)this.getPlatformArn()));
                    }
                    if (this.getSolutionStackName() != null) {
                        obj.set("solutionStackName", om.valueToTree((Object)this.getSolutionStackName()));
                    }
                    if (this.getTags() != null) {
                        obj.set("tags", om.valueToTree(this.getTags()));
                    }
                    if (this.getTemplateName() != null) {
                        obj.set("templateName", om.valueToTree((Object)this.getTemplateName()));
                    }
                    if (this.getTier() != null) {
                        obj.set("tier", om.valueToTree(this.getTier()));
                    }
                    if (this.getVersionLabel() != null) {
                        obj.set("versionLabel", om.valueToTree((Object)this.getVersionLabel()));
                    }
                    return obj;
                }
            };
        }
    }
}

