package software.amazon.awscdk.services.elasticbeanstalk;

/**
 * Properties for defining a `AWS::ElasticBeanstalk::ApplicationVersion`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.13.3 (build 3624e0f)", date = "2019-07-04T19:22:29.130Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnApplicationVersionProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * `AWS::ElasticBeanstalk::ApplicationVersion.ApplicationName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-applicationname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getApplicationName();
    /**
     * `AWS::ElasticBeanstalk::ApplicationVersion.SourceBundle`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-sourcebundle
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Object getSourceBundle();
    /**
     * `AWS::ElasticBeanstalk::ApplicationVersion.Description`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getDescription();

    /**
     * @return a {@link Builder} of {@link CfnApplicationVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CfnApplicationVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private java.lang.String _applicationName;
        private java.lang.Object _sourceBundle;
        @javax.annotation.Nullable
        private java.lang.String _description;

        /**
         * Sets the value of ApplicationName
         * @param value `AWS::ElasticBeanstalk::ApplicationVersion.ApplicationName`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withApplicationName(final java.lang.String value) {
            this._applicationName = java.util.Objects.requireNonNull(value, "applicationName is required");
            return this;
        }
        /**
         * Sets the value of SourceBundle
         * @param value `AWS::ElasticBeanstalk::ApplicationVersion.SourceBundle`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withSourceBundle(final software.amazon.awscdk.core.IResolvable value) {
            this._sourceBundle = java.util.Objects.requireNonNull(value, "sourceBundle is required");
            return this;
        }
        /**
         * Sets the value of SourceBundle
         * @param value `AWS::ElasticBeanstalk::ApplicationVersion.SourceBundle`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withSourceBundle(final software.amazon.awscdk.services.elasticbeanstalk.CfnApplicationVersion.SourceBundleProperty value) {
            this._sourceBundle = java.util.Objects.requireNonNull(value, "sourceBundle is required");
            return this;
        }
        /**
         * Sets the value of Description
         * @param value `AWS::ElasticBeanstalk::ApplicationVersion.Description`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withDescription(@javax.annotation.Nullable final java.lang.String value) {
            this._description = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnApplicationVersionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public CfnApplicationVersionProps build() {
            return new CfnApplicationVersionProps() {
                private final java.lang.String $applicationName = java.util.Objects.requireNonNull(_applicationName, "applicationName is required");
                private final java.lang.Object $sourceBundle = java.util.Objects.requireNonNull(_sourceBundle, "sourceBundle is required");
                @javax.annotation.Nullable
                private final java.lang.String $description = _description;

                @Override
                public java.lang.String getApplicationName() {
                    return this.$applicationName;
                }

                @Override
                public java.lang.Object getSourceBundle() {
                    return this.$sourceBundle;
                }

                @Override
                public java.lang.String getDescription() {
                    return this.$description;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("applicationName", om.valueToTree(this.getApplicationName()));
                    obj.set("sourceBundle", om.valueToTree(this.getSourceBundle()));
                    if (this.getDescription() != null) {
                        obj.set("description", om.valueToTree(this.getDescription()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticbeanstalk.CfnApplicationVersionProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * `AWS::ElasticBeanstalk::ApplicationVersion.ApplicationName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-applicationname
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.lang.String getApplicationName() {
            return this.jsiiGet("applicationName", java.lang.String.class);
        }

        /**
         * `AWS::ElasticBeanstalk::ApplicationVersion.SourceBundle`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-sourcebundle
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.lang.Object getSourceBundle() {
            return this.jsiiGet("sourceBundle", java.lang.Object.class);
        }

        /**
         * `AWS::ElasticBeanstalk::ApplicationVersion.Description`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-description
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getDescription() {
            return this.jsiiGet("description", java.lang.String.class);
        }
    }
}
