package software.amazon.awscdk.services.elasticbeanstalk;

/**
 * A CloudFormation `AWS::ElasticBeanstalk::ConfigurationTemplate`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.0 (build a586a1a)", date = "2019-07-08T12:58:49.130Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticbeanstalk.$Module.class, fqn = "@aws-cdk/aws-elasticbeanstalk.CfnConfigurationTemplate")
public class CfnConfigurationTemplate extends software.amazon.awscdk.core.CfnResource {
    protected CfnConfigurationTemplate(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticbeanstalk.CfnConfigurationTemplate.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }
    /**
     * Create a new `AWS::ElasticBeanstalk::ConfigurationTemplate`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnConfigurationTemplate(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.elasticbeanstalk.CfnConfigurationTemplateProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.util.Map<java.lang.String, java.lang.Object> props) {
        return this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return this.jsiiGet("cfnProperties", java.util.Map.class);
    }

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.ApplicationName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-applicationname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getApplicationName() {
        return this.jsiiGet("applicationName", java.lang.String.class);
    }

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.ApplicationName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-applicationname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApplicationName(final java.lang.String value) {
        this.jsiiSet("applicationName", java.util.Objects.requireNonNull(value, "applicationName is required"));
    }

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.Description`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @javax.annotation.Nullable
    public java.lang.String getDescription() {
        return this.jsiiGet("description", java.lang.String.class);
    }

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.Description`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
        this.jsiiSet("description", value);
    }

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.EnvironmentId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-environmentid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @javax.annotation.Nullable
    public java.lang.String getEnvironmentId() {
        return this.jsiiGet("environmentId", java.lang.String.class);
    }

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.EnvironmentId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-environmentid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnvironmentId(@javax.annotation.Nullable final java.lang.String value) {
        this.jsiiSet("environmentId", value);
    }

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.OptionSettings`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-optionsettings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @javax.annotation.Nullable
    public java.lang.Object getOptionSettings() {
        return this.jsiiGet("optionSettings", java.lang.Object.class);
    }

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.OptionSettings`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-optionsettings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOptionSettings(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("optionSettings", value);
    }

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.OptionSettings`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-optionsettings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOptionSettings(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
        this.jsiiSet("optionSettings", value);
    }

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.PlatformArn`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-platformarn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @javax.annotation.Nullable
    public java.lang.String getPlatformArn() {
        return this.jsiiGet("platformArn", java.lang.String.class);
    }

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.PlatformArn`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-platformarn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPlatformArn(@javax.annotation.Nullable final java.lang.String value) {
        this.jsiiSet("platformArn", value);
    }

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.SolutionStackName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-solutionstackname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @javax.annotation.Nullable
    public java.lang.String getSolutionStackName() {
        return this.jsiiGet("solutionStackName", java.lang.String.class);
    }

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.SolutionStackName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-solutionstackname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSolutionStackName(@javax.annotation.Nullable final java.lang.String value) {
        this.jsiiSet("solutionStackName", value);
    }

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.SourceConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @javax.annotation.Nullable
    public java.lang.Object getSourceConfiguration() {
        return this.jsiiGet("sourceConfiguration", java.lang.Object.class);
    }

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.SourceConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("sourceConfiguration", value);
    }

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.SourceConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticbeanstalk.CfnConfigurationTemplate.SourceConfigurationProperty value) {
        this.jsiiSet("sourceConfiguration", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConfigurationOptionSettingProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnConfigurationTemplate.ConfigurationOptionSettingProperty.Namespace`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-namespace
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getNamespace();
        /**
         * `CfnConfigurationTemplate.ConfigurationOptionSettingProperty.OptionName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-optionname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getOptionName();
        /**
         * `CfnConfigurationTemplate.ConfigurationOptionSettingProperty.ResourceName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-resourcename
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getResourceName();
        /**
         * `CfnConfigurationTemplate.ConfigurationOptionSettingProperty.Value`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-value
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link ConfigurationOptionSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ConfigurationOptionSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _namespace;
            private java.lang.String _optionName;
            @javax.annotation.Nullable
            private java.lang.String _resourceName;
            @javax.annotation.Nullable
            private java.lang.String _value;

            /**
             * Sets the value of Namespace
             * @param value `CfnConfigurationTemplate.ConfigurationOptionSettingProperty.Namespace`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withNamespace(final java.lang.String value) {
                this._namespace = java.util.Objects.requireNonNull(value, "namespace is required");
                return this;
            }
            /**
             * Sets the value of OptionName
             * @param value `CfnConfigurationTemplate.ConfigurationOptionSettingProperty.OptionName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withOptionName(final java.lang.String value) {
                this._optionName = java.util.Objects.requireNonNull(value, "optionName is required");
                return this;
            }
            /**
             * Sets the value of ResourceName
             * @param value `CfnConfigurationTemplate.ConfigurationOptionSettingProperty.ResourceName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withResourceName(@javax.annotation.Nullable final java.lang.String value) {
                this._resourceName = value;
                return this;
            }
            /**
             * Sets the value of Value
             * @param value `CfnConfigurationTemplate.ConfigurationOptionSettingProperty.Value`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withValue(@javax.annotation.Nullable final java.lang.String value) {
                this._value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConfigurationOptionSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public ConfigurationOptionSettingProperty build() {
                return new ConfigurationOptionSettingProperty() {
                    private final java.lang.String $namespace = java.util.Objects.requireNonNull(_namespace, "namespace is required");
                    private final java.lang.String $optionName = java.util.Objects.requireNonNull(_optionName, "optionName is required");
                    @javax.annotation.Nullable
                    private final java.lang.String $resourceName = _resourceName;
                    @javax.annotation.Nullable
                    private final java.lang.String $value = _value;

                    @Override
                    public java.lang.String getNamespace() {
                        return this.$namespace;
                    }

                    @Override
                    public java.lang.String getOptionName() {
                        return this.$optionName;
                    }

                    @Override
                    public java.lang.String getResourceName() {
                        return this.$resourceName;
                    }

                    @Override
                    public java.lang.String getValue() {
                        return this.$value;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("namespace", om.valueToTree(this.getNamespace()));
                        obj.set("optionName", om.valueToTree(this.getOptionName()));
                        if (this.getResourceName() != null) {
                            obj.set("resourceName", om.valueToTree(this.getResourceName()));
                        }
                        if (this.getValue() != null) {
                            obj.set("value", om.valueToTree(this.getValue()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticbeanstalk.CfnConfigurationTemplate.ConfigurationOptionSettingProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnConfigurationTemplate.ConfigurationOptionSettingProperty.Namespace`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-namespace
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getNamespace() {
                return this.jsiiGet("namespace", java.lang.String.class);
            }

            /**
             * `CfnConfigurationTemplate.ConfigurationOptionSettingProperty.OptionName`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-optionname
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getOptionName() {
                return this.jsiiGet("optionName", java.lang.String.class);
            }

            /**
             * `CfnConfigurationTemplate.ConfigurationOptionSettingProperty.ResourceName`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-resourcename
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getResourceName() {
                return this.jsiiGet("resourceName", java.lang.String.class);
            }

            /**
             * `CfnConfigurationTemplate.ConfigurationOptionSettingProperty.Value`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-value
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getValue() {
                return this.jsiiGet("value", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-sourceconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SourceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnConfigurationTemplate.SourceConfigurationProperty.ApplicationName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-sourceconfiguration.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration-applicationname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getApplicationName();
        /**
         * `CfnConfigurationTemplate.SourceConfigurationProperty.TemplateName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-sourceconfiguration.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration-templatename
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getTemplateName();

        /**
         * @return a {@link Builder} of {@link SourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _applicationName;
            private java.lang.String _templateName;

            /**
             * Sets the value of ApplicationName
             * @param value `CfnConfigurationTemplate.SourceConfigurationProperty.ApplicationName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withApplicationName(final java.lang.String value) {
                this._applicationName = java.util.Objects.requireNonNull(value, "applicationName is required");
                return this;
            }
            /**
             * Sets the value of TemplateName
             * @param value `CfnConfigurationTemplate.SourceConfigurationProperty.TemplateName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withTemplateName(final java.lang.String value) {
                this._templateName = java.util.Objects.requireNonNull(value, "templateName is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public SourceConfigurationProperty build() {
                return new SourceConfigurationProperty() {
                    private final java.lang.String $applicationName = java.util.Objects.requireNonNull(_applicationName, "applicationName is required");
                    private final java.lang.String $templateName = java.util.Objects.requireNonNull(_templateName, "templateName is required");

                    @Override
                    public java.lang.String getApplicationName() {
                        return this.$applicationName;
                    }

                    @Override
                    public java.lang.String getTemplateName() {
                        return this.$templateName;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("applicationName", om.valueToTree(this.getApplicationName()));
                        obj.set("templateName", om.valueToTree(this.getTemplateName()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticbeanstalk.CfnConfigurationTemplate.SourceConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnConfigurationTemplate.SourceConfigurationProperty.ApplicationName`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-sourceconfiguration.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration-applicationname
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getApplicationName() {
                return this.jsiiGet("applicationName", java.lang.String.class);
            }

            /**
             * `CfnConfigurationTemplate.SourceConfigurationProperty.TemplateName`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-sourceconfiguration.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration-templatename
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getTemplateName() {
                return this.jsiiGet("templateName", java.lang.String.class);
            }
        }
    }
}
