package software.amazon.awscdk.services.elasticbeanstalk.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html
 */
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticbeanstalk.$Module.class, fqn = "@aws-cdk/aws-elasticbeanstalk.cloudformation.ConfigurationTemplateResource")
public class ConfigurationTemplateResource extends software.amazon.awscdk.Resource {
    protected ConfigurationTemplateResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ConfigurationTemplateResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::ElasticBeanstalk::ConfigurationTemplate``.
     * @param parent the ``cdk.Construct`` this ``ConfigurationTemplateResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``ConfigurationTemplateResource``
     */
    public ConfigurationTemplateResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, final software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ConfigurationTemplateResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required"))).toArray());
    }
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties() {
        return this.jsiiCall("renderProperties", java.util.Map.class);
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html
     */
    public static interface ConfigurationOptionSettingProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``ConfigurationTemplateResource.ConfigurationOptionSettingProperty.Namespace``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-namespace
         */
        java.lang.Object getNamespace();
        /**
         * ``ConfigurationTemplateResource.ConfigurationOptionSettingProperty.Namespace``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-namespace
         */
        void setNamespace(final java.lang.String value);
        /**
         * ``ConfigurationTemplateResource.ConfigurationOptionSettingProperty.Namespace``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-namespace
         */
        void setNamespace(final software.amazon.awscdk.Token value);
        /**
         * ``ConfigurationTemplateResource.ConfigurationOptionSettingProperty.OptionName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-optionname
         */
        java.lang.Object getOptionName();
        /**
         * ``ConfigurationTemplateResource.ConfigurationOptionSettingProperty.OptionName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-optionname
         */
        void setOptionName(final java.lang.String value);
        /**
         * ``ConfigurationTemplateResource.ConfigurationOptionSettingProperty.OptionName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-optionname
         */
        void setOptionName(final software.amazon.awscdk.Token value);
        /**
         * ``ConfigurationTemplateResource.ConfigurationOptionSettingProperty.ResourceName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-resourcename
         */
        java.lang.Object getResourceName();
        /**
         * ``ConfigurationTemplateResource.ConfigurationOptionSettingProperty.ResourceName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-resourcename
         */
        void setResourceName(final java.lang.String value);
        /**
         * ``ConfigurationTemplateResource.ConfigurationOptionSettingProperty.ResourceName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-resourcename
         */
        void setResourceName(final software.amazon.awscdk.Token value);
        /**
         * ``ConfigurationTemplateResource.ConfigurationOptionSettingProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-value
         */
        java.lang.Object getValue();
        /**
         * ``ConfigurationTemplateResource.ConfigurationOptionSettingProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-value
         */
        void setValue(final java.lang.String value);
        /**
         * ``ConfigurationTemplateResource.ConfigurationOptionSettingProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-value
         */
        void setValue(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link ConfigurationOptionSettingProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``ConfigurationTemplateResource.ConfigurationOptionSettingProperty.Namespace``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-namespace
             */
            public OptionNameStep withNamespace(final java.lang.String value) {
                return new FullBuilder().withNamespace(value);
            }
            /**
             * ``ConfigurationTemplateResource.ConfigurationOptionSettingProperty.Namespace``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-namespace
             */
            public OptionNameStep withNamespace(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withNamespace(value);
            }

            public interface OptionNameStep {
                /**
                 * ``ConfigurationTemplateResource.ConfigurationOptionSettingProperty.OptionName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-optionname
                 */
                Build withOptionName(final java.lang.String value);
                /**
                 * ``ConfigurationTemplateResource.ConfigurationOptionSettingProperty.OptionName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-optionname
                 */
                Build withOptionName(final software.amazon.awscdk.Token value);
            }

            public interface Build {
                /**
                 * @return a new {@link ConfigurationOptionSettingProperty} object, initialized with the values set on this builder.
                 */
                ConfigurationOptionSettingProperty build();
                /**
                 * ``ConfigurationTemplateResource.ConfigurationOptionSettingProperty.ResourceName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-resourcename
                 */
                Build withResourceName(final java.lang.String value);
                /**
                 * ``ConfigurationTemplateResource.ConfigurationOptionSettingProperty.ResourceName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-resourcename
                 */
                Build withResourceName(final software.amazon.awscdk.Token value);
                /**
                 * ``ConfigurationTemplateResource.ConfigurationOptionSettingProperty.Value``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-value
                 */
                Build withValue(final java.lang.String value);
                /**
                 * ``ConfigurationTemplateResource.ConfigurationOptionSettingProperty.Value``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-value
                 */
                Build withValue(final software.amazon.awscdk.Token value);
            }

            final class FullBuilder implements OptionNameStep, Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``ConfigurationTemplateResource.ConfigurationOptionSettingProperty.Namespace``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-namespace
                 */
                public OptionNameStep withNamespace(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "ConfigurationOptionSettingProperty#namespace is required");
                    this.instance._namespace = value;
                    return this;
                }
                /**
                 * ``ConfigurationTemplateResource.ConfigurationOptionSettingProperty.Namespace``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-namespace
                 */
                public OptionNameStep withNamespace(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "ConfigurationOptionSettingProperty#namespace is required");
                    this.instance._namespace = value;
                    return this;
                }
                /**
                 * ``ConfigurationTemplateResource.ConfigurationOptionSettingProperty.OptionName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-optionname
                 */
                public Build withOptionName(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "ConfigurationOptionSettingProperty#optionName is required");
                    this.instance._optionName = value;
                    return this;
                }
                /**
                 * ``ConfigurationTemplateResource.ConfigurationOptionSettingProperty.OptionName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-optionname
                 */
                public Build withOptionName(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "ConfigurationOptionSettingProperty#optionName is required");
                    this.instance._optionName = value;
                    return this;
                }
                /**
                 * ``ConfigurationTemplateResource.ConfigurationOptionSettingProperty.ResourceName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-resourcename
                 */
                public Build withResourceName(final java.lang.String value) {
                    this.instance._resourceName = value;
                    return this;
                }
                /**
                 * ``ConfigurationTemplateResource.ConfigurationOptionSettingProperty.ResourceName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-resourcename
                 */
                public Build withResourceName(final software.amazon.awscdk.Token value) {
                    this.instance._resourceName = value;
                    return this;
                }
                /**
                 * ``ConfigurationTemplateResource.ConfigurationOptionSettingProperty.Value``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-value
                 */
                public Build withValue(final java.lang.String value) {
                    this.instance._value = value;
                    return this;
                }
                /**
                 * ``ConfigurationTemplateResource.ConfigurationOptionSettingProperty.Value``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-value
                 */
                public Build withValue(final software.amazon.awscdk.Token value) {
                    this.instance._value = value;
                    return this;
                }
                public ConfigurationOptionSettingProperty build() {
                    ConfigurationOptionSettingProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link ConfigurationOptionSettingProperty}.
         */
        final class Jsii$Pojo implements ConfigurationOptionSettingProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _namespace;

            public java.lang.Object getNamespace() {
                return this._namespace;
            }
            public void setNamespace(final java.lang.String value) {
                this._namespace = value;
            }
            public void setNamespace(final software.amazon.awscdk.Token value) {
                this._namespace = value;
            }

            protected java.lang.Object _optionName;

            public java.lang.Object getOptionName() {
                return this._optionName;
            }
            public void setOptionName(final java.lang.String value) {
                this._optionName = value;
            }
            public void setOptionName(final software.amazon.awscdk.Token value) {
                this._optionName = value;
            }

            protected java.lang.Object _resourceName;

            public java.lang.Object getResourceName() {
                return this._resourceName;
            }
            public void setResourceName(final java.lang.String value) {
                this._resourceName = value;
            }
            public void setResourceName(final software.amazon.awscdk.Token value) {
                this._resourceName = value;
            }

            protected java.lang.Object _value;

            public java.lang.Object getValue() {
                return this._value;
            }
            public void setValue(final java.lang.String value) {
                this._value = value;
            }
            public void setValue(final software.amazon.awscdk.Token value) {
                this._value = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ConfigurationTemplateResource.ConfigurationOptionSettingProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``ConfigurationTemplateResource.ConfigurationOptionSettingProperty.Namespace``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-namespace
             */
            public java.lang.Object getNamespace() {
                return this.jsiiGet("namespace", java.lang.Object.class);
            }
            /**
             * ``ConfigurationTemplateResource.ConfigurationOptionSettingProperty.Namespace``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-namespace
             */
            public void setNamespace(final java.lang.String value) {
                this.jsiiSet("namespace", java.util.Objects.requireNonNull(value, "namespace is required"));
            }
            /**
             * ``ConfigurationTemplateResource.ConfigurationOptionSettingProperty.Namespace``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-namespace
             */
            public void setNamespace(final software.amazon.awscdk.Token value) {
                this.jsiiSet("namespace", java.util.Objects.requireNonNull(value, "namespace is required"));
            }
            /**
             * ``ConfigurationTemplateResource.ConfigurationOptionSettingProperty.OptionName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-optionname
             */
            public java.lang.Object getOptionName() {
                return this.jsiiGet("optionName", java.lang.Object.class);
            }
            /**
             * ``ConfigurationTemplateResource.ConfigurationOptionSettingProperty.OptionName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-optionname
             */
            public void setOptionName(final java.lang.String value) {
                this.jsiiSet("optionName", java.util.Objects.requireNonNull(value, "optionName is required"));
            }
            /**
             * ``ConfigurationTemplateResource.ConfigurationOptionSettingProperty.OptionName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-optionname
             */
            public void setOptionName(final software.amazon.awscdk.Token value) {
                this.jsiiSet("optionName", java.util.Objects.requireNonNull(value, "optionName is required"));
            }
            /**
             * ``ConfigurationTemplateResource.ConfigurationOptionSettingProperty.ResourceName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-resourcename
             */
            @javax.annotation.Nullable
            public java.lang.Object getResourceName() {
                return this.jsiiGet("resourceName", java.lang.Object.class);
            }
            /**
             * ``ConfigurationTemplateResource.ConfigurationOptionSettingProperty.ResourceName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-resourcename
             */
            public void setResourceName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("resourceName", value);
            }
            /**
             * ``ConfigurationTemplateResource.ConfigurationOptionSettingProperty.ResourceName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-resourcename
             */
            public void setResourceName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("resourceName", value);
            }
            /**
             * ``ConfigurationTemplateResource.ConfigurationOptionSettingProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-value
             */
            @javax.annotation.Nullable
            public java.lang.Object getValue() {
                return this.jsiiGet("value", java.lang.Object.class);
            }
            /**
             * ``ConfigurationTemplateResource.ConfigurationOptionSettingProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-value
             */
            public void setValue(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("value", value);
            }
            /**
             * ``ConfigurationTemplateResource.ConfigurationOptionSettingProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-value
             */
            public void setValue(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("value", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-sourceconfiguration.html
     */
    public static interface SourceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``ConfigurationTemplateResource.SourceConfigurationProperty.ApplicationName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-sourceconfiguration.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration-applicationname
         */
        java.lang.Object getApplicationName();
        /**
         * ``ConfigurationTemplateResource.SourceConfigurationProperty.ApplicationName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-sourceconfiguration.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration-applicationname
         */
        void setApplicationName(final java.lang.String value);
        /**
         * ``ConfigurationTemplateResource.SourceConfigurationProperty.ApplicationName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-sourceconfiguration.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration-applicationname
         */
        void setApplicationName(final software.amazon.awscdk.Token value);
        /**
         * ``ConfigurationTemplateResource.SourceConfigurationProperty.TemplateName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-sourceconfiguration.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration-templatename
         */
        java.lang.Object getTemplateName();
        /**
         * ``ConfigurationTemplateResource.SourceConfigurationProperty.TemplateName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-sourceconfiguration.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration-templatename
         */
        void setTemplateName(final java.lang.String value);
        /**
         * ``ConfigurationTemplateResource.SourceConfigurationProperty.TemplateName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-sourceconfiguration.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration-templatename
         */
        void setTemplateName(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link SourceConfigurationProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``ConfigurationTemplateResource.SourceConfigurationProperty.ApplicationName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-sourceconfiguration.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration-applicationname
             */
            public TemplateNameStep withApplicationName(final java.lang.String value) {
                return new FullBuilder().withApplicationName(value);
            }
            /**
             * ``ConfigurationTemplateResource.SourceConfigurationProperty.ApplicationName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-sourceconfiguration.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration-applicationname
             */
            public TemplateNameStep withApplicationName(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withApplicationName(value);
            }

            public interface TemplateNameStep {
                /**
                 * ``ConfigurationTemplateResource.SourceConfigurationProperty.TemplateName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-sourceconfiguration.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration-templatename
                 */
                Build withTemplateName(final java.lang.String value);
                /**
                 * ``ConfigurationTemplateResource.SourceConfigurationProperty.TemplateName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-sourceconfiguration.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration-templatename
                 */
                Build withTemplateName(final software.amazon.awscdk.Token value);
            }

            public interface Build {
                /**
                 * @return a new {@link SourceConfigurationProperty} object, initialized with the values set on this builder.
                 */
                SourceConfigurationProperty build();
            }

            final class FullBuilder implements TemplateNameStep, Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``ConfigurationTemplateResource.SourceConfigurationProperty.ApplicationName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-sourceconfiguration.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration-applicationname
                 */
                public TemplateNameStep withApplicationName(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "SourceConfigurationProperty#applicationName is required");
                    this.instance._applicationName = value;
                    return this;
                }
                /**
                 * ``ConfigurationTemplateResource.SourceConfigurationProperty.ApplicationName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-sourceconfiguration.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration-applicationname
                 */
                public TemplateNameStep withApplicationName(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "SourceConfigurationProperty#applicationName is required");
                    this.instance._applicationName = value;
                    return this;
                }
                /**
                 * ``ConfigurationTemplateResource.SourceConfigurationProperty.TemplateName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-sourceconfiguration.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration-templatename
                 */
                public Build withTemplateName(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "SourceConfigurationProperty#templateName is required");
                    this.instance._templateName = value;
                    return this;
                }
                /**
                 * ``ConfigurationTemplateResource.SourceConfigurationProperty.TemplateName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-sourceconfiguration.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration-templatename
                 */
                public Build withTemplateName(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "SourceConfigurationProperty#templateName is required");
                    this.instance._templateName = value;
                    return this;
                }
                public SourceConfigurationProperty build() {
                    SourceConfigurationProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link SourceConfigurationProperty}.
         */
        final class Jsii$Pojo implements SourceConfigurationProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _applicationName;

            public java.lang.Object getApplicationName() {
                return this._applicationName;
            }
            public void setApplicationName(final java.lang.String value) {
                this._applicationName = value;
            }
            public void setApplicationName(final software.amazon.awscdk.Token value) {
                this._applicationName = value;
            }

            protected java.lang.Object _templateName;

            public java.lang.Object getTemplateName() {
                return this._templateName;
            }
            public void setTemplateName(final java.lang.String value) {
                this._templateName = value;
            }
            public void setTemplateName(final software.amazon.awscdk.Token value) {
                this._templateName = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ConfigurationTemplateResource.SourceConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``ConfigurationTemplateResource.SourceConfigurationProperty.ApplicationName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-sourceconfiguration.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration-applicationname
             */
            public java.lang.Object getApplicationName() {
                return this.jsiiGet("applicationName", java.lang.Object.class);
            }
            /**
             * ``ConfigurationTemplateResource.SourceConfigurationProperty.ApplicationName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-sourceconfiguration.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration-applicationname
             */
            public void setApplicationName(final java.lang.String value) {
                this.jsiiSet("applicationName", java.util.Objects.requireNonNull(value, "applicationName is required"));
            }
            /**
             * ``ConfigurationTemplateResource.SourceConfigurationProperty.ApplicationName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-sourceconfiguration.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration-applicationname
             */
            public void setApplicationName(final software.amazon.awscdk.Token value) {
                this.jsiiSet("applicationName", java.util.Objects.requireNonNull(value, "applicationName is required"));
            }
            /**
             * ``ConfigurationTemplateResource.SourceConfigurationProperty.TemplateName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-sourceconfiguration.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration-templatename
             */
            public java.lang.Object getTemplateName() {
                return this.jsiiGet("templateName", java.lang.Object.class);
            }
            /**
             * ``ConfigurationTemplateResource.SourceConfigurationProperty.TemplateName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-sourceconfiguration.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration-templatename
             */
            public void setTemplateName(final java.lang.String value) {
                this.jsiiSet("templateName", java.util.Objects.requireNonNull(value, "templateName is required"));
            }
            /**
             * ``ConfigurationTemplateResource.SourceConfigurationProperty.TemplateName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-sourceconfiguration.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration-templatename
             */
            public void setTemplateName(final software.amazon.awscdk.Token value) {
                this.jsiiSet("templateName", java.util.Objects.requireNonNull(value, "templateName is required"));
            }
        }
    }
}
