package software.amazon.awscdk.services.elasticbeanstalk.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html
 */
public interface EnvironmentResourceProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * ``AWS::ElasticBeanstalk::Environment.ApplicationName``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-applicationname
     */
    java.lang.Object getApplicationName();
    /**
     * ``AWS::ElasticBeanstalk::Environment.ApplicationName``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-applicationname
     */
    void setApplicationName(final java.lang.String value);
    /**
     * ``AWS::ElasticBeanstalk::Environment.ApplicationName``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-applicationname
     */
    void setApplicationName(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::ElasticBeanstalk::Environment.CNAMEPrefix``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-cnameprefix
     */
    java.lang.Object getCnamePrefix();
    /**
     * ``AWS::ElasticBeanstalk::Environment.CNAMEPrefix``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-cnameprefix
     */
    void setCnamePrefix(final java.lang.String value);
    /**
     * ``AWS::ElasticBeanstalk::Environment.CNAMEPrefix``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-cnameprefix
     */
    void setCnamePrefix(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::ElasticBeanstalk::Environment.Description``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-description
     */
    java.lang.Object getDescription();
    /**
     * ``AWS::ElasticBeanstalk::Environment.Description``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-description
     */
    void setDescription(final java.lang.String value);
    /**
     * ``AWS::ElasticBeanstalk::Environment.Description``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-description
     */
    void setDescription(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::ElasticBeanstalk::Environment.EnvironmentName``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-name
     */
    java.lang.Object getEnvironmentName();
    /**
     * ``AWS::ElasticBeanstalk::Environment.EnvironmentName``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-name
     */
    void setEnvironmentName(final java.lang.String value);
    /**
     * ``AWS::ElasticBeanstalk::Environment.EnvironmentName``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-name
     */
    void setEnvironmentName(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::ElasticBeanstalk::Environment.OptionSettings``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-optionsettings
     */
    java.lang.Object getOptionSettings();
    /**
     * ``AWS::ElasticBeanstalk::Environment.OptionSettings``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-optionsettings
     */
    void setOptionSettings(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::ElasticBeanstalk::Environment.OptionSettings``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-optionsettings
     */
    void setOptionSettings(final java.util.List<java.lang.Object> value);
    /**
     * ``AWS::ElasticBeanstalk::Environment.PlatformArn``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-platformarn
     */
    java.lang.Object getPlatformArn();
    /**
     * ``AWS::ElasticBeanstalk::Environment.PlatformArn``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-platformarn
     */
    void setPlatformArn(final java.lang.String value);
    /**
     * ``AWS::ElasticBeanstalk::Environment.PlatformArn``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-platformarn
     */
    void setPlatformArn(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::ElasticBeanstalk::Environment.SolutionStackName``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-solutionstackname
     */
    java.lang.Object getSolutionStackName();
    /**
     * ``AWS::ElasticBeanstalk::Environment.SolutionStackName``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-solutionstackname
     */
    void setSolutionStackName(final java.lang.String value);
    /**
     * ``AWS::ElasticBeanstalk::Environment.SolutionStackName``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-solutionstackname
     */
    void setSolutionStackName(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::ElasticBeanstalk::Environment.Tags``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-elasticbeanstalk-environment-tags
     */
    java.lang.Object getTags();
    /**
     * ``AWS::ElasticBeanstalk::Environment.Tags``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-elasticbeanstalk-environment-tags
     */
    void setTags(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::ElasticBeanstalk::Environment.Tags``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-elasticbeanstalk-environment-tags
     */
    void setTags(final java.util.List<java.lang.Object> value);
    /**
     * ``AWS::ElasticBeanstalk::Environment.TemplateName``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-templatename
     */
    java.lang.Object getTemplateName();
    /**
     * ``AWS::ElasticBeanstalk::Environment.TemplateName``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-templatename
     */
    void setTemplateName(final java.lang.String value);
    /**
     * ``AWS::ElasticBeanstalk::Environment.TemplateName``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-templatename
     */
    void setTemplateName(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::ElasticBeanstalk::Environment.Tier``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-tier
     */
    java.lang.Object getTier();
    /**
     * ``AWS::ElasticBeanstalk::Environment.Tier``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-tier
     */
    void setTier(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::ElasticBeanstalk::Environment.Tier``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-tier
     */
    void setTier(final software.amazon.awscdk.services.elasticbeanstalk.cloudformation.EnvironmentResource.TierProperty value);
    /**
     * ``AWS::ElasticBeanstalk::Environment.VersionLabel``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-versionlabel
     */
    java.lang.Object getVersionLabel();
    /**
     * ``AWS::ElasticBeanstalk::Environment.VersionLabel``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-versionlabel
     */
    void setVersionLabel(final java.lang.String value);
    /**
     * ``AWS::ElasticBeanstalk::Environment.VersionLabel``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-versionlabel
     */
    void setVersionLabel(final software.amazon.awscdk.Token value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }
    /**
     * A fluent step builder class for {@link EnvironmentResourceProps}.
     * The {@link Build#build()} method will be available once all required properties are fulfilled.
     */
    final class Builder {
        /**
         * ``AWS::ElasticBeanstalk::Environment.ApplicationName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-applicationname
         */
        public Build withApplicationName(final java.lang.String value) {
            return new FullBuilder().withApplicationName(value);
        }
        /**
         * ``AWS::ElasticBeanstalk::Environment.ApplicationName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-applicationname
         */
        public Build withApplicationName(final software.amazon.awscdk.Token value) {
            return new FullBuilder().withApplicationName(value);
        }

        public interface Build {
            /**
             * @return a new {@link EnvironmentResourceProps} object, initialized with the values set on this builder.
             */
            EnvironmentResourceProps build();
            /**
             * ``AWS::ElasticBeanstalk::Environment.CNAMEPrefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-cnameprefix
             */
            Build withCnamePrefix(final java.lang.String value);
            /**
             * ``AWS::ElasticBeanstalk::Environment.CNAMEPrefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-cnameprefix
             */
            Build withCnamePrefix(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::ElasticBeanstalk::Environment.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-description
             */
            Build withDescription(final java.lang.String value);
            /**
             * ``AWS::ElasticBeanstalk::Environment.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-description
             */
            Build withDescription(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::ElasticBeanstalk::Environment.EnvironmentName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-name
             */
            Build withEnvironmentName(final java.lang.String value);
            /**
             * ``AWS::ElasticBeanstalk::Environment.EnvironmentName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-name
             */
            Build withEnvironmentName(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::ElasticBeanstalk::Environment.OptionSettings``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-optionsettings
             */
            Build withOptionSettings(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::ElasticBeanstalk::Environment.OptionSettings``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-optionsettings
             */
            Build withOptionSettings(final java.util.List<java.lang.Object> value);
            /**
             * ``AWS::ElasticBeanstalk::Environment.PlatformArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-platformarn
             */
            Build withPlatformArn(final java.lang.String value);
            /**
             * ``AWS::ElasticBeanstalk::Environment.PlatformArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-platformarn
             */
            Build withPlatformArn(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::ElasticBeanstalk::Environment.SolutionStackName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-solutionstackname
             */
            Build withSolutionStackName(final java.lang.String value);
            /**
             * ``AWS::ElasticBeanstalk::Environment.SolutionStackName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-solutionstackname
             */
            Build withSolutionStackName(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::ElasticBeanstalk::Environment.Tags``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-elasticbeanstalk-environment-tags
             */
            Build withTags(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::ElasticBeanstalk::Environment.Tags``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-elasticbeanstalk-environment-tags
             */
            Build withTags(final java.util.List<java.lang.Object> value);
            /**
             * ``AWS::ElasticBeanstalk::Environment.TemplateName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-templatename
             */
            Build withTemplateName(final java.lang.String value);
            /**
             * ``AWS::ElasticBeanstalk::Environment.TemplateName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-templatename
             */
            Build withTemplateName(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::ElasticBeanstalk::Environment.Tier``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-tier
             */
            Build withTier(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::ElasticBeanstalk::Environment.Tier``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-tier
             */
            Build withTier(final software.amazon.awscdk.services.elasticbeanstalk.cloudformation.EnvironmentResource.TierProperty value);
            /**
             * ``AWS::ElasticBeanstalk::Environment.VersionLabel``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-versionlabel
             */
            Build withVersionLabel(final java.lang.String value);
            /**
             * ``AWS::ElasticBeanstalk::Environment.VersionLabel``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-versionlabel
             */
            Build withVersionLabel(final software.amazon.awscdk.Token value);
        }

        final class FullBuilder implements Build {

            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``AWS::ElasticBeanstalk::Environment.ApplicationName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-applicationname
             */
            public Build withApplicationName(final java.lang.String value) {
                java.util.Objects.requireNonNull(value, "EnvironmentResourceProps#applicationName is required");
                this.instance._applicationName = value;
                return this;
            }
            /**
             * ``AWS::ElasticBeanstalk::Environment.ApplicationName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-applicationname
             */
            public Build withApplicationName(final software.amazon.awscdk.Token value) {
                java.util.Objects.requireNonNull(value, "EnvironmentResourceProps#applicationName is required");
                this.instance._applicationName = value;
                return this;
            }
            /**
             * ``AWS::ElasticBeanstalk::Environment.CNAMEPrefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-cnameprefix
             */
            public Build withCnamePrefix(final java.lang.String value) {
                this.instance._cnamePrefix = value;
                return this;
            }
            /**
             * ``AWS::ElasticBeanstalk::Environment.CNAMEPrefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-cnameprefix
             */
            public Build withCnamePrefix(final software.amazon.awscdk.Token value) {
                this.instance._cnamePrefix = value;
                return this;
            }
            /**
             * ``AWS::ElasticBeanstalk::Environment.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-description
             */
            public Build withDescription(final java.lang.String value) {
                this.instance._description = value;
                return this;
            }
            /**
             * ``AWS::ElasticBeanstalk::Environment.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-description
             */
            public Build withDescription(final software.amazon.awscdk.Token value) {
                this.instance._description = value;
                return this;
            }
            /**
             * ``AWS::ElasticBeanstalk::Environment.EnvironmentName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-name
             */
            public Build withEnvironmentName(final java.lang.String value) {
                this.instance._environmentName = value;
                return this;
            }
            /**
             * ``AWS::ElasticBeanstalk::Environment.EnvironmentName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-name
             */
            public Build withEnvironmentName(final software.amazon.awscdk.Token value) {
                this.instance._environmentName = value;
                return this;
            }
            /**
             * ``AWS::ElasticBeanstalk::Environment.OptionSettings``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-optionsettings
             */
            public Build withOptionSettings(final software.amazon.awscdk.Token value) {
                this.instance._optionSettings = value;
                return this;
            }
            /**
             * ``AWS::ElasticBeanstalk::Environment.OptionSettings``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-optionsettings
             */
            public Build withOptionSettings(final java.util.List<java.lang.Object> value) {
                this.instance._optionSettings = value;
                return this;
            }
            /**
             * ``AWS::ElasticBeanstalk::Environment.PlatformArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-platformarn
             */
            public Build withPlatformArn(final java.lang.String value) {
                this.instance._platformArn = value;
                return this;
            }
            /**
             * ``AWS::ElasticBeanstalk::Environment.PlatformArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-platformarn
             */
            public Build withPlatformArn(final software.amazon.awscdk.Token value) {
                this.instance._platformArn = value;
                return this;
            }
            /**
             * ``AWS::ElasticBeanstalk::Environment.SolutionStackName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-solutionstackname
             */
            public Build withSolutionStackName(final java.lang.String value) {
                this.instance._solutionStackName = value;
                return this;
            }
            /**
             * ``AWS::ElasticBeanstalk::Environment.SolutionStackName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-solutionstackname
             */
            public Build withSolutionStackName(final software.amazon.awscdk.Token value) {
                this.instance._solutionStackName = value;
                return this;
            }
            /**
             * ``AWS::ElasticBeanstalk::Environment.Tags``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-elasticbeanstalk-environment-tags
             */
            public Build withTags(final software.amazon.awscdk.Token value) {
                this.instance._tags = value;
                return this;
            }
            /**
             * ``AWS::ElasticBeanstalk::Environment.Tags``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-elasticbeanstalk-environment-tags
             */
            public Build withTags(final java.util.List<java.lang.Object> value) {
                this.instance._tags = value;
                return this;
            }
            /**
             * ``AWS::ElasticBeanstalk::Environment.TemplateName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-templatename
             */
            public Build withTemplateName(final java.lang.String value) {
                this.instance._templateName = value;
                return this;
            }
            /**
             * ``AWS::ElasticBeanstalk::Environment.TemplateName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-templatename
             */
            public Build withTemplateName(final software.amazon.awscdk.Token value) {
                this.instance._templateName = value;
                return this;
            }
            /**
             * ``AWS::ElasticBeanstalk::Environment.Tier``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-tier
             */
            public Build withTier(final software.amazon.awscdk.Token value) {
                this.instance._tier = value;
                return this;
            }
            /**
             * ``AWS::ElasticBeanstalk::Environment.Tier``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-tier
             */
            public Build withTier(final software.amazon.awscdk.services.elasticbeanstalk.cloudformation.EnvironmentResource.TierProperty value) {
                this.instance._tier = value;
                return this;
            }
            /**
             * ``AWS::ElasticBeanstalk::Environment.VersionLabel``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-versionlabel
             */
            public Build withVersionLabel(final java.lang.String value) {
                this.instance._versionLabel = value;
                return this;
            }
            /**
             * ``AWS::ElasticBeanstalk::Environment.VersionLabel``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-versionlabel
             */
            public Build withVersionLabel(final software.amazon.awscdk.Token value) {
                this.instance._versionLabel = value;
                return this;
            }
            public EnvironmentResourceProps build() {
                EnvironmentResourceProps result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link EnvironmentResourceProps}.
     */
    final class Jsii$Pojo implements EnvironmentResourceProps {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected java.lang.Object _applicationName;

        public java.lang.Object getApplicationName() {
            return this._applicationName;
        }
        public void setApplicationName(final java.lang.String value) {
            this._applicationName = value;
        }
        public void setApplicationName(final software.amazon.awscdk.Token value) {
            this._applicationName = value;
        }

        protected java.lang.Object _cnamePrefix;

        public java.lang.Object getCnamePrefix() {
            return this._cnamePrefix;
        }
        public void setCnamePrefix(final java.lang.String value) {
            this._cnamePrefix = value;
        }
        public void setCnamePrefix(final software.amazon.awscdk.Token value) {
            this._cnamePrefix = value;
        }

        protected java.lang.Object _description;

        public java.lang.Object getDescription() {
            return this._description;
        }
        public void setDescription(final java.lang.String value) {
            this._description = value;
        }
        public void setDescription(final software.amazon.awscdk.Token value) {
            this._description = value;
        }

        protected java.lang.Object _environmentName;

        public java.lang.Object getEnvironmentName() {
            return this._environmentName;
        }
        public void setEnvironmentName(final java.lang.String value) {
            this._environmentName = value;
        }
        public void setEnvironmentName(final software.amazon.awscdk.Token value) {
            this._environmentName = value;
        }

        protected java.lang.Object _optionSettings;

        public java.lang.Object getOptionSettings() {
            return this._optionSettings;
        }
        public void setOptionSettings(final software.amazon.awscdk.Token value) {
            this._optionSettings = value;
        }
        public void setOptionSettings(final java.util.List<java.lang.Object> value) {
            this._optionSettings = value;
        }

        protected java.lang.Object _platformArn;

        public java.lang.Object getPlatformArn() {
            return this._platformArn;
        }
        public void setPlatformArn(final java.lang.String value) {
            this._platformArn = value;
        }
        public void setPlatformArn(final software.amazon.awscdk.Token value) {
            this._platformArn = value;
        }

        protected java.lang.Object _solutionStackName;

        public java.lang.Object getSolutionStackName() {
            return this._solutionStackName;
        }
        public void setSolutionStackName(final java.lang.String value) {
            this._solutionStackName = value;
        }
        public void setSolutionStackName(final software.amazon.awscdk.Token value) {
            this._solutionStackName = value;
        }

        protected java.lang.Object _tags;

        public java.lang.Object getTags() {
            return this._tags;
        }
        public void setTags(final software.amazon.awscdk.Token value) {
            this._tags = value;
        }
        public void setTags(final java.util.List<java.lang.Object> value) {
            this._tags = value;
        }

        protected java.lang.Object _templateName;

        public java.lang.Object getTemplateName() {
            return this._templateName;
        }
        public void setTemplateName(final java.lang.String value) {
            this._templateName = value;
        }
        public void setTemplateName(final software.amazon.awscdk.Token value) {
            this._templateName = value;
        }

        protected java.lang.Object _tier;

        public java.lang.Object getTier() {
            return this._tier;
        }
        public void setTier(final software.amazon.awscdk.Token value) {
            this._tier = value;
        }
        public void setTier(final software.amazon.awscdk.services.elasticbeanstalk.cloudformation.EnvironmentResource.TierProperty value) {
            this._tier = value;
        }

        protected java.lang.Object _versionLabel;

        public java.lang.Object getVersionLabel() {
            return this._versionLabel;
        }
        public void setVersionLabel(final java.lang.String value) {
            this._versionLabel = value;
        }
        public void setVersionLabel(final software.amazon.awscdk.Token value) {
            this._versionLabel = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticbeanstalk.cloudformation.EnvironmentResourceProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * ``AWS::ElasticBeanstalk::Environment.ApplicationName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-applicationname
         */
        public java.lang.Object getApplicationName() {
            return this.jsiiGet("applicationName", java.lang.Object.class);
        }
        /**
         * ``AWS::ElasticBeanstalk::Environment.ApplicationName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-applicationname
         */
        public void setApplicationName(final java.lang.String value) {
            this.jsiiSet("applicationName", java.util.Objects.requireNonNull(value, "applicationName is required"));
        }
        /**
         * ``AWS::ElasticBeanstalk::Environment.ApplicationName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-applicationname
         */
        public void setApplicationName(final software.amazon.awscdk.Token value) {
            this.jsiiSet("applicationName", java.util.Objects.requireNonNull(value, "applicationName is required"));
        }
        /**
         * ``AWS::ElasticBeanstalk::Environment.CNAMEPrefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-cnameprefix
         */
        @javax.annotation.Nullable
        public java.lang.Object getCnamePrefix() {
            return this.jsiiGet("cnamePrefix", java.lang.Object.class);
        }
        /**
         * ``AWS::ElasticBeanstalk::Environment.CNAMEPrefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-cnameprefix
         */
        public void setCnamePrefix(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("cnamePrefix", value);
        }
        /**
         * ``AWS::ElasticBeanstalk::Environment.CNAMEPrefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-cnameprefix
         */
        public void setCnamePrefix(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("cnamePrefix", value);
        }
        /**
         * ``AWS::ElasticBeanstalk::Environment.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-description
         */
        @javax.annotation.Nullable
        public java.lang.Object getDescription() {
            return this.jsiiGet("description", java.lang.Object.class);
        }
        /**
         * ``AWS::ElasticBeanstalk::Environment.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-description
         */
        public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("description", value);
        }
        /**
         * ``AWS::ElasticBeanstalk::Environment.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-description
         */
        public void setDescription(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("description", value);
        }
        /**
         * ``AWS::ElasticBeanstalk::Environment.EnvironmentName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-name
         */
        @javax.annotation.Nullable
        public java.lang.Object getEnvironmentName() {
            return this.jsiiGet("environmentName", java.lang.Object.class);
        }
        /**
         * ``AWS::ElasticBeanstalk::Environment.EnvironmentName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-name
         */
        public void setEnvironmentName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("environmentName", value);
        }
        /**
         * ``AWS::ElasticBeanstalk::Environment.EnvironmentName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-name
         */
        public void setEnvironmentName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("environmentName", value);
        }
        /**
         * ``AWS::ElasticBeanstalk::Environment.OptionSettings``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-optionsettings
         */
        @javax.annotation.Nullable
        public java.lang.Object getOptionSettings() {
            return this.jsiiGet("optionSettings", java.lang.Object.class);
        }
        /**
         * ``AWS::ElasticBeanstalk::Environment.OptionSettings``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-optionsettings
         */
        public void setOptionSettings(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("optionSettings", value);
        }
        /**
         * ``AWS::ElasticBeanstalk::Environment.OptionSettings``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-optionsettings
         */
        public void setOptionSettings(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
            this.jsiiSet("optionSettings", value);
        }
        /**
         * ``AWS::ElasticBeanstalk::Environment.PlatformArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-platformarn
         */
        @javax.annotation.Nullable
        public java.lang.Object getPlatformArn() {
            return this.jsiiGet("platformArn", java.lang.Object.class);
        }
        /**
         * ``AWS::ElasticBeanstalk::Environment.PlatformArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-platformarn
         */
        public void setPlatformArn(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("platformArn", value);
        }
        /**
         * ``AWS::ElasticBeanstalk::Environment.PlatformArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-platformarn
         */
        public void setPlatformArn(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("platformArn", value);
        }
        /**
         * ``AWS::ElasticBeanstalk::Environment.SolutionStackName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-solutionstackname
         */
        @javax.annotation.Nullable
        public java.lang.Object getSolutionStackName() {
            return this.jsiiGet("solutionStackName", java.lang.Object.class);
        }
        /**
         * ``AWS::ElasticBeanstalk::Environment.SolutionStackName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-solutionstackname
         */
        public void setSolutionStackName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("solutionStackName", value);
        }
        /**
         * ``AWS::ElasticBeanstalk::Environment.SolutionStackName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-solutionstackname
         */
        public void setSolutionStackName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("solutionStackName", value);
        }
        /**
         * ``AWS::ElasticBeanstalk::Environment.Tags``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-elasticbeanstalk-environment-tags
         */
        @javax.annotation.Nullable
        public java.lang.Object getTags() {
            return this.jsiiGet("tags", java.lang.Object.class);
        }
        /**
         * ``AWS::ElasticBeanstalk::Environment.Tags``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-elasticbeanstalk-environment-tags
         */
        public void setTags(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("tags", value);
        }
        /**
         * ``AWS::ElasticBeanstalk::Environment.Tags``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-elasticbeanstalk-environment-tags
         */
        public void setTags(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
            this.jsiiSet("tags", value);
        }
        /**
         * ``AWS::ElasticBeanstalk::Environment.TemplateName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-templatename
         */
        @javax.annotation.Nullable
        public java.lang.Object getTemplateName() {
            return this.jsiiGet("templateName", java.lang.Object.class);
        }
        /**
         * ``AWS::ElasticBeanstalk::Environment.TemplateName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-templatename
         */
        public void setTemplateName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("templateName", value);
        }
        /**
         * ``AWS::ElasticBeanstalk::Environment.TemplateName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-templatename
         */
        public void setTemplateName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("templateName", value);
        }
        /**
         * ``AWS::ElasticBeanstalk::Environment.Tier``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-tier
         */
        @javax.annotation.Nullable
        public java.lang.Object getTier() {
            return this.jsiiGet("tier", java.lang.Object.class);
        }
        /**
         * ``AWS::ElasticBeanstalk::Environment.Tier``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-tier
         */
        public void setTier(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("tier", value);
        }
        /**
         * ``AWS::ElasticBeanstalk::Environment.Tier``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-tier
         */
        public void setTier(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticbeanstalk.cloudformation.EnvironmentResource.TierProperty value) {
            this.jsiiSet("tier", value);
        }
        /**
         * ``AWS::ElasticBeanstalk::Environment.VersionLabel``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-versionlabel
         */
        @javax.annotation.Nullable
        public java.lang.Object getVersionLabel() {
            return this.jsiiGet("versionLabel", java.lang.Object.class);
        }
        /**
         * ``AWS::ElasticBeanstalk::Environment.VersionLabel``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-versionlabel
         */
        public void setVersionLabel(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("versionLabel", value);
        }
        /**
         * ``AWS::ElasticBeanstalk::Environment.VersionLabel``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-versionlabel
         */
        public void setVersionLabel(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("versionLabel", value);
        }
    }
}
