package software.amazon.awscdk.services.elasticbeanstalk.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk.html
 */
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticbeanstalk.$Module.class, fqn = "@aws-cdk/aws-elasticbeanstalk.cloudformation.ApplicationResource")
public class ApplicationResource extends software.amazon.awscdk.Resource {
    protected ApplicationResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ApplicationResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::ElasticBeanstalk::Application``.
     * @param parent the ``cdk.Construct`` this ``ApplicationResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``ApplicationResource``
     */
    public ApplicationResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, @javax.annotation.Nullable final software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ApplicationResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(properties)).toArray());
    }
    /**
     * Creates a new ``AWS::ElasticBeanstalk::Application``.
     * @param parent the ``cdk.Construct`` this ``ApplicationResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     */
    public ApplicationResource(final software.amazon.awscdk.Construct parent, final java.lang.String name) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))).toArray());
    }
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties() {
        return this.jsiiCall("renderProperties", java.util.Map.class);
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationresourcelifecycleconfig.html
     */
    public static interface ApplicationResourceLifecycleConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``ApplicationResource.ApplicationResourceLifecycleConfigProperty.ServiceRole``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationresourcelifecycleconfig.html#cfn-elasticbeanstalk-application-applicationresourcelifecycleconfig-servicerole
         */
        java.lang.Object getServiceRole();
        /**
         * ``ApplicationResource.ApplicationResourceLifecycleConfigProperty.ServiceRole``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationresourcelifecycleconfig.html#cfn-elasticbeanstalk-application-applicationresourcelifecycleconfig-servicerole
         */
        void setServiceRole(final java.lang.String value);
        /**
         * ``ApplicationResource.ApplicationResourceLifecycleConfigProperty.ServiceRole``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationresourcelifecycleconfig.html#cfn-elasticbeanstalk-application-applicationresourcelifecycleconfig-servicerole
         */
        void setServiceRole(final software.amazon.awscdk.Token value);
        /**
         * ``ApplicationResource.ApplicationResourceLifecycleConfigProperty.VersionLifecycleConfig``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationresourcelifecycleconfig.html#cfn-elasticbeanstalk-application-applicationresourcelifecycleconfig-versionlifecycleconfig
         */
        java.lang.Object getVersionLifecycleConfig();
        /**
         * ``ApplicationResource.ApplicationResourceLifecycleConfigProperty.VersionLifecycleConfig``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationresourcelifecycleconfig.html#cfn-elasticbeanstalk-application-applicationresourcelifecycleconfig-versionlifecycleconfig
         */
        void setVersionLifecycleConfig(final software.amazon.awscdk.Token value);
        /**
         * ``ApplicationResource.ApplicationResourceLifecycleConfigProperty.VersionLifecycleConfig``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationresourcelifecycleconfig.html#cfn-elasticbeanstalk-application-applicationresourcelifecycleconfig-versionlifecycleconfig
         */
        void setVersionLifecycleConfig(final software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ApplicationResource.ApplicationVersionLifecycleConfigProperty value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link ApplicationResourceLifecycleConfigProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``ApplicationResource.ApplicationResourceLifecycleConfigProperty.ServiceRole``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationresourcelifecycleconfig.html#cfn-elasticbeanstalk-application-applicationresourcelifecycleconfig-servicerole
             */
            public Builder withServiceRole(final java.lang.String value) {
                this.instance._serviceRole = value;
                return this;
            }
            /**
             * ``ApplicationResource.ApplicationResourceLifecycleConfigProperty.ServiceRole``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationresourcelifecycleconfig.html#cfn-elasticbeanstalk-application-applicationresourcelifecycleconfig-servicerole
             */
            public Builder withServiceRole(final software.amazon.awscdk.Token value) {
                this.instance._serviceRole = value;
                return this;
            }
            /**
             * ``ApplicationResource.ApplicationResourceLifecycleConfigProperty.VersionLifecycleConfig``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationresourcelifecycleconfig.html#cfn-elasticbeanstalk-application-applicationresourcelifecycleconfig-versionlifecycleconfig
             */
            public Builder withVersionLifecycleConfig(final software.amazon.awscdk.Token value) {
                this.instance._versionLifecycleConfig = value;
                return this;
            }
            /**
             * ``ApplicationResource.ApplicationResourceLifecycleConfigProperty.VersionLifecycleConfig``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationresourcelifecycleconfig.html#cfn-elasticbeanstalk-application-applicationresourcelifecycleconfig-versionlifecycleconfig
             */
            public Builder withVersionLifecycleConfig(final software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ApplicationResource.ApplicationVersionLifecycleConfigProperty value) {
                this.instance._versionLifecycleConfig = value;
                return this;
            }
            public ApplicationResourceLifecycleConfigProperty build() {
                ApplicationResourceLifecycleConfigProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link ApplicationResourceLifecycleConfigProperty}.
         */
        final class Jsii$Pojo implements ApplicationResourceLifecycleConfigProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _serviceRole;

            public java.lang.Object getServiceRole() {
                return this._serviceRole;
            }
            public void setServiceRole(final java.lang.String value) {
                this._serviceRole = value;
            }
            public void setServiceRole(final software.amazon.awscdk.Token value) {
                this._serviceRole = value;
            }

            protected java.lang.Object _versionLifecycleConfig;

            public java.lang.Object getVersionLifecycleConfig() {
                return this._versionLifecycleConfig;
            }
            public void setVersionLifecycleConfig(final software.amazon.awscdk.Token value) {
                this._versionLifecycleConfig = value;
            }
            public void setVersionLifecycleConfig(final software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ApplicationResource.ApplicationVersionLifecycleConfigProperty value) {
                this._versionLifecycleConfig = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ApplicationResource.ApplicationResourceLifecycleConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``ApplicationResource.ApplicationResourceLifecycleConfigProperty.ServiceRole``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationresourcelifecycleconfig.html#cfn-elasticbeanstalk-application-applicationresourcelifecycleconfig-servicerole
             */
            @javax.annotation.Nullable
            public java.lang.Object getServiceRole() {
                return this.jsiiGet("serviceRole", java.lang.Object.class);
            }
            /**
             * ``ApplicationResource.ApplicationResourceLifecycleConfigProperty.ServiceRole``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationresourcelifecycleconfig.html#cfn-elasticbeanstalk-application-applicationresourcelifecycleconfig-servicerole
             */
            public void setServiceRole(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("serviceRole", value);
            }
            /**
             * ``ApplicationResource.ApplicationResourceLifecycleConfigProperty.ServiceRole``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationresourcelifecycleconfig.html#cfn-elasticbeanstalk-application-applicationresourcelifecycleconfig-servicerole
             */
            public void setServiceRole(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("serviceRole", value);
            }
            /**
             * ``ApplicationResource.ApplicationResourceLifecycleConfigProperty.VersionLifecycleConfig``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationresourcelifecycleconfig.html#cfn-elasticbeanstalk-application-applicationresourcelifecycleconfig-versionlifecycleconfig
             */
            @javax.annotation.Nullable
            public java.lang.Object getVersionLifecycleConfig() {
                return this.jsiiGet("versionLifecycleConfig", java.lang.Object.class);
            }
            /**
             * ``ApplicationResource.ApplicationResourceLifecycleConfigProperty.VersionLifecycleConfig``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationresourcelifecycleconfig.html#cfn-elasticbeanstalk-application-applicationresourcelifecycleconfig-versionlifecycleconfig
             */
            public void setVersionLifecycleConfig(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("versionLifecycleConfig", value);
            }
            /**
             * ``ApplicationResource.ApplicationResourceLifecycleConfigProperty.VersionLifecycleConfig``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationresourcelifecycleconfig.html#cfn-elasticbeanstalk-application-applicationresourcelifecycleconfig-versionlifecycleconfig
             */
            public void setVersionLifecycleConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ApplicationResource.ApplicationVersionLifecycleConfigProperty value) {
                this.jsiiSet("versionLifecycleConfig", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html
     */
    public static interface ApplicationVersionLifecycleConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``ApplicationResource.ApplicationVersionLifecycleConfigProperty.MaxAgeRule``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html#cfn-elasticbeanstalk-application-applicationversionlifecycleconfig-maxagerule
         */
        java.lang.Object getMaxAgeRule();
        /**
         * ``ApplicationResource.ApplicationVersionLifecycleConfigProperty.MaxAgeRule``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html#cfn-elasticbeanstalk-application-applicationversionlifecycleconfig-maxagerule
         */
        void setMaxAgeRule(final software.amazon.awscdk.Token value);
        /**
         * ``ApplicationResource.ApplicationVersionLifecycleConfigProperty.MaxAgeRule``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html#cfn-elasticbeanstalk-application-applicationversionlifecycleconfig-maxagerule
         */
        void setMaxAgeRule(final software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ApplicationResource.MaxAgeRuleProperty value);
        /**
         * ``ApplicationResource.ApplicationVersionLifecycleConfigProperty.MaxCountRule``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html#cfn-elasticbeanstalk-application-applicationversionlifecycleconfig-maxcountrule
         */
        java.lang.Object getMaxCountRule();
        /**
         * ``ApplicationResource.ApplicationVersionLifecycleConfigProperty.MaxCountRule``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html#cfn-elasticbeanstalk-application-applicationversionlifecycleconfig-maxcountrule
         */
        void setMaxCountRule(final software.amazon.awscdk.Token value);
        /**
         * ``ApplicationResource.ApplicationVersionLifecycleConfigProperty.MaxCountRule``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html#cfn-elasticbeanstalk-application-applicationversionlifecycleconfig-maxcountrule
         */
        void setMaxCountRule(final software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ApplicationResource.MaxCountRuleProperty value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link ApplicationVersionLifecycleConfigProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``ApplicationResource.ApplicationVersionLifecycleConfigProperty.MaxAgeRule``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html#cfn-elasticbeanstalk-application-applicationversionlifecycleconfig-maxagerule
             */
            public Builder withMaxAgeRule(final software.amazon.awscdk.Token value) {
                this.instance._maxAgeRule = value;
                return this;
            }
            /**
             * ``ApplicationResource.ApplicationVersionLifecycleConfigProperty.MaxAgeRule``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html#cfn-elasticbeanstalk-application-applicationversionlifecycleconfig-maxagerule
             */
            public Builder withMaxAgeRule(final software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ApplicationResource.MaxAgeRuleProperty value) {
                this.instance._maxAgeRule = value;
                return this;
            }
            /**
             * ``ApplicationResource.ApplicationVersionLifecycleConfigProperty.MaxCountRule``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html#cfn-elasticbeanstalk-application-applicationversionlifecycleconfig-maxcountrule
             */
            public Builder withMaxCountRule(final software.amazon.awscdk.Token value) {
                this.instance._maxCountRule = value;
                return this;
            }
            /**
             * ``ApplicationResource.ApplicationVersionLifecycleConfigProperty.MaxCountRule``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html#cfn-elasticbeanstalk-application-applicationversionlifecycleconfig-maxcountrule
             */
            public Builder withMaxCountRule(final software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ApplicationResource.MaxCountRuleProperty value) {
                this.instance._maxCountRule = value;
                return this;
            }
            public ApplicationVersionLifecycleConfigProperty build() {
                ApplicationVersionLifecycleConfigProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link ApplicationVersionLifecycleConfigProperty}.
         */
        final class Jsii$Pojo implements ApplicationVersionLifecycleConfigProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _maxAgeRule;

            public java.lang.Object getMaxAgeRule() {
                return this._maxAgeRule;
            }
            public void setMaxAgeRule(final software.amazon.awscdk.Token value) {
                this._maxAgeRule = value;
            }
            public void setMaxAgeRule(final software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ApplicationResource.MaxAgeRuleProperty value) {
                this._maxAgeRule = value;
            }

            protected java.lang.Object _maxCountRule;

            public java.lang.Object getMaxCountRule() {
                return this._maxCountRule;
            }
            public void setMaxCountRule(final software.amazon.awscdk.Token value) {
                this._maxCountRule = value;
            }
            public void setMaxCountRule(final software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ApplicationResource.MaxCountRuleProperty value) {
                this._maxCountRule = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ApplicationResource.ApplicationVersionLifecycleConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``ApplicationResource.ApplicationVersionLifecycleConfigProperty.MaxAgeRule``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html#cfn-elasticbeanstalk-application-applicationversionlifecycleconfig-maxagerule
             */
            @javax.annotation.Nullable
            public java.lang.Object getMaxAgeRule() {
                return this.jsiiGet("maxAgeRule", java.lang.Object.class);
            }
            /**
             * ``ApplicationResource.ApplicationVersionLifecycleConfigProperty.MaxAgeRule``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html#cfn-elasticbeanstalk-application-applicationversionlifecycleconfig-maxagerule
             */
            public void setMaxAgeRule(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("maxAgeRule", value);
            }
            /**
             * ``ApplicationResource.ApplicationVersionLifecycleConfigProperty.MaxAgeRule``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html#cfn-elasticbeanstalk-application-applicationversionlifecycleconfig-maxagerule
             */
            public void setMaxAgeRule(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ApplicationResource.MaxAgeRuleProperty value) {
                this.jsiiSet("maxAgeRule", value);
            }
            /**
             * ``ApplicationResource.ApplicationVersionLifecycleConfigProperty.MaxCountRule``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html#cfn-elasticbeanstalk-application-applicationversionlifecycleconfig-maxcountrule
             */
            @javax.annotation.Nullable
            public java.lang.Object getMaxCountRule() {
                return this.jsiiGet("maxCountRule", java.lang.Object.class);
            }
            /**
             * ``ApplicationResource.ApplicationVersionLifecycleConfigProperty.MaxCountRule``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html#cfn-elasticbeanstalk-application-applicationversionlifecycleconfig-maxcountrule
             */
            public void setMaxCountRule(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("maxCountRule", value);
            }
            /**
             * ``ApplicationResource.ApplicationVersionLifecycleConfigProperty.MaxCountRule``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html#cfn-elasticbeanstalk-application-applicationversionlifecycleconfig-maxcountrule
             */
            public void setMaxCountRule(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ApplicationResource.MaxCountRuleProperty value) {
                this.jsiiSet("maxCountRule", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html
     */
    public static interface MaxAgeRuleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``ApplicationResource.MaxAgeRuleProperty.DeleteSourceFromS3``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-deletesourcefroms3
         */
        java.lang.Object getDeleteSourceFromS3();
        /**
         * ``ApplicationResource.MaxAgeRuleProperty.DeleteSourceFromS3``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-deletesourcefroms3
         */
        void setDeleteSourceFromS3(final java.lang.Boolean value);
        /**
         * ``ApplicationResource.MaxAgeRuleProperty.DeleteSourceFromS3``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-deletesourcefroms3
         */
        void setDeleteSourceFromS3(final software.amazon.awscdk.Token value);
        /**
         * ``ApplicationResource.MaxAgeRuleProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-enabled
         */
        java.lang.Object getEnabled();
        /**
         * ``ApplicationResource.MaxAgeRuleProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-enabled
         */
        void setEnabled(final java.lang.Boolean value);
        /**
         * ``ApplicationResource.MaxAgeRuleProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-enabled
         */
        void setEnabled(final software.amazon.awscdk.Token value);
        /**
         * ``ApplicationResource.MaxAgeRuleProperty.MaxAgeInDays``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-maxageindays
         */
        java.lang.Object getMaxAgeInDays();
        /**
         * ``ApplicationResource.MaxAgeRuleProperty.MaxAgeInDays``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-maxageindays
         */
        void setMaxAgeInDays(final java.lang.Number value);
        /**
         * ``ApplicationResource.MaxAgeRuleProperty.MaxAgeInDays``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-maxageindays
         */
        void setMaxAgeInDays(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link MaxAgeRuleProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``ApplicationResource.MaxAgeRuleProperty.DeleteSourceFromS3``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-deletesourcefroms3
             */
            public Builder withDeleteSourceFromS3(final java.lang.Boolean value) {
                this.instance._deleteSourceFromS3 = value;
                return this;
            }
            /**
             * ``ApplicationResource.MaxAgeRuleProperty.DeleteSourceFromS3``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-deletesourcefroms3
             */
            public Builder withDeleteSourceFromS3(final software.amazon.awscdk.Token value) {
                this.instance._deleteSourceFromS3 = value;
                return this;
            }
            /**
             * ``ApplicationResource.MaxAgeRuleProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-enabled
             */
            public Builder withEnabled(final java.lang.Boolean value) {
                this.instance._enabled = value;
                return this;
            }
            /**
             * ``ApplicationResource.MaxAgeRuleProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-enabled
             */
            public Builder withEnabled(final software.amazon.awscdk.Token value) {
                this.instance._enabled = value;
                return this;
            }
            /**
             * ``ApplicationResource.MaxAgeRuleProperty.MaxAgeInDays``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-maxageindays
             */
            public Builder withMaxAgeInDays(final java.lang.Number value) {
                this.instance._maxAgeInDays = value;
                return this;
            }
            /**
             * ``ApplicationResource.MaxAgeRuleProperty.MaxAgeInDays``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-maxageindays
             */
            public Builder withMaxAgeInDays(final software.amazon.awscdk.Token value) {
                this.instance._maxAgeInDays = value;
                return this;
            }
            public MaxAgeRuleProperty build() {
                MaxAgeRuleProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link MaxAgeRuleProperty}.
         */
        final class Jsii$Pojo implements MaxAgeRuleProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _deleteSourceFromS3;

            public java.lang.Object getDeleteSourceFromS3() {
                return this._deleteSourceFromS3;
            }
            public void setDeleteSourceFromS3(final java.lang.Boolean value) {
                this._deleteSourceFromS3 = value;
            }
            public void setDeleteSourceFromS3(final software.amazon.awscdk.Token value) {
                this._deleteSourceFromS3 = value;
            }

            protected java.lang.Object _enabled;

            public java.lang.Object getEnabled() {
                return this._enabled;
            }
            public void setEnabled(final java.lang.Boolean value) {
                this._enabled = value;
            }
            public void setEnabled(final software.amazon.awscdk.Token value) {
                this._enabled = value;
            }

            protected java.lang.Object _maxAgeInDays;

            public java.lang.Object getMaxAgeInDays() {
                return this._maxAgeInDays;
            }
            public void setMaxAgeInDays(final java.lang.Number value) {
                this._maxAgeInDays = value;
            }
            public void setMaxAgeInDays(final software.amazon.awscdk.Token value) {
                this._maxAgeInDays = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ApplicationResource.MaxAgeRuleProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``ApplicationResource.MaxAgeRuleProperty.DeleteSourceFromS3``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-deletesourcefroms3
             */
            @javax.annotation.Nullable
            public java.lang.Object getDeleteSourceFromS3() {
                return this.jsiiGet("deleteSourceFromS3", java.lang.Object.class);
            }
            /**
             * ``ApplicationResource.MaxAgeRuleProperty.DeleteSourceFromS3``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-deletesourcefroms3
             */
            public void setDeleteSourceFromS3(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("deleteSourceFromS3", value);
            }
            /**
             * ``ApplicationResource.MaxAgeRuleProperty.DeleteSourceFromS3``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-deletesourcefroms3
             */
            public void setDeleteSourceFromS3(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("deleteSourceFromS3", value);
            }
            /**
             * ``ApplicationResource.MaxAgeRuleProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-enabled
             */
            @javax.annotation.Nullable
            public java.lang.Object getEnabled() {
                return this.jsiiGet("enabled", java.lang.Object.class);
            }
            /**
             * ``ApplicationResource.MaxAgeRuleProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-enabled
             */
            public void setEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("enabled", value);
            }
            /**
             * ``ApplicationResource.MaxAgeRuleProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-enabled
             */
            public void setEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("enabled", value);
            }
            /**
             * ``ApplicationResource.MaxAgeRuleProperty.MaxAgeInDays``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-maxageindays
             */
            @javax.annotation.Nullable
            public java.lang.Object getMaxAgeInDays() {
                return this.jsiiGet("maxAgeInDays", java.lang.Object.class);
            }
            /**
             * ``ApplicationResource.MaxAgeRuleProperty.MaxAgeInDays``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-maxageindays
             */
            public void setMaxAgeInDays(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("maxAgeInDays", value);
            }
            /**
             * ``ApplicationResource.MaxAgeRuleProperty.MaxAgeInDays``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-maxageindays
             */
            public void setMaxAgeInDays(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("maxAgeInDays", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html
     */
    public static interface MaxCountRuleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``ApplicationResource.MaxCountRuleProperty.DeleteSourceFromS3``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-deletesourcefroms3
         */
        java.lang.Object getDeleteSourceFromS3();
        /**
         * ``ApplicationResource.MaxCountRuleProperty.DeleteSourceFromS3``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-deletesourcefroms3
         */
        void setDeleteSourceFromS3(final java.lang.Boolean value);
        /**
         * ``ApplicationResource.MaxCountRuleProperty.DeleteSourceFromS3``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-deletesourcefroms3
         */
        void setDeleteSourceFromS3(final software.amazon.awscdk.Token value);
        /**
         * ``ApplicationResource.MaxCountRuleProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-enabled
         */
        java.lang.Object getEnabled();
        /**
         * ``ApplicationResource.MaxCountRuleProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-enabled
         */
        void setEnabled(final java.lang.Boolean value);
        /**
         * ``ApplicationResource.MaxCountRuleProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-enabled
         */
        void setEnabled(final software.amazon.awscdk.Token value);
        /**
         * ``ApplicationResource.MaxCountRuleProperty.MaxCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-maxcount
         */
        java.lang.Object getMaxCount();
        /**
         * ``ApplicationResource.MaxCountRuleProperty.MaxCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-maxcount
         */
        void setMaxCount(final java.lang.Number value);
        /**
         * ``ApplicationResource.MaxCountRuleProperty.MaxCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-maxcount
         */
        void setMaxCount(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link MaxCountRuleProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``ApplicationResource.MaxCountRuleProperty.DeleteSourceFromS3``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-deletesourcefroms3
             */
            public Builder withDeleteSourceFromS3(final java.lang.Boolean value) {
                this.instance._deleteSourceFromS3 = value;
                return this;
            }
            /**
             * ``ApplicationResource.MaxCountRuleProperty.DeleteSourceFromS3``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-deletesourcefroms3
             */
            public Builder withDeleteSourceFromS3(final software.amazon.awscdk.Token value) {
                this.instance._deleteSourceFromS3 = value;
                return this;
            }
            /**
             * ``ApplicationResource.MaxCountRuleProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-enabled
             */
            public Builder withEnabled(final java.lang.Boolean value) {
                this.instance._enabled = value;
                return this;
            }
            /**
             * ``ApplicationResource.MaxCountRuleProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-enabled
             */
            public Builder withEnabled(final software.amazon.awscdk.Token value) {
                this.instance._enabled = value;
                return this;
            }
            /**
             * ``ApplicationResource.MaxCountRuleProperty.MaxCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-maxcount
             */
            public Builder withMaxCount(final java.lang.Number value) {
                this.instance._maxCount = value;
                return this;
            }
            /**
             * ``ApplicationResource.MaxCountRuleProperty.MaxCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-maxcount
             */
            public Builder withMaxCount(final software.amazon.awscdk.Token value) {
                this.instance._maxCount = value;
                return this;
            }
            public MaxCountRuleProperty build() {
                MaxCountRuleProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link MaxCountRuleProperty}.
         */
        final class Jsii$Pojo implements MaxCountRuleProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _deleteSourceFromS3;

            public java.lang.Object getDeleteSourceFromS3() {
                return this._deleteSourceFromS3;
            }
            public void setDeleteSourceFromS3(final java.lang.Boolean value) {
                this._deleteSourceFromS3 = value;
            }
            public void setDeleteSourceFromS3(final software.amazon.awscdk.Token value) {
                this._deleteSourceFromS3 = value;
            }

            protected java.lang.Object _enabled;

            public java.lang.Object getEnabled() {
                return this._enabled;
            }
            public void setEnabled(final java.lang.Boolean value) {
                this._enabled = value;
            }
            public void setEnabled(final software.amazon.awscdk.Token value) {
                this._enabled = value;
            }

            protected java.lang.Object _maxCount;

            public java.lang.Object getMaxCount() {
                return this._maxCount;
            }
            public void setMaxCount(final java.lang.Number value) {
                this._maxCount = value;
            }
            public void setMaxCount(final software.amazon.awscdk.Token value) {
                this._maxCount = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ApplicationResource.MaxCountRuleProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``ApplicationResource.MaxCountRuleProperty.DeleteSourceFromS3``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-deletesourcefroms3
             */
            @javax.annotation.Nullable
            public java.lang.Object getDeleteSourceFromS3() {
                return this.jsiiGet("deleteSourceFromS3", java.lang.Object.class);
            }
            /**
             * ``ApplicationResource.MaxCountRuleProperty.DeleteSourceFromS3``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-deletesourcefroms3
             */
            public void setDeleteSourceFromS3(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("deleteSourceFromS3", value);
            }
            /**
             * ``ApplicationResource.MaxCountRuleProperty.DeleteSourceFromS3``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-deletesourcefroms3
             */
            public void setDeleteSourceFromS3(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("deleteSourceFromS3", value);
            }
            /**
             * ``ApplicationResource.MaxCountRuleProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-enabled
             */
            @javax.annotation.Nullable
            public java.lang.Object getEnabled() {
                return this.jsiiGet("enabled", java.lang.Object.class);
            }
            /**
             * ``ApplicationResource.MaxCountRuleProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-enabled
             */
            public void setEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("enabled", value);
            }
            /**
             * ``ApplicationResource.MaxCountRuleProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-enabled
             */
            public void setEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("enabled", value);
            }
            /**
             * ``ApplicationResource.MaxCountRuleProperty.MaxCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-maxcount
             */
            @javax.annotation.Nullable
            public java.lang.Object getMaxCount() {
                return this.jsiiGet("maxCount", java.lang.Object.class);
            }
            /**
             * ``ApplicationResource.MaxCountRuleProperty.MaxCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-maxcount
             */
            public void setMaxCount(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("maxCount", value);
            }
            /**
             * ``ApplicationResource.MaxCountRuleProperty.MaxCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-maxcount
             */
            public void setMaxCount(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("maxCount", value);
            }
        }
    }
}
