package software.amazon.awscdk.services.elasticbeanstalk.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html
 */
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticbeanstalk.$Module.class, fqn = "@aws-cdk/aws-elasticbeanstalk.cloudformation.ApplicationVersionResource")
public class ApplicationVersionResource extends software.amazon.awscdk.Resource {
    protected ApplicationVersionResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ApplicationVersionResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::ElasticBeanstalk::ApplicationVersion``.
     * @param parent the ``cdk.Construct`` this ``ApplicationVersionResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``ApplicationVersionResource``
     */
    public ApplicationVersionResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, final software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ApplicationVersionResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required"))).toArray());
    }
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties() {
        return this.jsiiCall("renderProperties", java.util.Map.class);
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-sourcebundle.html
     */
    public static interface SourceBundleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``ApplicationVersionResource.SourceBundleProperty.S3Bucket``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-sourcebundle.html#cfn-beanstalk-sourcebundle-s3bucket
         */
        java.lang.Object getS3Bucket();
        /**
         * ``ApplicationVersionResource.SourceBundleProperty.S3Bucket``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-sourcebundle.html#cfn-beanstalk-sourcebundle-s3bucket
         */
        void setS3Bucket(final java.lang.String value);
        /**
         * ``ApplicationVersionResource.SourceBundleProperty.S3Bucket``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-sourcebundle.html#cfn-beanstalk-sourcebundle-s3bucket
         */
        void setS3Bucket(final software.amazon.awscdk.Token value);
        /**
         * ``ApplicationVersionResource.SourceBundleProperty.S3Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-sourcebundle.html#cfn-beanstalk-sourcebundle-s3key
         */
        java.lang.Object getS3Key();
        /**
         * ``ApplicationVersionResource.SourceBundleProperty.S3Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-sourcebundle.html#cfn-beanstalk-sourcebundle-s3key
         */
        void setS3Key(final java.lang.String value);
        /**
         * ``ApplicationVersionResource.SourceBundleProperty.S3Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-sourcebundle.html#cfn-beanstalk-sourcebundle-s3key
         */
        void setS3Key(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link SourceBundleProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``ApplicationVersionResource.SourceBundleProperty.S3Bucket``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-sourcebundle.html#cfn-beanstalk-sourcebundle-s3bucket
             */
            public S3KeyStep withS3Bucket(final java.lang.String value) {
                return new FullBuilder().withS3Bucket(value);
            }
            /**
             * ``ApplicationVersionResource.SourceBundleProperty.S3Bucket``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-sourcebundle.html#cfn-beanstalk-sourcebundle-s3bucket
             */
            public S3KeyStep withS3Bucket(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withS3Bucket(value);
            }

            public interface S3KeyStep {
                /**
                 * ``ApplicationVersionResource.SourceBundleProperty.S3Key``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-sourcebundle.html#cfn-beanstalk-sourcebundle-s3key
                 */
                Build withS3Key(final java.lang.String value);
                /**
                 * ``ApplicationVersionResource.SourceBundleProperty.S3Key``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-sourcebundle.html#cfn-beanstalk-sourcebundle-s3key
                 */
                Build withS3Key(final software.amazon.awscdk.Token value);
            }

            public interface Build {
                /**
                 * @return a new {@link SourceBundleProperty} object, initialized with the values set on this builder.
                 */
                SourceBundleProperty build();
            }

            final class FullBuilder implements S3KeyStep, Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``ApplicationVersionResource.SourceBundleProperty.S3Bucket``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-sourcebundle.html#cfn-beanstalk-sourcebundle-s3bucket
                 */
                public S3KeyStep withS3Bucket(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "SourceBundleProperty#s3Bucket is required");
                    this.instance._s3Bucket = value;
                    return this;
                }
                /**
                 * ``ApplicationVersionResource.SourceBundleProperty.S3Bucket``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-sourcebundle.html#cfn-beanstalk-sourcebundle-s3bucket
                 */
                public S3KeyStep withS3Bucket(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "SourceBundleProperty#s3Bucket is required");
                    this.instance._s3Bucket = value;
                    return this;
                }
                /**
                 * ``ApplicationVersionResource.SourceBundleProperty.S3Key``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-sourcebundle.html#cfn-beanstalk-sourcebundle-s3key
                 */
                public Build withS3Key(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "SourceBundleProperty#s3Key is required");
                    this.instance._s3Key = value;
                    return this;
                }
                /**
                 * ``ApplicationVersionResource.SourceBundleProperty.S3Key``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-sourcebundle.html#cfn-beanstalk-sourcebundle-s3key
                 */
                public Build withS3Key(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "SourceBundleProperty#s3Key is required");
                    this.instance._s3Key = value;
                    return this;
                }
                public SourceBundleProperty build() {
                    SourceBundleProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link SourceBundleProperty}.
         */
        final class Jsii$Pojo implements SourceBundleProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _s3Bucket;

            public java.lang.Object getS3Bucket() {
                return this._s3Bucket;
            }
            public void setS3Bucket(final java.lang.String value) {
                this._s3Bucket = value;
            }
            public void setS3Bucket(final software.amazon.awscdk.Token value) {
                this._s3Bucket = value;
            }

            protected java.lang.Object _s3Key;

            public java.lang.Object getS3Key() {
                return this._s3Key;
            }
            public void setS3Key(final java.lang.String value) {
                this._s3Key = value;
            }
            public void setS3Key(final software.amazon.awscdk.Token value) {
                this._s3Key = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ApplicationVersionResource.SourceBundleProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``ApplicationVersionResource.SourceBundleProperty.S3Bucket``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-sourcebundle.html#cfn-beanstalk-sourcebundle-s3bucket
             */
            public java.lang.Object getS3Bucket() {
                return this.jsiiGet("s3Bucket", java.lang.Object.class);
            }
            /**
             * ``ApplicationVersionResource.SourceBundleProperty.S3Bucket``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-sourcebundle.html#cfn-beanstalk-sourcebundle-s3bucket
             */
            public void setS3Bucket(final java.lang.String value) {
                this.jsiiSet("s3Bucket", java.util.Objects.requireNonNull(value, "s3Bucket is required"));
            }
            /**
             * ``ApplicationVersionResource.SourceBundleProperty.S3Bucket``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-sourcebundle.html#cfn-beanstalk-sourcebundle-s3bucket
             */
            public void setS3Bucket(final software.amazon.awscdk.Token value) {
                this.jsiiSet("s3Bucket", java.util.Objects.requireNonNull(value, "s3Bucket is required"));
            }
            /**
             * ``ApplicationVersionResource.SourceBundleProperty.S3Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-sourcebundle.html#cfn-beanstalk-sourcebundle-s3key
             */
            public java.lang.Object getS3Key() {
                return this.jsiiGet("s3Key", java.lang.Object.class);
            }
            /**
             * ``ApplicationVersionResource.SourceBundleProperty.S3Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-sourcebundle.html#cfn-beanstalk-sourcebundle-s3key
             */
            public void setS3Key(final java.lang.String value) {
                this.jsiiSet("s3Key", java.util.Objects.requireNonNull(value, "s3Key is required"));
            }
            /**
             * ``ApplicationVersionResource.SourceBundleProperty.S3Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-sourcebundle.html#cfn-beanstalk-sourcebundle-s3key
             */
            public void setS3Key(final software.amazon.awscdk.Token value) {
                this.jsiiSet("s3Key", java.util.Objects.requireNonNull(value, "s3Key is required"));
            }
        }
    }
}
