package software.amazon.awscdk.services.elasticbeanstalk.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html
 */
public interface ApplicationVersionResourceProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * ``AWS::ElasticBeanstalk::ApplicationVersion.ApplicationName``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-applicationname
     */
    java.lang.Object getApplicationName();
    /**
     * ``AWS::ElasticBeanstalk::ApplicationVersion.ApplicationName``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-applicationname
     */
    void setApplicationName(final java.lang.String value);
    /**
     * ``AWS::ElasticBeanstalk::ApplicationVersion.ApplicationName``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-applicationname
     */
    void setApplicationName(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::ElasticBeanstalk::ApplicationVersion.SourceBundle``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-sourcebundle
     */
    java.lang.Object getSourceBundle();
    /**
     * ``AWS::ElasticBeanstalk::ApplicationVersion.SourceBundle``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-sourcebundle
     */
    void setSourceBundle(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::ElasticBeanstalk::ApplicationVersion.SourceBundle``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-sourcebundle
     */
    void setSourceBundle(final software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ApplicationVersionResource.SourceBundleProperty value);
    /**
     * ``AWS::ElasticBeanstalk::ApplicationVersion.Description``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-description
     */
    java.lang.Object getDescription();
    /**
     * ``AWS::ElasticBeanstalk::ApplicationVersion.Description``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-description
     */
    void setDescription(final java.lang.String value);
    /**
     * ``AWS::ElasticBeanstalk::ApplicationVersion.Description``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-description
     */
    void setDescription(final software.amazon.awscdk.Token value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }
    /**
     * A fluent step builder class for {@link ApplicationVersionResourceProps}.
     * The {@link Build#build()} method will be available once all required properties are fulfilled.
     */
    final class Builder {
        /**
         * ``AWS::ElasticBeanstalk::ApplicationVersion.ApplicationName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-applicationname
         */
        public SourceBundleStep withApplicationName(final java.lang.String value) {
            return new FullBuilder().withApplicationName(value);
        }
        /**
         * ``AWS::ElasticBeanstalk::ApplicationVersion.ApplicationName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-applicationname
         */
        public SourceBundleStep withApplicationName(final software.amazon.awscdk.Token value) {
            return new FullBuilder().withApplicationName(value);
        }

        public interface SourceBundleStep {
            /**
             * ``AWS::ElasticBeanstalk::ApplicationVersion.SourceBundle``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-sourcebundle
             */
            Build withSourceBundle(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::ElasticBeanstalk::ApplicationVersion.SourceBundle``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-sourcebundle
             */
            Build withSourceBundle(final software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ApplicationVersionResource.SourceBundleProperty value);
        }

        public interface Build {
            /**
             * @return a new {@link ApplicationVersionResourceProps} object, initialized with the values set on this builder.
             */
            ApplicationVersionResourceProps build();
            /**
             * ``AWS::ElasticBeanstalk::ApplicationVersion.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-description
             */
            Build withDescription(final java.lang.String value);
            /**
             * ``AWS::ElasticBeanstalk::ApplicationVersion.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-description
             */
            Build withDescription(final software.amazon.awscdk.Token value);
        }

        final class FullBuilder implements SourceBundleStep, Build {

            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``AWS::ElasticBeanstalk::ApplicationVersion.ApplicationName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-applicationname
             */
            public SourceBundleStep withApplicationName(final java.lang.String value) {
                java.util.Objects.requireNonNull(value, "ApplicationVersionResourceProps#applicationName is required");
                this.instance._applicationName = value;
                return this;
            }
            /**
             * ``AWS::ElasticBeanstalk::ApplicationVersion.ApplicationName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-applicationname
             */
            public SourceBundleStep withApplicationName(final software.amazon.awscdk.Token value) {
                java.util.Objects.requireNonNull(value, "ApplicationVersionResourceProps#applicationName is required");
                this.instance._applicationName = value;
                return this;
            }
            /**
             * ``AWS::ElasticBeanstalk::ApplicationVersion.SourceBundle``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-sourcebundle
             */
            public Build withSourceBundle(final software.amazon.awscdk.Token value) {
                java.util.Objects.requireNonNull(value, "ApplicationVersionResourceProps#sourceBundle is required");
                this.instance._sourceBundle = value;
                return this;
            }
            /**
             * ``AWS::ElasticBeanstalk::ApplicationVersion.SourceBundle``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-sourcebundle
             */
            public Build withSourceBundle(final software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ApplicationVersionResource.SourceBundleProperty value) {
                java.util.Objects.requireNonNull(value, "ApplicationVersionResourceProps#sourceBundle is required");
                this.instance._sourceBundle = value;
                return this;
            }
            /**
             * ``AWS::ElasticBeanstalk::ApplicationVersion.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-description
             */
            public Build withDescription(final java.lang.String value) {
                this.instance._description = value;
                return this;
            }
            /**
             * ``AWS::ElasticBeanstalk::ApplicationVersion.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-description
             */
            public Build withDescription(final software.amazon.awscdk.Token value) {
                this.instance._description = value;
                return this;
            }
            public ApplicationVersionResourceProps build() {
                ApplicationVersionResourceProps result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link ApplicationVersionResourceProps}.
     */
    final class Jsii$Pojo implements ApplicationVersionResourceProps {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected java.lang.Object _applicationName;

        public java.lang.Object getApplicationName() {
            return this._applicationName;
        }
        public void setApplicationName(final java.lang.String value) {
            this._applicationName = value;
        }
        public void setApplicationName(final software.amazon.awscdk.Token value) {
            this._applicationName = value;
        }

        protected java.lang.Object _sourceBundle;

        public java.lang.Object getSourceBundle() {
            return this._sourceBundle;
        }
        public void setSourceBundle(final software.amazon.awscdk.Token value) {
            this._sourceBundle = value;
        }
        public void setSourceBundle(final software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ApplicationVersionResource.SourceBundleProperty value) {
            this._sourceBundle = value;
        }

        protected java.lang.Object _description;

        public java.lang.Object getDescription() {
            return this._description;
        }
        public void setDescription(final java.lang.String value) {
            this._description = value;
        }
        public void setDescription(final software.amazon.awscdk.Token value) {
            this._description = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ApplicationVersionResourceProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * ``AWS::ElasticBeanstalk::ApplicationVersion.ApplicationName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-applicationname
         */
        public java.lang.Object getApplicationName() {
            return this.jsiiGet("applicationName", java.lang.Object.class);
        }
        /**
         * ``AWS::ElasticBeanstalk::ApplicationVersion.ApplicationName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-applicationname
         */
        public void setApplicationName(final java.lang.String value) {
            this.jsiiSet("applicationName", java.util.Objects.requireNonNull(value, "applicationName is required"));
        }
        /**
         * ``AWS::ElasticBeanstalk::ApplicationVersion.ApplicationName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-applicationname
         */
        public void setApplicationName(final software.amazon.awscdk.Token value) {
            this.jsiiSet("applicationName", java.util.Objects.requireNonNull(value, "applicationName is required"));
        }
        /**
         * ``AWS::ElasticBeanstalk::ApplicationVersion.SourceBundle``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-sourcebundle
         */
        public java.lang.Object getSourceBundle() {
            return this.jsiiGet("sourceBundle", java.lang.Object.class);
        }
        /**
         * ``AWS::ElasticBeanstalk::ApplicationVersion.SourceBundle``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-sourcebundle
         */
        public void setSourceBundle(final software.amazon.awscdk.Token value) {
            this.jsiiSet("sourceBundle", java.util.Objects.requireNonNull(value, "sourceBundle is required"));
        }
        /**
         * ``AWS::ElasticBeanstalk::ApplicationVersion.SourceBundle``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-sourcebundle
         */
        public void setSourceBundle(final software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ApplicationVersionResource.SourceBundleProperty value) {
            this.jsiiSet("sourceBundle", java.util.Objects.requireNonNull(value, "sourceBundle is required"));
        }
        /**
         * ``AWS::ElasticBeanstalk::ApplicationVersion.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-description
         */
        @javax.annotation.Nullable
        public java.lang.Object getDescription() {
            return this.jsiiGet("description", java.lang.Object.class);
        }
        /**
         * ``AWS::ElasticBeanstalk::ApplicationVersion.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-description
         */
        public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("description", value);
        }
        /**
         * ``AWS::ElasticBeanstalk::ApplicationVersion.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-description
         */
        public void setDescription(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("description", value);
        }
    }
}
