package software.amazon.awscdk.services.elasticbeanstalk.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html
 */
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticbeanstalk.$Module.class, fqn = "@aws-cdk/aws-elasticbeanstalk.cloudformation.EnvironmentResource")
public class EnvironmentResource extends software.amazon.awscdk.Resource {
    protected EnvironmentResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticbeanstalk.cloudformation.EnvironmentResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::ElasticBeanstalk::Environment``.
     * @param parent the ``cdk.Construct`` this ``EnvironmentResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``EnvironmentResource``
     */
    public EnvironmentResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, final software.amazon.awscdk.services.elasticbeanstalk.cloudformation.EnvironmentResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required"))).toArray());
    }
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties() {
        return this.jsiiCall("renderProperties", java.util.Map.class);
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;
    /**
     * @cloudformation_attribute EndpointURL
     */
    public software.amazon.awscdk.services.elasticbeanstalk.EnvironmentEndpointUrl getEnvironmentEndpointUrl() {
        return this.jsiiGet("environmentEndpointUrl", software.amazon.awscdk.services.elasticbeanstalk.EnvironmentEndpointUrl.class);
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html
     */
    public static interface OptionSettingProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``EnvironmentResource.OptionSettingProperty.Namespace``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-namespace
         */
        java.lang.Object getNamespace();
        /**
         * ``EnvironmentResource.OptionSettingProperty.Namespace``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-namespace
         */
        void setNamespace(final java.lang.String value);
        /**
         * ``EnvironmentResource.OptionSettingProperty.Namespace``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-namespace
         */
        void setNamespace(final software.amazon.awscdk.Token value);
        /**
         * ``EnvironmentResource.OptionSettingProperty.OptionName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-optionname
         */
        java.lang.Object getOptionName();
        /**
         * ``EnvironmentResource.OptionSettingProperty.OptionName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-optionname
         */
        void setOptionName(final java.lang.String value);
        /**
         * ``EnvironmentResource.OptionSettingProperty.OptionName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-optionname
         */
        void setOptionName(final software.amazon.awscdk.Token value);
        /**
         * ``EnvironmentResource.OptionSettingProperty.ResourceName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-elasticbeanstalk-environment-optionsetting-resourcename
         */
        java.lang.Object getResourceName();
        /**
         * ``EnvironmentResource.OptionSettingProperty.ResourceName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-elasticbeanstalk-environment-optionsetting-resourcename
         */
        void setResourceName(final java.lang.String value);
        /**
         * ``EnvironmentResource.OptionSettingProperty.ResourceName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-elasticbeanstalk-environment-optionsetting-resourcename
         */
        void setResourceName(final software.amazon.awscdk.Token value);
        /**
         * ``EnvironmentResource.OptionSettingProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-value
         */
        java.lang.Object getValue();
        /**
         * ``EnvironmentResource.OptionSettingProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-value
         */
        void setValue(final java.lang.String value);
        /**
         * ``EnvironmentResource.OptionSettingProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-value
         */
        void setValue(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link OptionSettingProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``EnvironmentResource.OptionSettingProperty.Namespace``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-namespace
             */
            public OptionNameStep withNamespace(final java.lang.String value) {
                return new FullBuilder().withNamespace(value);
            }
            /**
             * ``EnvironmentResource.OptionSettingProperty.Namespace``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-namespace
             */
            public OptionNameStep withNamespace(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withNamespace(value);
            }

            public interface OptionNameStep {
                /**
                 * ``EnvironmentResource.OptionSettingProperty.OptionName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-optionname
                 */
                Build withOptionName(final java.lang.String value);
                /**
                 * ``EnvironmentResource.OptionSettingProperty.OptionName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-optionname
                 */
                Build withOptionName(final software.amazon.awscdk.Token value);
            }

            public interface Build {
                /**
                 * @return a new {@link OptionSettingProperty} object, initialized with the values set on this builder.
                 */
                OptionSettingProperty build();
                /**
                 * ``EnvironmentResource.OptionSettingProperty.ResourceName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-elasticbeanstalk-environment-optionsetting-resourcename
                 */
                Build withResourceName(final java.lang.String value);
                /**
                 * ``EnvironmentResource.OptionSettingProperty.ResourceName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-elasticbeanstalk-environment-optionsetting-resourcename
                 */
                Build withResourceName(final software.amazon.awscdk.Token value);
                /**
                 * ``EnvironmentResource.OptionSettingProperty.Value``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-value
                 */
                Build withValue(final java.lang.String value);
                /**
                 * ``EnvironmentResource.OptionSettingProperty.Value``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-value
                 */
                Build withValue(final software.amazon.awscdk.Token value);
            }

            final class FullBuilder implements OptionNameStep, Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``EnvironmentResource.OptionSettingProperty.Namespace``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-namespace
                 */
                public OptionNameStep withNamespace(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "OptionSettingProperty#namespace is required");
                    this.instance._namespace = value;
                    return this;
                }
                /**
                 * ``EnvironmentResource.OptionSettingProperty.Namespace``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-namespace
                 */
                public OptionNameStep withNamespace(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "OptionSettingProperty#namespace is required");
                    this.instance._namespace = value;
                    return this;
                }
                /**
                 * ``EnvironmentResource.OptionSettingProperty.OptionName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-optionname
                 */
                public Build withOptionName(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "OptionSettingProperty#optionName is required");
                    this.instance._optionName = value;
                    return this;
                }
                /**
                 * ``EnvironmentResource.OptionSettingProperty.OptionName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-optionname
                 */
                public Build withOptionName(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "OptionSettingProperty#optionName is required");
                    this.instance._optionName = value;
                    return this;
                }
                /**
                 * ``EnvironmentResource.OptionSettingProperty.ResourceName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-elasticbeanstalk-environment-optionsetting-resourcename
                 */
                public Build withResourceName(final java.lang.String value) {
                    this.instance._resourceName = value;
                    return this;
                }
                /**
                 * ``EnvironmentResource.OptionSettingProperty.ResourceName``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-elasticbeanstalk-environment-optionsetting-resourcename
                 */
                public Build withResourceName(final software.amazon.awscdk.Token value) {
                    this.instance._resourceName = value;
                    return this;
                }
                /**
                 * ``EnvironmentResource.OptionSettingProperty.Value``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-value
                 */
                public Build withValue(final java.lang.String value) {
                    this.instance._value = value;
                    return this;
                }
                /**
                 * ``EnvironmentResource.OptionSettingProperty.Value``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-value
                 */
                public Build withValue(final software.amazon.awscdk.Token value) {
                    this.instance._value = value;
                    return this;
                }
                public OptionSettingProperty build() {
                    OptionSettingProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link OptionSettingProperty}.
         */
        final class Jsii$Pojo implements OptionSettingProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _namespace;

            public java.lang.Object getNamespace() {
                return this._namespace;
            }
            public void setNamespace(final java.lang.String value) {
                this._namespace = value;
            }
            public void setNamespace(final software.amazon.awscdk.Token value) {
                this._namespace = value;
            }

            protected java.lang.Object _optionName;

            public java.lang.Object getOptionName() {
                return this._optionName;
            }
            public void setOptionName(final java.lang.String value) {
                this._optionName = value;
            }
            public void setOptionName(final software.amazon.awscdk.Token value) {
                this._optionName = value;
            }

            protected java.lang.Object _resourceName;

            public java.lang.Object getResourceName() {
                return this._resourceName;
            }
            public void setResourceName(final java.lang.String value) {
                this._resourceName = value;
            }
            public void setResourceName(final software.amazon.awscdk.Token value) {
                this._resourceName = value;
            }

            protected java.lang.Object _value;

            public java.lang.Object getValue() {
                return this._value;
            }
            public void setValue(final java.lang.String value) {
                this._value = value;
            }
            public void setValue(final software.amazon.awscdk.Token value) {
                this._value = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticbeanstalk.cloudformation.EnvironmentResource.OptionSettingProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``EnvironmentResource.OptionSettingProperty.Namespace``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-namespace
             */
            public java.lang.Object getNamespace() {
                return this.jsiiGet("namespace", java.lang.Object.class);
            }
            /**
             * ``EnvironmentResource.OptionSettingProperty.Namespace``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-namespace
             */
            public void setNamespace(final java.lang.String value) {
                this.jsiiSet("namespace", java.util.Objects.requireNonNull(value, "namespace is required"));
            }
            /**
             * ``EnvironmentResource.OptionSettingProperty.Namespace``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-namespace
             */
            public void setNamespace(final software.amazon.awscdk.Token value) {
                this.jsiiSet("namespace", java.util.Objects.requireNonNull(value, "namespace is required"));
            }
            /**
             * ``EnvironmentResource.OptionSettingProperty.OptionName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-optionname
             */
            public java.lang.Object getOptionName() {
                return this.jsiiGet("optionName", java.lang.Object.class);
            }
            /**
             * ``EnvironmentResource.OptionSettingProperty.OptionName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-optionname
             */
            public void setOptionName(final java.lang.String value) {
                this.jsiiSet("optionName", java.util.Objects.requireNonNull(value, "optionName is required"));
            }
            /**
             * ``EnvironmentResource.OptionSettingProperty.OptionName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-optionname
             */
            public void setOptionName(final software.amazon.awscdk.Token value) {
                this.jsiiSet("optionName", java.util.Objects.requireNonNull(value, "optionName is required"));
            }
            /**
             * ``EnvironmentResource.OptionSettingProperty.ResourceName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-elasticbeanstalk-environment-optionsetting-resourcename
             */
            @javax.annotation.Nullable
            public java.lang.Object getResourceName() {
                return this.jsiiGet("resourceName", java.lang.Object.class);
            }
            /**
             * ``EnvironmentResource.OptionSettingProperty.ResourceName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-elasticbeanstalk-environment-optionsetting-resourcename
             */
            public void setResourceName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("resourceName", value);
            }
            /**
             * ``EnvironmentResource.OptionSettingProperty.ResourceName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-elasticbeanstalk-environment-optionsetting-resourcename
             */
            public void setResourceName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("resourceName", value);
            }
            /**
             * ``EnvironmentResource.OptionSettingProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-value
             */
            @javax.annotation.Nullable
            public java.lang.Object getValue() {
                return this.jsiiGet("value", java.lang.Object.class);
            }
            /**
             * ``EnvironmentResource.OptionSettingProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-value
             */
            public void setValue(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("value", value);
            }
            /**
             * ``EnvironmentResource.OptionSettingProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-value
             */
            public void setValue(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("value", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html
     */
    public static interface TierProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``EnvironmentResource.TierProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-name
         */
        java.lang.Object getName();
        /**
         * ``EnvironmentResource.TierProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-name
         */
        void setName(final java.lang.String value);
        /**
         * ``EnvironmentResource.TierProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-name
         */
        void setName(final software.amazon.awscdk.Token value);
        /**
         * ``EnvironmentResource.TierProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-type
         */
        java.lang.Object getType();
        /**
         * ``EnvironmentResource.TierProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-type
         */
        void setType(final java.lang.String value);
        /**
         * ``EnvironmentResource.TierProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-type
         */
        void setType(final software.amazon.awscdk.Token value);
        /**
         * ``EnvironmentResource.TierProperty.Version``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-version
         */
        java.lang.Object getVersion();
        /**
         * ``EnvironmentResource.TierProperty.Version``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-version
         */
        void setVersion(final java.lang.String value);
        /**
         * ``EnvironmentResource.TierProperty.Version``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-version
         */
        void setVersion(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link TierProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``EnvironmentResource.TierProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-name
             */
            public Builder withName(final java.lang.String value) {
                this.instance._name = value;
                return this;
            }
            /**
             * ``EnvironmentResource.TierProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-name
             */
            public Builder withName(final software.amazon.awscdk.Token value) {
                this.instance._name = value;
                return this;
            }
            /**
             * ``EnvironmentResource.TierProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-type
             */
            public Builder withType(final java.lang.String value) {
                this.instance._type = value;
                return this;
            }
            /**
             * ``EnvironmentResource.TierProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-type
             */
            public Builder withType(final software.amazon.awscdk.Token value) {
                this.instance._type = value;
                return this;
            }
            /**
             * ``EnvironmentResource.TierProperty.Version``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-version
             */
            public Builder withVersion(final java.lang.String value) {
                this.instance._version = value;
                return this;
            }
            /**
             * ``EnvironmentResource.TierProperty.Version``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-version
             */
            public Builder withVersion(final software.amazon.awscdk.Token value) {
                this.instance._version = value;
                return this;
            }
            public TierProperty build() {
                TierProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link TierProperty}.
         */
        final class Jsii$Pojo implements TierProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _name;

            public java.lang.Object getName() {
                return this._name;
            }
            public void setName(final java.lang.String value) {
                this._name = value;
            }
            public void setName(final software.amazon.awscdk.Token value) {
                this._name = value;
            }

            protected java.lang.Object _type;

            public java.lang.Object getType() {
                return this._type;
            }
            public void setType(final java.lang.String value) {
                this._type = value;
            }
            public void setType(final software.amazon.awscdk.Token value) {
                this._type = value;
            }

            protected java.lang.Object _version;

            public java.lang.Object getVersion() {
                return this._version;
            }
            public void setVersion(final java.lang.String value) {
                this._version = value;
            }
            public void setVersion(final software.amazon.awscdk.Token value) {
                this._version = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticbeanstalk.cloudformation.EnvironmentResource.TierProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``EnvironmentResource.TierProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-name
             */
            @javax.annotation.Nullable
            public java.lang.Object getName() {
                return this.jsiiGet("name", java.lang.Object.class);
            }
            /**
             * ``EnvironmentResource.TierProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-name
             */
            public void setName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("name", value);
            }
            /**
             * ``EnvironmentResource.TierProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-name
             */
            public void setName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("name", value);
            }
            /**
             * ``EnvironmentResource.TierProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-type
             */
            @javax.annotation.Nullable
            public java.lang.Object getType() {
                return this.jsiiGet("type", java.lang.Object.class);
            }
            /**
             * ``EnvironmentResource.TierProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-type
             */
            public void setType(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("type", value);
            }
            /**
             * ``EnvironmentResource.TierProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-type
             */
            public void setType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("type", value);
            }
            /**
             * ``EnvironmentResource.TierProperty.Version``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-version
             */
            @javax.annotation.Nullable
            public java.lang.Object getVersion() {
                return this.jsiiGet("version", java.lang.Object.class);
            }
            /**
             * ``EnvironmentResource.TierProperty.Version``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-version
             */
            public void setVersion(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("version", value);
            }
            /**
             * ``EnvironmentResource.TierProperty.Version``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-version
             */
            public void setVersion(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("version", value);
            }
        }
    }
}
