package software.amazon.awscdk.services.elasticbeanstalk.cloudformation;

/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.4 (build e80a889)", date = "2018-09-11T09:53:41.239Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticbeanstalk.$Module.class, fqn = "@aws-cdk/aws-elasticbeanstalk.cloudformation.EnvironmentResource")
public class EnvironmentResource extends software.amazon.awscdk.Resource {
    protected EnvironmentResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticbeanstalk.cloudformation.EnvironmentResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::ElasticBeanstalk::Environment``.
     * @param parent the ``cdk.Construct`` this ``EnvironmentResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``EnvironmentResource``
     */
    public EnvironmentResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, final software.amazon.awscdk.services.elasticbeanstalk.cloudformation.EnvironmentResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required"))).toArray());
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties() {
        return this.jsiiCall("renderProperties", java.util.Map.class);
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    /**
     * @cloudformation_attribute EndpointURL
     */
    public software.amazon.awscdk.services.elasticbeanstalk.EnvironmentEndpointUrl getEnvironmentEndpointUrl() {
        return this.jsiiGet("environmentEndpointUrl", software.amazon.awscdk.services.elasticbeanstalk.EnvironmentEndpointUrl.class);
    }

    public software.amazon.awscdk.services.elasticbeanstalk.EnvironmentName getRef() {
        return this.jsiiGet("ref", software.amazon.awscdk.services.elasticbeanstalk.EnvironmentName.class);
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html
     */
    public static interface OptionSettingProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``EnvironmentResource.OptionSettingProperty.Namespace``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-namespace
         */
        java.lang.Object getNamespace();
        /**
         * ``EnvironmentResource.OptionSettingProperty.Namespace``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-namespace
         */
        void setNamespace(final java.lang.String value);
        /**
         * ``EnvironmentResource.OptionSettingProperty.Namespace``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-namespace
         */
        void setNamespace(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``EnvironmentResource.OptionSettingProperty.OptionName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-optionname
         */
        java.lang.Object getOptionName();
        /**
         * ``EnvironmentResource.OptionSettingProperty.OptionName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-optionname
         */
        void setOptionName(final java.lang.String value);
        /**
         * ``EnvironmentResource.OptionSettingProperty.OptionName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-optionname
         */
        void setOptionName(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``EnvironmentResource.OptionSettingProperty.ResourceName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-elasticbeanstalk-environment-optionsetting-resourcename
         */
        java.lang.Object getResourceName();
        /**
         * ``EnvironmentResource.OptionSettingProperty.ResourceName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-elasticbeanstalk-environment-optionsetting-resourcename
         */
        void setResourceName(final java.lang.String value);
        /**
         * ``EnvironmentResource.OptionSettingProperty.ResourceName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-elasticbeanstalk-environment-optionsetting-resourcename
         */
        void setResourceName(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``EnvironmentResource.OptionSettingProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-value
         */
        java.lang.Object getValue();
        /**
         * ``EnvironmentResource.OptionSettingProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-value
         */
        void setValue(final java.lang.String value);
        /**
         * ``EnvironmentResource.OptionSettingProperty.Value``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-value
         */
        void setValue(final software.amazon.awscdk.CloudFormationToken value);

        /**
         * @return a {@link Builder} of {@link OptionSettingProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link OptionSettingProperty}
         */
        final class Builder {
            private java.lang.Object _namespace;
            private java.lang.Object _optionName;
            @javax.annotation.Nullable
            private java.lang.Object _resourceName;
            @javax.annotation.Nullable
            private java.lang.Object _value;

            /**
             * Sets the value of Namespace
             * @param value ``EnvironmentResource.OptionSettingProperty.Namespace``
             * @return {@code this}
             */
            public Builder withNamespace(final java.lang.String value) {
                this._namespace = java.util.Objects.requireNonNull(value, "namespace is required");
                return this;
            }
            /**
             * Sets the value of Namespace
             * @param value ``EnvironmentResource.OptionSettingProperty.Namespace``
             * @return {@code this}
             */
            public Builder withNamespace(final software.amazon.awscdk.CloudFormationToken value) {
                this._namespace = java.util.Objects.requireNonNull(value, "namespace is required");
                return this;
            }
            /**
             * Sets the value of OptionName
             * @param value ``EnvironmentResource.OptionSettingProperty.OptionName``
             * @return {@code this}
             */
            public Builder withOptionName(final java.lang.String value) {
                this._optionName = java.util.Objects.requireNonNull(value, "optionName is required");
                return this;
            }
            /**
             * Sets the value of OptionName
             * @param value ``EnvironmentResource.OptionSettingProperty.OptionName``
             * @return {@code this}
             */
            public Builder withOptionName(final software.amazon.awscdk.CloudFormationToken value) {
                this._optionName = java.util.Objects.requireNonNull(value, "optionName is required");
                return this;
            }
            /**
             * Sets the value of ResourceName
             * @param value ``EnvironmentResource.OptionSettingProperty.ResourceName``
             * @return {@code this}
             */
            public Builder withResourceName(@javax.annotation.Nullable final java.lang.String value) {
                this._resourceName = value;
                return this;
            }
            /**
             * Sets the value of ResourceName
             * @param value ``EnvironmentResource.OptionSettingProperty.ResourceName``
             * @return {@code this}
             */
            public Builder withResourceName(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._resourceName = value;
                return this;
            }
            /**
             * Sets the value of Value
             * @param value ``EnvironmentResource.OptionSettingProperty.Value``
             * @return {@code this}
             */
            public Builder withValue(@javax.annotation.Nullable final java.lang.String value) {
                this._value = value;
                return this;
            }
            /**
             * Sets the value of Value
             * @param value ``EnvironmentResource.OptionSettingProperty.Value``
             * @return {@code this}
             */
            public Builder withValue(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OptionSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public OptionSettingProperty build() {
                return new OptionSettingProperty() {
                    private java.lang.Object $namespace = java.util.Objects.requireNonNull(_namespace, "namespace is required");
                    private java.lang.Object $optionName = java.util.Objects.requireNonNull(_optionName, "optionName is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $resourceName = _resourceName;
                    @javax.annotation.Nullable
                    private java.lang.Object $value = _value;

                    @Override
                    public java.lang.Object getNamespace() {
                        return this.$namespace;
                    }

                    @Override
                    public void setNamespace(final java.lang.String value) {
                        this.$namespace = java.util.Objects.requireNonNull(value, "namespace is required");
                    }

                    @Override
                    public void setNamespace(final software.amazon.awscdk.CloudFormationToken value) {
                        this.$namespace = java.util.Objects.requireNonNull(value, "namespace is required");
                    }

                    @Override
                    public java.lang.Object getOptionName() {
                        return this.$optionName;
                    }

                    @Override
                    public void setOptionName(final java.lang.String value) {
                        this.$optionName = java.util.Objects.requireNonNull(value, "optionName is required");
                    }

                    @Override
                    public void setOptionName(final software.amazon.awscdk.CloudFormationToken value) {
                        this.$optionName = java.util.Objects.requireNonNull(value, "optionName is required");
                    }

                    @Override
                    public java.lang.Object getResourceName() {
                        return this.$resourceName;
                    }

                    @Override
                    public void setResourceName(@javax.annotation.Nullable final java.lang.String value) {
                        this.$resourceName = value;
                    }

                    @Override
                    public void setResourceName(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$resourceName = value;
                    }

                    @Override
                    public java.lang.Object getValue() {
                        return this.$value;
                    }

                    @Override
                    public void setValue(@javax.annotation.Nullable final java.lang.String value) {
                        this.$value = value;
                    }

                    @Override
                    public void setValue(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$value = value;
                    }

                };
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticbeanstalk.cloudformation.EnvironmentResource.OptionSettingProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``EnvironmentResource.OptionSettingProperty.Namespace``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-namespace
             */
            @Override
            public java.lang.Object getNamespace() {
                return this.jsiiGet("namespace", java.lang.Object.class);
            }

            /**
             * ``EnvironmentResource.OptionSettingProperty.Namespace``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-namespace
             */
            @Override
            public void setNamespace(final java.lang.String value) {
                this.jsiiSet("namespace", java.util.Objects.requireNonNull(value, "namespace is required"));
            }

            /**
             * ``EnvironmentResource.OptionSettingProperty.Namespace``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-namespace
             */
            @Override
            public void setNamespace(final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("namespace", java.util.Objects.requireNonNull(value, "namespace is required"));
            }

            /**
             * ``EnvironmentResource.OptionSettingProperty.OptionName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-optionname
             */
            @Override
            public java.lang.Object getOptionName() {
                return this.jsiiGet("optionName", java.lang.Object.class);
            }

            /**
             * ``EnvironmentResource.OptionSettingProperty.OptionName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-optionname
             */
            @Override
            public void setOptionName(final java.lang.String value) {
                this.jsiiSet("optionName", java.util.Objects.requireNonNull(value, "optionName is required"));
            }

            /**
             * ``EnvironmentResource.OptionSettingProperty.OptionName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-optionname
             */
            @Override
            public void setOptionName(final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("optionName", java.util.Objects.requireNonNull(value, "optionName is required"));
            }

            /**
             * ``EnvironmentResource.OptionSettingProperty.ResourceName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-elasticbeanstalk-environment-optionsetting-resourcename
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getResourceName() {
                return this.jsiiGet("resourceName", java.lang.Object.class);
            }

            /**
             * ``EnvironmentResource.OptionSettingProperty.ResourceName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-elasticbeanstalk-environment-optionsetting-resourcename
             */
            @Override
            public void setResourceName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("resourceName", value);
            }

            /**
             * ``EnvironmentResource.OptionSettingProperty.ResourceName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-elasticbeanstalk-environment-optionsetting-resourcename
             */
            @Override
            public void setResourceName(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("resourceName", value);
            }

            /**
             * ``EnvironmentResource.OptionSettingProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-value
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getValue() {
                return this.jsiiGet("value", java.lang.Object.class);
            }

            /**
             * ``EnvironmentResource.OptionSettingProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-value
             */
            @Override
            public void setValue(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("value", value);
            }

            /**
             * ``EnvironmentResource.OptionSettingProperty.Value``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-value
             */
            @Override
            public void setValue(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("value", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html
     */
    public static interface TierProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``EnvironmentResource.TierProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-name
         */
        java.lang.Object getName();
        /**
         * ``EnvironmentResource.TierProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-name
         */
        void setName(final java.lang.String value);
        /**
         * ``EnvironmentResource.TierProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-name
         */
        void setName(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``EnvironmentResource.TierProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-type
         */
        java.lang.Object getType();
        /**
         * ``EnvironmentResource.TierProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-type
         */
        void setType(final java.lang.String value);
        /**
         * ``EnvironmentResource.TierProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-type
         */
        void setType(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``EnvironmentResource.TierProperty.Version``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-version
         */
        java.lang.Object getVersion();
        /**
         * ``EnvironmentResource.TierProperty.Version``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-version
         */
        void setVersion(final java.lang.String value);
        /**
         * ``EnvironmentResource.TierProperty.Version``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-version
         */
        void setVersion(final software.amazon.awscdk.CloudFormationToken value);

        /**
         * @return a {@link Builder} of {@link TierProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link TierProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _name;
            @javax.annotation.Nullable
            private java.lang.Object _type;
            @javax.annotation.Nullable
            private java.lang.Object _version;

            /**
             * Sets the value of Name
             * @param value ``EnvironmentResource.TierProperty.Name``
             * @return {@code this}
             */
            public Builder withName(@javax.annotation.Nullable final java.lang.String value) {
                this._name = value;
                return this;
            }
            /**
             * Sets the value of Name
             * @param value ``EnvironmentResource.TierProperty.Name``
             * @return {@code this}
             */
            public Builder withName(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._name = value;
                return this;
            }
            /**
             * Sets the value of Type
             * @param value ``EnvironmentResource.TierProperty.Type``
             * @return {@code this}
             */
            public Builder withType(@javax.annotation.Nullable final java.lang.String value) {
                this._type = value;
                return this;
            }
            /**
             * Sets the value of Type
             * @param value ``EnvironmentResource.TierProperty.Type``
             * @return {@code this}
             */
            public Builder withType(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._type = value;
                return this;
            }
            /**
             * Sets the value of Version
             * @param value ``EnvironmentResource.TierProperty.Version``
             * @return {@code this}
             */
            public Builder withVersion(@javax.annotation.Nullable final java.lang.String value) {
                this._version = value;
                return this;
            }
            /**
             * Sets the value of Version
             * @param value ``EnvironmentResource.TierProperty.Version``
             * @return {@code this}
             */
            public Builder withVersion(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._version = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TierProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public TierProperty build() {
                return new TierProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $name = _name;
                    @javax.annotation.Nullable
                    private java.lang.Object $type = _type;
                    @javax.annotation.Nullable
                    private java.lang.Object $version = _version;

                    @Override
                    public java.lang.Object getName() {
                        return this.$name;
                    }

                    @Override
                    public void setName(@javax.annotation.Nullable final java.lang.String value) {
                        this.$name = value;
                    }

                    @Override
                    public void setName(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$name = value;
                    }

                    @Override
                    public java.lang.Object getType() {
                        return this.$type;
                    }

                    @Override
                    public void setType(@javax.annotation.Nullable final java.lang.String value) {
                        this.$type = value;
                    }

                    @Override
                    public void setType(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$type = value;
                    }

                    @Override
                    public java.lang.Object getVersion() {
                        return this.$version;
                    }

                    @Override
                    public void setVersion(@javax.annotation.Nullable final java.lang.String value) {
                        this.$version = value;
                    }

                    @Override
                    public void setVersion(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$version = value;
                    }

                };
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticbeanstalk.cloudformation.EnvironmentResource.TierProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``EnvironmentResource.TierProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-name
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getName() {
                return this.jsiiGet("name", java.lang.Object.class);
            }

            /**
             * ``EnvironmentResource.TierProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-name
             */
            @Override
            public void setName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("name", value);
            }

            /**
             * ``EnvironmentResource.TierProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-name
             */
            @Override
            public void setName(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("name", value);
            }

            /**
             * ``EnvironmentResource.TierProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-type
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getType() {
                return this.jsiiGet("type", java.lang.Object.class);
            }

            /**
             * ``EnvironmentResource.TierProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-type
             */
            @Override
            public void setType(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("type", value);
            }

            /**
             * ``EnvironmentResource.TierProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-type
             */
            @Override
            public void setType(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("type", value);
            }

            /**
             * ``EnvironmentResource.TierProperty.Version``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-version
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getVersion() {
                return this.jsiiGet("version", java.lang.Object.class);
            }

            /**
             * ``EnvironmentResource.TierProperty.Version``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-version
             */
            @Override
            public void setVersion(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("version", value);
            }

            /**
             * ``EnvironmentResource.TierProperty.Version``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-version
             */
            @Override
            public void setVersion(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("version", value);
            }
        }
    }
}
