package software.amazon.awscdk.services.elasticbeanstalk.cloudformation;

/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.5 (build 845cc48)", date = "2018-09-14T09:13:57.031Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticbeanstalk.$Module.class, fqn = "@aws-cdk/aws-elasticbeanstalk.cloudformation.ApplicationResource")
public class ApplicationResource extends software.amazon.awscdk.Resource {
    protected ApplicationResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ApplicationResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::ElasticBeanstalk::Application``.
     * @param parent the ``cdk.Construct`` this ``ApplicationResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``ApplicationResource``
     */
    public ApplicationResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, @javax.annotation.Nullable final software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ApplicationResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(properties)).toArray());
    }
    /**
     * Creates a new ``AWS::ElasticBeanstalk::Application``.
     * @param parent the ``cdk.Construct`` this ``ApplicationResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     */
    public ApplicationResource(final software.amazon.awscdk.Construct parent, final java.lang.String name) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))).toArray());
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties() {
        return this.jsiiCall("renderProperties", java.util.Map.class);
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    public software.amazon.awscdk.services.elasticbeanstalk.ApplicationName getRef() {
        return this.jsiiGet("ref", software.amazon.awscdk.services.elasticbeanstalk.ApplicationName.class);
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationresourcelifecycleconfig.html
     */
    public static interface ApplicationResourceLifecycleConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``ApplicationResource.ApplicationResourceLifecycleConfigProperty.ServiceRole``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationresourcelifecycleconfig.html#cfn-elasticbeanstalk-application-applicationresourcelifecycleconfig-servicerole
         */
        java.lang.Object getServiceRole();
        /**
         * ``ApplicationResource.ApplicationResourceLifecycleConfigProperty.ServiceRole``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationresourcelifecycleconfig.html#cfn-elasticbeanstalk-application-applicationresourcelifecycleconfig-servicerole
         */
        void setServiceRole(final java.lang.String value);
        /**
         * ``ApplicationResource.ApplicationResourceLifecycleConfigProperty.ServiceRole``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationresourcelifecycleconfig.html#cfn-elasticbeanstalk-application-applicationresourcelifecycleconfig-servicerole
         */
        void setServiceRole(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``ApplicationResource.ApplicationResourceLifecycleConfigProperty.VersionLifecycleConfig``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationresourcelifecycleconfig.html#cfn-elasticbeanstalk-application-applicationresourcelifecycleconfig-versionlifecycleconfig
         */
        java.lang.Object getVersionLifecycleConfig();
        /**
         * ``ApplicationResource.ApplicationResourceLifecycleConfigProperty.VersionLifecycleConfig``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationresourcelifecycleconfig.html#cfn-elasticbeanstalk-application-applicationresourcelifecycleconfig-versionlifecycleconfig
         */
        void setVersionLifecycleConfig(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``ApplicationResource.ApplicationResourceLifecycleConfigProperty.VersionLifecycleConfig``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationresourcelifecycleconfig.html#cfn-elasticbeanstalk-application-applicationresourcelifecycleconfig-versionlifecycleconfig
         */
        void setVersionLifecycleConfig(final software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ApplicationResource.ApplicationVersionLifecycleConfigProperty value);

        /**
         * @return a {@link Builder} of {@link ApplicationResourceLifecycleConfigProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ApplicationResourceLifecycleConfigProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _serviceRole;
            @javax.annotation.Nullable
            private java.lang.Object _versionLifecycleConfig;

            /**
             * Sets the value of ServiceRole
             * @param value ``ApplicationResource.ApplicationResourceLifecycleConfigProperty.ServiceRole``
             * @return {@code this}
             */
            public Builder withServiceRole(@javax.annotation.Nullable final java.lang.String value) {
                this._serviceRole = value;
                return this;
            }
            /**
             * Sets the value of ServiceRole
             * @param value ``ApplicationResource.ApplicationResourceLifecycleConfigProperty.ServiceRole``
             * @return {@code this}
             */
            public Builder withServiceRole(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._serviceRole = value;
                return this;
            }
            /**
             * Sets the value of VersionLifecycleConfig
             * @param value ``ApplicationResource.ApplicationResourceLifecycleConfigProperty.VersionLifecycleConfig``
             * @return {@code this}
             */
            public Builder withVersionLifecycleConfig(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._versionLifecycleConfig = value;
                return this;
            }
            /**
             * Sets the value of VersionLifecycleConfig
             * @param value ``ApplicationResource.ApplicationResourceLifecycleConfigProperty.VersionLifecycleConfig``
             * @return {@code this}
             */
            public Builder withVersionLifecycleConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ApplicationResource.ApplicationVersionLifecycleConfigProperty value) {
                this._versionLifecycleConfig = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ApplicationResourceLifecycleConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ApplicationResourceLifecycleConfigProperty build() {
                return new ApplicationResourceLifecycleConfigProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $serviceRole = _serviceRole;
                    @javax.annotation.Nullable
                    private java.lang.Object $versionLifecycleConfig = _versionLifecycleConfig;

                    @Override
                    public java.lang.Object getServiceRole() {
                        return this.$serviceRole;
                    }

                    @Override
                    public void setServiceRole(@javax.annotation.Nullable final java.lang.String value) {
                        this.$serviceRole = value;
                    }

                    @Override
                    public void setServiceRole(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$serviceRole = value;
                    }

                    @Override
                    public java.lang.Object getVersionLifecycleConfig() {
                        return this.$versionLifecycleConfig;
                    }

                    @Override
                    public void setVersionLifecycleConfig(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$versionLifecycleConfig = value;
                    }

                    @Override
                    public void setVersionLifecycleConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ApplicationResource.ApplicationVersionLifecycleConfigProperty value) {
                        this.$versionLifecycleConfig = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ApplicationResource.ApplicationResourceLifecycleConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``ApplicationResource.ApplicationResourceLifecycleConfigProperty.ServiceRole``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationresourcelifecycleconfig.html#cfn-elasticbeanstalk-application-applicationresourcelifecycleconfig-servicerole
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getServiceRole() {
                return this.jsiiGet("serviceRole", java.lang.Object.class);
            }

            /**
             * ``ApplicationResource.ApplicationResourceLifecycleConfigProperty.ServiceRole``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationresourcelifecycleconfig.html#cfn-elasticbeanstalk-application-applicationresourcelifecycleconfig-servicerole
             */
            @Override
            public void setServiceRole(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("serviceRole", value);
            }

            /**
             * ``ApplicationResource.ApplicationResourceLifecycleConfigProperty.ServiceRole``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationresourcelifecycleconfig.html#cfn-elasticbeanstalk-application-applicationresourcelifecycleconfig-servicerole
             */
            @Override
            public void setServiceRole(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("serviceRole", value);
            }

            /**
             * ``ApplicationResource.ApplicationResourceLifecycleConfigProperty.VersionLifecycleConfig``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationresourcelifecycleconfig.html#cfn-elasticbeanstalk-application-applicationresourcelifecycleconfig-versionlifecycleconfig
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getVersionLifecycleConfig() {
                return this.jsiiGet("versionLifecycleConfig", java.lang.Object.class);
            }

            /**
             * ``ApplicationResource.ApplicationResourceLifecycleConfigProperty.VersionLifecycleConfig``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationresourcelifecycleconfig.html#cfn-elasticbeanstalk-application-applicationresourcelifecycleconfig-versionlifecycleconfig
             */
            @Override
            public void setVersionLifecycleConfig(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("versionLifecycleConfig", value);
            }

            /**
             * ``ApplicationResource.ApplicationResourceLifecycleConfigProperty.VersionLifecycleConfig``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationresourcelifecycleconfig.html#cfn-elasticbeanstalk-application-applicationresourcelifecycleconfig-versionlifecycleconfig
             */
            @Override
            public void setVersionLifecycleConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ApplicationResource.ApplicationVersionLifecycleConfigProperty value) {
                this.jsiiSet("versionLifecycleConfig", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html
     */
    public static interface ApplicationVersionLifecycleConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``ApplicationResource.ApplicationVersionLifecycleConfigProperty.MaxAgeRule``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html#cfn-elasticbeanstalk-application-applicationversionlifecycleconfig-maxagerule
         */
        java.lang.Object getMaxAgeRule();
        /**
         * ``ApplicationResource.ApplicationVersionLifecycleConfigProperty.MaxAgeRule``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html#cfn-elasticbeanstalk-application-applicationversionlifecycleconfig-maxagerule
         */
        void setMaxAgeRule(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``ApplicationResource.ApplicationVersionLifecycleConfigProperty.MaxAgeRule``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html#cfn-elasticbeanstalk-application-applicationversionlifecycleconfig-maxagerule
         */
        void setMaxAgeRule(final software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ApplicationResource.MaxAgeRuleProperty value);
        /**
         * ``ApplicationResource.ApplicationVersionLifecycleConfigProperty.MaxCountRule``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html#cfn-elasticbeanstalk-application-applicationversionlifecycleconfig-maxcountrule
         */
        java.lang.Object getMaxCountRule();
        /**
         * ``ApplicationResource.ApplicationVersionLifecycleConfigProperty.MaxCountRule``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html#cfn-elasticbeanstalk-application-applicationversionlifecycleconfig-maxcountrule
         */
        void setMaxCountRule(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``ApplicationResource.ApplicationVersionLifecycleConfigProperty.MaxCountRule``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html#cfn-elasticbeanstalk-application-applicationversionlifecycleconfig-maxcountrule
         */
        void setMaxCountRule(final software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ApplicationResource.MaxCountRuleProperty value);

        /**
         * @return a {@link Builder} of {@link ApplicationVersionLifecycleConfigProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ApplicationVersionLifecycleConfigProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _maxAgeRule;
            @javax.annotation.Nullable
            private java.lang.Object _maxCountRule;

            /**
             * Sets the value of MaxAgeRule
             * @param value ``ApplicationResource.ApplicationVersionLifecycleConfigProperty.MaxAgeRule``
             * @return {@code this}
             */
            public Builder withMaxAgeRule(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._maxAgeRule = value;
                return this;
            }
            /**
             * Sets the value of MaxAgeRule
             * @param value ``ApplicationResource.ApplicationVersionLifecycleConfigProperty.MaxAgeRule``
             * @return {@code this}
             */
            public Builder withMaxAgeRule(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ApplicationResource.MaxAgeRuleProperty value) {
                this._maxAgeRule = value;
                return this;
            }
            /**
             * Sets the value of MaxCountRule
             * @param value ``ApplicationResource.ApplicationVersionLifecycleConfigProperty.MaxCountRule``
             * @return {@code this}
             */
            public Builder withMaxCountRule(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._maxCountRule = value;
                return this;
            }
            /**
             * Sets the value of MaxCountRule
             * @param value ``ApplicationResource.ApplicationVersionLifecycleConfigProperty.MaxCountRule``
             * @return {@code this}
             */
            public Builder withMaxCountRule(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ApplicationResource.MaxCountRuleProperty value) {
                this._maxCountRule = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ApplicationVersionLifecycleConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ApplicationVersionLifecycleConfigProperty build() {
                return new ApplicationVersionLifecycleConfigProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $maxAgeRule = _maxAgeRule;
                    @javax.annotation.Nullable
                    private java.lang.Object $maxCountRule = _maxCountRule;

                    @Override
                    public java.lang.Object getMaxAgeRule() {
                        return this.$maxAgeRule;
                    }

                    @Override
                    public void setMaxAgeRule(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$maxAgeRule = value;
                    }

                    @Override
                    public void setMaxAgeRule(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ApplicationResource.MaxAgeRuleProperty value) {
                        this.$maxAgeRule = value;
                    }

                    @Override
                    public java.lang.Object getMaxCountRule() {
                        return this.$maxCountRule;
                    }

                    @Override
                    public void setMaxCountRule(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$maxCountRule = value;
                    }

                    @Override
                    public void setMaxCountRule(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ApplicationResource.MaxCountRuleProperty value) {
                        this.$maxCountRule = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ApplicationResource.ApplicationVersionLifecycleConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``ApplicationResource.ApplicationVersionLifecycleConfigProperty.MaxAgeRule``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html#cfn-elasticbeanstalk-application-applicationversionlifecycleconfig-maxagerule
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getMaxAgeRule() {
                return this.jsiiGet("maxAgeRule", java.lang.Object.class);
            }

            /**
             * ``ApplicationResource.ApplicationVersionLifecycleConfigProperty.MaxAgeRule``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html#cfn-elasticbeanstalk-application-applicationversionlifecycleconfig-maxagerule
             */
            @Override
            public void setMaxAgeRule(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("maxAgeRule", value);
            }

            /**
             * ``ApplicationResource.ApplicationVersionLifecycleConfigProperty.MaxAgeRule``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html#cfn-elasticbeanstalk-application-applicationversionlifecycleconfig-maxagerule
             */
            @Override
            public void setMaxAgeRule(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ApplicationResource.MaxAgeRuleProperty value) {
                this.jsiiSet("maxAgeRule", value);
            }

            /**
             * ``ApplicationResource.ApplicationVersionLifecycleConfigProperty.MaxCountRule``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html#cfn-elasticbeanstalk-application-applicationversionlifecycleconfig-maxcountrule
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getMaxCountRule() {
                return this.jsiiGet("maxCountRule", java.lang.Object.class);
            }

            /**
             * ``ApplicationResource.ApplicationVersionLifecycleConfigProperty.MaxCountRule``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html#cfn-elasticbeanstalk-application-applicationversionlifecycleconfig-maxcountrule
             */
            @Override
            public void setMaxCountRule(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("maxCountRule", value);
            }

            /**
             * ``ApplicationResource.ApplicationVersionLifecycleConfigProperty.MaxCountRule``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html#cfn-elasticbeanstalk-application-applicationversionlifecycleconfig-maxcountrule
             */
            @Override
            public void setMaxCountRule(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ApplicationResource.MaxCountRuleProperty value) {
                this.jsiiSet("maxCountRule", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html
     */
    public static interface MaxAgeRuleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``ApplicationResource.MaxAgeRuleProperty.DeleteSourceFromS3``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-deletesourcefroms3
         */
        java.lang.Object getDeleteSourceFromS3();
        /**
         * ``ApplicationResource.MaxAgeRuleProperty.DeleteSourceFromS3``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-deletesourcefroms3
         */
        void setDeleteSourceFromS3(final java.lang.Boolean value);
        /**
         * ``ApplicationResource.MaxAgeRuleProperty.DeleteSourceFromS3``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-deletesourcefroms3
         */
        void setDeleteSourceFromS3(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``ApplicationResource.MaxAgeRuleProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-enabled
         */
        java.lang.Object getEnabled();
        /**
         * ``ApplicationResource.MaxAgeRuleProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-enabled
         */
        void setEnabled(final java.lang.Boolean value);
        /**
         * ``ApplicationResource.MaxAgeRuleProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-enabled
         */
        void setEnabled(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``ApplicationResource.MaxAgeRuleProperty.MaxAgeInDays``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-maxageindays
         */
        java.lang.Object getMaxAgeInDays();
        /**
         * ``ApplicationResource.MaxAgeRuleProperty.MaxAgeInDays``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-maxageindays
         */
        void setMaxAgeInDays(final java.lang.Number value);
        /**
         * ``ApplicationResource.MaxAgeRuleProperty.MaxAgeInDays``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-maxageindays
         */
        void setMaxAgeInDays(final software.amazon.awscdk.CloudFormationToken value);

        /**
         * @return a {@link Builder} of {@link MaxAgeRuleProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link MaxAgeRuleProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _deleteSourceFromS3;
            @javax.annotation.Nullable
            private java.lang.Object _enabled;
            @javax.annotation.Nullable
            private java.lang.Object _maxAgeInDays;

            /**
             * Sets the value of DeleteSourceFromS3
             * @param value ``ApplicationResource.MaxAgeRuleProperty.DeleteSourceFromS3``
             * @return {@code this}
             */
            public Builder withDeleteSourceFromS3(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._deleteSourceFromS3 = value;
                return this;
            }
            /**
             * Sets the value of DeleteSourceFromS3
             * @param value ``ApplicationResource.MaxAgeRuleProperty.DeleteSourceFromS3``
             * @return {@code this}
             */
            public Builder withDeleteSourceFromS3(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._deleteSourceFromS3 = value;
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value ``ApplicationResource.MaxAgeRuleProperty.Enabled``
             * @return {@code this}
             */
            public Builder withEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._enabled = value;
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value ``ApplicationResource.MaxAgeRuleProperty.Enabled``
             * @return {@code this}
             */
            public Builder withEnabled(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._enabled = value;
                return this;
            }
            /**
             * Sets the value of MaxAgeInDays
             * @param value ``ApplicationResource.MaxAgeRuleProperty.MaxAgeInDays``
             * @return {@code this}
             */
            public Builder withMaxAgeInDays(@javax.annotation.Nullable final java.lang.Number value) {
                this._maxAgeInDays = value;
                return this;
            }
            /**
             * Sets the value of MaxAgeInDays
             * @param value ``ApplicationResource.MaxAgeRuleProperty.MaxAgeInDays``
             * @return {@code this}
             */
            public Builder withMaxAgeInDays(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._maxAgeInDays = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MaxAgeRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public MaxAgeRuleProperty build() {
                return new MaxAgeRuleProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $deleteSourceFromS3 = _deleteSourceFromS3;
                    @javax.annotation.Nullable
                    private java.lang.Object $enabled = _enabled;
                    @javax.annotation.Nullable
                    private java.lang.Object $maxAgeInDays = _maxAgeInDays;

                    @Override
                    public java.lang.Object getDeleteSourceFromS3() {
                        return this.$deleteSourceFromS3;
                    }

                    @Override
                    public void setDeleteSourceFromS3(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$deleteSourceFromS3 = value;
                    }

                    @Override
                    public void setDeleteSourceFromS3(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$deleteSourceFromS3 = value;
                    }

                    @Override
                    public java.lang.Object getEnabled() {
                        return this.$enabled;
                    }

                    @Override
                    public void setEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$enabled = value;
                    }

                    @Override
                    public void setEnabled(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$enabled = value;
                    }

                    @Override
                    public java.lang.Object getMaxAgeInDays() {
                        return this.$maxAgeInDays;
                    }

                    @Override
                    public void setMaxAgeInDays(@javax.annotation.Nullable final java.lang.Number value) {
                        this.$maxAgeInDays = value;
                    }

                    @Override
                    public void setMaxAgeInDays(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$maxAgeInDays = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ApplicationResource.MaxAgeRuleProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``ApplicationResource.MaxAgeRuleProperty.DeleteSourceFromS3``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-deletesourcefroms3
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getDeleteSourceFromS3() {
                return this.jsiiGet("deleteSourceFromS3", java.lang.Object.class);
            }

            /**
             * ``ApplicationResource.MaxAgeRuleProperty.DeleteSourceFromS3``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-deletesourcefroms3
             */
            @Override
            public void setDeleteSourceFromS3(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("deleteSourceFromS3", value);
            }

            /**
             * ``ApplicationResource.MaxAgeRuleProperty.DeleteSourceFromS3``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-deletesourcefroms3
             */
            @Override
            public void setDeleteSourceFromS3(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("deleteSourceFromS3", value);
            }

            /**
             * ``ApplicationResource.MaxAgeRuleProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-enabled
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getEnabled() {
                return this.jsiiGet("enabled", java.lang.Object.class);
            }

            /**
             * ``ApplicationResource.MaxAgeRuleProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-enabled
             */
            @Override
            public void setEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("enabled", value);
            }

            /**
             * ``ApplicationResource.MaxAgeRuleProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-enabled
             */
            @Override
            public void setEnabled(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("enabled", value);
            }

            /**
             * ``ApplicationResource.MaxAgeRuleProperty.MaxAgeInDays``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-maxageindays
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getMaxAgeInDays() {
                return this.jsiiGet("maxAgeInDays", java.lang.Object.class);
            }

            /**
             * ``ApplicationResource.MaxAgeRuleProperty.MaxAgeInDays``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-maxageindays
             */
            @Override
            public void setMaxAgeInDays(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("maxAgeInDays", value);
            }

            /**
             * ``ApplicationResource.MaxAgeRuleProperty.MaxAgeInDays``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxagerule.html#cfn-elasticbeanstalk-application-maxagerule-maxageindays
             */
            @Override
            public void setMaxAgeInDays(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("maxAgeInDays", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html
     */
    public static interface MaxCountRuleProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``ApplicationResource.MaxCountRuleProperty.DeleteSourceFromS3``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-deletesourcefroms3
         */
        java.lang.Object getDeleteSourceFromS3();
        /**
         * ``ApplicationResource.MaxCountRuleProperty.DeleteSourceFromS3``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-deletesourcefroms3
         */
        void setDeleteSourceFromS3(final java.lang.Boolean value);
        /**
         * ``ApplicationResource.MaxCountRuleProperty.DeleteSourceFromS3``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-deletesourcefroms3
         */
        void setDeleteSourceFromS3(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``ApplicationResource.MaxCountRuleProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-enabled
         */
        java.lang.Object getEnabled();
        /**
         * ``ApplicationResource.MaxCountRuleProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-enabled
         */
        void setEnabled(final java.lang.Boolean value);
        /**
         * ``ApplicationResource.MaxCountRuleProperty.Enabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-enabled
         */
        void setEnabled(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``ApplicationResource.MaxCountRuleProperty.MaxCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-maxcount
         */
        java.lang.Object getMaxCount();
        /**
         * ``ApplicationResource.MaxCountRuleProperty.MaxCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-maxcount
         */
        void setMaxCount(final java.lang.Number value);
        /**
         * ``ApplicationResource.MaxCountRuleProperty.MaxCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-maxcount
         */
        void setMaxCount(final software.amazon.awscdk.CloudFormationToken value);

        /**
         * @return a {@link Builder} of {@link MaxCountRuleProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link MaxCountRuleProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _deleteSourceFromS3;
            @javax.annotation.Nullable
            private java.lang.Object _enabled;
            @javax.annotation.Nullable
            private java.lang.Object _maxCount;

            /**
             * Sets the value of DeleteSourceFromS3
             * @param value ``ApplicationResource.MaxCountRuleProperty.DeleteSourceFromS3``
             * @return {@code this}
             */
            public Builder withDeleteSourceFromS3(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._deleteSourceFromS3 = value;
                return this;
            }
            /**
             * Sets the value of DeleteSourceFromS3
             * @param value ``ApplicationResource.MaxCountRuleProperty.DeleteSourceFromS3``
             * @return {@code this}
             */
            public Builder withDeleteSourceFromS3(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._deleteSourceFromS3 = value;
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value ``ApplicationResource.MaxCountRuleProperty.Enabled``
             * @return {@code this}
             */
            public Builder withEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._enabled = value;
                return this;
            }
            /**
             * Sets the value of Enabled
             * @param value ``ApplicationResource.MaxCountRuleProperty.Enabled``
             * @return {@code this}
             */
            public Builder withEnabled(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._enabled = value;
                return this;
            }
            /**
             * Sets the value of MaxCount
             * @param value ``ApplicationResource.MaxCountRuleProperty.MaxCount``
             * @return {@code this}
             */
            public Builder withMaxCount(@javax.annotation.Nullable final java.lang.Number value) {
                this._maxCount = value;
                return this;
            }
            /**
             * Sets the value of MaxCount
             * @param value ``ApplicationResource.MaxCountRuleProperty.MaxCount``
             * @return {@code this}
             */
            public Builder withMaxCount(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._maxCount = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MaxCountRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public MaxCountRuleProperty build() {
                return new MaxCountRuleProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $deleteSourceFromS3 = _deleteSourceFromS3;
                    @javax.annotation.Nullable
                    private java.lang.Object $enabled = _enabled;
                    @javax.annotation.Nullable
                    private java.lang.Object $maxCount = _maxCount;

                    @Override
                    public java.lang.Object getDeleteSourceFromS3() {
                        return this.$deleteSourceFromS3;
                    }

                    @Override
                    public void setDeleteSourceFromS3(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$deleteSourceFromS3 = value;
                    }

                    @Override
                    public void setDeleteSourceFromS3(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$deleteSourceFromS3 = value;
                    }

                    @Override
                    public java.lang.Object getEnabled() {
                        return this.$enabled;
                    }

                    @Override
                    public void setEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                        this.$enabled = value;
                    }

                    @Override
                    public void setEnabled(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$enabled = value;
                    }

                    @Override
                    public java.lang.Object getMaxCount() {
                        return this.$maxCount;
                    }

                    @Override
                    public void setMaxCount(@javax.annotation.Nullable final java.lang.Number value) {
                        this.$maxCount = value;
                    }

                    @Override
                    public void setMaxCount(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$maxCount = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticbeanstalk.cloudformation.ApplicationResource.MaxCountRuleProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``ApplicationResource.MaxCountRuleProperty.DeleteSourceFromS3``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-deletesourcefroms3
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getDeleteSourceFromS3() {
                return this.jsiiGet("deleteSourceFromS3", java.lang.Object.class);
            }

            /**
             * ``ApplicationResource.MaxCountRuleProperty.DeleteSourceFromS3``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-deletesourcefroms3
             */
            @Override
            public void setDeleteSourceFromS3(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("deleteSourceFromS3", value);
            }

            /**
             * ``ApplicationResource.MaxCountRuleProperty.DeleteSourceFromS3``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-deletesourcefroms3
             */
            @Override
            public void setDeleteSourceFromS3(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("deleteSourceFromS3", value);
            }

            /**
             * ``ApplicationResource.MaxCountRuleProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-enabled
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getEnabled() {
                return this.jsiiGet("enabled", java.lang.Object.class);
            }

            /**
             * ``ApplicationResource.MaxCountRuleProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-enabled
             */
            @Override
            public void setEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("enabled", value);
            }

            /**
             * ``ApplicationResource.MaxCountRuleProperty.Enabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-enabled
             */
            @Override
            public void setEnabled(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("enabled", value);
            }

            /**
             * ``ApplicationResource.MaxCountRuleProperty.MaxCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-maxcount
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getMaxCount() {
                return this.jsiiGet("maxCount", java.lang.Object.class);
            }

            /**
             * ``ApplicationResource.MaxCountRuleProperty.MaxCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-maxcount
             */
            @Override
            public void setMaxCount(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("maxCount", value);
            }

            /**
             * ``ApplicationResource.MaxCountRuleProperty.MaxCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-maxcountrule.html#cfn-elasticbeanstalk-application-maxcountrule-maxcount
             */
            @Override
            public void setMaxCount(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("maxCount", value);
            }
        }
    }
}
