/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.elasticbeanstalk;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.elasticbeanstalk.;
import software.amazon.awscdk.services.elasticbeanstalk.CfnConfigurationTemplate;
import software.amazon.awscdk.services.elasticbeanstalk.CfnConfigurationTemplateProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-elasticbeanstalk.CfnConfigurationTemplate")
public class CfnConfigurationTemplate
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnConfigurationTemplate.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnConfigurationTemplate(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnConfigurationTemplate(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnConfigurationTemplate(@NotNull Construct scope, @NotNull String id, @NotNull CfnConfigurationTemplateProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)((Object)this), (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)((Object)this), (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)((Object)this), (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getApplicationName() {
        return (String)Kernel.get((Object)((Object)this), (String)"applicationName", (NativeType)NativeType.forClass(String.class));
    }

    public void setApplicationName(@NotNull String value) {
        Kernel.set((Object)((Object)this), (String)"applicationName", (Object)Objects.requireNonNull(value, "applicationName is required"));
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)((Object)this), (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"description", (Object)value);
    }

    @Nullable
    public String getEnvironmentId() {
        return (String)Kernel.get((Object)((Object)this), (String)"environmentId", (NativeType)NativeType.forClass(String.class));
    }

    public void setEnvironmentId(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"environmentId", (Object)value);
    }

    @Nullable
    public Object getOptionSettings() {
        return Kernel.get((Object)((Object)this), (String)"optionSettings", (NativeType)NativeType.forClass(Object.class));
    }

    public void setOptionSettings(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"optionSettings", (Object)value);
    }

    public void setOptionSettings(@Nullable List<Object> value) {
        Kernel.set((Object)((Object)this), (String)"optionSettings", value);
    }

    @Nullable
    public String getPlatformArn() {
        return (String)Kernel.get((Object)((Object)this), (String)"platformArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setPlatformArn(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"platformArn", (Object)value);
    }

    @Nullable
    public String getSolutionStackName() {
        return (String)Kernel.get((Object)((Object)this), (String)"solutionStackName", (NativeType)NativeType.forClass(String.class));
    }

    public void setSolutionStackName(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"solutionStackName", (Object)value);
    }

    @Nullable
    public Object getSourceConfiguration() {
        return Kernel.get((Object)((Object)this), (String)"sourceConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setSourceConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"sourceConfiguration", (Object)value);
    }

    public void setSourceConfiguration(@Nullable SourceConfigurationProperty value) {
        Kernel.set((Object)((Object)this), (String)"sourceConfiguration", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnConfigurationTemplate> {
        private final Construct scope;
        private final String id;
        private final CfnConfigurationTemplateProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnConfigurationTemplateProps.Builder();
        }

        public Builder applicationName(String applicationName) {
            this.props.applicationName(applicationName);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder environmentId(String environmentId) {
            this.props.environmentId(environmentId);
            return this;
        }

        public Builder optionSettings(IResolvable optionSettings) {
            this.props.optionSettings(optionSettings);
            return this;
        }

        public Builder optionSettings(List<? extends Object> optionSettings) {
            this.props.optionSettings(optionSettings);
            return this;
        }

        public Builder platformArn(String platformArn) {
            this.props.platformArn(platformArn);
            return this;
        }

        public Builder solutionStackName(String solutionStackName) {
            this.props.solutionStackName(solutionStackName);
            return this;
        }

        public Builder sourceConfiguration(IResolvable sourceConfiguration) {
            this.props.sourceConfiguration(sourceConfiguration);
            return this;
        }

        public Builder sourceConfiguration(SourceConfigurationProperty sourceConfiguration) {
            this.props.sourceConfiguration(sourceConfiguration);
            return this;
        }

        public CfnConfigurationTemplate build() {
            return new CfnConfigurationTemplate(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-elasticbeanstalk.CfnConfigurationTemplate.SourceConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SourceConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getApplicationName();

        @NotNull
        public String getTemplateName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SourceConfigurationProperty> {
            private String applicationName;
            private String templateName;

            public Builder applicationName(String applicationName) {
                this.applicationName = applicationName;
                return this;
            }

            public Builder templateName(String templateName) {
                this.templateName = templateName;
                return this;
            }

            public SourceConfigurationProperty build() {
                return new Jsii.Proxy(this.applicationName, this.templateName);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-elasticbeanstalk.CfnConfigurationTemplate.ConfigurationOptionSettingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConfigurationOptionSettingProperty
    extends JsiiSerializable {
        @NotNull
        public String getNamespace();

        @NotNull
        public String getOptionName();

        @Nullable
        default public String getResourceName() {
            return null;
        }

        @Nullable
        default public String getValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConfigurationOptionSettingProperty> {
            private String namespace;
            private String optionName;
            private String resourceName;
            private String value;

            public Builder namespace(String namespace) {
                this.namespace = namespace;
                return this;
            }

            public Builder optionName(String optionName) {
                this.optionName = optionName;
                return this;
            }

            public Builder resourceName(String resourceName) {
                this.resourceName = resourceName;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public ConfigurationOptionSettingProperty build() {
                return new Jsii.Proxy(this.namespace, this.optionName, this.resourceName, this.value);
            }
        }
    }
}

