package software.amazon.awscdk.services.elasticbeanstalk;

/**
 * A CloudFormation `AWS::ElasticBeanstalk::ConfigurationTemplate`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-22T08:15:59.676Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticbeanstalk.$Module.class, fqn = "@aws-cdk/aws-elasticbeanstalk.CfnConfigurationTemplate")
public class CfnConfigurationTemplate extends software.amazon.awscdk.core.CfnResource {

    protected CfnConfigurationTemplate(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnConfigurationTemplate(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticbeanstalk.CfnConfigurationTemplate.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::ElasticBeanstalk::ConfigurationTemplate`.
     * 
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnConfigurationTemplate(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.elasticbeanstalk.CfnConfigurationTemplateProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        this.setObjRef(software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", java.util.Map.class));
    }

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.ApplicationName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-applicationname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getApplicationName() {
        return this.jsiiGet("applicationName", java.lang.String.class);
    }

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.ApplicationName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-applicationname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setApplicationName(final java.lang.String value) {
        this.jsiiSet("applicationName", java.util.Objects.requireNonNull(value, "applicationName is required"));
    }

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.Description`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getDescription() {
        return this.jsiiGet("description", java.lang.String.class);
    }

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.Description`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDescription(final java.lang.String value) {
        this.jsiiSet("description", value);
    }

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.EnvironmentId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-environmentid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getEnvironmentId() {
        return this.jsiiGet("environmentId", java.lang.String.class);
    }

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.EnvironmentId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-environmentid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setEnvironmentId(final java.lang.String value) {
        this.jsiiSet("environmentId", value);
    }

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.OptionSettings`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-optionsettings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getOptionSettings() {
        return this.jsiiGet("optionSettings", java.lang.Object.class);
    }

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.OptionSettings`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-optionsettings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setOptionSettings(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("optionSettings", value);
    }

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.OptionSettings`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-optionsettings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setOptionSettings(final java.util.List<java.lang.Object> value) {
        this.jsiiSet("optionSettings", value);
    }

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.PlatformArn`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-platformarn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getPlatformArn() {
        return this.jsiiGet("platformArn", java.lang.String.class);
    }

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.PlatformArn`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-platformarn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setPlatformArn(final java.lang.String value) {
        this.jsiiSet("platformArn", value);
    }

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.SolutionStackName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-solutionstackname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getSolutionStackName() {
        return this.jsiiGet("solutionStackName", java.lang.String.class);
    }

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.SolutionStackName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-solutionstackname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSolutionStackName(final java.lang.String value) {
        this.jsiiSet("solutionStackName", value);
    }

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.SourceConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getSourceConfiguration() {
        return this.jsiiGet("sourceConfiguration", java.lang.Object.class);
    }

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.SourceConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSourceConfiguration(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("sourceConfiguration", value);
    }

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.SourceConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSourceConfiguration(final software.amazon.awscdk.services.elasticbeanstalk.CfnConfigurationTemplate.SourceConfigurationProperty value) {
        this.jsiiSet("sourceConfiguration", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface ConfigurationOptionSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnConfigurationTemplate.ConfigurationOptionSettingProperty.Namespace`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-namespace
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getNamespace();

        /**
         * `CfnConfigurationTemplate.ConfigurationOptionSettingProperty.OptionName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-optionname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getOptionName();

        /**
         * `CfnConfigurationTemplate.ConfigurationOptionSettingProperty.ResourceName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-resourcename
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getResourceName();

        /**
         * `CfnConfigurationTemplate.ConfigurationOptionSettingProperty.Value`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-value
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link ConfigurationOptionSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConfigurationOptionSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String namespace;
            private java.lang.String optionName;
            private java.lang.String resourceName;
            private java.lang.String value;

            /**
             * Sets the value of Namespace
             * @param namespace `CfnConfigurationTemplate.ConfigurationOptionSettingProperty.Namespace`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder namespace(java.lang.String namespace) {
                this.namespace = namespace;
                return this;
            }

            /**
             * Sets the value of OptionName
             * @param optionName `CfnConfigurationTemplate.ConfigurationOptionSettingProperty.OptionName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder optionName(java.lang.String optionName) {
                this.optionName = optionName;
                return this;
            }

            /**
             * Sets the value of ResourceName
             * @param resourceName `CfnConfigurationTemplate.ConfigurationOptionSettingProperty.ResourceName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder resourceName(java.lang.String resourceName) {
                this.resourceName = resourceName;
                return this;
            }

            /**
             * Sets the value of Value
             * @param value `CfnConfigurationTemplate.ConfigurationOptionSettingProperty.Value`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConfigurationOptionSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public ConfigurationOptionSettingProperty build() {
                return new Jsii$Proxy(namespace, optionName, resourceName, value);
            }
        }

        /**
         * An implementation for {@link ConfigurationOptionSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfigurationOptionSettingProperty {
            private final java.lang.String namespace;
            private final java.lang.String optionName;
            private final java.lang.String resourceName;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.namespace = this.jsiiGet("namespace", java.lang.String.class);
                this.optionName = this.jsiiGet("optionName", java.lang.String.class);
                this.resourceName = this.jsiiGet("resourceName", java.lang.String.class);
                this.value = this.jsiiGet("value", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String namespace, java.lang.String optionName, java.lang.String resourceName, java.lang.String value) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.namespace = java.util.Objects.requireNonNull(namespace, "namespace is required");
                this.optionName = java.util.Objects.requireNonNull(optionName, "optionName is required");
                this.resourceName = resourceName;
                this.value = value;
            }

            @Override
            public java.lang.String getNamespace() {
                return this.namespace;
            }

            @Override
            public java.lang.String getOptionName() {
                return this.optionName;
            }

            @Override
            public java.lang.String getResourceName() {
                return this.resourceName;
            }

            @Override
            public java.lang.String getValue() {
                return this.value;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("namespace", om.valueToTree(this.getNamespace()));
                obj.set("optionName", om.valueToTree(this.getOptionName()));
                if (this.getResourceName() != null) {
                    obj.set("resourceName", om.valueToTree(this.getResourceName()));
                }
                if (this.getValue() != null) {
                    obj.set("value", om.valueToTree(this.getValue()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConfigurationOptionSettingProperty.Jsii$Proxy that = (ConfigurationOptionSettingProperty.Jsii$Proxy) o;

                if (!namespace.equals(that.namespace)) return false;
                if (!optionName.equals(that.optionName)) return false;
                if (this.resourceName != null ? !this.resourceName.equals(that.resourceName) : that.resourceName != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public int hashCode() {
                int result = this.namespace.hashCode();
                result = 31 * result + (this.optionName.hashCode());
                result = 31 * result + (this.resourceName != null ? this.resourceName.hashCode() : 0);
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-sourceconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface SourceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnConfigurationTemplate.SourceConfigurationProperty.ApplicationName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-sourceconfiguration.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration-applicationname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getApplicationName();

        /**
         * `CfnConfigurationTemplate.SourceConfigurationProperty.TemplateName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-sourceconfiguration.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration-templatename
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getTemplateName();

        /**
         * @return a {@link Builder} of {@link SourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String applicationName;
            private java.lang.String templateName;

            /**
             * Sets the value of ApplicationName
             * @param applicationName `CfnConfigurationTemplate.SourceConfigurationProperty.ApplicationName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder applicationName(java.lang.String applicationName) {
                this.applicationName = applicationName;
                return this;
            }

            /**
             * Sets the value of TemplateName
             * @param templateName `CfnConfigurationTemplate.SourceConfigurationProperty.TemplateName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder templateName(java.lang.String templateName) {
                this.templateName = templateName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public SourceConfigurationProperty build() {
                return new Jsii$Proxy(applicationName, templateName);
            }
        }

        /**
         * An implementation for {@link SourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceConfigurationProperty {
            private final java.lang.String applicationName;
            private final java.lang.String templateName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.applicationName = this.jsiiGet("applicationName", java.lang.String.class);
                this.templateName = this.jsiiGet("templateName", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String applicationName, java.lang.String templateName) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.applicationName = java.util.Objects.requireNonNull(applicationName, "applicationName is required");
                this.templateName = java.util.Objects.requireNonNull(templateName, "templateName is required");
            }

            @Override
            public java.lang.String getApplicationName() {
                return this.applicationName;
            }

            @Override
            public java.lang.String getTemplateName() {
                return this.templateName;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("applicationName", om.valueToTree(this.getApplicationName()));
                obj.set("templateName", om.valueToTree(this.getTemplateName()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SourceConfigurationProperty.Jsii$Proxy that = (SourceConfigurationProperty.Jsii$Proxy) o;

                if (!applicationName.equals(that.applicationName)) return false;
                return this.templateName.equals(that.templateName);
            }

            @Override
            public int hashCode() {
                int result = this.applicationName.hashCode();
                result = 31 * result + (this.templateName.hashCode());
                return result;
            }
        }
    }
}
