package software.amazon.awscdk.services.elasticbeanstalk;

/**
 * A CloudFormation `AWS::ElasticBeanstalk::Application`.
 * <p>
 * Specify an AWS Elastic Beanstalk application by using the AWS::ElasticBeanstalk::Application resource in an AWS CloudFormation template.
 * <p>
 * The AWS::ElasticBeanstalk::Application resource is an AWS Elastic Beanstalk Beanstalk resource type that specifies an Elastic Beanstalk application.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.elasticbeanstalk.*;
 * CfnApplication cfnApplication = CfnApplication.Builder.create(this, "MyCfnApplication")
 *         .applicationName("applicationName")
 *         .description("description")
 *         .resourceLifecycleConfig(ApplicationResourceLifecycleConfigProperty.builder()
 *                 .serviceRole("serviceRole")
 *                 .versionLifecycleConfig(ApplicationVersionLifecycleConfigProperty.builder()
 *                         .maxAgeRule(MaxAgeRuleProperty.builder()
 *                                 .deleteSourceFromS3(false)
 *                                 .enabled(false)
 *                                 .maxAgeInDays(123)
 *                                 .build())
 *                         .maxCountRule(MaxCountRuleProperty.builder()
 *                                 .deleteSourceFromS3(false)
 *                                 .enabled(false)
 *                                 .maxCount(123)
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.60.0 (build ebcefe6)", date = "2022-07-13T22:11:49.101Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticbeanstalk.$Module.class, fqn = "@aws-cdk/aws-elasticbeanstalk.CfnApplication")
public class CfnApplication extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnApplication(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnApplication(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticbeanstalk.CfnApplication.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::ElasticBeanstalk::Application`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnApplication(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticbeanstalk.CfnApplicationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::ElasticBeanstalk::Application`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnApplication(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A name for the Elastic Beanstalk application.
     * <p>
     * If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the application name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
     * <p>
     * <blockquote>
     * <p>
     * If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getApplicationName() {
        return software.amazon.jsii.Kernel.get(this, "applicationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A name for the Elastic Beanstalk application.
     * <p>
     * If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the application name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
     * <p>
     * <blockquote>
     * <p>
     * If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApplicationName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "applicationName", value);
    }

    /**
     * Your description of the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Your description of the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * Specifies an application resource lifecycle configuration to prevent your application from accumulating too many versions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getResourceLifecycleConfig() {
        return software.amazon.jsii.Kernel.get(this, "resourceLifecycleConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies an application resource lifecycle configuration to prevent your application from accumulating too many versions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceLifecycleConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticbeanstalk.CfnApplication.ApplicationResourceLifecycleConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "resourceLifecycleConfig", value);
    }

    /**
     * Specifies an application resource lifecycle configuration to prevent your application from accumulating too many versions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceLifecycleConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "resourceLifecycleConfig", value);
    }
    /**
     * Use the `ApplicationResourceLifecycleConfig` property type to specify lifecycle settings for resources that belong to an AWS Elastic Beanstalk application when defining an AWS::ElasticBeanstalk::Application resource in an AWS CloudFormation template.
     * <p>
     * The resource lifecycle configuration for an application. Defines lifecycle settings for resources that belong to the application, and the service role that Elastic Beanstalk assumes in order to apply lifecycle settings. The version lifecycle configuration defines lifecycle settings for application versions.
     * <p>
     * <code>ApplicationResourceLifecycleConfig</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk.html">AWS::ElasticBeanstalk::Application</a> resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticbeanstalk.*;
     * ApplicationResourceLifecycleConfigProperty applicationResourceLifecycleConfigProperty = ApplicationResourceLifecycleConfigProperty.builder()
     *         .serviceRole("serviceRole")
     *         .versionLifecycleConfig(ApplicationVersionLifecycleConfigProperty.builder()
     *                 .maxAgeRule(MaxAgeRuleProperty.builder()
     *                         .deleteSourceFromS3(false)
     *                         .enabled(false)
     *                         .maxAgeInDays(123)
     *                         .build())
     *                 .maxCountRule(MaxCountRuleProperty.builder()
     *                         .deleteSourceFromS3(false)
     *                         .enabled(false)
     *                         .maxCount(123)
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticbeanstalk.$Module.class, fqn = "@aws-cdk/aws-elasticbeanstalk.CfnApplication.ApplicationResourceLifecycleConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ApplicationResourceLifecycleConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ApplicationResourceLifecycleConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of an IAM service role that Elastic Beanstalk has permission to assume.
         * <p>
         * The <code>ServiceRole</code> property is required the first time that you provide a <code>ResourceLifecycleConfig</code> for the application. After you provide it once, Elastic Beanstalk persists the Service Role with the application, and you don't need to specify it again. You can, however, specify it in subsequent updates to change the Service Role to another value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServiceRole() {
            return null;
        }

        /**
         * Defines lifecycle settings for application versions.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVersionLifecycleConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ApplicationResourceLifecycleConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ApplicationResourceLifecycleConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ApplicationResourceLifecycleConfigProperty> {
            java.lang.String serviceRole;
            java.lang.Object versionLifecycleConfig;

            /**
             * Sets the value of {@link ApplicationResourceLifecycleConfigProperty#getServiceRole}
             * @param serviceRole The ARN of an IAM service role that Elastic Beanstalk has permission to assume.
             *                    The <code>ServiceRole</code> property is required the first time that you provide a <code>ResourceLifecycleConfig</code> for the application. After you provide it once, Elastic Beanstalk persists the Service Role with the application, and you don't need to specify it again. You can, however, specify it in subsequent updates to change the Service Role to another value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceRole(java.lang.String serviceRole) {
                this.serviceRole = serviceRole;
                return this;
            }

            /**
             * Sets the value of {@link ApplicationResourceLifecycleConfigProperty#getVersionLifecycleConfig}
             * @param versionLifecycleConfig Defines lifecycle settings for application versions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder versionLifecycleConfig(software.amazon.awscdk.core.IResolvable versionLifecycleConfig) {
                this.versionLifecycleConfig = versionLifecycleConfig;
                return this;
            }

            /**
             * Sets the value of {@link ApplicationResourceLifecycleConfigProperty#getVersionLifecycleConfig}
             * @param versionLifecycleConfig Defines lifecycle settings for application versions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder versionLifecycleConfig(software.amazon.awscdk.services.elasticbeanstalk.CfnApplication.ApplicationVersionLifecycleConfigProperty versionLifecycleConfig) {
                this.versionLifecycleConfig = versionLifecycleConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ApplicationResourceLifecycleConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ApplicationResourceLifecycleConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ApplicationResourceLifecycleConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplicationResourceLifecycleConfigProperty {
            private final java.lang.String serviceRole;
            private final java.lang.Object versionLifecycleConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.serviceRole = software.amazon.jsii.Kernel.get(this, "serviceRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.versionLifecycleConfig = software.amazon.jsii.Kernel.get(this, "versionLifecycleConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.serviceRole = builder.serviceRole;
                this.versionLifecycleConfig = builder.versionLifecycleConfig;
            }

            @Override
            public final java.lang.String getServiceRole() {
                return this.serviceRole;
            }

            @Override
            public final java.lang.Object getVersionLifecycleConfig() {
                return this.versionLifecycleConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getServiceRole() != null) {
                    data.set("serviceRole", om.valueToTree(this.getServiceRole()));
                }
                if (this.getVersionLifecycleConfig() != null) {
                    data.set("versionLifecycleConfig", om.valueToTree(this.getVersionLifecycleConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticbeanstalk.CfnApplication.ApplicationResourceLifecycleConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ApplicationResourceLifecycleConfigProperty.Jsii$Proxy that = (ApplicationResourceLifecycleConfigProperty.Jsii$Proxy) o;

                if (this.serviceRole != null ? !this.serviceRole.equals(that.serviceRole) : that.serviceRole != null) return false;
                return this.versionLifecycleConfig != null ? this.versionLifecycleConfig.equals(that.versionLifecycleConfig) : that.versionLifecycleConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.serviceRole != null ? this.serviceRole.hashCode() : 0;
                result = 31 * result + (this.versionLifecycleConfig != null ? this.versionLifecycleConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Use the `ApplicationVersionLifecycleConfig` property type to specify application version lifecycle settings for an AWS Elastic Beanstalk application when defining an AWS::ElasticBeanstalk::Application resource in an AWS CloudFormation template.
     * <p>
     * The application version lifecycle settings for an application. Defines the rules that Elastic Beanstalk applies to an application's versions in order to avoid hitting the per-region limit for application versions.
     * <p>
     * When Elastic Beanstalk deletes an application version from its database, you can no longer deploy that version to an environment. The source bundle remains in S3 unless you configure the rule to delete it.
     * <p>
     * <code>ApplicationVersionLifecycleConfig</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationresourcelifecycleconfig.html">ApplicationResourceLifecycleConfig</a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticbeanstalk.*;
     * ApplicationVersionLifecycleConfigProperty applicationVersionLifecycleConfigProperty = ApplicationVersionLifecycleConfigProperty.builder()
     *         .maxAgeRule(MaxAgeRuleProperty.builder()
     *                 .deleteSourceFromS3(false)
     *                 .enabled(false)
     *                 .maxAgeInDays(123)
     *                 .build())
     *         .maxCountRule(MaxCountRuleProperty.builder()
     *                 .deleteSourceFromS3(false)
     *                 .enabled(false)
     *                 .maxCount(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticbeanstalk.$Module.class, fqn = "@aws-cdk/aws-elasticbeanstalk.CfnApplication.ApplicationVersionLifecycleConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ApplicationVersionLifecycleConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ApplicationVersionLifecycleConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specify a max age rule to restrict the length of time that application versions are retained for an application.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMaxAgeRule() {
            return null;
        }

        /**
         * Specify a max count rule to restrict the number of application versions that are retained for an application.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMaxCountRule() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ApplicationVersionLifecycleConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ApplicationVersionLifecycleConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ApplicationVersionLifecycleConfigProperty> {
            java.lang.Object maxAgeRule;
            java.lang.Object maxCountRule;

            /**
             * Sets the value of {@link ApplicationVersionLifecycleConfigProperty#getMaxAgeRule}
             * @param maxAgeRule Specify a max age rule to restrict the length of time that application versions are retained for an application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxAgeRule(software.amazon.awscdk.core.IResolvable maxAgeRule) {
                this.maxAgeRule = maxAgeRule;
                return this;
            }

            /**
             * Sets the value of {@link ApplicationVersionLifecycleConfigProperty#getMaxAgeRule}
             * @param maxAgeRule Specify a max age rule to restrict the length of time that application versions are retained for an application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxAgeRule(software.amazon.awscdk.services.elasticbeanstalk.CfnApplication.MaxAgeRuleProperty maxAgeRule) {
                this.maxAgeRule = maxAgeRule;
                return this;
            }

            /**
             * Sets the value of {@link ApplicationVersionLifecycleConfigProperty#getMaxCountRule}
             * @param maxCountRule Specify a max count rule to restrict the number of application versions that are retained for an application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxCountRule(software.amazon.awscdk.core.IResolvable maxCountRule) {
                this.maxCountRule = maxCountRule;
                return this;
            }

            /**
             * Sets the value of {@link ApplicationVersionLifecycleConfigProperty#getMaxCountRule}
             * @param maxCountRule Specify a max count rule to restrict the number of application versions that are retained for an application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxCountRule(software.amazon.awscdk.services.elasticbeanstalk.CfnApplication.MaxCountRuleProperty maxCountRule) {
                this.maxCountRule = maxCountRule;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ApplicationVersionLifecycleConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ApplicationVersionLifecycleConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ApplicationVersionLifecycleConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplicationVersionLifecycleConfigProperty {
            private final java.lang.Object maxAgeRule;
            private final java.lang.Object maxCountRule;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxAgeRule = software.amazon.jsii.Kernel.get(this, "maxAgeRule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maxCountRule = software.amazon.jsii.Kernel.get(this, "maxCountRule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxAgeRule = builder.maxAgeRule;
                this.maxCountRule = builder.maxCountRule;
            }

            @Override
            public final java.lang.Object getMaxAgeRule() {
                return this.maxAgeRule;
            }

            @Override
            public final java.lang.Object getMaxCountRule() {
                return this.maxCountRule;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMaxAgeRule() != null) {
                    data.set("maxAgeRule", om.valueToTree(this.getMaxAgeRule()));
                }
                if (this.getMaxCountRule() != null) {
                    data.set("maxCountRule", om.valueToTree(this.getMaxCountRule()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticbeanstalk.CfnApplication.ApplicationVersionLifecycleConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ApplicationVersionLifecycleConfigProperty.Jsii$Proxy that = (ApplicationVersionLifecycleConfigProperty.Jsii$Proxy) o;

                if (this.maxAgeRule != null ? !this.maxAgeRule.equals(that.maxAgeRule) : that.maxAgeRule != null) return false;
                return this.maxCountRule != null ? this.maxCountRule.equals(that.maxCountRule) : that.maxCountRule == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maxAgeRule != null ? this.maxAgeRule.hashCode() : 0;
                result = 31 * result + (this.maxCountRule != null ? this.maxCountRule.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Use the `MaxAgeRule` property type to specify a max age rule to restrict the length of time that application versions are retained for an AWS Elastic Beanstalk application when defining an AWS::ElasticBeanstalk::Application resource in an AWS CloudFormation template.
     * <p>
     * A lifecycle rule that deletes application versions after the specified number of days.
     * <p>
     * <code>MaxAgeRule</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html">ApplicationVersionLifecycleConfig</a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticbeanstalk.*;
     * MaxAgeRuleProperty maxAgeRuleProperty = MaxAgeRuleProperty.builder()
     *         .deleteSourceFromS3(false)
     *         .enabled(false)
     *         .maxAgeInDays(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticbeanstalk.$Module.class, fqn = "@aws-cdk/aws-elasticbeanstalk.CfnApplication.MaxAgeRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(MaxAgeRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MaxAgeRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Set to `true` to delete a version's source bundle from Amazon S3 when Elastic Beanstalk deletes the application version.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeleteSourceFromS3() {
            return null;
        }

        /**
         * Specify `true` to apply the rule, or `false` to disable it.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * Specify the number of days to retain an application versions.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxAgeInDays() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MaxAgeRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MaxAgeRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MaxAgeRuleProperty> {
            java.lang.Object deleteSourceFromS3;
            java.lang.Object enabled;
            java.lang.Number maxAgeInDays;

            /**
             * Sets the value of {@link MaxAgeRuleProperty#getDeleteSourceFromS3}
             * @param deleteSourceFromS3 Set to `true` to delete a version's source bundle from Amazon S3 when Elastic Beanstalk deletes the application version.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deleteSourceFromS3(java.lang.Boolean deleteSourceFromS3) {
                this.deleteSourceFromS3 = deleteSourceFromS3;
                return this;
            }

            /**
             * Sets the value of {@link MaxAgeRuleProperty#getDeleteSourceFromS3}
             * @param deleteSourceFromS3 Set to `true` to delete a version's source bundle from Amazon S3 when Elastic Beanstalk deletes the application version.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deleteSourceFromS3(software.amazon.awscdk.core.IResolvable deleteSourceFromS3) {
                this.deleteSourceFromS3 = deleteSourceFromS3;
                return this;
            }

            /**
             * Sets the value of {@link MaxAgeRuleProperty#getEnabled}
             * @param enabled Specify `true` to apply the rule, or `false` to disable it.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link MaxAgeRuleProperty#getEnabled}
             * @param enabled Specify `true` to apply the rule, or `false` to disable it.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.core.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link MaxAgeRuleProperty#getMaxAgeInDays}
             * @param maxAgeInDays Specify the number of days to retain an application versions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxAgeInDays(java.lang.Number maxAgeInDays) {
                this.maxAgeInDays = maxAgeInDays;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MaxAgeRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MaxAgeRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MaxAgeRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MaxAgeRuleProperty {
            private final java.lang.Object deleteSourceFromS3;
            private final java.lang.Object enabled;
            private final java.lang.Number maxAgeInDays;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deleteSourceFromS3 = software.amazon.jsii.Kernel.get(this, "deleteSourceFromS3", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maxAgeInDays = software.amazon.jsii.Kernel.get(this, "maxAgeInDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deleteSourceFromS3 = builder.deleteSourceFromS3;
                this.enabled = builder.enabled;
                this.maxAgeInDays = builder.maxAgeInDays;
            }

            @Override
            public final java.lang.Object getDeleteSourceFromS3() {
                return this.deleteSourceFromS3;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.Number getMaxAgeInDays() {
                return this.maxAgeInDays;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDeleteSourceFromS3() != null) {
                    data.set("deleteSourceFromS3", om.valueToTree(this.getDeleteSourceFromS3()));
                }
                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getMaxAgeInDays() != null) {
                    data.set("maxAgeInDays", om.valueToTree(this.getMaxAgeInDays()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticbeanstalk.CfnApplication.MaxAgeRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MaxAgeRuleProperty.Jsii$Proxy that = (MaxAgeRuleProperty.Jsii$Proxy) o;

                if (this.deleteSourceFromS3 != null ? !this.deleteSourceFromS3.equals(that.deleteSourceFromS3) : that.deleteSourceFromS3 != null) return false;
                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                return this.maxAgeInDays != null ? this.maxAgeInDays.equals(that.maxAgeInDays) : that.maxAgeInDays == null;
            }

            @Override
            public final int hashCode() {
                int result = this.deleteSourceFromS3 != null ? this.deleteSourceFromS3.hashCode() : 0;
                result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
                result = 31 * result + (this.maxAgeInDays != null ? this.maxAgeInDays.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Use the `MaxAgeRule` property type to specify a max count rule to restrict the number of application versions that are retained for an AWS Elastic Beanstalk application when defining an AWS::ElasticBeanstalk::Application resource in an AWS CloudFormation template.
     * <p>
     * A lifecycle rule that deletes the oldest application version when the maximum count is exceeded.
     * <p>
     * <code>MaxCountRule</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-application-applicationversionlifecycleconfig.html">ApplicationVersionLifecycleConfig</a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticbeanstalk.*;
     * MaxCountRuleProperty maxCountRuleProperty = MaxCountRuleProperty.builder()
     *         .deleteSourceFromS3(false)
     *         .enabled(false)
     *         .maxCount(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticbeanstalk.$Module.class, fqn = "@aws-cdk/aws-elasticbeanstalk.CfnApplication.MaxCountRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(MaxCountRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MaxCountRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Set to `true` to delete a version's source bundle from Amazon S3 when Elastic Beanstalk deletes the application version.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeleteSourceFromS3() {
            return null;
        }

        /**
         * Specify `true` to apply the rule, or `false` to disable it.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * Specify the maximum number of application versions to retain.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxCount() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MaxCountRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MaxCountRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MaxCountRuleProperty> {
            java.lang.Object deleteSourceFromS3;
            java.lang.Object enabled;
            java.lang.Number maxCount;

            /**
             * Sets the value of {@link MaxCountRuleProperty#getDeleteSourceFromS3}
             * @param deleteSourceFromS3 Set to `true` to delete a version's source bundle from Amazon S3 when Elastic Beanstalk deletes the application version.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deleteSourceFromS3(java.lang.Boolean deleteSourceFromS3) {
                this.deleteSourceFromS3 = deleteSourceFromS3;
                return this;
            }

            /**
             * Sets the value of {@link MaxCountRuleProperty#getDeleteSourceFromS3}
             * @param deleteSourceFromS3 Set to `true` to delete a version's source bundle from Amazon S3 when Elastic Beanstalk deletes the application version.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deleteSourceFromS3(software.amazon.awscdk.core.IResolvable deleteSourceFromS3) {
                this.deleteSourceFromS3 = deleteSourceFromS3;
                return this;
            }

            /**
             * Sets the value of {@link MaxCountRuleProperty#getEnabled}
             * @param enabled Specify `true` to apply the rule, or `false` to disable it.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link MaxCountRuleProperty#getEnabled}
             * @param enabled Specify `true` to apply the rule, or `false` to disable it.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.core.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link MaxCountRuleProperty#getMaxCount}
             * @param maxCount Specify the maximum number of application versions to retain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxCount(java.lang.Number maxCount) {
                this.maxCount = maxCount;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MaxCountRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MaxCountRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MaxCountRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MaxCountRuleProperty {
            private final java.lang.Object deleteSourceFromS3;
            private final java.lang.Object enabled;
            private final java.lang.Number maxCount;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deleteSourceFromS3 = software.amazon.jsii.Kernel.get(this, "deleteSourceFromS3", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maxCount = software.amazon.jsii.Kernel.get(this, "maxCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deleteSourceFromS3 = builder.deleteSourceFromS3;
                this.enabled = builder.enabled;
                this.maxCount = builder.maxCount;
            }

            @Override
            public final java.lang.Object getDeleteSourceFromS3() {
                return this.deleteSourceFromS3;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.Number getMaxCount() {
                return this.maxCount;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDeleteSourceFromS3() != null) {
                    data.set("deleteSourceFromS3", om.valueToTree(this.getDeleteSourceFromS3()));
                }
                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getMaxCount() != null) {
                    data.set("maxCount", om.valueToTree(this.getMaxCount()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticbeanstalk.CfnApplication.MaxCountRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MaxCountRuleProperty.Jsii$Proxy that = (MaxCountRuleProperty.Jsii$Proxy) o;

                if (this.deleteSourceFromS3 != null ? !this.deleteSourceFromS3.equals(that.deleteSourceFromS3) : that.deleteSourceFromS3 != null) return false;
                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                return this.maxCount != null ? this.maxCount.equals(that.maxCount) : that.maxCount == null;
            }

            @Override
            public final int hashCode() {
                int result = this.deleteSourceFromS3 != null ? this.deleteSourceFromS3.hashCode() : 0;
                result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
                result = 31 * result + (this.maxCount != null ? this.maxCount.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.elasticbeanstalk.CfnApplication}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.elasticbeanstalk.CfnApplication> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.elasticbeanstalk.CfnApplicationProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * A name for the Elastic Beanstalk application.
         * <p>
         * If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the application name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
         * <p>
         * <blockquote>
         * <p>
         * If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param applicationName A name for the Elastic Beanstalk application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationName(final java.lang.String applicationName) {
            this.props().applicationName(applicationName);
            return this;
        }

        /**
         * Your description of the application.
         * <p>
         * @return {@code this}
         * @param description Your description of the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * Specifies an application resource lifecycle configuration to prevent your application from accumulating too many versions.
         * <p>
         * @return {@code this}
         * @param resourceLifecycleConfig Specifies an application resource lifecycle configuration to prevent your application from accumulating too many versions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceLifecycleConfig(final software.amazon.awscdk.services.elasticbeanstalk.CfnApplication.ApplicationResourceLifecycleConfigProperty resourceLifecycleConfig) {
            this.props().resourceLifecycleConfig(resourceLifecycleConfig);
            return this;
        }
        /**
         * Specifies an application resource lifecycle configuration to prevent your application from accumulating too many versions.
         * <p>
         * @return {@code this}
         * @param resourceLifecycleConfig Specifies an application resource lifecycle configuration to prevent your application from accumulating too many versions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceLifecycleConfig(final software.amazon.awscdk.core.IResolvable resourceLifecycleConfig) {
            this.props().resourceLifecycleConfig(resourceLifecycleConfig);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.elasticbeanstalk.CfnApplication}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.elasticbeanstalk.CfnApplication build() {
            return new software.amazon.awscdk.services.elasticbeanstalk.CfnApplication(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.elasticbeanstalk.CfnApplicationProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.elasticbeanstalk.CfnApplicationProps.Builder();
            }
            return this.props;
        }
    }
}
