package software.amazon.awscdk.services.elasticbeanstalk;

/**
 * Properties for defining a `AWS::ElasticBeanstalk::Environment`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.8 (build bd5ef4d)", date = "2019-11-25T14:22:10.404Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticbeanstalk.$Module.class, fqn = "@aws-cdk/aws-elasticbeanstalk.CfnEnvironmentProps")
@software.amazon.jsii.Jsii.Proxy(CfnEnvironmentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnEnvironmentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::ElasticBeanstalk::Environment.ApplicationName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-applicationname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getApplicationName();

    /**
     * `AWS::ElasticBeanstalk::Environment.CNAMEPrefix`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-cnameprefix
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default java.lang.String getCnamePrefix() {
        return null;
    }

    /**
     * `AWS::ElasticBeanstalk::Environment.Description`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default java.lang.String getDescription() {
        return null;
    }

    /**
     * `AWS::ElasticBeanstalk::Environment.EnvironmentName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default java.lang.String getEnvironmentName() {
        return null;
    }

    /**
     * `AWS::ElasticBeanstalk::Environment.OptionSettings`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-optionsettings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default java.lang.Object getOptionSettings() {
        return null;
    }

    /**
     * `AWS::ElasticBeanstalk::Environment.PlatformArn`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-platformarn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default java.lang.String getPlatformArn() {
        return null;
    }

    /**
     * `AWS::ElasticBeanstalk::Environment.SolutionStackName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-solutionstackname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default java.lang.String getSolutionStackName() {
        return null;
    }

    /**
     * `AWS::ElasticBeanstalk::Environment.Tags`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-elasticbeanstalk-environment-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * `AWS::ElasticBeanstalk::Environment.TemplateName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-templatename
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default java.lang.String getTemplateName() {
        return null;
    }

    /**
     * `AWS::ElasticBeanstalk::Environment.Tier`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-tier
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default java.lang.Object getTier() {
        return null;
    }

    /**
     * `AWS::ElasticBeanstalk::Environment.VersionLabel`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-versionlabel
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default java.lang.String getVersionLabel() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnEnvironmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnEnvironmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        private java.lang.String applicationName;
        private java.lang.String cnamePrefix;
        private java.lang.String description;
        private java.lang.String environmentName;
        private java.lang.Object optionSettings;
        private java.lang.String platformArn;
        private java.lang.String solutionStackName;
        private java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        private java.lang.String templateName;
        private java.lang.Object tier;
        private java.lang.String versionLabel;

        /**
         * Sets the value of ApplicationName
         * @param applicationName `AWS::ElasticBeanstalk::Environment.ApplicationName`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder applicationName(java.lang.String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        /**
         * Sets the value of CnamePrefix
         * @param cnamePrefix `AWS::ElasticBeanstalk::Environment.CNAMEPrefix`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder cnamePrefix(java.lang.String cnamePrefix) {
            this.cnamePrefix = cnamePrefix;
            return this;
        }

        /**
         * Sets the value of Description
         * @param description `AWS::ElasticBeanstalk::Environment.Description`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of EnvironmentName
         * @param environmentName `AWS::ElasticBeanstalk::Environment.EnvironmentName`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder environmentName(java.lang.String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        /**
         * Sets the value of OptionSettings
         * @param optionSettings `AWS::ElasticBeanstalk::Environment.OptionSettings`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder optionSettings(software.amazon.awscdk.core.IResolvable optionSettings) {
            this.optionSettings = optionSettings;
            return this;
        }

        /**
         * Sets the value of OptionSettings
         * @param optionSettings `AWS::ElasticBeanstalk::Environment.OptionSettings`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder optionSettings(java.util.List<java.lang.Object> optionSettings) {
            this.optionSettings = optionSettings;
            return this;
        }

        /**
         * Sets the value of PlatformArn
         * @param platformArn `AWS::ElasticBeanstalk::Environment.PlatformArn`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder platformArn(java.lang.String platformArn) {
            this.platformArn = platformArn;
            return this;
        }

        /**
         * Sets the value of SolutionStackName
         * @param solutionStackName `AWS::ElasticBeanstalk::Environment.SolutionStackName`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder solutionStackName(java.lang.String solutionStackName) {
            this.solutionStackName = solutionStackName;
            return this;
        }

        /**
         * Sets the value of Tags
         * @param tags `AWS::ElasticBeanstalk::Environment.Tags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tags(java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of TemplateName
         * @param templateName `AWS::ElasticBeanstalk::Environment.TemplateName`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder templateName(java.lang.String templateName) {
            this.templateName = templateName;
            return this;
        }

        /**
         * Sets the value of Tier
         * @param tier `AWS::ElasticBeanstalk::Environment.Tier`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tier(software.amazon.awscdk.core.IResolvable tier) {
            this.tier = tier;
            return this;
        }

        /**
         * Sets the value of Tier
         * @param tier `AWS::ElasticBeanstalk::Environment.Tier`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tier(software.amazon.awscdk.services.elasticbeanstalk.CfnEnvironment.TierProperty tier) {
            this.tier = tier;
            return this;
        }

        /**
         * Sets the value of VersionLabel
         * @param versionLabel `AWS::ElasticBeanstalk::Environment.VersionLabel`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder versionLabel(java.lang.String versionLabel) {
            this.versionLabel = versionLabel;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnEnvironmentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnEnvironmentProps build() {
            return new Jsii$Proxy(applicationName, cnamePrefix, description, environmentName, optionSettings, platformArn, solutionStackName, tags, templateName, tier, versionLabel);
        }
    }

    /**
     * An implementation for {@link CfnEnvironmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnEnvironmentProps {
        private final java.lang.String applicationName;
        private final java.lang.String cnamePrefix;
        private final java.lang.String description;
        private final java.lang.String environmentName;
        private final java.lang.Object optionSettings;
        private final java.lang.String platformArn;
        private final java.lang.String solutionStackName;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        private final java.lang.String templateName;
        private final java.lang.Object tier;
        private final java.lang.String versionLabel;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.applicationName = this.jsiiGet("applicationName", java.lang.String.class);
            this.cnamePrefix = this.jsiiGet("cnamePrefix", java.lang.String.class);
            this.description = this.jsiiGet("description", java.lang.String.class);
            this.environmentName = this.jsiiGet("environmentName", java.lang.String.class);
            this.optionSettings = this.jsiiGet("optionSettings", java.lang.Object.class);
            this.platformArn = this.jsiiGet("platformArn", java.lang.String.class);
            this.solutionStackName = this.jsiiGet("solutionStackName", java.lang.String.class);
            this.tags = this.jsiiGet("tags", java.util.List.class);
            this.templateName = this.jsiiGet("templateName", java.lang.String.class);
            this.tier = this.jsiiGet("tier", java.lang.Object.class);
            this.versionLabel = this.jsiiGet("versionLabel", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String applicationName, final java.lang.String cnamePrefix, final java.lang.String description, final java.lang.String environmentName, final java.lang.Object optionSettings, final java.lang.String platformArn, final java.lang.String solutionStackName, final java.util.List<software.amazon.awscdk.core.CfnTag> tags, final java.lang.String templateName, final java.lang.Object tier, final java.lang.String versionLabel) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.applicationName = java.util.Objects.requireNonNull(applicationName, "applicationName is required");
            this.cnamePrefix = cnamePrefix;
            this.description = description;
            this.environmentName = environmentName;
            this.optionSettings = optionSettings;
            this.platformArn = platformArn;
            this.solutionStackName = solutionStackName;
            this.tags = tags;
            this.templateName = templateName;
            this.tier = tier;
            this.versionLabel = versionLabel;
        }

        @Override
        public java.lang.String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public java.lang.String getCnamePrefix() {
            return this.cnamePrefix;
        }

        @Override
        public java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public java.lang.String getEnvironmentName() {
            return this.environmentName;
        }

        @Override
        public java.lang.Object getOptionSettings() {
            return this.optionSettings;
        }

        @Override
        public java.lang.String getPlatformArn() {
            return this.platformArn;
        }

        @Override
        public java.lang.String getSolutionStackName() {
            return this.solutionStackName;
        }

        @Override
        public java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public java.lang.String getTemplateName() {
            return this.templateName;
        }

        @Override
        public java.lang.Object getTier() {
            return this.tier;
        }

        @Override
        public java.lang.String getVersionLabel() {
            return this.versionLabel;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("applicationName", om.valueToTree(this.getApplicationName()));
            if (this.getCnamePrefix() != null) {
                data.set("cnamePrefix", om.valueToTree(this.getCnamePrefix()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEnvironmentName() != null) {
                data.set("environmentName", om.valueToTree(this.getEnvironmentName()));
            }
            if (this.getOptionSettings() != null) {
                data.set("optionSettings", om.valueToTree(this.getOptionSettings()));
            }
            if (this.getPlatformArn() != null) {
                data.set("platformArn", om.valueToTree(this.getPlatformArn()));
            }
            if (this.getSolutionStackName() != null) {
                data.set("solutionStackName", om.valueToTree(this.getSolutionStackName()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTemplateName() != null) {
                data.set("templateName", om.valueToTree(this.getTemplateName()));
            }
            if (this.getTier() != null) {
                data.set("tier", om.valueToTree(this.getTier()));
            }
            if (this.getVersionLabel() != null) {
                data.set("versionLabel", om.valueToTree(this.getVersionLabel()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticbeanstalk.CfnEnvironmentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnEnvironmentProps.Jsii$Proxy that = (CfnEnvironmentProps.Jsii$Proxy) o;

            if (!applicationName.equals(that.applicationName)) return false;
            if (this.cnamePrefix != null ? !this.cnamePrefix.equals(that.cnamePrefix) : that.cnamePrefix != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.environmentName != null ? !this.environmentName.equals(that.environmentName) : that.environmentName != null) return false;
            if (this.optionSettings != null ? !this.optionSettings.equals(that.optionSettings) : that.optionSettings != null) return false;
            if (this.platformArn != null ? !this.platformArn.equals(that.platformArn) : that.platformArn != null) return false;
            if (this.solutionStackName != null ? !this.solutionStackName.equals(that.solutionStackName) : that.solutionStackName != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.templateName != null ? !this.templateName.equals(that.templateName) : that.templateName != null) return false;
            if (this.tier != null ? !this.tier.equals(that.tier) : that.tier != null) return false;
            return this.versionLabel != null ? this.versionLabel.equals(that.versionLabel) : that.versionLabel == null;
        }

        @Override
        public int hashCode() {
            int result = this.applicationName.hashCode();
            result = 31 * result + (this.cnamePrefix != null ? this.cnamePrefix.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.environmentName != null ? this.environmentName.hashCode() : 0);
            result = 31 * result + (this.optionSettings != null ? this.optionSettings.hashCode() : 0);
            result = 31 * result + (this.platformArn != null ? this.platformArn.hashCode() : 0);
            result = 31 * result + (this.solutionStackName != null ? this.solutionStackName.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.templateName != null ? this.templateName.hashCode() : 0);
            result = 31 * result + (this.tier != null ? this.tier.hashCode() : 0);
            result = 31 * result + (this.versionLabel != null ? this.versionLabel.hashCode() : 0);
            return result;
        }
    }
}
