package software.amazon.awscdk.services.elasticbeanstalk;

/**
 * Properties for defining a `CfnApplicationVersion`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.elasticbeanstalk.*;
 * CfnApplicationVersionProps cfnApplicationVersionProps = CfnApplicationVersionProps.builder()
 *         .applicationName("applicationName")
 *         .sourceBundle(SourceBundleProperty.builder()
 *                 .s3Bucket("s3Bucket")
 *                 .s3Key("s3Key")
 *                 .build())
 *         // the properties below are optional
 *         .description("description")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-02-15T20:01:31.551Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticbeanstalk.$Module.class, fqn = "@aws-cdk/aws-elasticbeanstalk.CfnApplicationVersionProps")
@software.amazon.jsii.Jsii.Proxy(CfnApplicationVersionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnApplicationVersionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the Elastic Beanstalk application that is associated with this application version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApplicationName();

    /**
     * The Amazon S3 bucket and key that identify the location of the source bundle for this version.
     * <p>
     * <blockquote>
     * <p>
     * The Amazon S3 bucket must be in the same region as the environment.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getSourceBundle();

    /**
     * A description of this application version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnApplicationVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnApplicationVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnApplicationVersionProps> {
        java.lang.String applicationName;
        java.lang.Object sourceBundle;
        java.lang.String description;

        /**
         * Sets the value of {@link CfnApplicationVersionProps#getApplicationName}
         * @param applicationName The name of the Elastic Beanstalk application that is associated with this application version. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationName(java.lang.String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationVersionProps#getSourceBundle}
         * @param sourceBundle The Amazon S3 bucket and key that identify the location of the source bundle for this version. This parameter is required.
         *                     <blockquote>
         *                     <p>
         *                     The Amazon S3 bucket must be in the same region as the environment.
         *                     <p>
         *                     </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceBundle(software.amazon.awscdk.core.IResolvable sourceBundle) {
            this.sourceBundle = sourceBundle;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationVersionProps#getSourceBundle}
         * @param sourceBundle The Amazon S3 bucket and key that identify the location of the source bundle for this version. This parameter is required.
         *                     <blockquote>
         *                     <p>
         *                     The Amazon S3 bucket must be in the same region as the environment.
         *                     <p>
         *                     </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceBundle(software.amazon.awscdk.services.elasticbeanstalk.CfnApplicationVersion.SourceBundleProperty sourceBundle) {
            this.sourceBundle = sourceBundle;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationVersionProps#getDescription}
         * @param description A description of this application version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnApplicationVersionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnApplicationVersionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnApplicationVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnApplicationVersionProps {
        private final java.lang.String applicationName;
        private final java.lang.Object sourceBundle;
        private final java.lang.String description;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.applicationName = software.amazon.jsii.Kernel.get(this, "applicationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceBundle = software.amazon.jsii.Kernel.get(this, "sourceBundle", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.applicationName = java.util.Objects.requireNonNull(builder.applicationName, "applicationName is required");
            this.sourceBundle = java.util.Objects.requireNonNull(builder.sourceBundle, "sourceBundle is required");
            this.description = builder.description;
        }

        @Override
        public final java.lang.String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final java.lang.Object getSourceBundle() {
            return this.sourceBundle;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("applicationName", om.valueToTree(this.getApplicationName()));
            data.set("sourceBundle", om.valueToTree(this.getSourceBundle()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticbeanstalk.CfnApplicationVersionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnApplicationVersionProps.Jsii$Proxy that = (CfnApplicationVersionProps.Jsii$Proxy) o;

            if (!applicationName.equals(that.applicationName)) return false;
            if (!sourceBundle.equals(that.sourceBundle)) return false;
            return this.description != null ? this.description.equals(that.description) : that.description == null;
        }

        @Override
        public final int hashCode() {
            int result = this.applicationName.hashCode();
            result = 31 * result + (this.sourceBundle.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            return result;
        }
    }
}
