/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.elasticbeanstalk;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.services.elasticbeanstalk.CfnApplicationVersion;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CfnApplicationVersionProps
extends JsiiSerializable {
    public String getApplicationName();

    public Object getSourceBundle();

    public String getDescription();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _applicationName;
        private Object _sourceBundle;
        @Nullable
        private String _description;

        public Builder withApplicationName(String value) {
            this._applicationName = Objects.requireNonNull(value, "applicationName is required");
            return this;
        }

        public Builder withSourceBundle(IResolvable value) {
            this._sourceBundle = Objects.requireNonNull(value, "sourceBundle is required");
            return this;
        }

        public Builder withSourceBundle(CfnApplicationVersion.SourceBundleProperty value) {
            this._sourceBundle = Objects.requireNonNull(value, "sourceBundle is required");
            return this;
        }

        public Builder withDescription(@Nullable String value) {
            this._description = value;
            return this;
        }

        public CfnApplicationVersionProps build() {
            return new CfnApplicationVersionProps(){
                private final String $applicationName;
                private final Object $sourceBundle;
                @Nullable
                private final String $description;
                {
                    this.$applicationName = Objects.requireNonNull(_applicationName, "applicationName is required");
                    this.$sourceBundle = Objects.requireNonNull(_sourceBundle, "sourceBundle is required");
                    this.$description = _description;
                }

                @Override
                public String getApplicationName() {
                    return this.$applicationName;
                }

                @Override
                public Object getSourceBundle() {
                    return this.$sourceBundle;
                }

                @Override
                public String getDescription() {
                    return this.$description;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("applicationName", om.valueToTree((Object)this.getApplicationName()));
                    obj.set("sourceBundle", om.valueToTree(this.getSourceBundle()));
                    if (this.getDescription() != null) {
                        obj.set("description", om.valueToTree((Object)this.getDescription()));
                    }
                    return obj;
                }
            };
        }
    }
}

