package software.amazon.awscdk.services.elasticbeanstalk;

/**
 * Properties for defining a `AWS::ElasticBeanstalk::ApplicationVersion`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.7.0 (build 179a3a5)", date = "2020-07-01T08:46:25.811Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticbeanstalk.$Module.class, fqn = "@aws-cdk/aws-elasticbeanstalk.CfnApplicationVersionProps")
@software.amazon.jsii.Jsii.Proxy(CfnApplicationVersionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnApplicationVersionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::ElasticBeanstalk::ApplicationVersion.ApplicationName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-applicationname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApplicationName();

    /**
     * `AWS::ElasticBeanstalk::ApplicationVersion.SourceBundle`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-sourcebundle
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getSourceBundle();

    /**
     * `AWS::ElasticBeanstalk::ApplicationVersion.Description`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnApplicationVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnApplicationVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnApplicationVersionProps> {
        private java.lang.String applicationName;
        private java.lang.Object sourceBundle;
        private java.lang.String description;

        /**
         * Sets the value of {@link CfnApplicationVersionProps#getApplicationName}
         * @param applicationName `AWS::ElasticBeanstalk::ApplicationVersion.ApplicationName`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationName(java.lang.String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationVersionProps#getSourceBundle}
         * @param sourceBundle `AWS::ElasticBeanstalk::ApplicationVersion.SourceBundle`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceBundle(software.amazon.awscdk.services.elasticbeanstalk.CfnApplicationVersion.SourceBundleProperty sourceBundle) {
            this.sourceBundle = sourceBundle;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationVersionProps#getSourceBundle}
         * @param sourceBundle `AWS::ElasticBeanstalk::ApplicationVersion.SourceBundle`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceBundle(software.amazon.awscdk.core.IResolvable sourceBundle) {
            this.sourceBundle = sourceBundle;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationVersionProps#getDescription}
         * @param description `AWS::ElasticBeanstalk::ApplicationVersion.Description`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnApplicationVersionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnApplicationVersionProps build() {
            return new Jsii$Proxy(applicationName, sourceBundle, description);
        }
    }

    /**
     * An implementation for {@link CfnApplicationVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnApplicationVersionProps {
        private final java.lang.String applicationName;
        private final java.lang.Object sourceBundle;
        private final java.lang.String description;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.applicationName = this.jsiiGet("applicationName", java.lang.String.class);
            this.sourceBundle = this.jsiiGet("sourceBundle", java.lang.Object.class);
            this.description = this.jsiiGet("description", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String applicationName, final java.lang.Object sourceBundle, final java.lang.String description) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.applicationName = java.util.Objects.requireNonNull(applicationName, "applicationName is required");
            this.sourceBundle = java.util.Objects.requireNonNull(sourceBundle, "sourceBundle is required");
            this.description = description;
        }

        @Override
        public java.lang.String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public java.lang.Object getSourceBundle() {
            return this.sourceBundle;
        }

        @Override
        public java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("applicationName", om.valueToTree(this.getApplicationName()));
            data.set("sourceBundle", om.valueToTree(this.getSourceBundle()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticbeanstalk.CfnApplicationVersionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnApplicationVersionProps.Jsii$Proxy that = (CfnApplicationVersionProps.Jsii$Proxy) o;

            if (!applicationName.equals(that.applicationName)) return false;
            if (!sourceBundle.equals(that.sourceBundle)) return false;
            return this.description != null ? this.description.equals(that.description) : that.description == null;
        }

        @Override
        public int hashCode() {
            int result = this.applicationName.hashCode();
            result = 31 * result + (this.sourceBundle.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            return result;
        }
    }
}
