package software.amazon.awscdk.services.elasticbeanstalk;

/**
 * A CloudFormation `AWS::ElasticBeanstalk::ConfigurationTemplate`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-07-22T09:49:54.686Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticbeanstalk.$Module.class, fqn = "@aws-cdk/aws-elasticbeanstalk.CfnConfigurationTemplate")
public class CfnConfigurationTemplate extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnConfigurationTemplate(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnConfigurationTemplate(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticbeanstalk.CfnConfigurationTemplate.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::ElasticBeanstalk::ConfigurationTemplate`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnConfigurationTemplate(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticbeanstalk.CfnConfigurationTemplateProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A factory method that creates a new instance of this class from an object containing the CloudFormation properties of this resource.
     * <p>
     * Used in the &#64;aws-cdk/cloudformation-include module.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param resourceAttributes This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticbeanstalk.CfnConfigurationTemplate fromCloudFormation(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.Object resourceAttributes, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.FromCloudFormationOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.elasticbeanstalk.CfnConfigurationTemplate.class, "fromCloudFormation", software.amazon.awscdk.services.elasticbeanstalk.CfnConfigurationTemplate.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), resourceAttributes, java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.ApplicationName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-applicationname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getApplicationName() {
        return this.jsiiGet("applicationName", java.lang.String.class);
    }

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.ApplicationName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-applicationname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApplicationName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiSet("applicationName", java.util.Objects.requireNonNull(value, "applicationName is required"));
    }

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.Description`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return this.jsiiGet("description", java.lang.String.class);
    }

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.Description`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("description", value);
    }

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.EnvironmentId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-environmentid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEnvironmentId() {
        return this.jsiiGet("environmentId", java.lang.String.class);
    }

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.EnvironmentId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-environmentid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnvironmentId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("environmentId", value);
    }

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.OptionSettings`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-optionsettings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOptionSettings() {
        return this.jsiiGet("optionSettings", java.lang.Object.class);
    }

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.OptionSettings`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-optionsettings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOptionSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("optionSettings", value);
    }

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.OptionSettings`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-optionsettings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOptionSettings(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        this.jsiiSet("optionSettings", value);
    }

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.PlatformArn`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-platformarn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPlatformArn() {
        return this.jsiiGet("platformArn", java.lang.String.class);
    }

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.PlatformArn`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-platformarn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPlatformArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("platformArn", value);
    }

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.SolutionStackName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-solutionstackname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSolutionStackName() {
        return this.jsiiGet("solutionStackName", java.lang.String.class);
    }

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.SolutionStackName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-solutionstackname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSolutionStackName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("solutionStackName", value);
    }

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.SourceConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSourceConfiguration() {
        return this.jsiiGet("sourceConfiguration", java.lang.Object.class);
    }

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.SourceConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("sourceConfiguration", value);
    }

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.SourceConfiguration`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticbeanstalk.CfnConfigurationTemplate.SourceConfigurationProperty value) {
        this.jsiiSet("sourceConfiguration", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticbeanstalk.$Module.class, fqn = "@aws-cdk/aws-elasticbeanstalk.CfnConfigurationTemplate.ConfigurationOptionSettingProperty")
    @software.amazon.jsii.Jsii.Proxy(ConfigurationOptionSettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConfigurationOptionSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnConfigurationTemplate.ConfigurationOptionSettingProperty.Namespace`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-namespace
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getNamespace();

        /**
         * `CfnConfigurationTemplate.ConfigurationOptionSettingProperty.OptionName`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-optionname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOptionName();

        /**
         * `CfnConfigurationTemplate.ConfigurationOptionSettingProperty.ResourceName`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-resourcename
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourceName() {
            return null;
        }

        /**
         * `CfnConfigurationTemplate.ConfigurationOptionSettingProperty.Value`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-configurationoptionsetting.html#cfn-elasticbeanstalk-configurationtemplate-configurationoptionsetting-value
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConfigurationOptionSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConfigurationOptionSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConfigurationOptionSettingProperty> {
            private java.lang.String namespace;
            private java.lang.String optionName;
            private java.lang.String resourceName;
            private java.lang.String value;

            /**
             * Sets the value of {@link ConfigurationOptionSettingProperty#getNamespace}
             * @param namespace `CfnConfigurationTemplate.ConfigurationOptionSettingProperty.Namespace`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder namespace(java.lang.String namespace) {
                this.namespace = namespace;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationOptionSettingProperty#getOptionName}
             * @param optionName `CfnConfigurationTemplate.ConfigurationOptionSettingProperty.OptionName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder optionName(java.lang.String optionName) {
                this.optionName = optionName;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationOptionSettingProperty#getResourceName}
             * @param resourceName `CfnConfigurationTemplate.ConfigurationOptionSettingProperty.ResourceName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceName(java.lang.String resourceName) {
                this.resourceName = resourceName;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationOptionSettingProperty#getValue}
             * @param value `CfnConfigurationTemplate.ConfigurationOptionSettingProperty.Value`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConfigurationOptionSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConfigurationOptionSettingProperty build() {
                return new Jsii$Proxy(namespace, optionName, resourceName, value);
            }
        }

        /**
         * An implementation for {@link ConfigurationOptionSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfigurationOptionSettingProperty {
            private final java.lang.String namespace;
            private final java.lang.String optionName;
            private final java.lang.String resourceName;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.namespace = this.jsiiGet("namespace", java.lang.String.class);
                this.optionName = this.jsiiGet("optionName", java.lang.String.class);
                this.resourceName = this.jsiiGet("resourceName", java.lang.String.class);
                this.value = this.jsiiGet("value", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String namespace, final java.lang.String optionName, final java.lang.String resourceName, final java.lang.String value) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.namespace = java.util.Objects.requireNonNull(namespace, "namespace is required");
                this.optionName = java.util.Objects.requireNonNull(optionName, "optionName is required");
                this.resourceName = resourceName;
                this.value = value;
            }

            @Override
            public java.lang.String getNamespace() {
                return this.namespace;
            }

            @Override
            public java.lang.String getOptionName() {
                return this.optionName;
            }

            @Override
            public java.lang.String getResourceName() {
                return this.resourceName;
            }

            @Override
            public java.lang.String getValue() {
                return this.value;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("namespace", om.valueToTree(this.getNamespace()));
                data.set("optionName", om.valueToTree(this.getOptionName()));
                if (this.getResourceName() != null) {
                    data.set("resourceName", om.valueToTree(this.getResourceName()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticbeanstalk.CfnConfigurationTemplate.ConfigurationOptionSettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConfigurationOptionSettingProperty.Jsii$Proxy that = (ConfigurationOptionSettingProperty.Jsii$Proxy) o;

                if (!namespace.equals(that.namespace)) return false;
                if (!optionName.equals(that.optionName)) return false;
                if (this.resourceName != null ? !this.resourceName.equals(that.resourceName) : that.resourceName != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public int hashCode() {
                int result = this.namespace.hashCode();
                result = 31 * result + (this.optionName.hashCode());
                result = 31 * result + (this.resourceName != null ? this.resourceName.hashCode() : 0);
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-sourceconfiguration.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticbeanstalk.$Module.class, fqn = "@aws-cdk/aws-elasticbeanstalk.CfnConfigurationTemplate.SourceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SourceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SourceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnConfigurationTemplate.SourceConfigurationProperty.ApplicationName`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-sourceconfiguration.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration-applicationname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getApplicationName();

        /**
         * `CfnConfigurationTemplate.SourceConfigurationProperty.TemplateName`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticbeanstalk-configurationtemplate-sourceconfiguration.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration-templatename
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTemplateName();

        /**
         * @return a {@link Builder} of {@link SourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SourceConfigurationProperty> {
            private java.lang.String applicationName;
            private java.lang.String templateName;

            /**
             * Sets the value of {@link SourceConfigurationProperty#getApplicationName}
             * @param applicationName `CfnConfigurationTemplate.SourceConfigurationProperty.ApplicationName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder applicationName(java.lang.String applicationName) {
                this.applicationName = applicationName;
                return this;
            }

            /**
             * Sets the value of {@link SourceConfigurationProperty#getTemplateName}
             * @param templateName `CfnConfigurationTemplate.SourceConfigurationProperty.TemplateName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder templateName(java.lang.String templateName) {
                this.templateName = templateName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SourceConfigurationProperty build() {
                return new Jsii$Proxy(applicationName, templateName);
            }
        }

        /**
         * An implementation for {@link SourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceConfigurationProperty {
            private final java.lang.String applicationName;
            private final java.lang.String templateName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.applicationName = this.jsiiGet("applicationName", java.lang.String.class);
                this.templateName = this.jsiiGet("templateName", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String applicationName, final java.lang.String templateName) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.applicationName = java.util.Objects.requireNonNull(applicationName, "applicationName is required");
                this.templateName = java.util.Objects.requireNonNull(templateName, "templateName is required");
            }

            @Override
            public java.lang.String getApplicationName() {
                return this.applicationName;
            }

            @Override
            public java.lang.String getTemplateName() {
                return this.templateName;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("applicationName", om.valueToTree(this.getApplicationName()));
                data.set("templateName", om.valueToTree(this.getTemplateName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticbeanstalk.CfnConfigurationTemplate.SourceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SourceConfigurationProperty.Jsii$Proxy that = (SourceConfigurationProperty.Jsii$Proxy) o;

                if (!applicationName.equals(that.applicationName)) return false;
                return this.templateName.equals(that.templateName);
            }

            @Override
            public int hashCode() {
                int result = this.applicationName.hashCode();
                result = 31 * result + (this.templateName.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.elasticbeanstalk.CfnConfigurationTemplate}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.elasticbeanstalk.CfnConfigurationTemplate> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.elasticbeanstalk.CfnConfigurationTemplateProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.elasticbeanstalk.CfnConfigurationTemplateProps.Builder();
        }

        /**
         * `AWS::ElasticBeanstalk::ConfigurationTemplate.ApplicationName`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-applicationname
         * @param applicationName `AWS::ElasticBeanstalk::ConfigurationTemplate.ApplicationName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationName(final java.lang.String applicationName) {
            this.props.applicationName(applicationName);
            return this;
        }

        /**
         * `AWS::ElasticBeanstalk::ConfigurationTemplate.Description`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-description
         * @param description `AWS::ElasticBeanstalk::ConfigurationTemplate.Description`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * `AWS::ElasticBeanstalk::ConfigurationTemplate.EnvironmentId`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-environmentid
         * @param environmentId `AWS::ElasticBeanstalk::ConfigurationTemplate.EnvironmentId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentId(final java.lang.String environmentId) {
            this.props.environmentId(environmentId);
            return this;
        }

        /**
         * `AWS::ElasticBeanstalk::ConfigurationTemplate.OptionSettings`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-optionsettings
         * @param optionSettings `AWS::ElasticBeanstalk::ConfigurationTemplate.OptionSettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder optionSettings(final software.amazon.awscdk.core.IResolvable optionSettings) {
            this.props.optionSettings(optionSettings);
            return this;
        }
        /**
         * `AWS::ElasticBeanstalk::ConfigurationTemplate.OptionSettings`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-optionsettings
         * @param optionSettings `AWS::ElasticBeanstalk::ConfigurationTemplate.OptionSettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder optionSettings(final java.util.List<java.lang.Object> optionSettings) {
            this.props.optionSettings(optionSettings);
            return this;
        }

        /**
         * `AWS::ElasticBeanstalk::ConfigurationTemplate.PlatformArn`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-platformarn
         * @param platformArn `AWS::ElasticBeanstalk::ConfigurationTemplate.PlatformArn`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder platformArn(final java.lang.String platformArn) {
            this.props.platformArn(platformArn);
            return this;
        }

        /**
         * `AWS::ElasticBeanstalk::ConfigurationTemplate.SolutionStackName`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-solutionstackname
         * @param solutionStackName `AWS::ElasticBeanstalk::ConfigurationTemplate.SolutionStackName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder solutionStackName(final java.lang.String solutionStackName) {
            this.props.solutionStackName(solutionStackName);
            return this;
        }

        /**
         * `AWS::ElasticBeanstalk::ConfigurationTemplate.SourceConfiguration`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration
         * @param sourceConfiguration `AWS::ElasticBeanstalk::ConfigurationTemplate.SourceConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceConfiguration(final software.amazon.awscdk.core.IResolvable sourceConfiguration) {
            this.props.sourceConfiguration(sourceConfiguration);
            return this;
        }
        /**
         * `AWS::ElasticBeanstalk::ConfigurationTemplate.SourceConfiguration`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration
         * @param sourceConfiguration `AWS::ElasticBeanstalk::ConfigurationTemplate.SourceConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceConfiguration(final software.amazon.awscdk.services.elasticbeanstalk.CfnConfigurationTemplate.SourceConfigurationProperty sourceConfiguration) {
            this.props.sourceConfiguration(sourceConfiguration);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.elasticbeanstalk.CfnConfigurationTemplate}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.elasticbeanstalk.CfnConfigurationTemplate build() {
            return new software.amazon.awscdk.services.elasticbeanstalk.CfnConfigurationTemplate(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
