package software.amazon.awscdk.services.elasticbeanstalk;

/**
 * A CloudFormation `AWS::ElasticBeanstalk::ApplicationVersion`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-14T23:35:56.950Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticbeanstalk.$Module.class, fqn = "@aws-cdk/aws-elasticbeanstalk.CfnApplicationVersion")
public class CfnApplicationVersion extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnApplicationVersion(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnApplicationVersion(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticbeanstalk.CfnApplicationVersion.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::ElasticBeanstalk::ApplicationVersion`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnApplicationVersion(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticbeanstalk.CfnApplicationVersionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::ElasticBeanstalk::ApplicationVersion.ApplicationName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-applicationname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getApplicationName() {
        return this.jsiiGet("applicationName", java.lang.String.class);
    }

    /**
     * `AWS::ElasticBeanstalk::ApplicationVersion.ApplicationName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-applicationname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApplicationName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiSet("applicationName", java.util.Objects.requireNonNull(value, "applicationName is required"));
    }

    /**
     * `AWS::ElasticBeanstalk::ApplicationVersion.SourceBundle`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-sourcebundle
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getSourceBundle() {
        return this.jsiiGet("sourceBundle", java.lang.Object.class);
    }

    /**
     * `AWS::ElasticBeanstalk::ApplicationVersion.SourceBundle`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-sourcebundle
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceBundle(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticbeanstalk.CfnApplicationVersion.SourceBundleProperty value) {
        this.jsiiSet("sourceBundle", java.util.Objects.requireNonNull(value, "sourceBundle is required"));
    }

    /**
     * `AWS::ElasticBeanstalk::ApplicationVersion.SourceBundle`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-sourcebundle
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceBundle(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("sourceBundle", java.util.Objects.requireNonNull(value, "sourceBundle is required"));
    }

    /**
     * `AWS::ElasticBeanstalk::ApplicationVersion.Description`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return this.jsiiGet("description", java.lang.String.class);
    }

    /**
     * `AWS::ElasticBeanstalk::ApplicationVersion.Description`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("description", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-sourcebundle.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticbeanstalk.$Module.class, fqn = "@aws-cdk/aws-elasticbeanstalk.CfnApplicationVersion.SourceBundleProperty")
    @software.amazon.jsii.Jsii.Proxy(SourceBundleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SourceBundleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApplicationVersion.SourceBundleProperty.S3Bucket`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-sourcebundle.html#cfn-beanstalk-sourcebundle-s3bucket
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3Bucket();

        /**
         * `CfnApplicationVersion.SourceBundleProperty.S3Key`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-sourcebundle.html#cfn-beanstalk-sourcebundle-s3key
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3Key();

        /**
         * @return a {@link Builder} of {@link SourceBundleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SourceBundleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SourceBundleProperty> {
            private java.lang.String s3Bucket;
            private java.lang.String s3Key;

            /**
             * Sets the value of {@link SourceBundleProperty#getS3Bucket}
             * @param s3Bucket `CfnApplicationVersion.SourceBundleProperty.S3Bucket`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Bucket(java.lang.String s3Bucket) {
                this.s3Bucket = s3Bucket;
                return this;
            }

            /**
             * Sets the value of {@link SourceBundleProperty#getS3Key}
             * @param s3Key `CfnApplicationVersion.SourceBundleProperty.S3Key`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Key(java.lang.String s3Key) {
                this.s3Key = s3Key;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceBundleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SourceBundleProperty build() {
                return new Jsii$Proxy(s3Bucket, s3Key);
            }
        }

        /**
         * An implementation for {@link SourceBundleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceBundleProperty {
            private final java.lang.String s3Bucket;
            private final java.lang.String s3Key;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3Bucket = this.jsiiGet("s3Bucket", java.lang.String.class);
                this.s3Key = this.jsiiGet("s3Key", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String s3Bucket, final java.lang.String s3Key) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3Bucket = java.util.Objects.requireNonNull(s3Bucket, "s3Bucket is required");
                this.s3Key = java.util.Objects.requireNonNull(s3Key, "s3Key is required");
            }

            @Override
            public java.lang.String getS3Bucket() {
                return this.s3Bucket;
            }

            @Override
            public java.lang.String getS3Key() {
                return this.s3Key;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("s3Bucket", om.valueToTree(this.getS3Bucket()));
                data.set("s3Key", om.valueToTree(this.getS3Key()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticbeanstalk.CfnApplicationVersion.SourceBundleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SourceBundleProperty.Jsii$Proxy that = (SourceBundleProperty.Jsii$Proxy) o;

                if (!s3Bucket.equals(that.s3Bucket)) return false;
                return this.s3Key.equals(that.s3Key);
            }

            @Override
            public int hashCode() {
                int result = this.s3Bucket.hashCode();
                result = 31 * result + (this.s3Key.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.elasticbeanstalk.CfnApplicationVersion}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.elasticbeanstalk.CfnApplicationVersion> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.elasticbeanstalk.CfnApplicationVersionProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.elasticbeanstalk.CfnApplicationVersionProps.Builder();
        }

        /**
         * `AWS::ElasticBeanstalk::ApplicationVersion.ApplicationName`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-applicationname
         * @param applicationName `AWS::ElasticBeanstalk::ApplicationVersion.ApplicationName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationName(final java.lang.String applicationName) {
            this.props.applicationName(applicationName);
            return this;
        }

        /**
         * `AWS::ElasticBeanstalk::ApplicationVersion.SourceBundle`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-sourcebundle
         * @param sourceBundle `AWS::ElasticBeanstalk::ApplicationVersion.SourceBundle`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceBundle(final software.amazon.awscdk.services.elasticbeanstalk.CfnApplicationVersion.SourceBundleProperty sourceBundle) {
            this.props.sourceBundle(sourceBundle);
            return this;
        }
        /**
         * `AWS::ElasticBeanstalk::ApplicationVersion.SourceBundle`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-sourcebundle
         * @param sourceBundle `AWS::ElasticBeanstalk::ApplicationVersion.SourceBundle`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceBundle(final software.amazon.awscdk.core.IResolvable sourceBundle) {
            this.props.sourceBundle(sourceBundle);
            return this;
        }

        /**
         * `AWS::ElasticBeanstalk::ApplicationVersion.Description`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-description
         * @param description `AWS::ElasticBeanstalk::ApplicationVersion.Description`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.elasticbeanstalk.CfnApplicationVersion}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.elasticbeanstalk.CfnApplicationVersion build() {
            return new software.amazon.awscdk.services.elasticbeanstalk.CfnApplicationVersion(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
