/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.elasticbeanstalk;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.elasticbeanstalk.;
import software.amazon.awscdk.services.elasticbeanstalk.CfnEnvironment;
import software.amazon.awscdk.services.elasticbeanstalk.CfnEnvironmentProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-elasticbeanstalk.CfnEnvironment")
public class CfnEnvironment
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnEnvironment.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnEnvironment(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnEnvironment(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnEnvironment(@NotNull Construct scope, @NotNull String id, @NotNull CfnEnvironmentProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        this.jsiiCall("inspect", NativeType.VOID, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrEndpointUrl() {
        return (String)this.jsiiGet("attrEndpointUrl", String.class);
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)this.jsiiGet("tags", TagManager.class);
    }

    @NotNull
    public String getApplicationName() {
        return (String)this.jsiiGet("applicationName", String.class);
    }

    public void setApplicationName(@NotNull String value) {
        this.jsiiSet("applicationName", Objects.requireNonNull(value, "applicationName is required"));
    }

    @Nullable
    public String getCnamePrefix() {
        return (String)this.jsiiGet("cnamePrefix", String.class);
    }

    public void setCnamePrefix(@Nullable String value) {
        this.jsiiSet("cnamePrefix", value);
    }

    @Nullable
    public String getDescription() {
        return (String)this.jsiiGet("description", String.class);
    }

    public void setDescription(@Nullable String value) {
        this.jsiiSet("description", value);
    }

    @Nullable
    public String getEnvironmentName() {
        return (String)this.jsiiGet("environmentName", String.class);
    }

    public void setEnvironmentName(@Nullable String value) {
        this.jsiiSet("environmentName", value);
    }

    @Nullable
    public Object getOptionSettings() {
        return this.jsiiGet("optionSettings", Object.class);
    }

    public void setOptionSettings(@Nullable IResolvable value) {
        this.jsiiSet("optionSettings", value);
    }

    public void setOptionSettings(@Nullable List<Object> value) {
        this.jsiiSet("optionSettings", value);
    }

    @Nullable
    public String getPlatformArn() {
        return (String)this.jsiiGet("platformArn", String.class);
    }

    public void setPlatformArn(@Nullable String value) {
        this.jsiiSet("platformArn", value);
    }

    @Nullable
    public String getSolutionStackName() {
        return (String)this.jsiiGet("solutionStackName", String.class);
    }

    public void setSolutionStackName(@Nullable String value) {
        this.jsiiSet("solutionStackName", value);
    }

    @Nullable
    public String getTemplateName() {
        return (String)this.jsiiGet("templateName", String.class);
    }

    public void setTemplateName(@Nullable String value) {
        this.jsiiSet("templateName", value);
    }

    @Nullable
    public Object getTier() {
        return this.jsiiGet("tier", Object.class);
    }

    public void setTier(@Nullable IResolvable value) {
        this.jsiiSet("tier", value);
    }

    public void setTier(@Nullable TierProperty value) {
        this.jsiiSet("tier", value);
    }

    @Nullable
    public String getVersionLabel() {
        return (String)this.jsiiGet("versionLabel", String.class);
    }

    public void setVersionLabel(@Nullable String value) {
        this.jsiiSet("versionLabel", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnEnvironment> {
        private final Construct scope;
        private final String id;
        private final CfnEnvironmentProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnEnvironmentProps.Builder();
        }

        public Builder applicationName(String applicationName) {
            this.props.applicationName(applicationName);
            return this;
        }

        public Builder cnamePrefix(String cnamePrefix) {
            this.props.cnamePrefix(cnamePrefix);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder environmentName(String environmentName) {
            this.props.environmentName(environmentName);
            return this;
        }

        public Builder optionSettings(IResolvable optionSettings) {
            this.props.optionSettings(optionSettings);
            return this;
        }

        public Builder optionSettings(List<Object> optionSettings) {
            this.props.optionSettings(optionSettings);
            return this;
        }

        public Builder platformArn(String platformArn) {
            this.props.platformArn(platformArn);
            return this;
        }

        public Builder solutionStackName(String solutionStackName) {
            this.props.solutionStackName(solutionStackName);
            return this;
        }

        public Builder tags(List<CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder templateName(String templateName) {
            this.props.templateName(templateName);
            return this;
        }

        public Builder tier(IResolvable tier) {
            this.props.tier(tier);
            return this;
        }

        public Builder tier(TierProperty tier) {
            this.props.tier(tier);
            return this;
        }

        public Builder versionLabel(String versionLabel) {
            this.props.versionLabel(versionLabel);
            return this;
        }

        public CfnEnvironment build() {
            return new CfnEnvironment(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-elasticbeanstalk.CfnEnvironment.TierProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TierProperty
    extends JsiiSerializable {
        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public String getType() {
            return null;
        }

        @Nullable
        default public String getVersion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TierProperty> {
            private String name;
            private String type;
            private String version;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder version(String version) {
                this.version = version;
                return this;
            }

            public TierProperty build() {
                return new Jsii.Proxy(this.name, this.type, this.version, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-elasticbeanstalk.CfnEnvironment.OptionSettingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OptionSettingProperty
    extends JsiiSerializable {
        @NotNull
        public String getNamespace();

        @NotNull
        public String getOptionName();

        @Nullable
        default public String getResourceName() {
            return null;
        }

        @Nullable
        default public String getValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OptionSettingProperty> {
            private String namespace;
            private String optionName;
            private String resourceName;
            private String value;

            public Builder namespace(String namespace) {
                this.namespace = namespace;
                return this;
            }

            public Builder optionName(String optionName) {
                this.optionName = optionName;
                return this;
            }

            public Builder resourceName(String resourceName) {
                this.resourceName = resourceName;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public OptionSettingProperty build() {
                return new Jsii.Proxy(this.namespace, this.optionName, this.resourceName, this.value, null);
            }
        }
    }
}

