/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.elasticbeanstalk;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.elasticbeanstalk.;
import software.amazon.awscdk.services.elasticbeanstalk.CfnApplication;
import software.amazon.awscdk.services.elasticbeanstalk.CfnApplicationProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-elasticbeanstalk.CfnApplication")
public class CfnApplication
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnApplication.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnApplication(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnApplication(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnApplication(@NotNull Construct scope, @NotNull String id, @Nullable CfnApplicationProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public CfnApplication(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        this.jsiiCall("inspect", NativeType.VOID, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @Nullable
    public String getApplicationName() {
        return (String)this.jsiiGet("applicationName", String.class);
    }

    public void setApplicationName(@Nullable String value) {
        this.jsiiSet("applicationName", value);
    }

    @Nullable
    public String getDescription() {
        return (String)this.jsiiGet("description", String.class);
    }

    public void setDescription(@Nullable String value) {
        this.jsiiSet("description", value);
    }

    @Nullable
    public Object getResourceLifecycleConfig() {
        return this.jsiiGet("resourceLifecycleConfig", Object.class);
    }

    public void setResourceLifecycleConfig(@Nullable IResolvable value) {
        this.jsiiSet("resourceLifecycleConfig", value);
    }

    public void setResourceLifecycleConfig(@Nullable ApplicationResourceLifecycleConfigProperty value) {
        this.jsiiSet("resourceLifecycleConfig", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnApplication> {
        private final Construct scope;
        private final String id;
        private CfnApplicationProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder applicationName(String applicationName) {
            this.props().applicationName(applicationName);
            return this;
        }

        public Builder description(String description) {
            this.props().description(description);
            return this;
        }

        public Builder resourceLifecycleConfig(IResolvable resourceLifecycleConfig) {
            this.props().resourceLifecycleConfig(resourceLifecycleConfig);
            return this;
        }

        public Builder resourceLifecycleConfig(ApplicationResourceLifecycleConfigProperty resourceLifecycleConfig) {
            this.props().resourceLifecycleConfig(resourceLifecycleConfig);
            return this;
        }

        public CfnApplication build() {
            return new CfnApplication(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private CfnApplicationProps.Builder props() {
            if (this.props == null) {
                this.props = new CfnApplicationProps.Builder();
            }
            return this.props;
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-elasticbeanstalk.CfnApplication.MaxCountRuleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MaxCountRuleProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDeleteSourceFromS3() {
            return null;
        }

        @Nullable
        default public Object getEnabled() {
            return null;
        }

        @Nullable
        default public Number getMaxCount() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MaxCountRuleProperty> {
            private Object deleteSourceFromS3;
            private Object enabled;
            private Number maxCount;

            public Builder deleteSourceFromS3(Boolean deleteSourceFromS3) {
                this.deleteSourceFromS3 = deleteSourceFromS3;
                return this;
            }

            public Builder deleteSourceFromS3(IResolvable deleteSourceFromS3) {
                this.deleteSourceFromS3 = deleteSourceFromS3;
                return this;
            }

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder maxCount(Number maxCount) {
                this.maxCount = maxCount;
                return this;
            }

            public MaxCountRuleProperty build() {
                return new Jsii.Proxy(this.deleteSourceFromS3, this.enabled, this.maxCount, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-elasticbeanstalk.CfnApplication.MaxAgeRuleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MaxAgeRuleProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDeleteSourceFromS3() {
            return null;
        }

        @Nullable
        default public Object getEnabled() {
            return null;
        }

        @Nullable
        default public Number getMaxAgeInDays() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MaxAgeRuleProperty> {
            private Object deleteSourceFromS3;
            private Object enabled;
            private Number maxAgeInDays;

            public Builder deleteSourceFromS3(Boolean deleteSourceFromS3) {
                this.deleteSourceFromS3 = deleteSourceFromS3;
                return this;
            }

            public Builder deleteSourceFromS3(IResolvable deleteSourceFromS3) {
                this.deleteSourceFromS3 = deleteSourceFromS3;
                return this;
            }

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder maxAgeInDays(Number maxAgeInDays) {
                this.maxAgeInDays = maxAgeInDays;
                return this;
            }

            public MaxAgeRuleProperty build() {
                return new Jsii.Proxy(this.deleteSourceFromS3, this.enabled, this.maxAgeInDays, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-elasticbeanstalk.CfnApplication.ApplicationVersionLifecycleConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ApplicationVersionLifecycleConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getMaxAgeRule() {
            return null;
        }

        @Nullable
        default public Object getMaxCountRule() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ApplicationVersionLifecycleConfigProperty> {
            private Object maxAgeRule;
            private Object maxCountRule;

            public Builder maxAgeRule(IResolvable maxAgeRule) {
                this.maxAgeRule = maxAgeRule;
                return this;
            }

            public Builder maxAgeRule(MaxAgeRuleProperty maxAgeRule) {
                this.maxAgeRule = maxAgeRule;
                return this;
            }

            public Builder maxCountRule(IResolvable maxCountRule) {
                this.maxCountRule = maxCountRule;
                return this;
            }

            public Builder maxCountRule(MaxCountRuleProperty maxCountRule) {
                this.maxCountRule = maxCountRule;
                return this;
            }

            public ApplicationVersionLifecycleConfigProperty build() {
                return new Jsii.Proxy(this.maxAgeRule, this.maxCountRule, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-elasticbeanstalk.CfnApplication.ApplicationResourceLifecycleConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ApplicationResourceLifecycleConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public String getServiceRole() {
            return null;
        }

        @Nullable
        default public Object getVersionLifecycleConfig() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ApplicationResourceLifecycleConfigProperty> {
            private String serviceRole;
            private Object versionLifecycleConfig;

            public Builder serviceRole(String serviceRole) {
                this.serviceRole = serviceRole;
                return this;
            }

            public Builder versionLifecycleConfig(IResolvable versionLifecycleConfig) {
                this.versionLifecycleConfig = versionLifecycleConfig;
                return this;
            }

            public Builder versionLifecycleConfig(ApplicationVersionLifecycleConfigProperty versionLifecycleConfig) {
                this.versionLifecycleConfig = versionLifecycleConfig;
                return this;
            }

            public ApplicationResourceLifecycleConfigProperty build() {
                return new Jsii.Proxy(this.serviceRole, this.versionLifecycleConfig, null);
            }
        }
    }
}

