package software.amazon.awscdk.services.elasticbeanstalk;

/**
 * Properties for defining a `AWS::ElasticBeanstalk::ApplicationVersion`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.16.0 (build 98909b5)", date = "2019-09-10T21:08:20.493Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnApplicationVersionProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * `AWS::ElasticBeanstalk::ApplicationVersion.ApplicationName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-applicationname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getApplicationName();

    /**
     * `AWS::ElasticBeanstalk::ApplicationVersion.SourceBundle`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-sourcebundle
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getSourceBundle();

    /**
     * `AWS::ElasticBeanstalk::ApplicationVersion.Description`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-version.html#cfn-elasticbeanstalk-applicationversion-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getDescription();

    /**
     * @return a {@link Builder} of {@link CfnApplicationVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CfnApplicationVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Builder {
        private java.lang.String applicationName;
        private java.lang.Object sourceBundle;
        private java.lang.String description;

        /**
         * Sets the value of ApplicationName
         * @param applicationName `AWS::ElasticBeanstalk::ApplicationVersion.ApplicationName`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder applicationName(java.lang.String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        /**
         * Sets the value of SourceBundle
         * @param sourceBundle `AWS::ElasticBeanstalk::ApplicationVersion.SourceBundle`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder sourceBundle(software.amazon.awscdk.core.IResolvable sourceBundle) {
            this.sourceBundle = sourceBundle;
            return this;
        }

        /**
         * Sets the value of SourceBundle
         * @param sourceBundle `AWS::ElasticBeanstalk::ApplicationVersion.SourceBundle`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder sourceBundle(software.amazon.awscdk.services.elasticbeanstalk.CfnApplicationVersion.SourceBundleProperty sourceBundle) {
            this.sourceBundle = sourceBundle;
            return this;
        }

        /**
         * Sets the value of Description
         * @param description `AWS::ElasticBeanstalk::ApplicationVersion.Description`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnApplicationVersionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnApplicationVersionProps build() {
            return new Jsii$Proxy(applicationName, sourceBundle, description);
        }

    }

    /**
     * An implementation for {@link CfnApplicationVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnApplicationVersionProps {
        private final java.lang.String applicationName;
        private final java.lang.Object sourceBundle;
        private final java.lang.String description;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.applicationName = this.jsiiGet("applicationName", java.lang.String.class);
            this.sourceBundle = this.jsiiGet("sourceBundle", java.lang.Object.class);
            this.description = this.jsiiGet("description", java.lang.String.class);
        }


        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String applicationName, java.lang.Object sourceBundle, java.lang.String description) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.applicationName = java.util.Objects.requireNonNull(applicationName, "applicationName is required");
            this.sourceBundle = java.util.Objects.requireNonNull(sourceBundle, "sourceBundle is required");
            this.description = description;
        }

        @Override
        public java.lang.String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public java.lang.Object getSourceBundle() {
            return this.sourceBundle;
        }

        @Override
        public java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("applicationName", om.valueToTree(this.getApplicationName()));
            obj.set("sourceBundle", om.valueToTree(this.getSourceBundle()));
            if (this.getDescription() != null) {
                obj.set("description", om.valueToTree(this.getDescription()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnApplicationVersionProps.Jsii$Proxy that = (CfnApplicationVersionProps.Jsii$Proxy) o;

            if (!applicationName.equals(that.applicationName)) return false;
            if (!sourceBundle.equals(that.sourceBundle)) return false;
            return this.description != null ? this.description.equals(that.description) : that.description == null;
        }

        @Override
        public int hashCode() {
            int result = this.applicationName.hashCode();
            result = 31 * result + (this.sourceBundle.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            return result;
        }

    }
}
