package software.amazon.awscdk.services.elasticloadbalancing;

/**
 * Add a backend to the load balancer.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IVpc vpc;
 * AutoScalingGroup myAutoScalingGroup;
 * LoadBalancer lb = LoadBalancer.Builder.create(this, "LB")
 *         .vpc(vpc)
 *         .internetFacing(true)
 *         .healthCheck(HealthCheck.builder()
 *                 .port(80)
 *                 .build())
 *         .build();
 * lb.addTarget(myAutoScalingGroup);
 * lb.addListener(LoadBalancerListener.builder()
 *         .externalPort(80)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-07T17:24:41.587Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancing.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancing.LoadBalancerListener")
@software.amazon.jsii.Jsii.Proxy(LoadBalancerListener.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LoadBalancerListener extends software.amazon.jsii.JsiiSerializable {

    /**
     * External listening port.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getExternalPort();

    /**
     * Allow connections to the load balancer from the given set of connection peers.
     * <p>
     * By default, connections will be allowed from anywhere. Set this to an empty list
     * to deny connections, or supply a custom list of peers to allow connections from
     * (IP ranges or security groups).
     * <p>
     * Default: Anywhere
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.IConnectable> getAllowConnectionsFrom() {
        return null;
    }

    /**
     * What public protocol to use for load balancing.
     * <p>
     * Either 'tcp', 'ssl', 'http' or 'https'.
     * <p>
     * May be omitted if the external port is either 80 or 443.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancing.LoadBalancingProtocol getExternalProtocol() {
        return null;
    }

    /**
     * Instance listening port.
     * <p>
     * Same as the externalPort if not specified.
     * <p>
     * Default: externalPort
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getInternalPort() {
        return null;
    }

    /**
     * What public protocol to use for load balancing.
     * <p>
     * Either 'tcp', 'ssl', 'http' or 'https'.
     * <p>
     * May be omitted if the internal port is either 80 or 443.
     * <p>
     * The instance protocol is 'tcp' if the front-end protocol
     * is 'tcp' or 'ssl', the instance protocol is 'http' if the
     * front-end protocol is 'https'.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancing.LoadBalancingProtocol getInternalProtocol() {
        return null;
    }

    /**
     * SSL policy names.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPolicyNames() {
        return null;
    }

    /**
     * the ARN of the SSL certificate.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSslCertificateArn() {
        return null;
    }

    /**
     * (deprecated) the ARN of the SSL certificate.
     * <p>
     * @deprecated - use sslCertificateArn instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.String getSslCertificateId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LoadBalancerListener}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LoadBalancerListener}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LoadBalancerListener> {
        java.lang.Number externalPort;
        java.util.List<software.amazon.awscdk.services.ec2.IConnectable> allowConnectionsFrom;
        software.amazon.awscdk.services.elasticloadbalancing.LoadBalancingProtocol externalProtocol;
        java.lang.Number internalPort;
        software.amazon.awscdk.services.elasticloadbalancing.LoadBalancingProtocol internalProtocol;
        java.util.List<java.lang.String> policyNames;
        java.lang.String sslCertificateArn;
        java.lang.String sslCertificateId;

        /**
         * Sets the value of {@link LoadBalancerListener#getExternalPort}
         * @param externalPort External listening port. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder externalPort(java.lang.Number externalPort) {
            this.externalPort = externalPort;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerListener#getAllowConnectionsFrom}
         * @param allowConnectionsFrom Allow connections to the load balancer from the given set of connection peers.
         *                             By default, connections will be allowed from anywhere. Set this to an empty list
         *                             to deny connections, or supply a custom list of peers to allow connections from
         *                             (IP ranges or security groups).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder allowConnectionsFrom(java.util.List<? extends software.amazon.awscdk.services.ec2.IConnectable> allowConnectionsFrom) {
            this.allowConnectionsFrom = (java.util.List<software.amazon.awscdk.services.ec2.IConnectable>)allowConnectionsFrom;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerListener#getExternalProtocol}
         * @param externalProtocol What public protocol to use for load balancing.
         *                         Either 'tcp', 'ssl', 'http' or 'https'.
         *                         <p>
         *                         May be omitted if the external port is either 80 or 443.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder externalProtocol(software.amazon.awscdk.services.elasticloadbalancing.LoadBalancingProtocol externalProtocol) {
            this.externalProtocol = externalProtocol;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerListener#getInternalPort}
         * @param internalPort Instance listening port.
         *                     Same as the externalPort if not specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder internalPort(java.lang.Number internalPort) {
            this.internalPort = internalPort;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerListener#getInternalProtocol}
         * @param internalProtocol What public protocol to use for load balancing.
         *                         Either 'tcp', 'ssl', 'http' or 'https'.
         *                         <p>
         *                         May be omitted if the internal port is either 80 or 443.
         *                         <p>
         *                         The instance protocol is 'tcp' if the front-end protocol
         *                         is 'tcp' or 'ssl', the instance protocol is 'http' if the
         *                         front-end protocol is 'https'.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder internalProtocol(software.amazon.awscdk.services.elasticloadbalancing.LoadBalancingProtocol internalProtocol) {
            this.internalProtocol = internalProtocol;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerListener#getPolicyNames}
         * @param policyNames SSL policy names.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyNames(java.util.List<java.lang.String> policyNames) {
            this.policyNames = policyNames;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerListener#getSslCertificateArn}
         * @param sslCertificateArn the ARN of the SSL certificate.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sslCertificateArn(java.lang.String sslCertificateArn) {
            this.sslCertificateArn = sslCertificateArn;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerListener#getSslCertificateId}
         * @param sslCertificateId the ARN of the SSL certificate.
         * @return {@code this}
         * @deprecated - use sslCertificateArn instead
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder sslCertificateId(java.lang.String sslCertificateId) {
            this.sslCertificateId = sslCertificateId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LoadBalancerListener}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LoadBalancerListener build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LoadBalancerListener}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoadBalancerListener {
        private final java.lang.Number externalPort;
        private final java.util.List<software.amazon.awscdk.services.ec2.IConnectable> allowConnectionsFrom;
        private final software.amazon.awscdk.services.elasticloadbalancing.LoadBalancingProtocol externalProtocol;
        private final java.lang.Number internalPort;
        private final software.amazon.awscdk.services.elasticloadbalancing.LoadBalancingProtocol internalProtocol;
        private final java.util.List<java.lang.String> policyNames;
        private final java.lang.String sslCertificateArn;
        private final java.lang.String sslCertificateId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.externalPort = software.amazon.jsii.Kernel.get(this, "externalPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.allowConnectionsFrom = software.amazon.jsii.Kernel.get(this, "allowConnectionsFrom", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IConnectable.class)));
            this.externalProtocol = software.amazon.jsii.Kernel.get(this, "externalProtocol", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancing.LoadBalancingProtocol.class));
            this.internalPort = software.amazon.jsii.Kernel.get(this, "internalPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.internalProtocol = software.amazon.jsii.Kernel.get(this, "internalProtocol", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancing.LoadBalancingProtocol.class));
            this.policyNames = software.amazon.jsii.Kernel.get(this, "policyNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.sslCertificateArn = software.amazon.jsii.Kernel.get(this, "sslCertificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sslCertificateId = software.amazon.jsii.Kernel.get(this, "sslCertificateId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.externalPort = java.util.Objects.requireNonNull(builder.externalPort, "externalPort is required");
            this.allowConnectionsFrom = (java.util.List<software.amazon.awscdk.services.ec2.IConnectable>)builder.allowConnectionsFrom;
            this.externalProtocol = builder.externalProtocol;
            this.internalPort = builder.internalPort;
            this.internalProtocol = builder.internalProtocol;
            this.policyNames = builder.policyNames;
            this.sslCertificateArn = builder.sslCertificateArn;
            this.sslCertificateId = builder.sslCertificateId;
        }

        @Override
        public final java.lang.Number getExternalPort() {
            return this.externalPort;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.IConnectable> getAllowConnectionsFrom() {
            return this.allowConnectionsFrom;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancing.LoadBalancingProtocol getExternalProtocol() {
            return this.externalProtocol;
        }

        @Override
        public final java.lang.Number getInternalPort() {
            return this.internalPort;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancing.LoadBalancingProtocol getInternalProtocol() {
            return this.internalProtocol;
        }

        @Override
        public final java.util.List<java.lang.String> getPolicyNames() {
            return this.policyNames;
        }

        @Override
        public final java.lang.String getSslCertificateArn() {
            return this.sslCertificateArn;
        }

        @Override
        public final java.lang.String getSslCertificateId() {
            return this.sslCertificateId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("externalPort", om.valueToTree(this.getExternalPort()));
            if (this.getAllowConnectionsFrom() != null) {
                data.set("allowConnectionsFrom", om.valueToTree(this.getAllowConnectionsFrom()));
            }
            if (this.getExternalProtocol() != null) {
                data.set("externalProtocol", om.valueToTree(this.getExternalProtocol()));
            }
            if (this.getInternalPort() != null) {
                data.set("internalPort", om.valueToTree(this.getInternalPort()));
            }
            if (this.getInternalProtocol() != null) {
                data.set("internalProtocol", om.valueToTree(this.getInternalProtocol()));
            }
            if (this.getPolicyNames() != null) {
                data.set("policyNames", om.valueToTree(this.getPolicyNames()));
            }
            if (this.getSslCertificateArn() != null) {
                data.set("sslCertificateArn", om.valueToTree(this.getSslCertificateArn()));
            }
            if (this.getSslCertificateId() != null) {
                data.set("sslCertificateId", om.valueToTree(this.getSslCertificateId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancing.LoadBalancerListener"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LoadBalancerListener.Jsii$Proxy that = (LoadBalancerListener.Jsii$Proxy) o;

            if (!externalPort.equals(that.externalPort)) return false;
            if (this.allowConnectionsFrom != null ? !this.allowConnectionsFrom.equals(that.allowConnectionsFrom) : that.allowConnectionsFrom != null) return false;
            if (this.externalProtocol != null ? !this.externalProtocol.equals(that.externalProtocol) : that.externalProtocol != null) return false;
            if (this.internalPort != null ? !this.internalPort.equals(that.internalPort) : that.internalPort != null) return false;
            if (this.internalProtocol != null ? !this.internalProtocol.equals(that.internalProtocol) : that.internalProtocol != null) return false;
            if (this.policyNames != null ? !this.policyNames.equals(that.policyNames) : that.policyNames != null) return false;
            if (this.sslCertificateArn != null ? !this.sslCertificateArn.equals(that.sslCertificateArn) : that.sslCertificateArn != null) return false;
            return this.sslCertificateId != null ? this.sslCertificateId.equals(that.sslCertificateId) : that.sslCertificateId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.externalPort.hashCode();
            result = 31 * result + (this.allowConnectionsFrom != null ? this.allowConnectionsFrom.hashCode() : 0);
            result = 31 * result + (this.externalProtocol != null ? this.externalProtocol.hashCode() : 0);
            result = 31 * result + (this.internalPort != null ? this.internalPort.hashCode() : 0);
            result = 31 * result + (this.internalProtocol != null ? this.internalProtocol.hashCode() : 0);
            result = 31 * result + (this.policyNames != null ? this.policyNames.hashCode() : 0);
            result = 31 * result + (this.sslCertificateArn != null ? this.sslCertificateArn.hashCode() : 0);
            result = 31 * result + (this.sslCertificateId != null ? this.sslCertificateId.hashCode() : 0);
            return result;
        }
    }
}
