/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.elasticloadbalancingv2;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.ec2.VpcNetworkRef;
import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol;
import software.amazon.awscdk.services.elasticloadbalancingv2.BaseTargetGroupProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck;
import software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget;
import software.amazon.jsii.JsiiSerializable;

public interface ApplicationTargetGroupProps
extends JsiiSerializable,
BaseTargetGroupProps {
    public Number getPort();

    public void setPort(Number var1);

    public ApplicationProtocol getProtocol();

    public void setProtocol(ApplicationProtocol var1);

    public Number getSlowStartSec();

    public void setSlowStartSec(Number var1);

    public Number getStickinessCookieDurationSec();

    public void setStickinessCookieDurationSec(Number var1);

    public List<IApplicationLoadBalancerTarget> getTargets();

    public void setTargets(List<IApplicationLoadBalancerTarget> var1);

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private Number _port;
        @Nullable
        private ApplicationProtocol _protocol;
        @Nullable
        private Number _slowStartSec;
        @Nullable
        private Number _stickinessCookieDurationSec;
        @Nullable
        private List<IApplicationLoadBalancerTarget> _targets;
        private VpcNetworkRef _vpc;
        @Nullable
        private Number _deregistrationDelaySec;
        @Nullable
        private HealthCheck _healthCheck;
        @Nullable
        private String _targetGroupName;

        public Builder withPort(@Nullable Number value) {
            this._port = value;
            return this;
        }

        public Builder withProtocol(@Nullable ApplicationProtocol value) {
            this._protocol = value;
            return this;
        }

        public Builder withSlowStartSec(@Nullable Number value) {
            this._slowStartSec = value;
            return this;
        }

        public Builder withStickinessCookieDurationSec(@Nullable Number value) {
            this._stickinessCookieDurationSec = value;
            return this;
        }

        public Builder withTargets(@Nullable List<IApplicationLoadBalancerTarget> value) {
            this._targets = value;
            return this;
        }

        public Builder withVpc(VpcNetworkRef value) {
            this._vpc = Objects.requireNonNull(value, "vpc is required");
            return this;
        }

        public Builder withDeregistrationDelaySec(@Nullable Number value) {
            this._deregistrationDelaySec = value;
            return this;
        }

        public Builder withHealthCheck(@Nullable HealthCheck value) {
            this._healthCheck = value;
            return this;
        }

        public Builder withTargetGroupName(@Nullable String value) {
            this._targetGroupName = value;
            return this;
        }

        public ApplicationTargetGroupProps build() {
            return new ApplicationTargetGroupProps(){
                @Nullable
                private Number $port;
                @Nullable
                private ApplicationProtocol $protocol;
                @Nullable
                private Number $slowStartSec;
                @Nullable
                private Number $stickinessCookieDurationSec;
                @Nullable
                private List<IApplicationLoadBalancerTarget> $targets;
                private VpcNetworkRef $vpc;
                @Nullable
                private Number $deregistrationDelaySec;
                @Nullable
                private HealthCheck $healthCheck;
                @Nullable
                private String $targetGroupName;
                {
                    this.$port = _port;
                    this.$protocol = _protocol;
                    this.$slowStartSec = _slowStartSec;
                    this.$stickinessCookieDurationSec = _stickinessCookieDurationSec;
                    this.$targets = _targets;
                    this.$vpc = Objects.requireNonNull(_vpc, "vpc is required");
                    this.$deregistrationDelaySec = _deregistrationDelaySec;
                    this.$healthCheck = _healthCheck;
                    this.$targetGroupName = _targetGroupName;
                }

                @Override
                public Number getPort() {
                    return this.$port;
                }

                @Override
                public void setPort(@Nullable Number value) {
                    this.$port = value;
                }

                @Override
                public ApplicationProtocol getProtocol() {
                    return this.$protocol;
                }

                @Override
                public void setProtocol(@Nullable ApplicationProtocol value) {
                    this.$protocol = value;
                }

                @Override
                public Number getSlowStartSec() {
                    return this.$slowStartSec;
                }

                @Override
                public void setSlowStartSec(@Nullable Number value) {
                    this.$slowStartSec = value;
                }

                @Override
                public Number getStickinessCookieDurationSec() {
                    return this.$stickinessCookieDurationSec;
                }

                @Override
                public void setStickinessCookieDurationSec(@Nullable Number value) {
                    this.$stickinessCookieDurationSec = value;
                }

                @Override
                public List<IApplicationLoadBalancerTarget> getTargets() {
                    return this.$targets;
                }

                @Override
                public void setTargets(@Nullable List<IApplicationLoadBalancerTarget> value) {
                    this.$targets = value;
                }

                @Override
                public VpcNetworkRef getVpc() {
                    return this.$vpc;
                }

                @Override
                public void setVpc(VpcNetworkRef value) {
                    this.$vpc = Objects.requireNonNull(value, "vpc is required");
                }

                @Override
                public Number getDeregistrationDelaySec() {
                    return this.$deregistrationDelaySec;
                }

                @Override
                public void setDeregistrationDelaySec(@Nullable Number value) {
                    this.$deregistrationDelaySec = value;
                }

                @Override
                public HealthCheck getHealthCheck() {
                    return this.$healthCheck;
                }

                @Override
                public void setHealthCheck(@Nullable HealthCheck value) {
                    this.$healthCheck = value;
                }

                @Override
                public String getTargetGroupName() {
                    return this.$targetGroupName;
                }

                @Override
                public void setTargetGroupName(@Nullable String value) {
                    this.$targetGroupName = value;
                }
            };
        }
    }
}

